/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.mr.hive.Deserializer;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestDeserializer {
    private static final Schema CUSTOMER_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get())});
    private static final StandardStructObjectInspector CUSTOMER_OBJECT_INSPECTOR = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("customer_id", "first_name"), Arrays.asList(PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector));

    @Test
    public void testSchemaDeserialize() {
        StandardStructObjectInspector schemaObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("0:col1", "1:col2"), Arrays.asList(PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector));
        Deserializer deserializer = new Deserializer.Builder().schema(CUSTOMER_SCHEMA).writerInspector((StructObjectInspector)IcebergObjectInspector.create((Schema)CUSTOMER_SCHEMA)).sourceInspector((StructObjectInspector)schemaObjectInspector).build();
        GenericRecord expected = GenericRecord.create((Schema)CUSTOMER_SCHEMA);
        expected.set(0, (Object)1L);
        expected.set(1, (Object)"Bob");
        Record actual = deserializer.deserialize((Object)new Object[]{new LongWritable(1L), new Text("Bob")});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testStructDeserialize() {
        Deserializer deserializer = new Deserializer.Builder().schema(CUSTOMER_SCHEMA).writerInspector((StructObjectInspector)IcebergObjectInspector.create((Schema)CUSTOMER_SCHEMA)).sourceInspector((StructObjectInspector)CUSTOMER_OBJECT_INSPECTOR).build();
        GenericRecord expected = GenericRecord.create((Schema)CUSTOMER_SCHEMA);
        expected.set(0, (Object)1L);
        expected.set(1, (Object)"Bob");
        Record actual = deserializer.deserialize((Object)new Object[]{new LongWritable(1L), new Text("Bob")});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapDeserialize() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"map_type", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.LongType.get(), (Type)Types.StringType.get()))});
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("map_type"), Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector)));
        Deserializer deserializer = new Deserializer.Builder().schema(schema).writerInspector((StructObjectInspector)IcebergObjectInspector.create((Schema)schema)).sourceInspector((StructObjectInspector)inspector).build();
        GenericRecord expected = GenericRecord.create((Schema)schema);
        expected.set(0, Collections.singletonMap(1L, "Taylor"));
        MapWritable map = new MapWritable();
        map.put((Writable)new LongWritable(1L), (Writable)new Text("Taylor"));
        Object[] data = new Object[]{map};
        Record actual = deserializer.deserialize((Object)data);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testListDeserialize() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"list_type", (Type)Types.ListType.ofOptional((int)2, (Type)Types.LongType.get()))});
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("list_type"), Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector)));
        Deserializer deserializer = new Deserializer.Builder().schema(schema).writerInspector((StructObjectInspector)IcebergObjectInspector.create((Schema)schema)).sourceInspector((StructObjectInspector)inspector).build();
        GenericRecord expected = GenericRecord.create((Schema)schema);
        expected.set(0, Collections.singletonList(1L));
        Object[] data = new Object[]{new Object[]{new LongWritable(1L)}};
        Record actual = deserializer.deserialize((Object)data);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDeserializeEverySupportedType() {
        Assume.assumeFalse((String)"No test yet for Hive3 (Date/Timestamp creation)", (boolean)HiveVersion.min((HiveVersion)HiveVersion.HIVE_3));
        Deserializer deserializer = new Deserializer.Builder().schema(HiveIcebergTestUtils.FULL_SCHEMA).writerInspector((StructObjectInspector)IcebergObjectInspector.create((Schema)HiveIcebergTestUtils.FULL_SCHEMA)).sourceInspector((StructObjectInspector)HiveIcebergTestUtils.FULL_SCHEMA_OBJECT_INSPECTOR).build();
        Record expected = HiveIcebergTestUtils.getTestRecord();
        Record actual = deserializer.deserialize(HiveIcebergTestUtils.valuesForTestRecord(expected));
        HiveIcebergTestUtils.assertEquals(expected, actual);
    }

    @Test
    public void testNullDeserialize() {
        Deserializer deserializer = new Deserializer.Builder().schema(HiveIcebergTestUtils.FULL_SCHEMA).writerInspector((StructObjectInspector)IcebergObjectInspector.create((Schema)HiveIcebergTestUtils.FULL_SCHEMA)).sourceInspector((StructObjectInspector)HiveIcebergTestUtils.FULL_SCHEMA_OBJECT_INSPECTOR).build();
        Record expected = HiveIcebergTestUtils.getNullTestRecord();
        Object[] nulls = new Object[HiveIcebergTestUtils.FULL_SCHEMA.columns().size()];
        Arrays.fill(nulls, null);
        Record actual = deserializer.deserialize((Object)nulls);
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertNull((Object)deserializer.deserialize(null));
    }
}

