/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerWithEngineBase;
import org.apache.iceberg.mr.hive.HiveIcebergTestUtils;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.mr.hive.TestUtilPhaser;
import org.apache.iceberg.relocated.com.google.common.base.Throwables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestConflictingDataFiles
extends HiveIcebergStorageHandlerWithEngineBase {
    private final String storageHandlerStub = "'org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerStub'";

    @Before
    public void setUpTables() throws NoSuchMethodException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).identity("last_name").bucket("customer_id", 16).build();
        try (MockedStatic tableOps = Mockito.mockStatic(HiveTableOperations.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            this.testTables.createTable(shell, "customers", HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, spec, this.fileFormat, HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_2, 2, Collections.emptyMap(), "'org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerStub'");
        }
        shell.executeStatement(this.testTables.getInsertQuery(HiveIcebergStorageHandlerTestUtils.OTHER_CUSTOMER_RECORDS_1, TableIdentifier.of((String[])new String[]{"default", "customers"}), false));
        TestUtilPhaser.getInstance();
    }

    @After
    public void destroyTestSetUp() {
        TestUtilPhaser.destroyInstance();
    }

    @Override
    protected void validateTestParams() {
        Assume.assumeTrue((this.fileFormat.equals((Object)FileFormat.PARQUET) && this.isVectorized && this.testTableType.equals((Object)TestTables.TestTableType.HIVE_CATALOG) ? 1 : 0) != 0);
    }

    @Test
    public void testSingleFilterUpdate() {
        String[] singleFilterQuery = new String[]{"UPDATE customers SET first_name='Changed' WHERE  last_name='Taylor'", "UPDATE customers SET first_name='Changed' WHERE  last_name='Donnel'"};
        try {
            Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                TestUtilPhaser.getInstance().getPhaser().register();
                HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                shell.executeStatement(singleFilterQuery[i]);
                shell.closeSession();
            });
            List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, first_name");
            Assert.assertEquals((long)12L, (long)objects.size());
            List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(1L, "Changed", "Taylor").add(2L, "Changed", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(2L, "Joanna", "Silver").add(3L, "Marci", "Barna").add(3L, "Blake", "Burr").add(3L, "Trudy", "Henderson").add(3L, "Trudy", "Johnson").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
            HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
        }
        catch (Throwable ex) {
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            Assert.fail((String)String.valueOf(cause));
        }
    }

    @Test
    public void testMultiFiltersUpdate() {
        block2: {
            String[] multiFilterQuery = new String[]{"UPDATE customers SET first_name='Changed' WHERE  last_name='Henderson' OR last_name='Johnson'", "UPDATE customers SET first_name='Changed' WHERE  last_name='Taylor' AND customer_id=1"};
            try {
                Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                    TestUtilPhaser.getInstance().getPhaser().register();
                    HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                    HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                    shell.executeStatement(multiFilterQuery[i]);
                    shell.closeSession();
                });
            }
            catch (Throwable ex) {
                Throwable cause = Throwables.getRootCause((Throwable)ex);
                Assert.assertTrue((boolean)(cause instanceof ValidationException));
                if (!cause.getMessage().matches("^Found.*conflicting.*files(.*)")) break block2;
                Assert.fail();
            }
        }
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, first_name");
        Assert.assertEquals((long)12L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(1L, "Changed", "Taylor").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(2L, "Joanna", "Silver").add(3L, "Marci", "Barna").add(3L, "Blake", "Burr").add(3L, "Changed", "Henderson").add(3L, "Changed", "Johnson").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testDeleteFilters() {
        block2: {
            String[] sql = new String[]{"DELETE FROM customers WHERE  last_name='Taylor'", "DELETE FROM customers WHERE last_name='Donnel'", "DELETE FROM customers WHERE last_name='Henderson' OR last_name='Johnson'"};
            try {
                Tasks.range((int)3).executeWith(Executors.newFixedThreadPool(3)).run(i -> {
                    TestUtilPhaser.getInstance().getPhaser().register();
                    HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                    HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                    HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                    shell.executeStatement(sql[i]);
                    shell.closeSession();
                });
            }
            catch (Throwable ex) {
                Throwable cause = Throwables.getRootCause((Throwable)ex);
                Assert.assertTrue((boolean)(cause instanceof ValidationException));
                if (!cause.getMessage().matches("^Found.*conflicting.*files(.*)")) break block2;
                Assert.fail();
            }
        }
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, first_name");
        Assert.assertEquals((long)8L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(2L, "Joanna", "Silver").add(3L, "Marci", "Barna").add(3L, "Blake", "Burr").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
        TestUtilPhaser.destroyInstance();
    }

    @Test
    public void testConflictingUpdates() {
        String[] singleFilterQuery = new String[]{"UPDATE customers SET first_name='Changed' WHERE  last_name='Taylor'", "UPDATE customers SET first_name='Changed' WHERE  last_name='Taylor'"};
        try {
            Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
                TestUtilPhaser.getInstance().getPhaser().register();
                HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
                HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
                HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
                shell.executeStatement(singleFilterQuery[i]);
                shell.closeSession();
            });
        }
        catch (Throwable ex) {
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            Assert.assertTrue((boolean)(cause instanceof ValidationException));
            Assert.assertTrue((boolean)cause.getMessage().matches("^Found.*conflicting.*files(.*)"));
        }
        List<Object[]> objects = shell.executeStatement("SELECT * FROM customers ORDER BY customer_id, last_name, first_name");
        Assert.assertEquals((long)12L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(1L, "Changed", "Taylor").add(2L, "Jake", "Donnel").add(2L, "Susan", "Morrison").add(2L, "Bob", "Silver").add(2L, "Joanna", "Silver").add(3L, "Marci", "Barna").add(3L, "Blake", "Burr").add(3L, "Trudy", "Henderson").add(3L, "Trudy", "Johnson").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(HiveIcebergStorageHandlerTestUtils.CUSTOMER_SCHEMA, objects), 0);
    }

    @Test
    public void testConcurrentInsertAndInsertOverwrite() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"p", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("i", 10).build();
        this.testTables.createTable(shell, "ice_t", schema, spec, this.fileFormat, TestHelper.RecordsBuilder.newInstance(schema).add(1, 1).add(2, 2).add(10, 10).add(20, 20).add(40, 40).add(30, 30).build(), this.formatVersion);
        String[] singleFilterQuery = new String[]{"INSERT INTO ice_t SELECT i*100, p*100 FROM ice_t", "INSERT OVERWRITE TABLE ice_t SELECT i+1, p+1 FROM ice_t"};
        Tasks.range((int)2).executeWith(Executors.newFixedThreadPool(2)).run(i -> {
            if (i == 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
            HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
            HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
            HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_EXT_LOCKING_ENABLED, (boolean)true);
            shell.getHiveConf().setBoolean("iceberg.engine.hive.lock-enabled", false);
            HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, (String)"overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo");
            shell.executeStatement(singleFilterQuery[i]);
            shell.closeSession();
        });
        List<Object[]> objects = shell.executeStatement("SELECT * FROM ice_t");
        Assert.assertEquals((long)12L, (long)objects.size());
        List<Record> expected = TestHelper.RecordsBuilder.newInstance(schema).add(2, 2).add(3, 3).add(11, 11).add(21, 21).add(31, 31).add(41, 41).add(101, 101).add(201, 201).add(1001, 1001).add(2001, 2001).add(3001, 3001).add(4001, 4001).build();
        HiveIcebergTestUtils.validateData(expected, HiveIcebergTestUtils.valueForRow(schema, objects), 0);
    }
}

