/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.common.type.TimestampUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobID;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.ByteBuffers;
import org.junit.Assert;

public class HiveIcebergTestUtils {
    public static final Schema FULL_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"boolean_type", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)2, (String)"integer_type", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"long_type", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"float_type", (Type)Types.FloatType.get()), Types.NestedField.optional((int)5, (String)"double_type", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"date_type", (Type)Types.DateType.get()), Types.NestedField.optional((int)7, (String)"tstz", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)8, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)9, (String)"string_type", (Type)Types.StringType.get()), Types.NestedField.optional((int)10, (String)"fixed_type", (Type)Types.FixedType.ofLength((int)3)), Types.NestedField.optional((int)11, (String)"binary_type", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)12, (String)"decimal_type", (Type)Types.DecimalType.of((int)38, (int)10)), Types.NestedField.optional((int)13, (String)"time_type", (Type)Types.TimeType.get()), Types.NestedField.optional((int)14, (String)"uuid_type", (Type)Types.UUIDType.get())});
    public static final StandardStructObjectInspector FULL_SCHEMA_OBJECT_INSPECTOR = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("boolean_type", "integer_type", "long_type", "float_type", "double_type", "date_type", "tstz", "ts", "string_type", "fixed_type", "binary_type", "decimal_type", "time_type", "uuid_type"), Arrays.asList(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableBinaryObjectInspector, PrimitiveObjectInspectorFactory.writableBinaryObjectInspector, PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector));

    private HiveIcebergTestUtils() {
    }

    public static Record getTestRecord() {
        GenericRecord record = GenericRecord.create((Schema)FULL_SCHEMA);
        record.set(0, (Object)true);
        record.set(1, (Object)1);
        record.set(2, (Object)2L);
        record.set(3, (Object)Float.valueOf(3.1f));
        record.set(4, (Object)4.2);
        record.set(5, (Object)LocalDate.of(2020, 1, 21));
        record.set(6, (Object)OffsetDateTime.of(2017, 11, 22, 11, 30, 7, 0, ZoneOffset.ofHours(2)));
        record.set(7, (Object)LocalDateTime.of(2019, 2, 22, 9, 44, 54));
        record.set(8, (Object)"kilenc");
        record.set(9, (Object)new byte[]{0, 1, 2});
        record.set(10, (Object)ByteBuffer.wrap(new byte[]{0, 1, 2, 3}));
        record.set(11, (Object)new BigDecimal("0.0000000013"));
        record.set(12, (Object)LocalTime.of(11, 33));
        record.set(13, (Object)UUID.fromString("73689599-d7fc-4dfb-b94e-106ff20284a5"));
        return record;
    }

    public static Record getNullTestRecord() {
        GenericRecord record = GenericRecord.create((Schema)FULL_SCHEMA);
        for (int i = 0; i < FULL_SCHEMA.columns().size(); ++i) {
            record.set(i, null);
        }
        return record;
    }

    public static List<Object> valuesForTestRecord(Record record) {
        return Arrays.asList(new BooleanWritable(Boolean.TRUE.booleanValue()), new IntWritable(((Integer)record.get(1, Integer.class)).intValue()), new LongWritable(((Long)record.get(2, Long.class)).longValue()), new FloatWritable(((Float)record.get(3, Float.class)).floatValue()), new DoubleWritable(((Double)record.get(4, Double.class)).doubleValue()), new DateWritable((int)((LocalDate)record.get(5, LocalDate.class)).toEpochDay()), new TimestampWritable(Timestamp.from(((OffsetDateTime)record.get(6, OffsetDateTime.class)).toInstant())), new TimestampWritable(Timestamp.valueOf((LocalDateTime)record.get(7, LocalDateTime.class))), new Text((String)record.get(8, String.class)), new BytesWritable((byte[])record.get(9, byte[].class)), new BytesWritable(ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)record.get(10, ByteBuffer.class)))), new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)record.get(11, BigDecimal.class)))), new Text(((LocalTime)record.get(12, LocalTime.class)).toString()), new Text(((UUID)record.get(13, UUID.class)).toString()));
    }

    public static List<Record> valueForRow(Schema schema, List<Object[]> rows) {
        return rows.stream().map(row -> {
            GenericRecord record = GenericRecord.create((Schema)schema);
            for (int i = 0; i < ((Object[])row).length; ++i) {
                record.set(i, row[i]);
            }
            return record;
        }).collect(Collectors.toList());
    }

    public static void assertEquals(Record expected, Record actual) {
        for (int i = 0; i < expected.size(); ++i) {
            if (expected.get(i) instanceof OffsetDateTime) {
                Assert.assertEquals((Object)((OffsetDateTime)expected.get(i)).toInstant(), (Object)((OffsetDateTime)actual.get(i)).toInstant());
                continue;
            }
            if (expected.get(i) instanceof byte[]) {
                Assert.assertArrayEquals((byte[])((byte[])expected.get(i)), (byte[])((byte[])actual.get(i)));
                continue;
            }
            Assert.assertEquals((Object)expected.get(i), (Object)actual.get(i));
        }
    }

    public static void validateData(Table table, List<Record> expected, int sortBy) throws IOException {
        table.refresh();
        ArrayList records = Lists.newArrayListWithExpectedSize((int)expected.size());
        try (CloseableIterable iterable = IcebergGenerics.read((Table)table).build();){
            iterable.forEach(records::add);
        }
        HiveIcebergTestUtils.validateData(expected, (List<Record>)records, sortBy);
    }

    public static void validateData(List<Record> expected, List<Record> actual, int sortBy) {
        ArrayList sortedExpected = Lists.newArrayList(expected);
        ArrayList sortedActual = Lists.newArrayList(actual);
        sortedExpected.sort(Comparator.comparingInt(record -> record.get(sortBy).hashCode()));
        sortedActual.sort(Comparator.comparingInt(record -> record.get(sortBy).hashCode()));
        Assert.assertEquals((long)sortedExpected.size(), (long)sortedActual.size());
        HiveIcebergTestUtils.validateData(sortedExpected, sortedActual);
    }

    public static void validateData(List<Record> expected, List<Record> actual) {
        for (int i = 0; i < expected.size(); ++i) {
            HiveIcebergTestUtils.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public static void validateFiles(Table table, Configuration conf, JobID jobId, int dataFileNum) throws IOException {
        List dataFiles;
        try (Stream<java.nio.file.Path> files = Files.walk(Paths.get(table.location() + "/data", new String[0]), new FileVisitOption[0]);){
            dataFiles = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.getFileName().toString().startsWith(".")).collect(Collectors.toList());
        }
        Assert.assertEquals((long)dataFileNum, (long)dataFiles.size());
        Assert.assertFalse((boolean)new File(HiveIcebergOutputCommitter.generateJobLocation((String)table.location(), (Configuration)conf, (org.apache.hadoop.mapreduce.JobID)jobId)).exists());
    }

    public static void validateDataWithSQL(TestHiveShell shell, String tableName, List<Record> expected, String sortBy) {
        List<Object[]> rows = shell.executeStatement("SELECT * FROM " + tableName + " ORDER BY " + sortBy);
        Assert.assertEquals((long)expected.size(), (long)rows.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object[] row = rows.get(i);
            Record record = expected.get(i);
            Assert.assertEquals((long)record.size(), (long)row.length);
            for (int j = 0; j < record.size(); ++j) {
                Object field = record.get(j);
                if (field == null) {
                    Assert.assertNull((Object)row[j]);
                    continue;
                }
                if (field instanceof LocalDateTime) {
                    Assert.assertEquals((long)((LocalDateTime)field).toInstant(ZoneOffset.UTC).toEpochMilli(), (long)TimestampUtils.stringToTimestamp((String)((String)row[j])).toEpochMilli());
                    continue;
                }
                if (field instanceof OffsetDateTime) {
                    Assert.assertEquals((long)((OffsetDateTime)field).toInstant().toEpochMilli(), (long)TimestampTZUtil.parse((String)((String)row[j]), (ZoneId)ZoneId.systemDefault()).toEpochMilli());
                    continue;
                }
                Assert.assertEquals((Object)field.toString(), (Object)row[j].toString());
            }
        }
    }

    public static DeleteFile createEqualityDeleteFile(Table table, String deleteFilePath, List<String> equalityFields, FileFormat fileFormat, List<Record> rowsToDelete) throws IOException {
        EqualityDeleteWriter eqWriter;
        List equalityFieldIds = equalityFields.stream().map(id -> table.schema().findField(id).fieldId()).collect(Collectors.toList());
        Schema eqDeleteRowSchema = table.schema().select(equalityFields.toArray(new String[0]));
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema(), table.spec(), ArrayUtil.toIntArray(equalityFieldIds), eqDeleteRowSchema, null);
        EncryptedOutputFile outputFile = table.encryption().encrypt(HadoopOutputFile.fromPath((Path)new Path(table.location(), deleteFilePath), (Configuration)new Configuration()));
        PartitionKey part = new PartitionKey(table.spec(), eqDeleteRowSchema);
        part.partition((StructLike)rowsToDelete.get(0));
        try (EqualityDeleteWriter writer = eqWriter = appenderFactory.newEqDeleteWriter(outputFile, fileFormat, (StructLike)part);){
            writer.write(rowsToDelete);
        }
        return eqWriter.toDeleteFile();
    }

    public static DeleteFile createPositionalDeleteFile(Table table, String deleteFilePath, FileFormat fileFormat, Map<String, Object> partitionValues, List<PositionDelete<Record>> deletes) throws IOException {
        PositionDeleteWriter posWriter;
        Schema posDeleteRowSchema = deletes.get(0).row() == null ? null : table.schema();
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema(), table.spec(), null, null, posDeleteRowSchema);
        EncryptedOutputFile outputFile = table.encryption().encrypt(HadoopOutputFile.fromPath((Path)new Path(table.location(), deleteFilePath), (Configuration)new Configuration()));
        PartitionKey partitionKey = null;
        if (partitionValues != null) {
            GenericRecord record = GenericRecord.create((Schema)table.schema()).copy(partitionValues);
            partitionKey = new PartitionKey(table.spec(), table.schema());
            partitionKey.partition((StructLike)record);
        }
        try (PositionDeleteWriter writer = posWriter = appenderFactory.newPosDeleteWriter(outputFile, fileFormat, partitionKey);){
            deletes.forEach(del -> {
                PositionDelete positionDelete = PositionDelete.create();
                positionDelete.set(del.path(), del.pos(), del.row());
                writer.write(positionDelete);
            });
        }
        return posWriter.toDeleteFile();
    }

    public static String timestampAfterSnapshot(Table table, int snapshotPosition) {
        List history = table.history();
        long snapshotTime = ((HistoryEntry)history.get(snapshotPosition)).timestampMillis();
        long time = snapshotTime + 100L;
        if (history.size() > snapshotPosition + 1) {
            time = snapshotTime + (((HistoryEntry)history.get(snapshotPosition + 1)).timestampMillis() - snapshotTime) / 2L;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000000");
        return simpleDateFormat.format(new Date(time));
    }
}

