/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandlerTestUtils;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class HiveIcebergStorageHandlerWithEngineBase {
    public static final String RETRY_STRATEGIES = "overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo,write_conflict";
    public static final String RETRY_STRATEGIES_WITHOUT_WRITE_CONFLICT = "overlay,reoptimize,reexecute_lost_am,dagsubmit,recompile_without_cbo";
    protected static final Schema ORDER_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"order_id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"total", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"product_id", (Type)Types.LongType.get())});
    protected static final List<Record> ORDER_RECORDS = TestHelper.RecordsBuilder.newInstance(ORDER_SCHEMA).add(100L, 0L, 11.11, 1L).add(101L, 0L, 22.22, 2L).add(102L, 1L, 33.33, 3L).build();
    protected static final Schema PRODUCT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"name", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"price", (Type)Types.DoubleType.get())});
    protected static final List<Record> PRODUCT_RECORDS = TestHelper.RecordsBuilder.newInstance(PRODUCT_SCHEMA).add(1L, "skirt", 11.11).add(2L, "tee", 22.22).add(3L, "watch", 33.33).build();
    protected static final List<Type> SUPPORTED_TYPES = ImmutableList.of((Object)Types.BooleanType.get(), (Object)Types.IntegerType.get(), (Object)Types.LongType.get(), (Object)Types.FloatType.get(), (Object)Types.DoubleType.get(), (Object)Types.DateType.get(), (Object)Types.TimestampType.withZone(), (Object)Types.TimestampType.withoutZone(), (Object)Types.StringType.get(), (Object)Types.BinaryType.get(), (Object)Types.DecimalType.of((int)3, (int)1), (Object)Types.UUIDType.get(), (Object[])new Type[]{Types.FixedType.ofLength((int)5), Types.TimeType.get()});
    protected static final Map<String, String> STATS_MAPPING = ImmutableMap.of((Object)"numFiles", (Object)"total-data-files", (Object)"numRows", (Object)"total-records", (Object)"totalSize", (Object)"total-files-size");
    protected static TestHiveShell shell;
    protected TestTables testTables;
    @Parameterized.Parameter(value=0)
    public FileFormat fileFormat;
    @Parameterized.Parameter(value=1)
    public TestTables.TestTableType testTableType;
    @Parameterized.Parameter(value=2)
    public boolean isVectorized;
    @Parameterized.Parameter(value=3)
    public Integer formatVersion;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public Timeout timeout = new Timeout(500000L, TimeUnit.MILLISECONDS);

    @Parameterized.Parameters(name="fileFormat={0}, catalog={1}, isVectorized={2}, formatVersion={3}")
    public static Collection<Object[]> parameters() {
        ArrayList testParams = Lists.newArrayList();
        for (FileFormat fileFormat : HiveIcebergStorageHandlerTestUtils.FILE_FORMATS) {
            IntStream.of(2, 1).forEach(formatVersion -> {
                testParams.add(new Object[]{fileFormat, TestTables.TestTableType.HIVE_CATALOG, false, formatVersion});
                if (fileFormat != FileFormat.METADATA) {
                    testParams.add(new Object[]{fileFormat, TestTables.TestTableType.HIVE_CATALOG, true, formatVersion});
                }
            });
        }
        for (TestTables.TestTableType testTableType : TestTables.ALL_TABLE_TYPES) {
            if (testTableType == TestTables.TestTableType.HIVE_CATALOG) continue;
            testParams.add(new Object[]{FileFormat.PARQUET, testTableType, false, 1});
        }
        return testParams;
    }

    @BeforeClass
    public static void beforeClass() {
        shell = HiveIcebergStorageHandlerTestUtils.shell();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        shell.stop();
    }

    @Before
    public void before() throws IOException {
        this.validateTestParams();
        this.testTables = HiveIcebergStorageHandlerTestUtils.testTables(shell, this.testTableType, this.temp);
        HiveIcebergStorageHandlerTestUtils.init(shell, this.testTables, this.temp);
        HiveConf.setBoolVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)this.isVectorized);
        if (this.isVectorized) {
            HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
        } else {
            HiveConf.setVar((Configuration)shell.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"more");
        }
    }

    protected void validateTestParams() {
        Assume.assumeTrue((this.formatVersion == 1 ? 1 : 0) != 0);
    }

    @After
    public void after() throws Exception {
        HiveIcebergStorageHandlerTestUtils.close(shell);
        ExecMapper.setDone((boolean)false);
    }

    protected void validateBasicStats(Table icebergTable, String dbName, String tableName) throws TException, InterruptedException {
        Map hmsParams = shell.metastore().getTable(dbName, tableName).getParameters();
        Map<String, String> summary = Maps.newHashMap();
        if (icebergTable.currentSnapshot() == null) {
            for (String string : STATS_MAPPING.values()) {
                summary.put(string, "0");
            }
        } else {
            summary = icebergTable.currentSnapshot().summary();
        }
        for (Map.Entry entry : STATS_MAPPING.entrySet()) {
            Assert.assertEquals(summary.get(entry.getValue()), hmsParams.get(entry.getKey()));
        }
    }
}

