/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hive.iceberg.org.apache.orc.OrcConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.TestHiveShell;
import org.apache.iceberg.mr.hive.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.rules.TemporaryFolder;

public class HiveIcebergStorageHandlerTestUtils {
    static final FileFormat[] FILE_FORMATS = new FileFormat[]{FileFormat.AVRO, FileFormat.ORC, FileFormat.PARQUET};
    static final Schema CUSTOMER_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"customer_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"first_name", (Type)Types.StringType.get(), (String)"This is first name"), Types.NestedField.optional((int)3, (String)"last_name", (Type)Types.StringType.get(), (String)"This is last name")});
    static final Schema CUSTOMER_SCHEMA_WITH_UPPERCASE = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"CustomER_Id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"First_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"Last_name", (Type)Types.StringType.get())});
    static final Schema USER_CLICKS_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"name", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"age", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"num_clicks", (Type)Types.IntegerType.get())});
    static final List<Record> CUSTOMER_RECORDS = TestHelper.RecordsBuilder.newInstance(CUSTOMER_SCHEMA).add(0L, "Alice", "Brown").add(1L, "Bob", "Green").add(2L, "Trudy", "Pink").build();
    static final List<Record> OTHER_CUSTOMER_RECORDS_1 = TestHelper.RecordsBuilder.newInstance(CUSTOMER_SCHEMA).add(3L, "Marci", "Barna").add(4L, "Laci", "Zold").add(5L, "Peti", "Rozsaszin").build();
    static final List<Record> OTHER_CUSTOMER_RECORDS_2 = TestHelper.RecordsBuilder.newInstance(CUSTOMER_SCHEMA).add(1L, "Joanna", "Pierce").add(1L, "Sharon", "Taylor").add(2L, "Joanna", "Silver").add(2L, "Bob", "Silver").add(2L, "Susan", "Morrison").add(2L, "Jake", "Donnel").add(3L, "Blake", "Burr").add(3L, "Trudy", "Johnson").add(3L, "Trudy", "Henderson").build();
    static final List<Record> USER_CLICKS_RECORDS_1 = TestHelper.RecordsBuilder.newInstance(USER_CLICKS_SCHEMA).add("amy", 35, 12341234).add("bob", 66, 123471).add("cal", 21, 431).build();
    static final List<Record> USER_CLICKS_RECORDS_2 = TestHelper.RecordsBuilder.newInstance(USER_CLICKS_SCHEMA).add("amy", 52, 22323).add("drake", 44, 34222).add("earl", 21, 12347).build();

    private HiveIcebergStorageHandlerTestUtils() {
    }

    static TestHiveShell shell() {
        return HiveIcebergStorageHandlerTestUtils.shell(Collections.emptyMap());
    }

    static TestHiveShell shell(Map<String, String> configs) {
        TestHiveShell shell = new TestHiveShell();
        shell.setHiveConfValue("hive.notification.event.poll.interval", "-1");
        shell.setHiveConfValue("hive.tez.exec.print.summary", "true");
        shell.setHiveConfValue("tez.counters.max", "1024");
        configs.forEach((k, v) -> shell.setHiveConfValue((String)k, (String)v));
        shell.setHiveConfValue(OrcConf.FORCE_POSITIONAL_EVOLUTION.getHiveConfName(), "true");
        shell.start();
        return shell;
    }

    static TestTables testTables(TestHiveShell shell, TestTables.TestTableType testTableType, TemporaryFolder temp) throws IOException {
        return HiveIcebergStorageHandlerTestUtils.testTables(shell, testTableType, temp, "default_iceberg");
    }

    static TestTables testTables(TestHiveShell shell, TestTables.TestTableType testTableType, TemporaryFolder temp, String catalogName) throws IOException {
        return testTableType.instance((Configuration)shell.metastore().hiveConf(), temp, catalogName);
    }

    static void init(TestHiveShell shell, TestTables testTables, TemporaryFolder temp) {
        HiveIcebergStorageHandlerTestUtils.init(shell, testTables, temp, "tez");
    }

    static void init(TestHiveShell shell, TestTables testTables, TemporaryFolder temp, String engine) {
        shell.getSession();
        for (Map.Entry<String, String> property : testTables.properties().entrySet()) {
            shell.setHiveSessionValue(property.getKey(), property.getValue());
        }
        shell.setHiveSessionValue("hive.execution.engine", engine);
        shell.setHiveSessionValue("hive.jar.directory", temp.getRoot().getAbsolutePath());
        shell.setHiveSessionValue("tez.staging-dir", temp.getRoot().getAbsolutePath());
        DefaultMetricsSystem.instance().init("TestMetrics");
    }

    static void close(TestHiveShell shell) throws Exception {
        shell.closeSession();
        shell.metastore().reset();
        DefaultMetricsSystem.shutdown();
        System.gc();
    }
}

