/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Tables;
import org.apache.iceberg.data.DeleteReadTests;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.TestIcebergInputFormats;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestInputFormatReaderDeletes
extends DeleteReadTests {
    private final Configuration conf = new Configuration();
    private final HadoopTables tables = new HadoopTables(this.conf);
    private TestHelper helper;
    private final String inputFormat;
    private final FileFormat fileFormat;

    @Parameterized.Parameters(name="fileFormat = {0}, formatVersion = {1}, inputFormat={2}")
    public static Object[][] parameters() {
        return new Object[][]{{FileFormat.PARQUET, 2, "IcebergInputFormat"}, {FileFormat.AVRO, 2, "IcebergInputFormat"}, {FileFormat.ORC, 2, "IcebergInputFormat"}, {FileFormat.PARQUET, 2, "MapredIcebergInputFormat"}, {FileFormat.AVRO, 2, "MapredIcebergInputFormat"}, {FileFormat.ORC, 2, "MapredIcebergInputFormat"}, {FileFormat.PARQUET, 3, "IcebergInputFormat"}, {FileFormat.PARQUET, 3, "MapredIcebergInputFormat"}};
    }

    @Override
    @Before
    public void writeTestDataFile() throws IOException {
        this.conf.set("type", "location");
        super.writeTestDataFile();
    }

    public TestInputFormatReaderDeletes(FileFormat fileFormat, int formatVersion, String inputFormat) {
        super(formatVersion);
        this.fileFormat = fileFormat;
        this.inputFormat = inputFormat;
    }

    @Override
    protected Table createTable(String name, Schema schema, PartitionSpec spec) throws IOException {
        File location = this.temp.newFolder(new String[]{this.inputFormat, this.fileFormat.name()});
        Assert.assertTrue((boolean)location.delete());
        this.helper = new TestHelper(this.conf, (Tables)this.tables, location.toString(), schema, spec, this.fileFormat, this.temp);
        Table table = this.helper.createTable();
        TableOperations ops = ((BaseTable)table).operations();
        TableMetadata meta = ops.current();
        ops.commit(meta, meta.upgradeToFormatVersion(this.formatVersion));
        return table;
    }

    @Override
    protected void dropTable(String name) {
        this.tables.dropTable(this.helper.table().location());
    }

    @Override
    public StructLikeSet rowSet(String name, Table table, String ... columns) {
        InputFormatConfig.ConfigBuilder builder = new InputFormatConfig.ConfigBuilder(this.conf).readFrom(table.location());
        Schema projected = table.schema().select(columns);
        StructLikeSet set = StructLikeSet.create((Types.StructType)projected.asStruct());
        set.addAll((Collection)TestIcebergInputFormats.TESTED_INPUT_FORMATS.stream().filter(recordFactory -> recordFactory.name().equals(this.inputFormat)).map(recordFactory -> recordFactory.create(builder.project(projected).conf()).getRecords()).flatMap(Collection::stream).map(record -> new InternalRecordWrapper(projected.asStruct()).wrap((StructLike)record)).collect(Collectors.toList()));
        return set;
    }

    @Override
    protected boolean expectPruned() {
        return false;
    }
}

