/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Tables;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.TestHelper;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.mr.mapred.MapredIcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ThreadPools;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIcebergInputFormats {
    public static final List<TestInputFormat.Factory<Record>> TESTED_INPUT_FORMATS = ImmutableList.of(TestInputFormat.newFactory("IcebergInputFormat", TestIcebergInputFormat::create), TestInputFormat.newFactory("MapredIcebergInputFormat", TestMapredIcebergInputFormat::create));
    private static final List<String> TESTED_FILE_FORMATS = ImmutableList.of((Object)"avro", (Object)"orc", (Object)"parquet");
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("date").bucket("id", 1).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Configuration conf;
    private TestHelper helper;
    private InputFormatConfig.ConfigBuilder builder;
    private final TestInputFormat.Factory<Record> testInputFormat;
    private final FileFormat fileFormat;
    private static final Schema LOG_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"level", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"message", (Type)Types.StringType.get())});
    private static final PartitionSpec IDENTITY_PARTITION_SPEC = PartitionSpec.builderFor((Schema)LOG_SCHEMA).identity("date").identity("level").build();

    @Before
    public void before() throws IOException {
        this.conf = new JobConf();
        this.conf.set("type", "location");
        HadoopTables tables = new HadoopTables(this.conf);
        File location = this.temp.newFolder(new String[]{this.testInputFormat.name(), this.fileFormat.name()});
        Assert.assertTrue((boolean)location.delete());
        this.helper = new TestHelper(this.conf, (Tables)tables, location.toString(), SCHEMA, SPEC, this.fileFormat, this.temp);
        this.builder = new InputFormatConfig.ConfigBuilder(this.conf).readFrom(location.toString());
    }

    @Parameterized.Parameters(name="testInputFormat = {0}, fileFormat = {1}")
    public static Object[][] parameters() {
        Object[][] parameters = new Object[TESTED_INPUT_FORMATS.size() * TESTED_FILE_FORMATS.size()][2];
        int idx = 0;
        for (TestInputFormat.Factory<Record> inputFormat : TESTED_INPUT_FORMATS) {
            for (String fileFormat : TESTED_FILE_FORMATS) {
                parameters[idx++] = new Object[]{inputFormat, fileFormat};
            }
        }
        return parameters;
    }

    public TestIcebergInputFormats(TestInputFormat.Factory<Record> testInputFormat, String fileFormat) {
        this.testInputFormat = testInputFormat;
        this.fileFormat = FileFormat.fromString((String)fileFormat);
    }

    @Test
    public void testUnpartitionedTable() throws Exception {
        this.helper.createUnpartitionedTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(1, 0L);
        this.helper.appendToTable(null, expectedRecords);
        this.testInputFormat.create(this.builder.conf()).validate(expectedRecords);
    }

    @Test
    public void testPartitionedTable() throws Exception {
        this.helper.createTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(1, 0L);
        expectedRecords.get(0).set(2, (Object)"2020-03-20");
        this.helper.appendToTable((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        this.testInputFormat.create(this.builder.conf()).validate(expectedRecords);
    }

    @Test
    public void testFilterExp() throws Exception {
        this.helper.createTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(2, 0L);
        expectedRecords.get(0).set(2, (Object)"2020-03-20");
        expectedRecords.get(1).set(2, (Object)"2020-03-20");
        DataFile dataFile1 = this.helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        DataFile dataFile2 = this.helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-21", 0}), this.helper.generateRandomRecords(2, 0L));
        this.helper.appendToTable(dataFile1, dataFile2);
        this.builder.filter((Expression)Expressions.equal((String)"date", (Object)"2020-03-20"));
        this.testInputFormat.create(this.builder.conf()).validate(expectedRecords);
    }

    @Test
    public void testResiduals() throws Exception {
        this.helper.createTable();
        List<Record> writeRecords = this.helper.generateRandomRecords(2, 0L);
        writeRecords.get(0).set(1, (Object)123L);
        writeRecords.get(0).set(2, (Object)"2020-03-20");
        writeRecords.get(1).set(1, (Object)456L);
        writeRecords.get(1).set(2, (Object)"2020-03-20");
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.add(writeRecords.get(0));
        DataFile dataFile1 = this.helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), writeRecords);
        DataFile dataFile2 = this.helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-21", 0}), this.helper.generateRandomRecords(2, 0L));
        this.helper.appendToTable(dataFile1, dataFile2);
        this.builder.filter(Expressions.and((Expression)Expressions.equal((String)"date", (Object)"2020-03-20"), (Expression)Expressions.equal((String)"id", (Object)123)));
        this.testInputFormat.create(this.builder.conf()).validate(expectedRecords);
        this.builder.skipResidualFiltering();
        this.testInputFormat.create(this.builder.conf()).validate(writeRecords);
    }

    @Test
    @Ignore
    public void testFailedResidualFiltering() throws Exception {
        Assume.assumeTrue((String)"Vectorization is not yet supported for AVRO", (this.fileFormat != FileFormat.AVRO ? 1 : 0) != 0);
        this.helper.createTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(2, 0L);
        expectedRecords.get(0).set(2, (Object)"2020-03-20");
        expectedRecords.get(1).set(2, (Object)"2020-03-20");
        this.helper.appendToTable((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        this.builder.useHiveRows().filter(Expressions.and((Expression)Expressions.equal((String)"date", (Object)"2020-03-20"), (Expression)Expressions.equal((String)"id", (Object)0)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testInputFormat.create(this.builder.conf())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Filter expression ref(name=\"id\") == 0 is not completely satisfied. Additional rows can be returned not satisfied by the filter expression");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testInputFormat.create(this.builder.conf())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Filter expression ref(name=\"id\") == 0 is not completely satisfied. Additional rows can be returned not satisfied by the filter expression");
    }

    @Test
    public void testProjection() throws Exception {
        this.helper.createTable();
        List<Record> inputRecords = this.helper.generateRandomRecords(1, 0L);
        this.helper.appendToTable((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), inputRecords);
        Schema projection = TypeUtil.select((Schema)SCHEMA, (Set)ImmutableSet.of((Object)1));
        this.builder.project(projection);
        List<Record> outputRecords = this.testInputFormat.create(this.builder.conf()).getRecords();
        Assert.assertEquals((long)inputRecords.size(), (long)outputRecords.size());
        Assert.assertEquals((Object)projection.asStruct(), (Object)outputRecords.get(0).struct());
    }

    @Test
    public void testIdentityPartitionProjections() throws Exception {
        this.helper.createTable(LOG_SCHEMA, IDENTITY_PARTITION_SPEC);
        List<Record> inputRecords = this.helper.generateRandomRecords(10, 0L);
        Integer idx = 0;
        AppendFiles append = this.helper.table().newAppend();
        for (Record record : inputRecords) {
            record.set(1, (Object)("2020-03-2" + idx));
            record.set(2, (Object)idx.toString());
            append.appendFile(this.helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-2" + idx, idx.toString()}), (List<Record>)ImmutableList.of((Object)record)));
            idx = idx + 1;
        }
        append.commit();
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("date"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("level"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("message"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("id"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("date", "message"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("level", "message"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("date", "level"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("message", "date"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("message", "level"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("level", "date"), inputRecords);
        this.validateIdentityPartitionProjections(LOG_SCHEMA, inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("date", "level", "message"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("level", "date", "message"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("date", "message", "level"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("level", "message", "date"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("message", "date", "level"), inputRecords);
        this.validateIdentityPartitionProjections(TestIcebergInputFormats.withColumns("message", "level", "date"), inputRecords);
    }

    private static Schema withColumns(String ... names) {
        Map indexByName = TypeUtil.indexByName((Types.StructType)LOG_SCHEMA.asStruct());
        HashSet projectedIds = Sets.newHashSet();
        for (String name : names) {
            projectedIds.add((Integer)indexByName.get(name));
        }
        return TypeUtil.select((Schema)LOG_SCHEMA, (Set)projectedIds);
    }

    private void validateIdentityPartitionProjections(Schema projectedSchema, List<Record> inputRecords) {
        this.builder.project(projectedSchema);
        List<Record> actualRecords = this.testInputFormat.create(this.builder.conf()).getRecords();
        Set fieldNames = TypeUtil.indexByName((Types.StructType)projectedSchema.asStruct()).keySet();
        for (int pos = 0; pos < inputRecords.size(); ++pos) {
            Record inputRecord = inputRecords.get(pos);
            Record actualRecord = actualRecords.get(pos);
            Assert.assertEquals((String)"Projected schema should match", (Object)projectedSchema.asStruct(), (Object)actualRecord.struct());
            for (String name : fieldNames) {
                Assert.assertEquals((String)("Projected field " + name + " should match"), (Object)inputRecord.getField(name), (Object)actualRecord.getField(name));
            }
        }
    }

    @Test
    public void testSnapshotReads() throws Exception {
        this.helper.createUnpartitionedTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(1, 0L);
        this.helper.appendToTable(null, expectedRecords);
        long snapshotId = this.helper.table().currentSnapshot().snapshotId();
        this.helper.appendToTable(null, this.helper.generateRandomRecords(1, 0L));
        this.builder.snapshotId(snapshotId);
        this.testInputFormat.create(this.builder.conf()).validate(expectedRecords);
    }

    @Test
    public void testLocality() throws Exception {
        this.helper.createUnpartitionedTable();
        List<Record> expectedRecords = this.helper.generateRandomRecords(1, 0L);
        this.helper.appendToTable(null, expectedRecords);
        for (org.apache.hadoop.mapreduce.InputSplit inputSplit : this.testInputFormat.create(this.builder.conf()).getSplits()) {
            Assert.assertArrayEquals((Object[])IcebergSplit.ANYWHERE, (Object[])inputSplit.getLocations());
        }
        this.builder.preferLocality();
        for (org.apache.hadoop.mapreduce.InputSplit inputSplit : this.testInputFormat.create(this.builder.conf()).getSplits()) {
            Assert.assertArrayEquals((Object[])new String[]{"localhost"}, (Object[])inputSplit.getLocations());
        }
    }

    @Test
    public void testCustomCatalog() throws IOException {
        String warehouseLocation = this.temp.newFolder("hadoop_catalog").getAbsolutePath();
        this.conf.set("warehouse.location", warehouseLocation);
        this.conf.set("iceberg.catalog", "default_iceberg");
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)"default_iceberg", (String)"type"), "hadoop");
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)"default_iceberg", (String)"warehouse"), warehouseLocation);
        HadoopCatalog catalog = new HadoopCatalog(this.conf, this.conf.get("warehouse.location"));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"db", "t"});
        Table table = catalog.createTable(identifier, SCHEMA, SPEC, this.helper.properties());
        this.helper.setTable(table);
        List<Record> expectedRecords = this.helper.generateRandomRecords(1, 0L);
        expectedRecords.get(0).set(2, (Object)"2020-03-20");
        this.helper.appendToTable((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        this.builder.readFrom(identifier);
        this.testInputFormat.create(this.builder.conf()).validate(expectedRecords);
    }

    @Test
    public void testDeriveLlapSetsCacheAffinityForIcebergInputFormat() {
        MapWork mapWork = new MapWork();
        PartitionDesc partitionDesc = new PartitionDesc();
        partitionDesc.setInputFileFormatClass(HiveIcebergInputFormat.class);
        mapWork.addPathToPartitionInfo(new Path("/tmp"), partitionDesc);
        Configuration job = new Configuration(false);
        HiveConf.setVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (String)"true");
        HiveConf.setBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_NONVECTOR_WRAPPER_ENABLED, (boolean)true);
        mapWork.setVectorMode(true);
        mapWork.deriveLlap(job, false);
        Assert.assertTrue((String)"Cache affinity should be set for HiveIcebergInputFormat when LLAP and vectorization is enabled", (boolean)mapWork.getCacheAffinity());
        mapWork.setVectorMode(false);
        mapWork.deriveLlap(job, false);
        Assert.assertFalse((String)"Cache affinity should be disabled for HiveIcebergInputFormat when LLAP is on, but vectorization not", (boolean)mapWork.getCacheAffinity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkerPool() throws Exception {
        Table table = this.helper.createUnpartitionedTable();
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[0]);
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[0]);
        ExecutorService workerPool1 = ThreadPools.newFixedThreadPool((String)"iceberg-plan-worker-pool", (int)1);
        ExecutorService workerPool2 = ThreadPools.newFixedThreadPool((String)"iceberg-plan-worker-pool", (int)1);
        try {
            Assertions.assertThat((String)this.getUserFromWorkerPool(user1, table, workerPool1)).isEqualTo("user1");
            Assertions.assertThat((String)this.getUserFromWorkerPool(user2, table, workerPool1)).isEqualTo("user1");
            Assertions.assertThat((String)this.getUserFromWorkerPool(user2, table, workerPool2)).isEqualTo("user2");
        }
        finally {
            workerPool1.shutdown();
            workerPool2.shutdown();
        }
    }

    private String getUserFromWorkerPool(UserGroupInformation user, Table table, ExecutorService workerpool) throws Exception {
        Method method = IcebergInputFormat.class.getDeclaredMethod("planInputSplits", Table.class, Configuration.class, ExecutorService.class);
        method.setAccessible(true);
        return (String)user.doAs(() -> {
            try {
                method.invoke((Object)new IcebergInputFormat(), table, this.conf, workerpool);
                return workerpool.submit(() -> UserGroupInformation.getCurrentUser().getUserName()).get();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get user from worker pool", e);
            }
        });
    }

    public static abstract class TestInputFormat<T> {
        private final List<IcebergSplit> splits;
        private final List<T> records;

        private TestInputFormat(List<IcebergSplit> splits, List<T> records) {
            this.splits = splits;
            this.records = records;
        }

        public List<T> getRecords() {
            return this.records;
        }

        public List<IcebergSplit> getSplits() {
            return this.splits;
        }

        public void validate(List<T> expected) {
            Assert.assertEquals(expected, this.records);
        }

        public static <T> Factory<T> newFactory(final String name, final Function<Configuration, TestInputFormat<T>> function) {
            return new Factory<T>(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public TestInputFormat<T> create(Configuration conf) {
                    return (TestInputFormat)function.apply(conf);
                }

                public String toString() {
                    return String.format("Test%s<T>", this.name());
                }
            };
        }

        public static interface Factory<T> {
            public String name();

            public TestInputFormat<T> create(Configuration var1);
        }
    }

    private static final class TestIcebergInputFormat<T>
    extends TestInputFormat<T> {
        private TestIcebergInputFormat(List<IcebergSplit> splits, List<T> records) {
            super(splits, records);
        }

        private static <T> TestIcebergInputFormat<T> create(Configuration conf) {
            TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, (org.apache.hadoop.mapreduce.TaskAttemptID)new TaskAttemptID());
            IcebergInputFormat inputFormat = new IcebergInputFormat();
            List splits = inputFormat.getSplits((JobContext)context);
            ArrayList iceSplits = Lists.newArrayListWithExpectedSize((int)splits.size());
            ArrayList records = Lists.newArrayList();
            for (org.apache.hadoop.mapreduce.InputSplit split : splits) {
                iceSplits.add((IcebergSplit)split);
                try {
                    RecordReader reader = inputFormat.createRecordReader(split, (TaskAttemptContext)context);
                    try {
                        reader.initialize(split, (TaskAttemptContext)context);
                        while (reader.nextKeyValue()) {
                            records.add(reader.getCurrentValue());
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            return new TestIcebergInputFormat<T>(iceSplits, records);
        }
    }

    private static final class TestMapredIcebergInputFormat<T>
    extends TestInputFormat<T> {
        private TestMapredIcebergInputFormat(List<IcebergSplit> splits, List<T> records) {
            super(splits, records);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> TestMapredIcebergInputFormat<T> create(Configuration conf) {
            JobConf job = new JobConf(conf);
            MapredIcebergInputFormat inputFormat = new MapredIcebergInputFormat();
            try {
                InputSplit[] splits = inputFormat.getSplits(job, 1);
                ArrayList iceSplits = Lists.newArrayListWithExpectedSize((int)splits.length);
                ArrayList records = Lists.newArrayList();
                for (InputSplit split : splits) {
                    iceSplits.add((IcebergSplit)split);
                    try (org.apache.hadoop.mapred.RecordReader reader = inputFormat.getRecordReader(split, job, Reporter.NULL);){
                        Container container = (Container)reader.createValue();
                        while (reader.next(null, (Object)container)) {
                            records.add(container.get());
                        }
                    }
                }
                return new TestMapredIcebergInputFormat<T>(iceSplits, records);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }
}

