/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Tables;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.rules.TemporaryFolder;

public class TestHelper {
    private final Configuration conf;
    private final Tables tables;
    private final String tableIdentifier;
    private final Schema schema;
    private final PartitionSpec spec;
    private final FileFormat fileFormat;
    private final TemporaryFolder tmp;
    private final Map<String, String> tblProps;
    private SortOrder order;
    private Table table;

    public TestHelper(Configuration conf, Tables tables, String tableIdentifier, Schema schema, PartitionSpec spec, FileFormat fileFormat, TemporaryFolder tmp) {
        this(conf, tables, tableIdentifier, schema, spec, fileFormat, (Map<String, String>)ImmutableMap.of(), tmp);
    }

    public TestHelper(Configuration conf, Tables tables, String tableIdentifier, Schema schema, PartitionSpec spec, FileFormat fileFormat, Map<String, String> tblProps, TemporaryFolder tmp) {
        this.conf = conf;
        this.tables = tables;
        this.tableIdentifier = tableIdentifier;
        this.schema = schema;
        this.spec = spec;
        this.fileFormat = fileFormat;
        this.tblProps = tblProps;
        this.tmp = tmp;
    }

    public void setTable(Table table) {
        this.table = table;
        this.conf.set("iceberg.mr.table.schema", SchemaParser.toJson((Schema)table.schema()));
    }

    public void setOrder(SortOrder order) {
        this.order = order;
    }

    public Table table() {
        return this.table;
    }

    public Map<String, String> properties() {
        HashMap props = Maps.newHashMap(this.tblProps);
        props.put("write.format.default", this.fileFormat.name());
        props.put("engine.hive.enabled", "true");
        props.put("write.delete.mode", RowLevelOperationMode.MERGE_ON_READ.modeName());
        return props;
    }

    public Table createTable(Schema theSchema, PartitionSpec theSpec) {
        return this.createTable(theSchema, theSpec, null);
    }

    public Table createTable(Schema theSchema, PartitionSpec theSpec, SortOrder theOrder) {
        Table tbl = theOrder != null ? this.tables.create(theSchema, theSpec, theOrder, this.properties(), this.tableIdentifier) : this.tables.create(theSchema, theSpec, this.properties(), this.tableIdentifier);
        this.setTable(tbl);
        return tbl;
    }

    public Table createTable() {
        return this.createTable(this.schema, this.spec, this.order);
    }

    public Table createUnpartitionedTable() {
        return this.createTable(this.schema, PartitionSpec.unpartitioned());
    }

    public List<Record> generateRandomRecords(int num, long seed) {
        Preconditions.checkNotNull((Object)this.table, (Object)"table not set");
        return TestHelper.generateRandomRecords(this.table.schema(), num, seed);
    }

    public static List<Record> generateRandomRecords(Schema schema, int num, long seed) {
        return RandomGenericData.generate(schema, num, seed);
    }

    public void appendToTable(DataFile ... dataFiles) {
        this.appender().appendToTable(dataFiles);
    }

    public void appendToTable(StructLike partition, List<Record> records) throws IOException {
        this.appender().appendToTable(partition, records);
    }

    public void appendToTable(List<Record> rowSet) throws IOException {
        HashMap rows = Maps.newHashMap();
        PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.table.schema());
        for (Record record : rowSet) {
            partitionKey.partition((StructLike)record);
            List partitionRows = (List)rows.get(partitionKey);
            if (partitionRows == null) {
                partitionRows = Lists.newArrayList();
                rows.put(partitionKey.copy(), partitionRows);
            }
            partitionRows.add(record);
        }
        for (PartitionKey partition : rows.keySet()) {
            this.appendToTable((StructLike)partition, (List)rows.get(partition));
        }
    }

    public DataFile writeFile(StructLike partition, List<Record> records) throws IOException {
        return this.appender().writeFile(partition, records);
    }

    public Map<DataFile, List<Record>> writeFiles(List<Record> rowSet) throws IOException {
        HashMap rows = Maps.newHashMap();
        PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.table.schema());
        for (Record record : rowSet) {
            partitionKey.partition((StructLike)record);
            List partitionRows = (List)rows.get(partitionKey);
            if (partitionRows == null) {
                partitionRows = rows.put(partitionKey.copy(), Lists.newArrayList());
            }
            partitionRows.add(record);
        }
        HashMap dataFiles = Maps.newHashMapWithExpectedSize((int)rows.size());
        for (PartitionKey partition : rows.keySet()) {
            dataFiles.put(this.writeFile((StructLike)partition, (List)rows.get(partition)), (List)rows.get(partition));
        }
        return dataFiles;
    }

    private GenericAppenderHelper appender() {
        return new GenericAppenderHelper(this.table, this.fileFormat, this.tmp, this.conf);
    }

    public static class RecordsBuilder {
        private final List<Record> records = Lists.newArrayList();
        private final Schema schema;

        private RecordsBuilder(Schema schema) {
            this.schema = schema;
        }

        public RecordsBuilder add(Object ... values) {
            Preconditions.checkArgument((this.schema.columns().size() == values.length ? 1 : 0) != 0);
            GenericRecord record = GenericRecord.create((Schema)this.schema);
            for (int i = 0; i < values.length; ++i) {
                record.set(i, values[i]);
            }
            this.records.add((Record)record);
            return this;
        }

        public List<Record> build() {
            return Collections.unmodifiableList(this.records);
        }

        public static RecordsBuilder newInstance(Schema schema) {
            return new RecordsBuilder(schema);
        }
    }
}

