/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestCatalogs {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"foo", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("foo").build();
    private Configuration conf;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Before
    public void before() {
        this.conf = new Configuration();
    }

    @Test
    public void testLoadTableFromLocation() throws IOException {
        this.conf.set("type", "location");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.loadTable((Configuration)this.conf)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Table location not set");
        HadoopTables tables = new HadoopTables();
        Table hadoopTable = tables.create(SCHEMA, this.temp.newFolder("hadoop_tables").toString());
        this.conf.set("iceberg.mr.table.location", hadoopTable.location());
        Assert.assertEquals((Object)hadoopTable.location(), (Object)Catalogs.loadTable((Configuration)this.conf).location());
    }

    @Test
    public void testLoadTableFromCatalog() throws IOException {
        String defaultCatalogName = "default";
        String warehouseLocation = this.temp.newFolder(new String[]{"hadoop", "warehouse"}).toString();
        this.setCustomCatalogProperties(defaultCatalogName, warehouseLocation);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.loadTable((Configuration)this.conf)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Table identifier not set");
        CustomHadoopCatalog catalog = new CustomHadoopCatalog(this.conf, warehouseLocation);
        Table hadoopCatalogTable = catalog.createTable(TableIdentifier.of((String[])new String[]{"table"}), SCHEMA);
        this.conf.set("iceberg.mr.table.identifier", "table");
        Assert.assertEquals((Object)hadoopCatalogTable.location(), (Object)Catalogs.loadTable((Configuration)this.conf).location());
    }

    @Test
    public void testCreateDropTableToLocation() throws IOException {
        Properties missingSchema = new Properties();
        missingSchema.put("location", this.temp.newFolder("hadoop_tables").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.createTable((Configuration)this.conf, (Properties)missingSchema)).isInstanceOf(NullPointerException.class)).hasMessage("Table schema not set");
        this.conf.set("type", "location");
        Properties missingLocation = new Properties();
        missingLocation.put("iceberg.mr.table.schema", SchemaParser.toJson((Schema)SCHEMA));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.createTable((Configuration)this.conf, (Properties)missingLocation)).isInstanceOf(NullPointerException.class)).hasMessage("Table location not set");
        Properties properties = new Properties();
        properties.put("location", this.temp.getRoot() + "/hadoop_tables");
        properties.put("iceberg.mr.table.schema", SchemaParser.toJson((Schema)SCHEMA));
        properties.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson((PartitionSpec)SPEC));
        properties.put("dummy", "test");
        Catalogs.createTable((Configuration)this.conf, (Properties)properties);
        HadoopTables tables = new HadoopTables();
        Table table = tables.load(properties.getProperty("location"));
        Assert.assertEquals((Object)properties.getProperty("location"), (Object)table.location());
        Assert.assertEquals((Object)SchemaParser.toJson((Schema)SCHEMA), (Object)SchemaParser.toJson((Schema)table.schema()));
        Assert.assertEquals((Object)PartitionSpecParser.toJson((PartitionSpec)SPEC), (Object)PartitionSpecParser.toJson((PartitionSpec)table.spec()));
        Assertions.assertThat((Map)table.properties()).containsEntry((Object)"dummy", (Object)"test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.dropTable((Configuration)this.conf, (Properties)new Properties())).isInstanceOf(NullPointerException.class)).hasMessage("Table location not set");
        Properties dropProperties = new Properties();
        dropProperties.put("location", this.temp.getRoot() + "/hadoop_tables");
        Catalogs.dropTable((Configuration)this.conf, (Properties)dropProperties);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.loadTable((Configuration)this.conf, (Properties)dropProperties)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist at location: " + properties.getProperty("location"));
    }

    @Test
    public void testCreateDropTableToCatalog() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"test", "table"});
        String defaultCatalogName = "default";
        String warehouseLocation = this.temp.newFolder(new String[]{"hadoop", "warehouse"}).toString();
        this.setCustomCatalogProperties(defaultCatalogName, warehouseLocation);
        Properties missingSchema = new Properties();
        missingSchema.put("name", identifier.toString());
        missingSchema.put("iceberg.catalog", defaultCatalogName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.createTable((Configuration)this.conf, (Properties)missingSchema)).isInstanceOf(NullPointerException.class)).hasMessage("Table schema not set");
        Properties missingIdentifier = new Properties();
        missingIdentifier.put("iceberg.mr.table.schema", SchemaParser.toJson((Schema)SCHEMA));
        missingIdentifier.put("iceberg.catalog", defaultCatalogName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.createTable((Configuration)this.conf, (Properties)missingIdentifier)).isInstanceOf(NullPointerException.class)).hasMessage("Table identifier not set");
        Properties properties = new Properties();
        properties.put("name", identifier.toString());
        properties.put("iceberg.mr.table.schema", SchemaParser.toJson((Schema)SCHEMA));
        properties.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson((PartitionSpec)SPEC));
        properties.put("dummy", "test");
        properties.put("iceberg.catalog", defaultCatalogName);
        Catalogs.createTable((Configuration)this.conf, (Properties)properties);
        CustomHadoopCatalog catalog = new CustomHadoopCatalog(this.conf, warehouseLocation);
        Table table = catalog.loadTable(identifier);
        Assert.assertEquals((Object)SchemaParser.toJson((Schema)SCHEMA), (Object)SchemaParser.toJson((Schema)table.schema()));
        Assert.assertEquals((Object)PartitionSpecParser.toJson((PartitionSpec)SPEC), (Object)PartitionSpecParser.toJson((PartitionSpec)table.spec()));
        Assertions.assertThat((Map)table.properties()).containsEntry((Object)"dummy", (Object)"test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.dropTable((Configuration)this.conf, (Properties)new Properties())).isInstanceOf(NullPointerException.class)).hasMessage("Table identifier not set");
        Properties dropProperties = new Properties();
        dropProperties.put("name", identifier.toString());
        dropProperties.put("iceberg.catalog", defaultCatalogName);
        Catalogs.dropTable((Configuration)this.conf, (Properties)dropProperties);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.loadTable((Configuration)this.conf, (Properties)dropProperties)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: test.table");
    }

    @Test
    public void testLoadCatalogDefault() {
        String catalogName = "barCatalog";
        Optional defaultCatalog = Catalogs.loadCatalog((Configuration)this.conf, (String)catalogName);
        Assert.assertTrue((boolean)defaultCatalog.isPresent());
        Assertions.assertThat((Object)((Catalog)defaultCatalog.get())).isInstanceOf(HiveCatalog.class);
        Properties properties = new Properties();
        properties.put("iceberg.catalog", catalogName);
        Assert.assertTrue((boolean)Catalogs.hiveCatalog((Configuration)this.conf, (Properties)properties));
    }

    @Test
    public void testLoadCatalogHive() {
        String catalogName = "barCatalog";
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"type"), "hive");
        Optional hiveCatalog = Catalogs.loadCatalog((Configuration)this.conf, (String)catalogName);
        Assert.assertTrue((boolean)hiveCatalog.isPresent());
        Assertions.assertThat((Object)((Catalog)hiveCatalog.get())).isInstanceOf(HiveCatalog.class);
        Properties properties = new Properties();
        properties.put("iceberg.catalog", catalogName);
        Assert.assertTrue((boolean)Catalogs.hiveCatalog((Configuration)this.conf, (Properties)properties));
    }

    @Test
    public void testLoadCatalogHadoop() {
        String catalogName = "barCatalog";
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"type"), "hadoop");
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"warehouse"), "/tmp/mylocation");
        Optional hadoopCatalog = Catalogs.loadCatalog((Configuration)this.conf, (String)catalogName);
        Assert.assertTrue((boolean)hadoopCatalog.isPresent());
        Assertions.assertThat((Object)((Catalog)hadoopCatalog.get())).isInstanceOf(HadoopCatalog.class);
        Assert.assertEquals((Object)"HadoopCatalog{name=barCatalog, location=/tmp/mylocation}", (Object)((Catalog)hadoopCatalog.get()).toString());
        Properties properties = new Properties();
        properties.put("iceberg.catalog", catalogName);
        Assert.assertFalse((boolean)Catalogs.hiveCatalog((Configuration)this.conf, (Properties)properties));
    }

    @Test
    public void testLoadCatalogCustom() {
        String catalogName = "barCatalog";
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"catalog-impl"), CustomHadoopCatalog.class.getName());
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"warehouse"), "/tmp/mylocation");
        Optional customHadoopCatalog = Catalogs.loadCatalog((Configuration)this.conf, (String)catalogName);
        Assert.assertTrue((boolean)customHadoopCatalog.isPresent());
        Assertions.assertThat((Object)((Catalog)customHadoopCatalog.get())).isInstanceOf(CustomHadoopCatalog.class);
        Properties properties = new Properties();
        properties.put("iceberg.catalog", catalogName);
        Assert.assertFalse((boolean)Catalogs.hiveCatalog((Configuration)this.conf, (Properties)properties));
    }

    @Test
    public void testLoadCatalogLocation() {
        Assert.assertFalse((boolean)Catalogs.loadCatalog((Configuration)this.conf, (String)"location_based_table").isPresent());
    }

    @Test
    public void testLoadCatalogUnknown() {
        String catalogName = "barCatalog";
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"type"), "fooType");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Catalogs.loadCatalog((Configuration)this.conf, (String)catalogName)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Unknown catalog type: fooType");
    }

    @Test
    public void testDefaultCatalogProperties() {
        String catalogProperty = "io.manifest.cache-enabled";
        String defaultCatalogProperty = "iceberg.catalog-default." + catalogProperty;
        this.conf.setBoolean(defaultCatalogProperty, true);
        HiveCatalog defaultCatalog = (HiveCatalog)Catalogs.loadCatalog((Configuration)this.conf, null).get();
        Assert.assertEquals((Object)"true", defaultCatalog.properties().get(catalogProperty));
        Assert.assertEquals((Object)"true", defaultCatalog.newTableOps(TableIdentifier.of((String[])new String[]{"default", "iceberg"})).io().properties().get(catalogProperty));
        this.conf.setBoolean(String.format("%s%s.%s", "iceberg.catalog.", "default_iceberg", catalogProperty), false);
        defaultCatalog = (HiveCatalog)Catalogs.loadCatalog((Configuration)this.conf, null).get();
        Assert.assertEquals((Object)"false", defaultCatalog.properties().get(catalogProperty));
        Assert.assertEquals((Object)"false", defaultCatalog.newTableOps(TableIdentifier.of((String[])new String[]{"default", "iceberg"})).io().properties().get(catalogProperty));
    }

    private void setCustomCatalogProperties(String catalogName, String warehouseLocation) {
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"warehouse"), warehouseLocation);
        this.conf.set(InputFormatConfig.catalogPropertyConfigKey((String)catalogName, (String)"catalog-impl"), CustomHadoopCatalog.class.getName());
        this.conf.set("iceberg.catalog", catalogName);
    }

    public static class CustomHadoopCatalog
    extends HadoopCatalog {
        public CustomHadoopCatalog() {
        }

        public CustomHadoopCatalog(Configuration conf, String warehouseLocation) {
            super(conf, warehouseLocation);
        }
    }
}

