/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metasummary;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummarySchema;
import org.apache.iceberg.metasummary.IcebergSummaryHandler;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergSummaryHandler {
    @Test
    public void testInitialize() throws Exception {
        try (IcebergSummaryHandler handler = new IcebergSummaryHandler();){
            handler.setConf(MetastoreConf.newMetastoreConf());
            MetaSummarySchema schema = new MetaSummarySchema();
            handler.initialize("hive", true, schema);
            HashSet fields = Sets.newHashSet((Iterable)schema.getFields());
            Assert.assertTrue((boolean)fields.containsAll(Arrays.asList("metadata", "stats", "CoW/MoR", "writeFormat", "distribution-mode")));
            schema = new MetaSummarySchema();
            handler.initialize("hive", false, schema);
            fields = Sets.newHashSet((Iterable)schema.getFields());
            Assert.assertTrue((boolean)fields.containsAll(Arrays.asList("puffin_enabled", "numSnapshots", "manifestsSize", "version", "write.distribution-mode", "write.format.default", "write.merge.mode")));
        }
    }
}

