/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metasummary;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.metasummary.MetadataSummary;
import org.apache.iceberg.metasummary.TablePropertySummary;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestIcebergSummary {
    private static final HadoopTables TABLES = new HadoopTables();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"foo", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"bar", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"alist", (Type)Types.ListType.ofOptional((int)5, (Type)Types.StringType.get())), Types.NestedField.optional((int)4, (String)"amap", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.IntegerType.get(), (Type)Types.StringType.get()))});
    @Rule
    public TemporaryFolder tableDir = new TemporaryFolder();
    @Rule
    public TemporaryFolder dataDir = new TemporaryFolder();
    private final Configuration conf = MetastoreConf.newMetastoreConf();

    @Test
    public void testGetMetadataSummary() throws Exception {
        MetadataSummary summary = new MetadataSummary();
        summary.initialize(this.conf, false);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).bucket("foo", 16).build();
        HashMap props = Maps.newHashMap();
        props.put("history.expire.min-snapshots-to-keep", "7");
        String location = this.tableDir.getRoot() + "/test_metadata_summary";
        TABLES.create(SCHEMA, spec, (Map)props, location);
        Table table = TABLES.load(location);
        AppendFiles append = table.newAppend();
        String data1 = this.dataDir.getRoot() + "/data1.parquet";
        String data2 = this.dataDir.getRoot() + "/data2.parquet";
        Files.write(Paths.get(data1, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        Files.write(Paths.get(data2, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        PartitionData data = new PartitionData(spec.partitionType());
        data.set(0, (Object)1);
        append.appendFile(DataFiles.builder((PartitionSpec)spec).withPath(data1).withFileSizeInBytes(10L).withRecordCount(1L).withPartition((StructLike)data).build());
        append.commit();
        data = new PartitionData(spec.partitionType());
        data.set(0, (Object)2);
        table.newAppend().appendFile(DataFiles.builder((PartitionSpec)spec).withPath(data2).withFileSizeInBytes(20L).withRecordCount(2L).withPartition((StructLike)data).build()).commit();
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch("b1", first).commit();
        table.manageSnapshots().createTag("t1", first).commit();
        table.manageSnapshots().createTag("t2", first).commit();
        MetadataTableSummary tableSummary = new MetadataTableSummary();
        summary.getMetaSummary(table, tableSummary);
        Assert.assertEquals((long)1L, (long)tableSummary.getPartitionColumnCount());
        Assert.assertEquals((long)2L, (long)tableSummary.getNumFiles());
        Assert.assertEquals((long)2L, (long)tableSummary.getPartitionCount());
        Assert.assertEquals((long)3L, (long)tableSummary.getNumRows());
        Assert.assertEquals((long)4L, (long)tableSummary.getColCount());
        Assert.assertEquals((long)1L, (long)tableSummary.getArrayColumnCount());
        Assert.assertEquals((long)1L, (long)tableSummary.getMapColumnCount());
        Assert.assertEquals((long)0L, (long)tableSummary.getStructColumnCount());
        Assert.assertEquals((long)30L, (long)tableSummary.getTotalSize());
        Map extraSummary = tableSummary.getExtraSummary();
        Assert.assertEquals((Object)2, extraSummary.get("numSnapshots"));
        Assert.assertEquals((Object)2, extraSummary.get("numTags"));
        Assert.assertEquals((Object)2, extraSummary.get("numBranches"));
        Assert.assertEquals((Object)-1L, extraSummary.get("snapshotMaxAge"));
        Assert.assertEquals((Object)7L, extraSummary.get("snapshotMinKeep"));
        File directory = new File(table.location());
        List<File> manifestFiles = this.listManifestFiles(directory);
        Assert.assertEquals((Object)manifestFiles.size(), extraSummary.get("numManifests"));
        Assert.assertEquals((Object)manifestFiles.stream().mapToLong(File::length).sum(), extraSummary.get("manifestsSize"));
    }

    @Test
    public void testTablePropsSummary() {
        TablePropertySummary summary = new TablePropertySummary();
        summary.initialize(this.conf, false);
        HashMap props = Maps.newHashMap();
        props.put("write.format.default", "orc");
        props.put("write.delete.format.default", "parquet");
        props.put("write.distribution-mode", "hash");
        props.put("write.wap.enabled", "true");
        props.put("format-version", "2");
        props.put("write.delete.mode", "merge-on-read");
        props.put("write.update.mode", "copy-on-write");
        String location = this.tableDir.getRoot() + "/test_tabprops_summary";
        TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)props, location);
        Table table = TABLES.load(location);
        MetadataTableSummary tableSummary = new MetadataTableSummary();
        summary.getMetaSummary(table, tableSummary);
        Map extraSummary = tableSummary.getExtraSummary();
        Assert.assertEquals((Object)"orc", extraSummary.get("write.format.default"));
        Assert.assertEquals((Object)"parquet", extraSummary.get("write.delete.format.default"));
        Assert.assertEquals((Object)"hash", extraSummary.get("write.distribution-mode"));
        Assert.assertEquals((Object)"true", extraSummary.get("write.wap.enabled"));
        Assert.assertEquals((Object)"merge-on-read", extraSummary.get("write.delete.mode"));
        Assert.assertEquals((Object)"copy-on-write", extraSummary.get("write.update.mode"));
        Assert.assertEquals((Object)2, extraSummary.get("version"));
    }

    List<File> listManifestFiles(File tableDirToList) {
        return Lists.newArrayList((Object[])new File(tableDirToList, "metadata").listFiles((dir, name) -> !name.startsWith("snap") && name.endsWith(".avro")));
    }
}

