/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.PartitionStats;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.PartitionStatsHandler;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestPartitionStatsHandler {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    protected static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("c2").identity("c3").build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Random RANDOM = ThreadLocalRandom.current();
    public FileFormat format = FileFormat.AVRO;

    @Test
    public void testPartitionStatsOnEmptyTable() throws Exception {
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("empty_table"), (String)"empty_table", (Schema)SCHEMA, (PartitionSpec)SPEC, (int)2);
        Assertions.assertThat((Object)PartitionStatsHandler.computeAndWriteStatsFile((Table)testTable)).isNull();
    }

    @Test
    public void testPartitionStatsOnEmptyBranch() throws Exception {
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("empty_branch"), (String)"empty_branch", (Schema)SCHEMA, (PartitionSpec)SPEC, (int)2);
        testTable.manageSnapshots().createBranch("b1").commit();
        long branchSnapshot = ((SnapshotRef)testTable.refs().get("b1")).snapshotId();
        Assertions.assertThat((Object)PartitionStatsHandler.computeAndWriteStatsFile((Table)testTable, (long)branchSnapshot)).isNull();
    }

    @Test
    public void testPartitionStatsOnInvalidSnapshot() throws Exception {
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("invalid_snapshot"), (String)"invalid_snapshot", (Schema)SCHEMA, (PartitionSpec)SPEC, (int)2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestPartitionStatsHandler.lambda$testPartitionStatsOnInvalidSnapshot$0((Table)testTable)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Snapshot not found: 42");
    }

    @Test
    public void testPartitionStatsOnUnPartitionedTable() throws Exception {
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("unpartitioned_table"), (String)"unpartitioned_table", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (int)2);
        List<Record> records = TestPartitionStatsHandler.prepareRecords(testTable.schema());
        DataFile dataFile = FileHelpers.writeDataFile((Table)testTable, this.outputFile(), records);
        testTable.newAppend().appendFile(dataFile).commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestPartitionStatsHandler.lambda$testPartitionStatsOnUnPartitionedTable$1((Table)testTable)).isInstanceOf(IllegalArgumentException.class)).hasMessage("table must be partitioned");
    }

    @Test
    public void testAllDatatypePartitionWriting() throws Exception {
        ArrayList written;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)111, (String)"uuid", (Type)Types.UUIDType.get()), Types.NestedField.required((int)112, (String)"fixed", (Type)Types.FixedType.ofLength((int)7)), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10)), Types.NestedField.required((int)117, (String)"time", (Type)Types.TimeType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("b").identity("i").identity("l").identity("f").identity("d").identity("date").identity("ts").identity("s").identity("uuid").identity("fixed").identity("bytes").identity("dec_9_0").identity("dec_11_2").identity("dec_38_10").identity("time").build();
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("test_all_type"), (String)"test_all_type", (Schema)schema, (PartitionSpec)spec, (SortOrder)SortOrder.unsorted(), (int)2);
        Types.StructType partitionSchema = Partitioning.partitionType((Table)testTable);
        Schema dataSchema = PartitionStatsHandler.schema((Types.StructType)partitionSchema);
        PartitionData partitionData = new PartitionData(dataSchema.findField(0).type().asStructType());
        partitionData.set(0, (Object)true);
        partitionData.set(1, (Object)42);
        partitionData.set(2, (Object)42L);
        partitionData.set(3, (Object)Float.valueOf(3.14f));
        partitionData.set(4, (Object)Math.PI);
        partitionData.set(5, Literal.of((CharSequence)"2022-01-01").to((Type)Types.DateType.get()).value());
        partitionData.set(6, Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)Types.TimestampType.withoutZone()).value());
        partitionData.set(7, (Object)"string");
        partitionData.set(8, (Object)UUID.randomUUID());
        partitionData.set(9, (Object)ByteBuffer.wrap(new byte[]{0, 1, 2, 3, 4, 5, 6}));
        partitionData.set(10, (Object)ByteBuffer.wrap(new byte[]{1, 2, 3}));
        partitionData.set(11, (Object)new BigDecimal("123456789"));
        partitionData.set(12, (Object)new BigDecimal("1234567.89"));
        partitionData.set(13, (Object)new BigDecimal("12345678901234567890.1234567890"));
        partitionData.set(14, Literal.of((CharSequence)"10:10:10").to((Type)Types.TimeType.get()).value());
        PartitionStats partitionStats = new PartitionStats((StructLike)partitionData, RANDOM.nextInt(10));
        partitionStats.set(PartitionStatsHandler.DATA_RECORD_COUNT.fieldId(), (Object)RANDOM.nextLong());
        partitionStats.set(PartitionStatsHandler.DATA_FILE_COUNT.fieldId(), (Object)RANDOM.nextInt());
        partitionStats.set(PartitionStatsHandler.TOTAL_DATA_FILE_SIZE_IN_BYTES.fieldId(), (Object)(1024L * (long)RANDOM.nextInt(20)));
        List<PartitionStats> expected = Collections.singletonList(partitionStats);
        PartitionStatisticsFile statisticsFile = PartitionStatsHandler.writePartitionStatsFile((Table)testTable, (long)42L, (Schema)dataSchema, expected);
        try (CloseableIterable recordIterator = PartitionStatsHandler.readPartitionStatsFile((Schema)dataSchema, (InputFile)Files.localInput((String)statisticsFile.path()));){
            written = Lists.newArrayList((Iterable)recordIterator);
        }
        Assertions.assertThat((List)written).hasSize(expected.size());
        Comparator comparator = Comparators.forType((Types.StructType)partitionSchema);
        for (int i = 0; i < written.size(); ++i) {
            Assertions.assertThat((boolean)TestPartitionStatsHandler.isEqual(comparator, (PartitionStats)written.get(i), expected.get(i))).isTrue();
        }
    }

    @Test
    public void testOptionalFieldsWriting() throws Exception {
        ArrayList written;
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").build();
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("test_partition_stats_optional"), (String)"test_partition_stats_optional", (Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)SortOrder.unsorted(), (int)2);
        Types.StructType partitionSchema = Partitioning.partitionType((Table)testTable);
        Schema dataSchema = PartitionStatsHandler.schema((Types.StructType)partitionSchema);
        ImmutableList.Builder partitionListBuilder = ImmutableList.builder();
        for (int i = 0; i < 5; ++i) {
            PartitionData partitionData = new PartitionData(dataSchema.findField(0).type().asStructType());
            partitionData.set(0, (Object)RANDOM.nextInt());
            PartitionStats stats = new PartitionStats((StructLike)partitionData, RANDOM.nextInt(10));
            stats.set(0, (Object)partitionData);
            stats.set(PartitionStatsHandler.DATA_RECORD_COUNT.fieldId(), (Object)RANDOM.nextLong());
            stats.set(PartitionStatsHandler.DATA_FILE_COUNT.fieldId(), (Object)RANDOM.nextInt());
            stats.set(PartitionStatsHandler.TOTAL_DATA_FILE_SIZE_IN_BYTES.fieldId(), (Object)(1024L * (long)RANDOM.nextInt(20)));
            stats.set(PartitionStatsHandler.POSITION_DELETE_RECORD_COUNT.fieldId(), null);
            stats.set(PartitionStatsHandler.POSITION_DELETE_FILE_COUNT.fieldId(), null);
            stats.set(PartitionStatsHandler.EQUALITY_DELETE_RECORD_COUNT.fieldId(), null);
            stats.set(PartitionStatsHandler.EQUALITY_DELETE_FILE_COUNT.fieldId(), null);
            stats.set(PartitionStatsHandler.TOTAL_RECORD_COUNT.fieldId(), null);
            stats.set(PartitionStatsHandler.LAST_UPDATED_AT.fieldId(), null);
            stats.set(PartitionStatsHandler.LAST_UPDATED_SNAPSHOT_ID.fieldId(), null);
            partitionListBuilder.add((Object)stats);
        }
        ImmutableList expected = partitionListBuilder.build();
        Assertions.assertThat((Object)((PartitionStats)expected.get(0))).extracting(new Function[]{PartitionStats::positionDeleteRecordCount, PartitionStats::positionDeleteFileCount, PartitionStats::equalityDeleteRecordCount, PartitionStats::equalityDeleteFileCount, PartitionStats::totalRecords, PartitionStats::lastUpdatedAt, PartitionStats::lastUpdatedSnapshotId}).isEqualTo(Arrays.asList(0L, 0, 0L, 0, null, null, null));
        PartitionStatisticsFile statisticsFile = PartitionStatsHandler.writePartitionStatsFile((Table)testTable, (long)42L, (Schema)dataSchema, (Iterable)expected);
        try (CloseableIterable recordIterator = PartitionStatsHandler.readPartitionStatsFile((Schema)dataSchema, (InputFile)Files.localInput((String)statisticsFile.path()));){
            written = Lists.newArrayList((Iterable)recordIterator);
        }
        Assertions.assertThat((List)written).hasSize(expected.size());
        Comparator comparator = Comparators.forType((Types.StructType)partitionSchema);
        for (int i = 0; i < written.size(); ++i) {
            Assertions.assertThat((boolean)TestPartitionStatsHandler.isEqual(comparator, (PartitionStats)written.get(i), (PartitionStats)expected.get(i))).isTrue();
        }
    }

    @Test
    public void testPartitionStats() throws Exception {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.format).as("ORC internal readers and writers are not supported", new Object[0])).isNotEqualTo((Object)FileFormat.ORC);
        TestTables.TestTable testTable = TestTables.create((File)this.tempDir("partition_stats_" + this.format.name()), (String)("partition_stats_compute_" + this.format.name()), (Schema)SCHEMA, (PartitionSpec)SPEC, (int)2, (Map)ImmutableMap.of((Object)"write.format.default", (Object)this.format.name()));
        List<Record> records = TestPartitionStatsHandler.prepareRecords(testTable.schema());
        DataFile dataFile1 = FileHelpers.writeDataFile((Table)testTable, this.outputFile(), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"foo", "A"}), records.subList(0, 3));
        DataFile dataFile2 = FileHelpers.writeDataFile((Table)testTable, this.outputFile(), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"foo", "B"}), records.subList(3, 4));
        DataFile dataFile3 = FileHelpers.writeDataFile((Table)testTable, this.outputFile(), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"bar", "A"}), records.subList(4, 5));
        DataFile dataFile4 = FileHelpers.writeDataFile((Table)testTable, this.outputFile(), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"bar", "B"}), records.subList(5, 7));
        for (int i = 0; i < 3; ++i) {
            testTable.newAppend().appendFile(dataFile1).appendFile(dataFile2).appendFile(dataFile3).appendFile(dataFile4).commit();
        }
        Snapshot snapshot1 = testTable.currentSnapshot();
        Schema recordSchema = PartitionStatsHandler.schema((Types.StructType)Partitioning.partitionType((Table)testTable));
        Types.StructType partitionType = recordSchema.findField(0).type().asStructType();
        TestPartitionStatsHandler.computeAndValidatePartitionStats((Table)testTable, recordSchema, Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "foo", "A"), 0, 9L, 3, 3L * dataFile1.fileSizeInBytes(), 0L, 0, 0L, 0, null, snapshot1.timestampMillis(), snapshot1.snapshotId()}), Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "foo", "B"), 0, 3L, 3, 3L * dataFile2.fileSizeInBytes(), 0L, 0, 0L, 0, null, snapshot1.timestampMillis(), snapshot1.snapshotId()}), Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "bar", "A"), 0, 3L, 3, 3L * dataFile3.fileSizeInBytes(), 0L, 0, 0L, 0, null, snapshot1.timestampMillis(), snapshot1.snapshotId()}), Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "bar", "B"), 0, 6L, 3, 3L * dataFile4.fileSizeInBytes(), 0L, 0, 0L, 0, null, snapshot1.timestampMillis(), snapshot1.snapshotId()}));
        DeleteFile posDeletes = this.commitPositionDeletes((Table)testTable, dataFile1);
        Snapshot snapshot2 = testTable.currentSnapshot();
        DeleteFile eqDeletes = this.commitEqualityDeletes((Table)testTable);
        Snapshot snapshot3 = testTable.currentSnapshot();
        recordSchema = PartitionStatsHandler.schema((Types.StructType)Partitioning.partitionType((Table)testTable));
        partitionType = recordSchema.findField(0).type().asStructType();
        TestPartitionStatsHandler.computeAndValidatePartitionStats((Table)testTable, recordSchema, Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "foo", "A"), 0, 9L, 3, 3L * dataFile1.fileSizeInBytes(), 0L, 0, eqDeletes.recordCount(), 1, null, snapshot3.timestampMillis(), snapshot3.snapshotId()}), Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "foo", "B"), 0, 3L, 3, 3L * dataFile2.fileSizeInBytes(), 0L, 0, 0L, 0, null, snapshot1.timestampMillis(), snapshot1.snapshotId()}), Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "bar", "A"), 0, 3L, 3, 3L * dataFile3.fileSizeInBytes(), posDeletes.recordCount(), 1, 0L, 0, null, snapshot2.timestampMillis(), snapshot2.snapshotId()}), Tuple.tuple((Object[])new Object[]{TestPartitionStatsHandler.partitionRecord(partitionType, "bar", "B"), 0, 6L, 3, 3L * dataFile4.fileSizeInBytes(), 0L, 0, 0L, 0, null, snapshot1.timestampMillis(), snapshot1.snapshotId()}));
    }

    private OutputFile outputFile() throws IOException {
        return Files.localOutput((File)File.createTempFile("data", null, this.tempDir("stats")));
    }

    private static StructLike partitionRecord(Types.StructType partitionType, String val1, String val2) {
        GenericRecord record = GenericRecord.create((Types.StructType)partitionType);
        record.set(0, (Object)val1);
        record.set(1, (Object)val2);
        return record;
    }

    private static List<Record> prepareRecords(Schema schema) {
        GenericRecord record = GenericRecord.create((Schema)schema);
        ArrayList records = Lists.newArrayList();
        records.add(record.copy("c1", (Object)0, "c2", (Object)"foo", "c3", (Object)"A"));
        records.add(record.copy("c1", (Object)1, "c2", (Object)"foo", "c3", (Object)"A"));
        records.add(record.copy("c1", (Object)2, "c2", (Object)"foo", "c3", (Object)"A"));
        records.add(record.copy("c1", (Object)3, "c2", (Object)"foo", "c3", (Object)"B"));
        records.add(record.copy("c1", (Object)4, "c2", (Object)"bar", "c3", (Object)"A"));
        records.add(record.copy("c1", (Object)5, "c2", (Object)"bar", "c3", (Object)"B"));
        records.add(record.copy("c1", (Object)6, "c2", (Object)"bar", "c3", (Object)"B"));
        return records;
    }

    private static void computeAndValidatePartitionStats(Table testTable, Schema recordSchema, Tuple ... expectedValues) throws IOException {
        ArrayList partitionStats;
        Snapshot currentSnapshot = testTable.currentSnapshot();
        PartitionStatisticsFile result = PartitionStatsHandler.computeAndWriteStatsFile((Table)testTable);
        testTable.updatePartitionStatistics().setPartitionStatistics(result).commit();
        Assertions.assertThat((long)result.snapshotId()).isEqualTo(currentSnapshot.snapshotId());
        try (CloseableIterable recordIterator = PartitionStatsHandler.readPartitionStatsFile((Schema)recordSchema, (InputFile)Files.localInput((String)result.path()));){
            partitionStats = Lists.newArrayList((Iterable)recordIterator);
        }
        Assertions.assertThat((List)partitionStats).extracting(new Function[]{PartitionStats::partition, PartitionStats::specId, PartitionStats::dataRecordCount, PartitionStats::dataFileCount, PartitionStats::totalDataFileSizeInBytes, PartitionStats::positionDeleteRecordCount, PartitionStats::positionDeleteFileCount, PartitionStats::equalityDeleteRecordCount, PartitionStats::equalityDeleteFileCount, PartitionStats::totalRecords, PartitionStats::lastUpdatedAt, PartitionStats::lastUpdatedSnapshotId}).containsExactlyInAnyOrder((Object[])expectedValues);
    }

    private DeleteFile commitEqualityDeletes(Table testTable) throws IOException {
        Schema deleteRowSchema = testTable.schema().select(new String[]{"c1"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("c1", (Object)1), dataDelete.copy("c1", (Object)2)});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(testTable, Files.localOutput((File)File.createTempFile("junit", null, this.tempDir("eq_delete"))), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"foo", "A"}), dataDeletes, deleteRowSchema);
        testTable.newRowDelta().addDeletes(eqDeletes).commit();
        return eqDeletes;
    }

    private DeleteFile commitPositionDeletes(Table testTable, DataFile dataFile1) throws IOException {
        ArrayList deletes = Lists.newArrayList();
        for (long i = 0L; i < 2L; ++i) {
            deletes.add(TestPartitionStatsHandler.positionDelete(testTable.schema(), dataFile1.location(), i, (int)i, String.valueOf(i)));
        }
        DeleteFile posDeletes = FileHelpers.writePosDeleteFile(testTable, Files.localOutput((File)File.createTempFile("junit", null, this.tempDir("pos_delete"))), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"bar", "A"}), deletes);
        testTable.newRowDelta().addDeletes(posDeletes).commit();
        return posDeletes;
    }

    private static PositionDelete<GenericRecord> positionDelete(Schema tableSchema, CharSequence path, Long position, Object ... values) {
        PositionDelete posDelete = PositionDelete.create();
        GenericRecord nested = GenericRecord.create((Schema)tableSchema);
        for (int i = 0; i < values.length; ++i) {
            nested.set(i, values[i]);
        }
        posDelete.set(path, position.longValue(), (Object)nested);
        return posDelete;
    }

    private File tempDir(String folderName) throws IOException {
        return java.nio.file.Files.createTempDirectory(this.temp.getRoot().toPath(), folderName, new FileAttribute[0]).toFile();
    }

    private static boolean isEqual(Comparator<StructLike> partitionComparator, PartitionStats stats1, PartitionStats stats2) {
        if (stats1 == stats2) {
            return true;
        }
        if (stats1 == null || stats2 == null) {
            return false;
        }
        return partitionComparator.compare(stats1.partition(), stats2.partition()) == 0 && stats1.specId() == stats2.specId() && stats1.dataRecordCount() == stats2.dataRecordCount() && stats1.dataFileCount() == stats2.dataFileCount() && stats1.totalDataFileSizeInBytes() == stats2.totalDataFileSizeInBytes() && stats1.positionDeleteRecordCount() == stats2.positionDeleteRecordCount() && stats1.positionDeleteFileCount() == stats2.positionDeleteFileCount() && stats1.equalityDeleteRecordCount() == stats2.equalityDeleteRecordCount() && stats1.equalityDeleteFileCount() == stats2.equalityDeleteFileCount() && Objects.equals(stats1.totalRecords(), stats2.totalRecords()) && Objects.equals(stats1.lastUpdatedAt(), stats2.lastUpdatedAt()) && Objects.equals(stats1.lastUpdatedSnapshotId(), stats2.lastUpdatedSnapshotId());
    }

    private static /* synthetic */ void lambda$testPartitionStatsOnUnPartitionedTable$1(Table testTable) throws Throwable {
        PartitionStatsHandler.computeAndWriteStatsFile((Table)testTable);
    }

    private static /* synthetic */ void lambda$testPartitionStatsOnInvalidSnapshot$0(Table testTable) throws Throwable {
        PartitionStatsHandler.computeAndWriteStatsFile((Table)testTable, (long)42L);
    }
}

