/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.RandomUtil;

public class RandomGenericData {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private RandomGenericData() {
    }

    public static List<Record> generate(Schema schema, int numRecords, long seed) {
        return Lists.newArrayList(RandomGenericData.generateIcebergGenerics(schema, numRecords, () -> new RandomRecordGenerator(seed)));
    }

    public static Iterable<Record> generateFallbackRecords(Schema schema, int numRecords, long seed, long numDictRows) {
        return RandomGenericData.generateIcebergGenerics(schema, numRecords, () -> new FallbackGenerator(seed, numDictRows));
    }

    public static Iterable<Record> generateDictionaryEncodableRecords(Schema schema, int numRecords, long seed) {
        return RandomGenericData.generateIcebergGenerics(schema, numRecords, () -> new DictionaryEncodedGenerator(seed));
    }

    private static Iterable<Record> generateIcebergGenerics(final Schema schema, final int numRecords, final Supplier<RandomDataGenerator<Record>> supplier) {
        return () -> new Iterator<Record>(){
            private final RandomDataGenerator<Record> generator;
            private int count;
            {
                this.generator = (RandomDataGenerator)((Object)supplier.get());
                this.count = 0;
            }

            @Override
            public boolean hasNext() {
                return this.count < numRecords;
            }

            @Override
            public Record next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return (Record)TypeUtil.visit((Schema)schema, this.generator);
            }
        };
    }

    private static class DictionaryEncodedGenerator
    extends RandomRecordGenerator {
        DictionaryEncodedGenerator(long seed) {
            super(seed);
        }

        @Override
        protected int getMaxEntries() {
            return 3;
        }

        @Override
        protected Object randomValue(Type.PrimitiveType primitive, Random random) {
            return RandomUtil.generateDictionaryEncodablePrimitive(primitive, random);
        }
    }

    private static class FallbackGenerator
    extends RandomRecordGenerator {
        private final long dictionaryEncodedRows;
        private long rowCount = 0L;

        FallbackGenerator(long seed, long numDictionaryEncoded) {
            super(seed);
            this.dictionaryEncodedRows = numDictionaryEncoded;
        }

        @Override
        protected Object randomValue(Type.PrimitiveType primitive, Random rand) {
            ++this.rowCount;
            if (this.rowCount > this.dictionaryEncodedRows) {
                return RandomUtil.generatePrimitive(primitive, rand);
            }
            return RandomUtil.generateDictionaryEncodablePrimitive(primitive, rand);
        }
    }

    private static class RandomRecordGenerator
    extends RandomDataGenerator<Record> {
        private RandomRecordGenerator(long seed) {
            super(seed);
        }

        @Override
        public Record schema(Schema schema, Supplier<Object> structResult) {
            return (Record)structResult.get();
        }

        @Override
        public Record struct(Types.StructType struct, Iterable<Object> fieldResults) {
            GenericRecord rec = GenericRecord.create((Types.StructType)struct);
            ArrayList values = Lists.newArrayList(fieldResults);
            for (int i = 0; i < values.size(); ++i) {
                rec.set(i, values.get(i));
            }
            return rec;
        }
    }

    public static abstract class RandomDataGenerator<T>
    extends TypeUtil.CustomOrderSchemaVisitor<Object> {
        private final Random random;
        private static final int MAX_ENTRIES = 20;

        protected RandomDataGenerator(long seed) {
            this.random = new Random(seed);
        }

        protected int getMaxEntries() {
            return 20;
        }

        public abstract T schema(Schema var1, Supplier<Object> var2);

        public abstract T struct(Types.StructType var1, Iterable<Object> var2);

        public Object field(Types.NestedField field, Supplier<Object> fieldResult) {
            if (field.isOptional() && this.random.nextInt(20) == 1) {
                return null;
            }
            return fieldResult.get();
        }

        public Object list(Types.ListType list, Supplier<Object> elementResult) {
            int numElements = this.random.nextInt(this.getMaxEntries());
            ArrayList result = Lists.newArrayListWithExpectedSize((int)numElements);
            for (int i = 0; i < numElements; ++i) {
                if (list.isElementOptional() && this.random.nextInt(20) == 1) {
                    result.add(null);
                    continue;
                }
                result.add(elementResult.get());
            }
            return result;
        }

        public Object map(Types.MapType map, Supplier<Object> keyResult, Supplier<Object> valueResult) {
            int numEntries = this.random.nextInt(this.getMaxEntries());
            LinkedHashMap result = Maps.newLinkedHashMap();
            Supplier<Object> keyFunc = map.keyType() == Types.StringType.get() ? () -> keyResult.get().toString() : keyResult;
            HashSet keySet = Sets.newHashSet();
            for (int i = 0; i < numEntries; ++i) {
                Object key = keyFunc.get();
                while (keySet.contains(key)) {
                    key = keyFunc.get();
                }
                keySet.add(key);
                if (map.isValueOptional() && this.random.nextInt(20) == 1) {
                    result.put(key, null);
                    continue;
                }
                result.put(key, valueResult.get());
            }
            return result;
        }

        public Object primitive(Type.PrimitiveType primitive) {
            Object result = this.randomValue(primitive, this.random);
            switch (primitive.typeId()) {
                case BINARY: {
                    return ByteBuffer.wrap((byte[])result);
                }
                case UUID: {
                    return UUID.nameUUIDFromBytes((byte[])result);
                }
                case DATE: {
                    return EPOCH_DAY.plusDays(((Integer)result).intValue());
                }
                case TIME: {
                    return LocalTime.ofNanoOfDay((Long)result * 1000L);
                }
                case TIMESTAMP: {
                    Types.TimestampType ts = (Types.TimestampType)primitive;
                    if (ts.shouldAdjustToUTC()) {
                        return EPOCH.plus((Long)result, ChronoUnit.MICROS);
                    }
                    return EPOCH.plus((Long)result, ChronoUnit.MICROS).toLocalDateTime();
                }
            }
            return result;
        }

        protected Object randomValue(Type.PrimitiveType primitive, Random rand) {
            return RandomUtil.generatePrimitive(primitive, rand);
        }
    }
}

