/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericFileWriterFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.BaseDVFileWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;

public class FileHelpers {
    private FileHelpers() {
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, List<Pair<CharSequence, Long>> deletes) throws IOException {
        return FileHelpers.writeDeleteFile(table, out, null, deletes);
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Pair<CharSequence, Long>> deletes) throws IOException {
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec());
        PositionDeleteWriter writer = factory.newPosDeleteWriter(FileHelpers.encrypt(out), format, partition);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter toClose = writer;){
            for (Pair<CharSequence, Long> delete : deletes) {
                writer.write(posDelete.set((CharSequence)delete.first(), ((Long)delete.second()).longValue(), null));
            }
        }
        return Pair.of((Object)writer.toDeleteFile(), (Object)writer.referencedDataFiles());
    }

    public static DeleteFile writeDeleteFile(Table table, OutputFile out, List<Record> deletes, Schema deleteRowSchema) throws IOException {
        return FileHelpers.writeDeleteFile(table, out, null, deletes, deleteRowSchema);
    }

    public static DeleteFile writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Record> deletes, Schema deleteRowSchema) throws IOException {
        EqualityDeleteWriter writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        int[] equalityFieldIds = deleteRowSchema.columns().stream().mapToInt(Types.NestedField::fieldId).toArray();
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec(), equalityFieldIds, deleteRowSchema, null);
        try (EqualityDeleteWriter toClose = writer = factory.newEqDeleteWriter(FileHelpers.encrypt(out), format, partition);){
            writer.write(deletes);
        }
        return writer.toDeleteFile();
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Pair<CharSequence, Long>> deletes, int formatVersion) throws IOException {
        if (formatVersion >= 3) {
            BaseDVFileWriter writer;
            OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)1, (long)1L).format(FileFormat.PUFFIN).build();
            try (BaseDVFileWriter closeableWriter = writer = new BaseDVFileWriter(fileFactory, p -> null);){
                for (Pair<CharSequence, Long> delete : deletes) {
                    closeableWriter.delete(((CharSequence)delete.first()).toString(), ((Long)delete.second()).longValue(), table.spec(), partition);
                }
            }
            return Pair.of((Object)((DeleteFile)Iterables.getOnlyElement((Iterable)writer.result().deleteFiles())), (Object)writer.result().referencedDataFiles());
        }
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).build();
        PositionDeleteWriter writer = factory.newPositionDeleteWriter(FileHelpers.encrypt(out), table.spec(), partition);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter toClose = writer;){
            for (Pair<CharSequence, Long> delete : deletes) {
                writer.write(posDelete.set((CharSequence)delete.first(), ((Long)delete.second()).longValue(), null));
            }
        }
        return Pair.of((Object)writer.toDeleteFile(), (Object)writer.referencedDataFiles());
    }

    public static DataFile writeDataFile(Table table, OutputFile out, List<Record> rows) throws IOException {
        FileAppender writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema());
        try (FileAppender toClose = writer = factory.newAppender(out, format);){
            writer.addAll(rows);
        }
        return DataFiles.builder((PartitionSpec)table.spec()).withFormat(format).withPath(out.location()).withFileSizeInBytes(writer.length()).withSplitOffsets(writer.splitOffsets()).withMetrics(writer.metrics()).build();
    }

    public static DataFile writeDataFile(Table table, OutputFile out, StructLike partition, List<Record> rows) throws IOException {
        FileAppender writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec());
        try (FileAppender toClose = writer = factory.newAppender(out, format);){
            writer.addAll(rows);
        }
        return DataFiles.builder((PartitionSpec)table.spec()).withFormat(format).withPath(out.location()).withPartition(partition).withFileSizeInBytes(writer.length()).withSplitOffsets(writer.splitOffsets()).withMetrics(writer.metrics()).build();
    }

    public static DeleteFile writePosDeleteFile(Table table, OutputFile out, StructLike partition, List<PositionDelete<?>> deletes) throws IOException {
        return FileHelpers.writePosDeleteFile(table, out, partition, deletes, 2);
    }

    public static DeleteFile writePosDeleteFile(Table table, OutputFile out, StructLike partition, List<PositionDelete<?>> deletes, int formatVersion) throws IOException {
        PositionDeleteWriter writer;
        if (formatVersion >= 3) {
            BaseDVFileWriter writer2;
            OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)1, (long)1L).format(FileFormat.PUFFIN).build();
            try (BaseDVFileWriter closeableWriter = writer2 = new BaseDVFileWriter(fileFactory, p -> null);){
                for (PositionDelete<?> delete : deletes) {
                    closeableWriter.delete(delete.path().toString(), delete.pos(), table.spec(), partition);
                }
            }
            return (DeleteFile)Iterables.getOnlyElement((Iterable)writer2.result().deleteFiles());
        }
        GenericFileWriterFactory factory = GenericFileWriterFactory.builderFor((Table)table).positionDeleteRowSchema(table.schema()).build();
        try (PositionDeleteWriter toClose = writer = factory.newPositionDeleteWriter(FileHelpers.encrypt(out), table.spec(), partition);){
            for (PositionDelete<?> delete : deletes) {
                writer.write(delete);
            }
        }
        return writer.toDeleteFile();
    }

    private static EncryptedOutputFile encrypt(OutputFile out) {
        return EncryptedFiles.encryptedOutput((OutputFile)out, (EncryptionKeyMetadata)EncryptionKeyMetadata.EMPTY);
    }

    private static FileFormat defaultFormat(Map<String, String> properties) {
        String formatString = properties.getOrDefault("write.format.default", "parquet");
        return FileFormat.fromString((String)formatString);
    }
}

