/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructProjection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class DeleteReadTests {
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    public static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private String tableName = null;
    private Table table = null;
    private List<Record> records = null;
    private DataFile dataFile = null;
    protected final int formatVersion;

    public DeleteReadTests(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    @Before
    public void writeTestDataFile() throws IOException {
        this.tableName = "test";
        this.table = this.createTable(this.tableName, SCHEMA, SPEC);
        this.records = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records.add(record.copy("id", (Object)29, "data", (Object)"a"));
        this.records.add(record.copy("id", (Object)43, "data", (Object)"b"));
        this.records.add(record.copy("id", (Object)61, "data", (Object)"c"));
        this.records.add(record.copy("id", (Object)89, "data", (Object)"d"));
        this.records.add(record.copy("id", (Object)100, "data", (Object)"e"));
        this.records.add(record.copy("id", (Object)121, "data", (Object)"f"));
        this.records.add(record.copy("id", (Object)122, "data", (Object)"g"));
        this.dataFile = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), this.records);
        this.table.newAppend().appendFile(this.dataFile).commit();
    }

    @After
    public void cleanup() throws IOException {
        this.dropTable("test");
    }

    protected abstract Table createTable(String var1, Schema var2, PartitionSpec var3) throws IOException;

    protected abstract void dropTable(String var1) throws IOException;

    protected abstract StructLikeSet rowSet(String var1, Table var2, String ... var3) throws IOException;

    protected boolean expectPruned() {
        return true;
    }

    protected boolean countDeletes() {
        return false;
    }

    protected long deleteCount() {
        return 0L;
    }

    protected void checkDeleteCount(long expectedDeletes) {
        if (this.countDeletes()) {
            long actualDeletes = this.deleteCount();
            ((AbstractLongAssert)Assertions.assertThat((long)actualDeletes).as("Table should contain expected number of deletes", new Object[0])).isEqualTo(expectedDeletes);
        }
    }

    @Test
    public void testEqualityDeletes() throws IOException {
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
    }

    @Test
    public void testEqualityDeletesWithRequiredEqColumn() throws IOException {
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = this.selectColumns(DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122), "id");
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "id");
        if (this.expectPruned()) {
            Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)this.selectColumns(actual, "id"));
        }
    }

    @Test
    public void testEqualityDeletesSpanningMultipleDataFiles() throws IOException {
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records.add(record.copy("id", (Object)144, "data", (Object)"a"));
        this.dataFile = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), this.records);
        this.table.newAppend().appendFile(this.dataFile).commit();
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122, 144);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
    }

    @Test
    public void testPositionDeletes() throws IOException {
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)0L), Pair.of((Object)this.dataFile.path(), (Object)3L), Pair.of((Object)this.dataFile.path(), (Object)6L)});
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.getRoot())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), deletes, this.formatVersion);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
    }

    @Test
    public void testMixedPositionAndEqualityDeletes() throws IOException {
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.getRoot())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, dataSchema);
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.location(), (Object)3L), Pair.of((Object)this.dataFile.location(), (Object)5L)});
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.getRoot())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), deletes, this.formatVersion);
        this.table.newRowDelta().addDeletes(eqDeletes).addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 121, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(4L);
    }

    @Test
    public void testMultipleEqualityDeleteSchemas() throws IOException {
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile dataEqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, dataSchema);
        Schema idSchema = this.table.schema().select(new String[]{"id"});
        GenericRecord idDelete = GenericRecord.create((Schema)idSchema);
        ArrayList idDeletes = Lists.newArrayList((Object[])new Record[]{idDelete.copy("id", (Object)121), idDelete.copy("id", (Object)29)});
        DeleteFile idEqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), idDeletes, idSchema);
        this.table.newRowDelta().addDeletes(dataEqDeletes).addDeletes(idEqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 121, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
    }

    @Test
    public void testEqualityDeleteByNull() throws IOException {
        this.table.updateSchema().makeColumnOptional("data").commit();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        DataFile dataFileWithNull = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), Lists.newArrayList((Object[])new Record[]{record.copy("id", (Object)131, "data", null)}));
        this.table.newAppend().appendFile(dataFileWithNull).commit();
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", null)});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, dataSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 131);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        Assert.assertEquals((String)"Table should contain expected rows", (Object)expected, (Object)actual);
    }

    private StructLikeSet selectColumns(StructLikeSet rows, String ... columns) {
        Schema projection = this.table.schema().select(columns);
        StructLikeSet set = StructLikeSet.create((Types.StructType)projection.asStruct());
        rows.stream().map(row -> StructProjection.create((Schema)this.table.schema(), (Schema)projection).wrap(row)).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    protected static StructLikeSet rowSetWithoutIds(Table table, List<Record> recordList, int ... idsToRemove) {
        HashSet deletedIds = Sets.newHashSet((Iterable)ArrayUtil.toIntList((int[])idsToRemove));
        StructLikeSet set = StructLikeSet.create((Types.StructType)table.schema().asStruct());
        recordList.stream().filter(row -> !deletedIds.contains(row.getField("id"))).map(record -> new InternalRecordWrapper(table.schema().asStruct()).wrap((StructLike)record)).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }
}

