/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.functions.BuiltinFunctions;

public class FunctionString
extends BuiltinFunctions {
    public FunctionString(Exec e, QueryExecutor queryExecutor) {
        super(e, queryExecutor);
    }

    @Override
    public void register(BuiltinFunctions f) {
        f.map.put("CONCAT", this::concat);
        f.map.put("CHAR", this::char_);
        f.map.put("INSTR", this::instr);
        f.map.put("LEN", this::len);
        f.map.put("LENGTH", this::length);
        f.map.put("LOWER", this::lower);
        f.map.put("REPLACE", this::replace);
        f.map.put("SUBSTR", this::substr);
        f.map.put("SUBSTRING", this::substr);
        f.map.put("TO_CHAR", this::toChar);
        f.map.put("UPPER", this::upper);
        f.specMap.put("SUBSTRING", this::substring);
        f.specMap.put("TRIM", this::trim);
    }

    void concat(HplsqlParser.Expr_func_paramsContext ctx) {
        StringBuilder val = new StringBuilder();
        int cnt = FunctionString.getParamCount(ctx);
        boolean nulls = true;
        for (int i = 0; i < cnt; ++i) {
            Var c = this.evalPop(ctx.func_param(i).expr());
            if (c.isNull()) continue;
            String value = c.toString();
            value = this.unquoteString(value);
            val.append(value);
            nulls = false;
        }
        if (nulls) {
            this.evalNull();
        } else {
            this.evalString(val);
        }
    }

    private String unquoteString(String value) {
        if (this.exec.buildSql) {
            value = Utils.unquoteString(value);
        }
        return value;
    }

    void char_(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = FunctionString.getParamCount(ctx);
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void instr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = FunctionString.getParamCount(ctx);
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        if ((str = this.unquoteString(str)) == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalInt(0);
            return;
        }
        String substr = this.evalPop(ctx.func_param(1).expr()).toString();
        substr = this.unquoteString(substr);
        int pos = 1;
        int occur = 1;
        int idx = 0;
        if (cnt >= 3 && (pos = this.evalPop(ctx.func_param(2).expr()).intValue()) == 0) {
            pos = 1;
        }
        if (cnt >= 4 && (occur = this.evalPop(ctx.func_param(3).expr()).intValue()) < 0) {
            occur = 1;
        }
        for (int i = occur; i > 0; --i) {
            if (pos > 0) {
                idx = str.indexOf(substr, pos - 1);
            } else {
                str = str.substring(0, str.length() - pos * -1);
                idx = str.lastIndexOf(substr);
            }
            if (idx == -1) {
                idx = 0;
                break;
            }
            ++idx;
            if (i <= 1) continue;
            pos = pos > 0 ? idx + 1 : (str.length() - idx + 1) * -1;
        }
        this.evalInt(idx);
    }

    void len(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String value = this.evalPop(ctx.func_param(0).expr()).toString();
        value = this.unquoteString(value);
        int len = value.trim().length();
        this.evalInt(len);
    }

    void length(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String value = this.evalPop(ctx.func_param(0).expr()).toString();
        value = this.unquoteString(value);
        int len = value.length();
        this.evalInt(len);
    }

    void lower(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toLowerCase();
        str = this.unquoteString(str);
        this.evalString(str);
    }

    void replace(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = FunctionString.getParamCount(ctx);
        if (cnt < 3) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        str = this.unquoteString(str);
        String what = this.evalPop(ctx.func_param(1).expr()).toString();
        what = this.unquoteString(what);
        String with = this.evalPop(ctx.func_param(2).expr()).toString();
        with = this.unquoteString(with);
        this.evalString(str.replaceAll(what, with));
    }

    void substr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = BuiltinFunctions.getParamCount(ctx);
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        str = this.unquoteString(str);
        int start = this.evalPop(ctx.func_param(1).expr()).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (cnt > 2) {
            len = this.evalPop(ctx.func_param(2).expr()).intValue();
        }
        this.substr(str, start, len);
    }

    void substr(String str, int start, int len) {
        if (str == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalString(str);
            return;
        }
        if (start == 0) {
            start = 1;
        }
        if (len == -1) {
            if (start > 0) {
                this.evalString(str.substring(start - 1));
            }
        } else {
            this.evalString(str.substring(start - 1, start - 1 + len));
        }
    }

    void substring(HplsqlParser.Expr_spec_funcContext ctx) {
        String str = this.evalPop(ctx.expr(0)).toString();
        int start = this.evalPop(ctx.expr(1)).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (ctx.T_FOR() != null) {
            len = this.evalPop(ctx.expr(2)).intValue();
        }
        this.substr(str, start, len);
    }

    void trim(HplsqlParser.Expr_spec_funcContext ctx) {
        int cnt = ctx.expr().size();
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.expr(0)).toString();
        str = this.unquoteString(str);
        this.evalString(str.trim());
    }

    void toChar(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = BuiltinFunctions.getParamCount(ctx);
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalSqlString(str);
    }

    void upper(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toUpperCase();
        str = this.unquoteString(str);
        this.evalString(str);
    }
}

