/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.hbase.HBaseStorageHandler;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHBaseStorageHandler {
    @Test
    public void testHbaseConfigIsAddedToJobConf() {
        HBaseStorageHandler hbaseStorageHandler = new HBaseStorageHandler();
        hbaseStorageHandler.setConf((Configuration)new JobConf((Configuration)new HiveConf()));
        TableDesc tableDesc = this.getHBaseTableDesc();
        JobConf jobConfToConfigure = new JobConf((Configuration)new HiveConf());
        Assert.assertTrue((String)"hbase-site.xml is supposed to be present", (jobConfToConfigure.get("hbase.some.fake.option.from.xml.file") == null ? 1 : 0) != 0);
        hbaseStorageHandler.configureJobConf(tableDesc, jobConfToConfigure);
        Assert.assertTrue((String)"hbase-site.xml is supposed to be added as a resource by HBaseStorageHandler", (jobConfToConfigure.get("hbase.some.fake.option.from.xml.file") != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetUriForAuthEmptyTableDefaultHostPort() throws URISyntaxException {
        Table table = TestHBaseStorageHandler.createMockTable(new HashMap<String, String>());
        URI uri = TestHBaseStorageHandler.checkURIForAuth(table);
        Assert.assertEquals((Object)String.format("hbase://%s/null", IPStackUtils.concatLoopbackAddressPort((int)2181)), (Object)uri.toString());
    }

    @Test
    public void testGetUriForAuthEmptyTable() throws URISyntaxException {
        HashMap<String, String> serdeParams = new HashMap<String, String>();
        serdeParams.put("hbase.zookeeper.quorum", "testhost");
        serdeParams.put("hbase.zookeeper.property.clientPort", "8765");
        URI uri = TestHBaseStorageHandler.checkURIForAuth(TestHBaseStorageHandler.createMockTable(serdeParams));
        Assert.assertEquals((Object)"hbase://testhost:8765/null", (Object)uri.toString());
    }

    @Test
    public void testGetUriForAuthWithTable() throws URISyntaxException {
        HashMap<String, String> serdeParams = new HashMap<String, String>();
        serdeParams.put("hbase.zookeeper.quorum", "testhost");
        serdeParams.put("hbase.zookeeper.property.clientPort", "8765");
        serdeParams.put("hbase.table.name", "mytbl");
        URI uri = TestHBaseStorageHandler.checkURIForAuth(TestHBaseStorageHandler.createMockTable(serdeParams));
        Assert.assertEquals((Object)"hbase://testhost:8765/mytbl", (Object)uri.toString());
    }

    @Test
    public void testGetUriForAuthWithTableAndColumns() throws URISyntaxException {
        HashMap<String, String> serdeParams = new HashMap<String, String>();
        serdeParams.put("hbase.zookeeper.quorum", "testhost");
        serdeParams.put("hbase.zookeeper.property.clientPort", "8765");
        serdeParams.put("hbase.table.name", "mytbl");
        serdeParams.put("hbase.columns.mapping", "mycolumns");
        URI uri = TestHBaseStorageHandler.checkURIForAuth(TestHBaseStorageHandler.createMockTable(serdeParams));
        Assert.assertEquals((Object)"hbase://testhost:8765/mytbl/mycolumns", (Object)uri.toString());
    }

    @Test
    public void testGetUriForAuthWithTableAndEncodedColumns() throws URISyntaxException {
        HashMap<String, String> serdeParams = new HashMap<String, String>();
        serdeParams.put("hbase.zookeeper.quorum", "testhost");
        serdeParams.put("hbase.zookeeper.property.clientPort", "8765");
        serdeParams.put("hbase.table.name", "my#tbl");
        serdeParams.put("hbase.columns.mapping", "myco#lumns");
        URI uri = TestHBaseStorageHandler.checkURIForAuth(TestHBaseStorageHandler.createMockTable(serdeParams));
        Assert.assertEquals((Object)"hbase://testhost:8765/my%23tbl/myco%23lumns", (Object)uri.toString());
        serdeParams.put("hbase.columns.mapping", "myco#lumn\ns");
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SECURITY_HBASE_URLENCODE_AUTHORIZATION_URI, true);
        uri = TestHBaseStorageHandler.checkURIForAuth(TestHBaseStorageHandler.createMockTable(serdeParams), new JobConf((Configuration)hiveConf));
        Assert.assertEquals((Object)"hbase://testhost:8765/my%23tbl/myco%23lumn%0As", (Object)uri.toString());
    }

    private TableDesc getHBaseTableDesc() {
        TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Properties properties = new Properties();
        properties.put("hbase.columns.mapping", "cf:string");
        properties.put("hbase.struct.autogenerate", "true");
        properties.put("cf.string.serialization.type", "avro");
        properties.put("cf.string.serialization.class", "org.apache.hadoop.io.serializer.avro.AvroSpecificSerialization");
        Mockito.when((Object)tableDesc.getProperties()).thenReturn((Object)properties);
        return tableDesc;
    }

    private static URI checkURIForAuth(Table table) throws URISyntaxException {
        return TestHBaseStorageHandler.checkURIForAuth(table, new JobConf((Configuration)new HiveConf()));
    }

    private static URI checkURIForAuth(Table table, JobConf jobConf) throws URISyntaxException {
        HBaseStorageHandler hbaseStorageHandler = new HBaseStorageHandler();
        hbaseStorageHandler.setConf((Configuration)jobConf);
        return hbaseStorageHandler.getURIForAuth(table);
    }

    private static Table createMockTable(Map<String, String> serdeParams) {
        Table table = new Table();
        StorageDescriptor sd = new StorageDescriptor();
        SerDeInfo sdi = new SerDeInfo();
        sdi.setParameters(serdeParams);
        sd.setSerdeInfo(sdi);
        table.setSd(sd);
        table.setParameters(new HashMap());
        return table;
    }
}

