/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

public class TestHBaseQueries {
    private static MiniZooKeeperCluster zooKeeperCluster;
    private static MiniHBaseCluster miniHBaseCluster;
    private final HiveConf baseConf = new HiveConfForTest(HBaseConfiguration.create(), TestHBaseQueries.class);
    private IDriver driver;

    public TestHBaseQueries() throws Exception {
        this.baseConf.set(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER.varname, SQLStdHiveAuthorizerFactory.class.getName());
        File tmpDir = Files.createTempDirectory(Paths.get("/tmp/", new String[0]), "tmp_", new FileAttribute[0]).toFile();
        System.setProperty("zookeeper.4lw.commands.whitelist", "stat");
        zooKeeperCluster = new MiniZooKeeperCluster();
        int zkPort = zooKeeperCluster.startup(tmpDir);
        this.baseConf.setInt("hbase.zookeeper.property.clientPort", zkPort);
        this.baseConf.setBoolean("hbase.netty.nativetransport", false);
        HBaseTestingUtility util = new HBaseTestingUtility((Configuration)this.baseConf);
        util.setZkCluster(zooKeeperCluster);
        miniHBaseCluster = util.startMiniHBaseCluster(1, 1);
        TestTxnDbUtil.setConfValues((Configuration)this.baseConf);
        TestTxnDbUtil.cleanDb((Configuration)this.baseConf);
        TestTxnDbUtil.prepDb((Configuration)this.baseConf);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (miniHBaseCluster != null) {
            miniHBaseCluster.shutdown();
        }
        if (zooKeeperCluster != null) {
            zooKeeperCluster.shutdown();
        }
    }

    @Before
    public void before() {
        SessionState.start((HiveConf)this.baseConf);
    }

    @After
    public void after() throws Exception {
        if (this.driver != null) {
            this.driver.close();
        }
        TestTxnDbUtil.cleanDb((Configuration)this.baseConf);
    }

    @Test
    public void testRollbackDoesNotDeleteOriginTableWhenCTLTFails() throws CommandProcessorException {
        HiveConf conf = new HiveConf(this.baseConf);
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STRICT_MANAGED_TABLES, true);
        conf.setBoolVar(HiveConf.ConfVars.CREATE_TABLES_AS_ACID, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_CREATE_TABLES_AS_INSERT_ONLY, true);
        conf.setVar(HiveConf.ConfVars.HIVE_DEFAULT_MANAGED_FILEFORMAT, "ORC");
        this.driver = DriverFactory.newDriver((HiveConf)conf);
        this.driver.run("CREATE EXTERNAL TABLE `old_hbase_hive_table`(\n   `key` int COMMENT '',\n   `value` string COMMENT '')\n ROW FORMAT SERDE\n   'org.apache.hadoop.hive.hbase.HBaseSerDe'\n STORED BY\n   'org.apache.hadoop.hive.hbase.HBaseStorageHandler'\n WITH SERDEPROPERTIES (\n   'hbase.columns.mapping'=':key,cf:cf')\n TBLPROPERTIES ('hbase.table.name'='hbase_hive_table')");
        try {
            this.driver.run("create table new_hbase_hive_table like old_hbase_hive_table");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.driver.run("select * from old_hbase_hive_table");
        this.driver.run("drop table old_hbase_hive_table");
    }
}

