/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestPutResultWritable {
    @Test
    public void testResult() throws Exception {
        KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"cfacol1")), new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"cfacol2"))};
        Result expected = Result.create((Cell[])kvs);
        ResultWritable actual = this.copy(new ResultWritable(expected), new ResultWritable());
        Assert.assertArrayEquals((Object[])expected.rawCells(), (Object[])actual.getResult().rawCells());
    }

    @Test
    public void testPut() throws Exception {
        byte[] row = Bytes.toBytes((String)"test-row");
        KeyValue[] kvs = new KeyValue[]{new KeyValue(row, Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"cfacol1")), new KeyValue(row, Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"cfacol2"))};
        Put expected = new Put(row);
        for (int i = 0; i < kvs.length; ++i) {
            expected.add((Cell)kvs[i]);
        }
        PutWritable actual = this.copy(new PutWritable(expected), new PutWritable());
        Assert.assertArrayEquals((byte[])expected.getRow(), (byte[])actual.getPut().getRow());
        Assert.assertEquals(expected.getFamilyCellMap().keySet(), actual.getPut().getFamilyCellMap().keySet());
    }

    private <T extends Writable> T copy(T oldWritable, T newWritable) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        oldWritable.write((DataOutput)out);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream in = new DataInputStream(bais);
        newWritable.readFields((DataInput)in);
        return newWritable;
    }
}

