/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.hbase.LazyHBaseRow;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyHBaseObject {
    @Test
    public void testLazyHBaseCellMap1() throws SerDeException {
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<int,string>").get(0)), (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyHBaseCellMap b = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"cfacol1")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"cfacol2")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"def")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"-1"), Bytes.toBytes((String)"")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"0"), Bytes.toBytes((String)"0")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"8"), Bytes.toBytes((String)"abc")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfc"), Bytes.toBytes((String)"col3"), Bytes.toBytes((String)"cfccol3")));
        Result r = Result.create(kvs);
        ArrayList<Boolean> mapBinaryStorage = new ArrayList<Boolean>();
        mapBinaryStorage.add(false);
        mapBinaryStorage.add(false);
        b.init(r, "cfb".getBytes(), mapBinaryStorage);
        Assert.assertEquals((Object)new Text("def"), (Object)((LazyString)b.getMapValueElement((Object)new IntWritable(2))).getWritableObject());
        Assert.assertNull((Object)b.getMapValueElement((Object)new IntWritable(-1)));
        Assert.assertEquals((Object)new Text("0"), (Object)((LazyString)b.getMapValueElement((Object)new IntWritable(0))).getWritableObject());
        Assert.assertEquals((Object)new Text("abc"), (Object)((LazyString)b.getMapValueElement((Object)new IntWritable(8))).getWritableObject());
        Assert.assertNull((Object)b.getMapValueElement((Object)new IntWritable(12345)));
        Assert.assertEquals((Object)"{0:'0',2:'def',8:'abc'}".replace('\'', '\"'), (Object)SerDeUtils.getJSONString((Object)b, (ObjectInspector)oi));
    }

    @Test
    public void testLazyHBaseCellMap2() throws SerDeException {
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<string,string>").get(0)), (byte[])new byte[]{35, 9}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyHBaseCellMap b = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"cfacol1")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"cfacol2")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"d\tf")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"-1"), Bytes.toBytes((String)"")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"0"), Bytes.toBytes((String)"0")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"8"), Bytes.toBytes((String)"abc")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfc"), Bytes.toBytes((String)"col3"), Bytes.toBytes((String)"cfccol3")));
        Result r = Result.create(kvs);
        ArrayList<Boolean> mapBinaryStorage = new ArrayList<Boolean>();
        mapBinaryStorage.add(false);
        mapBinaryStorage.add(false);
        b.init(r, "cfb".getBytes(), mapBinaryStorage);
        Assert.assertEquals((Object)new Text("d\tf"), (Object)((LazyString)b.getMapValueElement((Object)new Text("2"))).getWritableObject());
        Assert.assertNull((Object)b.getMapValueElement((Object)new Text("-1")));
        Assert.assertEquals((Object)new Text("0"), (Object)((LazyString)b.getMapValueElement((Object)new Text("0"))).getWritableObject());
        Assert.assertEquals((Object)new Text("abc"), (Object)((LazyString)b.getMapValueElement((Object)new Text("8"))).getWritableObject());
        Assert.assertNull((Object)b.getMapValueElement((Object)new Text("-")));
        Assert.assertEquals((Object)"{'0':'0','2':'d\\tf','8':'abc'}".replace('\'', '\"'), (Object)SerDeUtils.getJSONString((Object)b, (ObjectInspector)oi));
    }

    @Test
    public void testLazyHBaseCellMap3() throws SerDeException {
        Text nullSequence = new Text("\\N");
        TypeInfo mapBinaryIntKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<int,int>");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryIntKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyHBaseCellMap hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] rowKey = "row-key".getBytes();
        byte[] cfInt = "cf-int".getBytes();
        kvs.add(new KeyValue(rowKey, cfInt, Bytes.toBytes((int)1), Bytes.toBytes((int)1)));
        Result result = Result.create(kvs);
        ArrayList<Boolean> mapBinaryStorage = new ArrayList<Boolean>();
        mapBinaryStorage.add(true);
        mapBinaryStorage.add(true);
        hbaseCellMap.init(result, cfInt, mapBinaryStorage);
        IntWritable expectedIntValue = new IntWritable(1);
        LazyPrimitive lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedIntValue);
        Assert.assertEquals((Object)expectedIntValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfInt, Bytes.toBytes((int)Integer.MIN_VALUE), Bytes.toBytes((int)Integer.MIN_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfInt, mapBinaryStorage);
        expectedIntValue = new IntWritable(Integer.MIN_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedIntValue);
        Assert.assertEquals((Object)expectedIntValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfInt, Bytes.toBytes((int)Integer.MAX_VALUE), Bytes.toBytes((int)Integer.MAX_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfInt, mapBinaryStorage);
        expectedIntValue = new IntWritable(Integer.MAX_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedIntValue);
        Assert.assertEquals((Object)expectedIntValue, (Object)lazyPrimitive.getWritableObject());
        TypeInfo mapBinaryByteKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<tinyint,tinyint>");
        oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryByteKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        byte[] cfByte = "cf-byte".getBytes();
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfByte, new byte[]{1}, new byte[]{1}));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfByte, mapBinaryStorage);
        ByteWritable expectedByteValue = new ByteWritable(1);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedByteValue);
        Assert.assertEquals((Object)expectedByteValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfByte, new byte[]{-128}, new byte[]{-128}));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfByte, mapBinaryStorage);
        expectedByteValue = new ByteWritable(-128);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedByteValue);
        Assert.assertEquals((Object)expectedByteValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfByte, new byte[]{127}, new byte[]{127}));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfByte, mapBinaryStorage);
        expectedByteValue = new ByteWritable(127);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedByteValue);
        Assert.assertEquals((Object)expectedByteValue, (Object)lazyPrimitive.getWritableObject());
        TypeInfo mapBinaryShortKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<smallint,smallint>");
        oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryShortKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        byte[] cfShort = "cf-short".getBytes();
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfShort, Bytes.toBytes((short)1), Bytes.toBytes((short)1)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfShort, mapBinaryStorage);
        ShortWritable expectedShortValue = new ShortWritable(1);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedShortValue);
        Assert.assertEquals((Object)expectedShortValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfShort, Bytes.toBytes((short)Short.MIN_VALUE), Bytes.toBytes((short)Short.MIN_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfShort, mapBinaryStorage);
        expectedShortValue = new ShortWritable(Short.MIN_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedShortValue);
        Assert.assertEquals((Object)expectedShortValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfShort, Bytes.toBytes((short)Short.MAX_VALUE), Bytes.toBytes((short)Short.MAX_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfShort, mapBinaryStorage);
        expectedShortValue = new ShortWritable(Short.MAX_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedShortValue);
        Assert.assertEquals((Object)expectedShortValue, (Object)lazyPrimitive.getWritableObject());
        TypeInfo mapBinaryLongKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<bigint,bigint>");
        oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryLongKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        byte[] cfLong = "cf-long".getBytes();
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfLong, Bytes.toBytes((long)1L), Bytes.toBytes((long)1L)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfLong, mapBinaryStorage);
        LongWritable expectedLongValue = new LongWritable(1L);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedLongValue);
        Assert.assertEquals((Object)expectedLongValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfLong, Bytes.toBytes((long)Long.MIN_VALUE), Bytes.toBytes((long)Long.MIN_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfLong, mapBinaryStorage);
        expectedLongValue = new LongWritable(Long.MIN_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedLongValue);
        Assert.assertEquals((Object)expectedLongValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfLong, Bytes.toBytes((long)Long.MAX_VALUE), Bytes.toBytes((long)Long.MAX_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfLong, mapBinaryStorage);
        expectedLongValue = new LongWritable(Long.MAX_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedLongValue);
        Assert.assertEquals((Object)expectedLongValue, (Object)lazyPrimitive.getWritableObject());
        TypeInfo mapBinaryFloatKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<float,float>");
        oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryFloatKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        byte[] cfFloat = "cf-float".getBytes();
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfFloat, Bytes.toBytes((float)1.0f), Bytes.toBytes((float)1.0f)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfFloat, mapBinaryStorage);
        FloatWritable expectedFloatValue = new FloatWritable(1.0f);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedFloatValue);
        Assert.assertEquals((Object)expectedFloatValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfFloat, Bytes.toBytes((float)Float.MIN_VALUE), Bytes.toBytes((float)Float.MIN_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfFloat, mapBinaryStorage);
        expectedFloatValue = new FloatWritable(Float.MIN_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedFloatValue);
        Assert.assertEquals((Object)expectedFloatValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfFloat, Bytes.toBytes((float)Float.MAX_VALUE), Bytes.toBytes((float)Float.MAX_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfFloat, mapBinaryStorage);
        expectedFloatValue = new FloatWritable(Float.MAX_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedFloatValue);
        Assert.assertEquals((Object)expectedFloatValue, (Object)lazyPrimitive.getWritableObject());
        TypeInfo mapBinaryDoubleKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<double,double>");
        oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryDoubleKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        byte[] cfDouble = "cf-double".getBytes();
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfDouble, Bytes.toBytes((double)1.0), Bytes.toBytes((double)1.0)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfDouble, mapBinaryStorage);
        DoubleWritable expectedDoubleValue = new DoubleWritable(1.0);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedDoubleValue);
        Assert.assertEquals((Object)expectedDoubleValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfDouble, Bytes.toBytes((double)Double.MIN_VALUE), Bytes.toBytes((double)Double.MIN_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfDouble, mapBinaryStorage);
        expectedDoubleValue = new DoubleWritable(Double.MIN_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedDoubleValue);
        Assert.assertEquals((Object)expectedDoubleValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfDouble, Bytes.toBytes((double)Double.MAX_VALUE), Bytes.toBytes((double)Double.MAX_VALUE)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfDouble, mapBinaryStorage);
        expectedDoubleValue = new DoubleWritable(Double.MAX_VALUE);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedDoubleValue);
        Assert.assertEquals((Object)expectedDoubleValue, (Object)lazyPrimitive.getWritableObject());
        TypeInfo mapBinaryBooleanKeyValue = TypeInfoUtils.getTypeInfoFromTypeString((String)"map<boolean,boolean>");
        oi = LazyFactory.createLazyObjectInspector((TypeInfo)mapBinaryBooleanKeyValue, (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        hbaseCellMap = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        byte[] cfBoolean = "cf-boolean".getBytes();
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfBoolean, Bytes.toBytes((boolean)false), Bytes.toBytes((boolean)false)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfBoolean, mapBinaryStorage);
        BooleanWritable expectedBooleanValue = new BooleanWritable(false);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedBooleanValue);
        Assert.assertEquals((Object)expectedBooleanValue, (Object)lazyPrimitive.getWritableObject());
        kvs.clear();
        kvs.add(new KeyValue(rowKey, cfBoolean, Bytes.toBytes((boolean)true), Bytes.toBytes((boolean)true)));
        result = Result.create(kvs);
        hbaseCellMap.init(result, cfBoolean, mapBinaryStorage);
        expectedBooleanValue = new BooleanWritable(true);
        lazyPrimitive = (LazyPrimitive)hbaseCellMap.getMapValueElement((Object)expectedBooleanValue);
        Assert.assertEquals((Object)expectedBooleanValue, (Object)lazyPrimitive.getWritableObject());
    }

    @Test
    public void testLazyHBaseRow1() throws SerDeException {
        ArrayList fieldTypeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"string,int,array<string>,map<string,string>,string");
        List<String> fieldNames = Arrays.asList("key", "a", "b", "c", "d");
        Text nullSequence = new Text("\\N");
        String hbaseColsMapping = ":key,cfa:a,cfa:b,cfb:c,cfb:d";
        ColumnMappings columnMappings = null;
        try {
            columnMappings = HBaseSerDe.parseColumnsMapping((String)hbaseColsMapping);
        }
        catch (SerDeException e) {
            Assert.fail((String)e.toString());
        }
        for (ColumnMappings.ColumnMapping colMap : columnMappings) {
            if (!colMap.hbaseRowKey && colMap.qualifierName == null) {
                colMap.binaryStorage.add(false);
                colMap.binaryStorage.add(false);
                continue;
            }
            colMap.binaryStorage.add(false);
        }
        ObjectInspector oi = LazyFactory.createLazyStructInspector(fieldNames, (List)fieldTypeInfos, (byte[])new byte[]{32, 58, 61}, (Text)nullSequence, (boolean)false, (boolean)false, (byte)0);
        LazyHBaseRow o = new LazyHBaseRow((LazySimpleStructObjectInspector)oi, columnMappings);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a:b:c")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d=e:f=g")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"hi")));
        Result r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':123,'b':['a','b','c'],'c':{'d':'e','f':'g'},'d':'hi'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d=e:f=g")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':123,'b':null,'c':{'d':'e','f':'g'},'d':null}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d=\\N:f=g:h")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"no")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':null,'b':['a'],'c':{'d':null,'f':'g','h':null},'d':'no'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)":a::")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"no")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':null,'b':['','a','',''],'c':null,'d':'no'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        Assert.assertEquals((Object)"{'key':'test-row','a':null,'b':['','a','',''],'c':null,'d':'no'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':123,'b':[],'c':{},'d':''}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
    }

    @Test
    public void testLazyHBaseRow2() throws SerDeException {
        ArrayList fieldTypeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"string,int,array<string>,map<string,string>,string");
        List<String> fieldNames = Arrays.asList("key", "a", "b", "c", "d");
        Text nullSequence = new Text("\\N");
        String hbaseColsMapping = ":key,cfa:a,cfa:b,cfb:,cfc:d";
        ColumnMappings columnMappings = null;
        try {
            columnMappings = HBaseSerDe.parseColumnsMapping((String)hbaseColsMapping);
        }
        catch (SerDeException e) {
            Assert.fail((String)e.toString());
        }
        for (ColumnMappings.ColumnMapping colMap : columnMappings) {
            if (!colMap.hbaseRowKey && colMap.qualifierName == null) {
                colMap.binaryStorage.add(false);
                colMap.binaryStorage.add(false);
                continue;
            }
            colMap.binaryStorage.add(false);
        }
        ObjectInspector oi = LazyFactory.createLazyStructInspector(fieldNames, (List)fieldTypeInfos, (byte[])new byte[]{32, 58, 61}, (Text)nullSequence, (boolean)false, (boolean)false, (byte)0);
        LazyHBaseRow o = new LazyHBaseRow((LazySimpleStructObjectInspector)oi, columnMappings);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a:b:c")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfc"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"hi")));
        Result r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':123,'b':['a','b','c'],'c':{'d':'e','f':'g'},'d':'hi'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':123,'b':null,'c':{'d':'e','f':'g'},'d':null}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfb"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfc"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"no")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':null,'b':['a'],'c':{'f':'g'},'d':'no'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)":a::")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfc"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"no")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':null,'b':['','a','',''],'c':{},'d':'no'}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
        kvs.clear();
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfa"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"")));
        kvs.add(new KeyValue(Bytes.toBytes((String)"test-row"), Bytes.toBytes((String)"cfc"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"")));
        r = Result.create(kvs);
        o.init(r);
        Assert.assertEquals((Object)"{'key':'test-row','a':123,'b':[],'c':{},'d':''}".replace("'", "\""), (Object)SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi));
    }

    @Test
    public void testLazyHBaseRow3() throws SerDeException {
        ArrayList fieldTypeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"string,int,tinyint,smallint,bigint,float,double,string,boolean");
        List<String> fieldNames = Arrays.asList("key", "c_int", "c_byte", "c_short", "c_long", "c_float", "c_double", "c_string", "c_bool");
        Text nullSequence = new Text("\\N");
        String hbaseColumnsMapping = ":key#str,cf-int:cq-int#bin,cf-byte:cq-byte#bin,cf-short:cq-short#bin,cf-long:cq-long#bin,cf-float:cq-float#bin,cf-double:cq-double#bin,cf-string:cq-string#str,cf-bool:cq-bool#bin";
        ColumnMappings columnMappings = null;
        try {
            columnMappings = HBaseSerDe.parseColumnsMapping((String)hbaseColumnsMapping);
        }
        catch (SerDeException e) {
            Assert.fail((String)e.toString());
        }
        ColumnMappings.ColumnMapping[] columnsMapping = columnMappings.getColumnsMapping();
        for (int i = 0; i < columnsMapping.length; ++i) {
            ColumnMappings.ColumnMapping colMap = columnsMapping[i];
            if (i == 0 || i == 7) {
                colMap.binaryStorage.add(false);
                continue;
            }
            colMap.binaryStorage.add(true);
        }
        ObjectInspector oi = LazyFactory.createLazyStructInspector(fieldNames, (List)fieldTypeInfos, (byte[])new byte[]{32, 58, 61}, (Text)nullSequence, (boolean)false, (boolean)false, (byte)0);
        LazyHBaseRow o = new LazyHBaseRow((LazySimpleStructObjectInspector)oi, columnMappings);
        byte[] rowKey = "row-key".getBytes();
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (int i = 1; i < columnsMapping.length; ++i) {
            byte[] value;
            switch (i) {
                case 1: {
                    value = Bytes.toBytes((int)1);
                    break;
                }
                case 2: {
                    value = new byte[]{1};
                    break;
                }
                case 3: {
                    value = Bytes.toBytes((short)1);
                    break;
                }
                case 4: {
                    value = Bytes.toBytes((long)1L);
                    break;
                }
                case 5: {
                    value = Bytes.toBytes((float)1.0f);
                    break;
                }
                case 6: {
                    value = Bytes.toBytes((double)1.0);
                    break;
                }
                case 7: {
                    value = "Hadoop, Hive, with HBase storage handler.".getBytes();
                    break;
                }
                case 8: {
                    value = Bytes.toBytes((boolean)true);
                    break;
                }
                default: {
                    throw new RuntimeException("Not expected: " + i);
                }
            }
            ColumnMappings.ColumnMapping colMap = columnsMapping[i];
            kvs.add(new KeyValue(rowKey, colMap.familyNameBytes, colMap.qualifierNameBytes, value));
        }
        Collections.sort(kvs, KeyValue.COMPARATOR);
        Result result = Result.create(kvs);
        o.init(result);
        List fieldRefs = ((StructObjectInspector)oi).getAllStructFieldRefs();
        block25: for (int i = 0; i < fieldRefs.size(); ++i) {
            Object fieldData = ((StructObjectInspector)oi).getStructFieldData((Object)o, (StructField)fieldRefs.get(i));
            assert (fieldData != null);
            assert (fieldData instanceof LazyPrimitive);
            Writable writable = ((LazyPrimitive)fieldData).getWritableObject();
            switch (i) {
                case 0: {
                    Text text = new Text("row-key");
                    Assert.assertEquals((Object)text, (Object)writable);
                    continue block25;
                }
                case 1: {
                    IntWritable iw = new IntWritable(1);
                    Assert.assertEquals((Object)iw, (Object)writable);
                    continue block25;
                }
                case 2: {
                    ByteWritable bw = new ByteWritable(1);
                    Assert.assertEquals((Object)bw, (Object)writable);
                    continue block25;
                }
                case 3: {
                    ShortWritable sw = new ShortWritable(1);
                    Assert.assertEquals((Object)sw, (Object)writable);
                    continue block25;
                }
                case 4: {
                    LongWritable lw = new LongWritable(1L);
                    Assert.assertEquals((Object)lw, (Object)writable);
                    continue block25;
                }
                case 5: {
                    FloatWritable fw = new FloatWritable(1.0f);
                    Assert.assertEquals((Object)fw, (Object)writable);
                    continue block25;
                }
                case 6: {
                    DoubleWritable dw = new DoubleWritable(1.0);
                    Assert.assertEquals((Object)dw, (Object)writable);
                    continue block25;
                }
                case 7: {
                    Text t = new Text("Hadoop, Hive, with HBase storage handler.");
                    Assert.assertEquals((Object)t, (Object)writable);
                    continue block25;
                }
                case 8: {
                    BooleanWritable boolWritable = new BooleanWritable(true);
                    Assert.assertEquals((Object)boolWritable, (Object)writable);
                    continue block25;
                }
                default: {
                    Assert.fail((String)"Error: Unanticipated value in deserializing fields for HBaseSerDe.");
                }
            }
        }
    }
}

