/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.apache.hadoop.hive.ql.udf.ptf.ValueBoundaryScanner;

public class PTFRangeUtil {
    public static Range getRange(WindowFrameDef winFrame, int currRow, PTFPartition p, boolean nullsLast) throws HiveException {
        int end;
        int start;
        BoundaryDef startB = winFrame.getStart();
        BoundaryDef endB = winFrame.getEnd();
        if (winFrame.getWindowType() == WindowingSpec.WindowType.ROWS) {
            start = PTFRangeUtil.getRowBoundaryStart(startB, currRow);
            end = PTFRangeUtil.getRowBoundaryEnd(endB, currRow, p);
        } else {
            ValueBoundaryScanner vbs = ValueBoundaryScanner.getScanner(winFrame, nullsLast);
            vbs.handleCache(currRow, p);
            start = vbs.computeStart(currRow, p);
            end = vbs.computeEnd(currRow, p);
        }
        start = start < 0 ? 0 : start;
        end = end > p.size() ? p.size() : end;
        return new Range(start, end, p);
    }

    private static int getRowBoundaryStart(BoundaryDef b, int currRow) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == Integer.MAX_VALUE) {
                    return 0;
                }
                return currRow - amt;
            }
            case CURRENT: {
                return currRow;
            }
            case FOLLOWING: {
                return currRow + amt;
            }
        }
        throw new HiveException("Unknown Start Boundary Direction: " + d);
    }

    private static int getRowBoundaryEnd(BoundaryDef b, int currRow, PTFPartition p) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == 0) {
                    return currRow + 1;
                }
                return currRow - amt + 1;
            }
            case CURRENT: {
                return currRow + 1;
            }
            case FOLLOWING: {
                if (amt == Integer.MAX_VALUE) {
                    return p.size();
                }
                return currRow + amt + 1;
            }
        }
        throw new HiveException("Unknown End Boundary Direction: " + d);
    }
}

