/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_MultiLineString", value="_FUNC_(array(x1, y1, x2, y2, ... ), array(x1, y1, x2, y2, ... ), ... ) - constructor for 2D multi line string\n_FUNC_('multilinestring( ... )') - constructor for 2D multi line string", extended="Example:\n  SELECT _FUNC_(array(1, 1, 2, 2), array(10, 10, 20, 20)) from src LIMIT 1;\n  SELECT _FUNC_('multilinestring ((1 1, 2 2), (10 10, 20 20))', 0) from src LIMIT 1;")
public class ST_MultiLineString
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_MultiLineString.class.getName());

    public BytesWritable evaluate(List<DoubleWritable> ... multipaths) throws UDFArgumentLengthException {
        if (multipaths == null || multipaths.length == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            Polyline mPolyline = new Polyline();
            int arg_idx = 0;
            for (List<DoubleWritable> multipath : multipaths) {
                if (multipath.size() % 2 != 0) {
                    LogUtils.Log_VariableArgumentLengthXY(LOG, arg_idx);
                    return null;
                }
                mPolyline.startPath(multipath.get(0).get(), multipath.get(1).get());
                for (int i = 2; i < multipath.size(); i += 2) {
                    mPolyline.lineTo(multipath.get(i).get(), multipath.get(i + 1).get());
                }
                ++arg_idx;
            }
            return GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry((Geometry)mPolyline, null, (boolean)true));
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_MultiLineString: " + e);
            return null;
        }
    }

    public BytesWritable evaluate(Text wkwrap) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            OGCGeometry ogcObj = OGCGeometry.fromText((String)wkt);
            ogcObj.setSpatialReference(null);
            if (ogcObj.geometryType().equals("MultiLineString")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_MULTILINESTRING, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

