/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyChangeListener;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLsImpl;

public class HDFSPermissionPolicyProvider
implements HivePolicyProvider {
    private Configuration conf;

    public HDFSPermissionPolicyProvider(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public HiveResourceACLs getResourceACLs(HivePrivilegeObject hiveObject) {
        HiveResourceACLs acls = null;
        try {
            switch (hiveObject.getType()) {
                case DATABASE: {
                    Database db = Hive.get().getDatabase(hiveObject.getDbname());
                    acls = this.getResourceACLs(new Path(db.getLocationUri()));
                    break;
                }
                case TABLE_OR_VIEW: 
                case COLUMN: {
                    Table table = Hive.get().getTable(hiveObject.getDbname(), hiveObject.getObjectName());
                    acls = this.getResourceACLs(new Path(table.getTTable().getSd().getLocation()));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown request type:" + hiveObject.getType());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return acls;
    }

    private HiveResourceACLs getResourceACLs(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        FileSystem fs = path.getFileSystem(this.conf);
        FileStatus pathStatus = FileUtils.getFileStatusOrNull((FileSystem)fs, (Path)path);
        if (pathStatus != null) {
            return this.getResourceACLs(fs, pathStatus);
        }
        if (path.getParent() != null) {
            FileStatus parStatus = null;
            for (Path par = path.getParent(); par != null && (parStatus = FileUtils.getFileStatusOrNull((FileSystem)fs, (Path)par)) == null; par = par.getParent()) {
            }
            return this.getResourceACLs(fs, parStatus);
        }
        return null;
    }

    private HiveResourceACLs getResourceACLs(FileSystem fs, FileStatus stat) {
        String owner = stat.getOwner();
        String group = stat.getGroup();
        HiveResourceACLsImpl acls = new HiveResourceACLsImpl();
        FsPermission permission = stat.getPermission();
        if (permission.getUserAction().implies(FsAction.READ)) {
            acls.addUserEntry(owner, HiveResourceACLs.Privilege.SELECT, HiveResourceACLs.AccessResult.ALLOWED);
        }
        if (permission.getGroupAction().implies(FsAction.READ)) {
            acls.addGroupEntry(group, HiveResourceACLs.Privilege.SELECT, HiveResourceACLs.AccessResult.ALLOWED);
        }
        if (permission.getOtherAction().implies(FsAction.READ)) {
            acls.addGroupEntry("public", HiveResourceACLs.Privilege.SELECT, HiveResourceACLs.AccessResult.ALLOWED);
        }
        return acls;
    }

    @Override
    public void registerHivePolicyChangeListener(HivePolicyChangeListener listener) {
    }
}

