/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CompileProcessor;
import org.apache.hadoop.hive.ql.processors.CryptoProcessor;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.DfsProcessor;
import org.apache.hadoop.hive.ql.processors.ErasureProcessor;
import org.apache.hadoop.hive.ql.processors.HiveCommand;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.LlapCacheResourceProcessor;
import org.apache.hadoop.hive.ql.processors.LlapClusterResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ReloadProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.processors.ShowProcessListProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandProcessorFactory {
    private static Logger LOG = LoggerFactory.getLogger(CommandProcessorFactory.class);

    private CommandProcessorFactory() {
    }

    public static CommandProcessor getForHiveCommand(String[] cmd, HiveConf conf) throws SQLException {
        return CommandProcessorFactory.getForHiveCommandInternal(cmd, conf, false);
    }

    public static CommandProcessor getForHiveCommandInternal(String[] cmd, HiveConf conf, boolean testOnly) throws SQLException {
        HiveCommand hiveCommand = HiveCommand.find(cmd, testOnly);
        if (hiveCommand == null || StringUtils.isBlank((CharSequence)cmd[0])) {
            return null;
        }
        if (conf == null) {
            conf = new HiveConf();
        }
        HashSet<String> availableCommands = new HashSet<String>();
        for (String availableCommand : conf.getVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST).split(",")) {
            availableCommands.add(availableCommand.toLowerCase().trim());
        }
        boolean isWhitelistedCommand = availableCommands.stream().anyMatch(c -> cmd[0].trim().equalsIgnoreCase((String)c) || hiveCommand.name().equalsIgnoreCase((String)c));
        if (!isWhitelistedCommand) {
            throw new SQLException("Insufficient privileges to execute " + cmd[0], "42000");
        }
        if (cmd.length > 1 && "reload".equalsIgnoreCase(cmd[0]) && "function".equalsIgnoreCase(cmd[1])) {
            return null;
        }
        switch (hiveCommand) {
            case SET: {
                return new SetProcessor();
            }
            case RESET: {
                return new ResetProcessor();
            }
            case DFS: {
                SessionState ss = SessionState.get();
                return new DfsProcessor((Configuration)ss.getConf());
            }
            case ADD: {
                return new AddResourceProcessor();
            }
            case LIST: {
                return new ListResourceProcessor();
            }
            case LLAP_CLUSTER: {
                return new LlapClusterResourceProcessor();
            }
            case LLAP_CACHE: {
                return new LlapCacheResourceProcessor();
            }
            case DELETE: {
                return new DeleteResourceProcessor();
            }
            case COMPILE: {
                return new CompileProcessor();
            }
            case RELOAD: {
                return new ReloadProcessor();
            }
            case PROCESSLIST: {
                return new ShowProcessListProcessor();
            }
            case CRYPTO: {
                try {
                    return new CryptoProcessor(SessionState.get().getHdfsEncryptionShim(), conf);
                }
                catch (HiveException e) {
                    throw new SQLException("Fail to start the command processor due to the exception: ", e);
                }
            }
            case ERASURE: {
                try {
                    return new ErasureProcessor(conf);
                }
                catch (IOException e) {
                    throw new SQLException("Fail to start the erasure command processor due to the exception: ", e);
                }
            }
        }
        throw new AssertionError((Object)("Unknown HiveCommand " + hiveCommand));
    }

    public static CommandProcessor get(String[] cmd, @Nonnull HiveConf conf) throws SQLException {
        CommandProcessor result = CommandProcessorFactory.getForHiveCommand(cmd, conf);
        if (result != null) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)cmd[0])) {
            return null;
        }
        return DriverFactory.newDriver(conf);
    }
}

