/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.Quotation;

public class UnparseTranslator {
    private final NavigableMap<Integer, Translation> translations;
    private final List<CopyTranslation> copyTranslations;
    private boolean enabled;
    private Quotation quotation;

    public UnparseTranslator(Configuration configuration) {
        this(Quotation.from((Configuration)configuration));
    }

    public UnparseTranslator(Quotation quotation) {
        this.quotation = quotation;
        this.translations = new TreeMap<Integer, Translation>();
        this.copyTranslations = new ArrayList<CopyTranslation>();
    }

    public void enable() {
        this.enabled = true;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void addTranslation(ASTNode node, String replacementText) {
        if (!this.enabled) {
            return;
        }
        if (node.getOrigin() != null) {
            return;
        }
        int tokenStartIndex = node.getTokenStartIndex();
        int tokenStopIndex = node.getTokenStopIndex();
        if (tokenStopIndex < 0) {
            return;
        }
        Translation translation = new Translation();
        translation.tokenStopIndex = tokenStopIndex;
        translation.replacementText = replacementText;
        assert (tokenStopIndex >= tokenStartIndex);
        ArrayList<Integer> subsetEntries = new ArrayList<Integer>();
        for (Map.Entry existingEntry : this.translations.headMap(tokenStopIndex, true).entrySet()) {
            if (((Translation)existingEntry.getValue()).tokenStopIndex <= tokenStopIndex && (Integer)existingEntry.getKey() >= tokenStartIndex) {
                subsetEntries.add((Integer)existingEntry.getKey());
                continue;
            }
            if (((Translation)existingEntry.getValue()).tokenStopIndex < tokenStopIndex || (Integer)existingEntry.getKey() > tokenStartIndex) continue;
            assert (((Translation)existingEntry.getValue()).replacementText.contains(replacementText));
            return;
        }
        for (Integer index : subsetEntries) {
            this.translations.remove(index);
        }
        this.translations.put(tokenStartIndex, translation);
    }

    public void addTableNameTranslation(ASTNode tableName, String currentDatabaseName) {
        if (!this.enabled) {
            return;
        }
        if (tableName.getToken().getType() == 24) {
            this.addIdentifierTranslation(tableName);
            return;
        }
        assert (tableName.getToken().getType() == 1273);
        assert (tableName.getChildCount() <= 3);
        if (tableName.getChildCount() == 2 || tableName.getChildCount() == 3) {
            this.addIdentifierTranslation((ASTNode)tableName.getChild(0));
            this.addIdentifierTranslation((ASTNode)tableName.getChild(1));
            if (tableName.getChildCount() == 3) {
                this.addIdentifierTranslation((ASTNode)tableName.getChild(2));
            }
        } else {
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(currentDatabaseName, this.quotation));
            replacementText.append('.');
            ASTNode identifier = (ASTNode)tableName.getChild(0);
            String identifierText = BaseSemanticAnalyzer.unescapeIdentifier(identifier.getText());
            replacementText.append(HiveUtils.unparseIdentifier(identifierText, this.quotation));
            this.addTranslation(identifier, replacementText.toString());
        }
    }

    public void addIdentifierTranslation(ASTNode identifier) {
        if (!this.enabled) {
            return;
        }
        assert (identifier.getToken().getType() == 24);
        String replacementText = identifier.getText();
        replacementText = BaseSemanticAnalyzer.unescapeIdentifier(replacementText);
        replacementText = HiveUtils.unparseIdentifier(replacementText, this.quotation);
        this.addTranslation(identifier, replacementText);
    }

    public void addDefaultValueTranslation(ASTNode exprNode, String defaultValue) {
        if (exprNode.getType() != 1270 || exprNode.getChild(0).getType() != 986) {
            return;
        }
        if (defaultValue == null) {
            defaultValue = "NULL";
        }
        this.addTranslation(exprNode, defaultValue);
    }

    public void addCopyTranslation(ASTNode targetNode, ASTNode sourceNode) {
        if (!this.enabled) {
            return;
        }
        if (targetNode.getOrigin() != null) {
            return;
        }
        CopyTranslation copyTranslation = new CopyTranslation();
        copyTranslation.targetNode = targetNode;
        copyTranslation.sourceNode = sourceNode;
        this.copyTranslations.add(copyTranslation);
    }

    void applyTranslations(TokenRewriteStream tokenRewriteStream) {
        this.applyTranslations(tokenRewriteStream, "default");
    }

    public void applyTranslations(TokenRewriteStream tokenRewriteStream, String programName) {
        for (Map.Entry entry : this.translations.entrySet()) {
            if ((Integer)entry.getKey() <= 0) continue;
            tokenRewriteStream.replace(programName, ((Integer)entry.getKey()).intValue(), ((Translation)entry.getValue()).tokenStopIndex, (Object)((Translation)entry.getValue()).replacementText);
        }
        for (CopyTranslation copyTranslation : this.copyTranslations) {
            String replacementText = tokenRewriteStream.toString(programName, copyTranslation.sourceNode.getTokenStartIndex(), copyTranslation.sourceNode.getTokenStopIndex());
            String currentText = tokenRewriteStream.toString(programName, copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex());
            if (currentText.equals(replacementText)) continue;
            this.addTranslation(copyTranslation.targetNode, replacementText);
            tokenRewriteStream.replace(programName, copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex(), (Object)replacementText);
        }
    }

    public void clear() {
        this.translations.clear();
        this.copyTranslations.clear();
        this.enabled = false;
    }

    private static class Translation {
        int tokenStopIndex;
        String replacementText;

        private Translation() {
        }

        public String toString() {
            return this.tokenStopIndex + " -> " + this.replacementText;
        }
    }

    private static class CopyTranslation {
        ASTNode targetNode;
        ASTNode sourceNode;

        private CopyTranslation() {
        }
    }
}

