/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenTezUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GenTezUtils.class);

    public static UnionWork createUnionWork(GenTezProcContext context, Operator<?> root, Operator<?> leaf, TezWork tezWork) {
        UnionWork unionWork = new UnionWork("Union " + context.nextSequenceNumber());
        context.rootUnionWorkMap.put(root, unionWork);
        context.unionWorkMap.put(leaf, unionWork);
        tezWork.add(unionWork);
        return unionWork;
    }

    private static boolean isRestrictReducerExtrapolation(Context context) {
        return context.getOperation() == Context.Operation.DELETE && context.getLoadTableOutputMap().values().stream().map(Entity::getTable).anyMatch(DDLUtils::isIcebergTable);
    }

    public static ReduceWork createReduceWork(GenTezProcContext context, Operator<?> root, TezWork tezWork) {
        TezEdgeProperty edgeProp;
        assert (!root.getParentOperators().isEmpty());
        boolean isAutoReduceParallelism = context.conf.getBoolVar(HiveConf.ConfVars.TEZ_AUTO_REDUCER_PARALLELISM);
        float maxPartitionFactor = context.conf.getFloatVar(HiveConf.ConfVars.TEZ_MAX_PARTITION_FACTOR);
        float minPartitionFactor = context.conf.getFloatVar(HiveConf.ConfVars.TEZ_MIN_PARTITION_FACTOR);
        long bytesPerReducer = context.conf.getLongVar(HiveConf.ConfVars.BYTES_PER_REDUCER);
        int defaultTinyBufferSize = context.conf.getIntVar(HiveConf.ConfVars.TEZ_SIMPLE_CUSTOM_EDGE_TINY_BUFFER_SIZE_MB);
        ReduceWork reduceWork = new ReduceWork("Reducer " + context.nextSequenceNumber());
        LOG.debug("Adding reduce work (" + reduceWork.getName() + ") for " + root);
        reduceWork.setReducer(root);
        reduceWork.setNeedsTagging(GenMapRedUtils.needsTagging(reduceWork));
        assert (context.parentOfRoot instanceof ReduceSinkOperator);
        ReduceSinkOperator reduceSink = (ReduceSinkOperator)context.parentOfRoot;
        reduceWork.setNumReduceTasks(((ReduceSinkDesc)reduceSink.getConf()).getNumReducers());
        reduceWork.setSlowStart(((ReduceSinkDesc)reduceSink.getConf()).isSlowStart());
        float minSrcFraction = context.conf.getFloat("tez.shuffle-vertex-manager.min-src-fraction", 0.25f);
        reduceWork.setMinSrcFraction(minSrcFraction);
        float maxSrcFraction = context.conf.getFloat("tez.shuffle-vertex-manager.max-src-fraction", 0.75f);
        reduceWork.setMaxSrcFraction(maxSrcFraction);
        reduceWork.setUniformDistribution(((ReduceSinkDesc)reduceSink.getConf()).getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM));
        if (GenTezUtils.hasBucketMapJoin(reduceSink, 0)) {
            ((ReduceSinkDesc)reduceSink.getConf()).getReducerTraits().remove((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
        }
        if (isAutoReduceParallelism && ((ReduceSinkDesc)reduceSink.getConf()).getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL)) {
            int maxPartition;
            int maxReducers = context.conf.getIntVar(HiveConf.ConfVars.MAX_REDUCERS);
            int nReducers = ((ReduceSinkDesc)reduceSink.getConf()).getNumReducers();
            int minPartition = Math.max(1, (int)((float)nReducers * minPartitionFactor));
            int n = minPartition = minPartition > maxReducers ? maxReducers : minPartition;
            if (GenTezUtils.isRestrictReducerExtrapolation(context.parseContext.getContext())) {
                LOG.debug("Overriding maxPartitionFactor to 1.0 to prevent creation of small files after delete operation");
                maxPartitionFactor = 1.0f;
            }
            maxPartition = (maxPartition = Math.max(1, (int)((float)nReducers * maxPartitionFactor))) > maxReducers ? maxReducers : maxPartition;
            LOG.debug("max partition factor={}, max partition={}", (Object)Float.valueOf(maxPartitionFactor), (Object)maxPartition);
            float minThreshold = context.conf.getFloatVar(HiveConf.ConfVars.TEZ_AUTO_REDUCER_PARALLELISM_MIN_THRESHOLD);
            if (minPartition < maxPartition && (float)nReducers * minPartitionFactor >= minThreshold) {
                reduceWork.setAutoReduceParallelism(true);
                reduceWork.setMinReduceTasks(minPartition);
                reduceWork.setMaxReduceTasks(maxPartition);
            } else if (nReducers < maxPartition) {
                reduceWork.setNumReduceTasks(maxPartition);
            }
        }
        GenTezUtils.setupReduceSink(context, reduceWork, reduceSink);
        tezWork.add(reduceWork);
        TezEdgeProperty.EdgeType edgeType = GenTezUtils.determineEdgeType(context.preceedingWork, reduceWork, reduceSink);
        if (reduceWork.isAutoReduceParallelism()) {
            edgeProp = new TezEdgeProperty(context.conf, edgeType, true, reduceWork.isSlowStart(), reduceWork.getMinReduceTasks(), reduceWork.getMaxReduceTasks(), bytesPerReducer, reduceWork.getMinSrcFraction(), reduceWork.getMaxSrcFraction());
        } else {
            edgeProp = new TezEdgeProperty(edgeType);
            edgeProp.setSlowStart(reduceWork.isSlowStart());
        }
        edgeProp.setBufferSize(GenTezUtils.obtainBufferSize(root, reduceSink, defaultTinyBufferSize));
        reduceWork.setEdgePropRef(edgeProp);
        tezWork.connect(context.preceedingWork, reduceWork, edgeProp);
        context.connectedReduceSinks.add(reduceSink);
        return reduceWork;
    }

    private static boolean hasBucketMapJoin(Operator<? extends OperatorDesc> operator, int rsoCount) {
        if (operator == null) {
            return false;
        }
        if (operator instanceof ReduceSinkOperator && ++rsoCount > 2) {
            return false;
        }
        for (Operator<OperatorDesc> childOp : operator.getChildOperators()) {
            MapJoinOperator mjOp;
            if (childOp instanceof MapJoinOperator && ((MapJoinDesc)(mjOp = (MapJoinOperator)childOp).getConf()).isBucketMapJoin()) {
                return true;
            }
            if (!GenTezUtils.hasBucketMapJoin(childOp, rsoCount)) continue;
            return true;
        }
        return false;
    }

    private static void setupReduceSink(GenTezProcContext context, ReduceWork reduceWork, ReduceSinkOperator reduceSink) {
        LOG.debug("Setting up reduce sink: " + reduceSink + " with following reduce work: " + reduceWork.getName());
        GenMapRedUtils.setKeyAndValueDesc(reduceWork, reduceSink);
        int tag = ((ReduceSinkDesc)reduceSink.getConf()).getTag();
        reduceWork.getTagToInput().put(tag == -1 ? 0 : tag, context.preceedingWork.getName());
        ((ReduceSinkDesc)reduceSink.getConf()).setOutputName(reduceWork.getName());
    }

    public MapWork createMapWork(GenTezProcContext context, Operator<?> root, TezWork tezWork, PrunedPartitionList partitions) throws SemanticException {
        assert (root.getParentOperators().isEmpty());
        MapWork mapWork = new MapWork("Map " + context.nextSequenceNumber());
        LOG.debug("Adding map work (" + mapWork.getName() + ") for " + root);
        assert (root instanceof TableScanOperator);
        TableScanOperator ts = (TableScanOperator)root;
        String alias = ((TableScanDesc)ts.getConf()).getAlias();
        this.setupMapWork(mapWork, context, partitions, ts, alias);
        if (((TableScanDesc)ts.getConf()).getTableMetadata() != null && ((TableScanDesc)ts.getConf()).getTableMetadata().isDummyTable()) {
            mapWork.setDummyTableScan(true);
        }
        if (((TableScanDesc)ts.getConf()).getNumBuckets() > 0) {
            mapWork.setIncludedBuckets(((TableScanDesc)ts.getConf()).getIncludedBuckets());
        }
        if (ts.getProbeDecodeContext() != null) {
            mapWork.setProbeDecodeContext(ts.getProbeDecodeContext());
        }
        tezWork.add(mapWork);
        return mapWork;
    }

    protected void setupMapWork(MapWork mapWork, GenTezProcContext context, PrunedPartitionList partitions, TableScanOperator root, String alias) throws SemanticException {
        GenMapRedUtils.setMapWork(mapWork, context.parseContext, context.inputs, partitions, root, alias, context.conf, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeUnionOperators(GenTezProcContext context, BaseWork work, int indexForTezUnion) throws SemanticException {
        List<Operator<?>> newRoots;
        ArrayList roots = new ArrayList();
        roots.addAll(work.getAllRootOperators());
        if (work.getDummyOps() != null) {
            roots.addAll(work.getDummyOps());
        }
        roots.addAll(context.eventOperatorSet);
        try (TruncatedOperatorTree truncator = new TruncatedOperatorTree(roots);){
            newRoots = SerializationUtilities.cloneOperatorTree(roots);
        }
        HashBiMap replacementMap = HashBiMap.create();
        LinkedList<HashTableDummyOperator> dummyOps = new LinkedList<HashTableDummyOperator>();
        Iterator<Operator<?>> it = newRoots.iterator();
        for (Operator operator : roots) {
            Set<FileSinkOperator> fsOpSet = OperatorUtils.findOperators(operator, FileSinkOperator.class);
            for (FileSinkOperator fsOp : fsOpSet) {
                context.fileSinkSet.remove(fsOp);
            }
            Operator<?> newRoot = it.next();
            replacementMap.put((Object)operator, newRoot);
            if (newRoot instanceof HashTableDummyOperator) {
                dummyOps.add((HashTableDummyOperator)newRoot);
                it.remove();
                continue;
            }
            if (newRoot instanceof AppMasterEventOperator) {
                if (newRoot.getConf() instanceof DynamicPruningEventDesc) {
                    TableScanOperator ts = ((DynamicPruningEventDesc)operator.getConf()).getTableScan();
                    if (ts == null) {
                        throw new AssertionError((Object)("No table scan associated with dynamic event pruning. " + operator));
                    }
                    ((DynamicPruningEventDesc)newRoot.getConf()).setTableScan(ts);
                }
                it.remove();
                continue;
            }
            if (newRoot instanceof TableScanOperator) {
                if (context.tsToEventMap.containsKey(operator)) {
                    for (AppMasterEventOperator appMasterEventOperator : context.tsToEventMap.get(operator)) {
                        ((DynamicPruningEventDesc)appMasterEventOperator.getConf()).setTableScan((TableScanOperator)newRoot);
                    }
                }
                LinkedHashMap<ReduceSinkOperator, SemiJoinBranchInfo> rsToSemiJoinBranchInfo = context.parseContext.getRsToSemiJoinBranchInfo();
                for (ReduceSinkOperator rs : rsToSemiJoinBranchInfo.keySet()) {
                    SemiJoinBranchInfo sjInfo = (SemiJoinBranchInfo)rsToSemiJoinBranchInfo.get(rs);
                    if (sjInfo.getTsOp() != operator) continue;
                    SemiJoinBranchInfo newSJInfo = new SemiJoinBranchInfo((TableScanOperator)newRoot, sjInfo.getIsHint());
                    rsToSemiJoinBranchInfo.put(rs, newSJInfo);
                }
                for (AppMasterEventOperator event3 : context.eventOperatorSet) {
                    TableScanOperator ts;
                    if (!(event3.getConf() instanceof DynamicPruningEventDesc) || !(ts = ((DynamicPruningEventDesc)event3.getConf()).getTableScan()).equals(operator)) continue;
                    ((DynamicPruningEventDesc)event3.getConf()).setTableScan((TableScanOperator)newRoot);
                }
            }
            context.rootToWorkMap.remove(operator);
            context.rootToWorkMap.put(newRoot, work);
        }
        LinkedList operators = new LinkedList();
        operators.addAll(newRoots);
        HashSet<Operator> hashSet = new HashSet<Operator>();
        Set<FileStatus> fileStatusesToFetch = null;
        if (context.parseContext.getFetchTask() != null) {
            fileStatusesToFetch = ((FetchWork)context.parseContext.getFetchTask().getWork()).getFilesToFetch();
        }
        while (!operators.isEmpty()) {
            Operator current = (Operator)operators.pop();
            if (hashSet.add(current) && current instanceof FileSinkOperator) {
                List<Object> linked;
                FileSinkOperator fileSink = (FileSinkOperator)current;
                if (context.fileSinkSet.contains(fileSink)) continue;
                context.fileSinkSet.add(fileSink);
                FileSinkDesc fileSinkDesc = (FileSinkDesc)fileSink.getConf();
                Path path = fileSinkDesc.getDirName();
                if (!context.linkedFileSinks.containsKey(path)) {
                    linked = new ArrayList();
                    context.linkedFileSinks.put(path, linked);
                }
                linked = context.linkedFileSinks.get(path);
                linked.add(fileSinkDesc);
                fileSinkDesc.setDirName(new Path(path, "HIVE_UNION_SUBDIR_" + linked.size()));
                Utilities.FILE_OP_LOGGER.debug("removing union - new desc with " + fileSinkDesc.getDirName() + "; parent " + path);
                fileSinkDesc.setLinkedFileSink(true);
                fileSinkDesc.setLinkedFileSinkDesc(linked);
                fileSinkDesc.setFilesToFetch(fileStatusesToFetch);
            }
            if (current instanceof AppMasterEventOperator) {
                context.eventOperatorSet.add((AppMasterEventOperator)current);
                context.abandonedEventOperatorSet.add((AppMasterEventOperator)replacementMap.inverse().get((Object)current));
            }
            if (current instanceof UnionOperator) {
                void var13_22;
                Operator<OperatorDesc> parent = null;
                boolean bl = false;
                for (Operator<OperatorDesc> op : current.getParentOperators()) {
                    if (!hashSet.contains(op)) continue;
                    ++var13_22;
                    parent = op;
                }
                assert (var13_22 <= true);
                if (parent == null) {
                    replacementMap.put((Object)current, current.getChildOperators().get(0));
                } else {
                    parent.removeChildAndAdoptItsChildren(current);
                    operators.remove(current);
                }
            }
            if (current instanceof FileSinkOperator || current instanceof ReduceSinkOperator) {
                current.setChildOperators(null);
                continue;
            }
            operators.addAll(current.getChildOperators());
        }
        LOG.debug("Setting dummy ops for work " + work.getName() + ": " + dummyOps);
        work.setDummyOps(dummyOps);
        work.replaceRoots((Map<Operator<?>, Operator<?>>)replacementMap);
    }

    public static void processFileSink(GenTezProcContext context, FileSinkOperator fileSink) throws SemanticException {
        FetchTask fetchTask;
        ParseContext parseContext = context.parseContext;
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseContext, fileSink);
        HiveConf hconf = parseContext.getConf();
        boolean chDir = GenMapRedUtils.isMergeRequired(context.moveTask, hconf, fileSink, context.currentTask, isInsertTable);
        Path finalName = GenMapRedUtils.createMoveTask(context.currentTask, chDir, fileSink, parseContext, context.moveTask, hconf, context.dependencyTask);
        if (chDir) {
            LOG.info("using CombineHiveInputformat for the merge job");
            Utilities.FILE_OP_LOGGER.debug("will generate MR work for merging files from " + ((FileSinkDesc)fileSink.getConf()).getDirName() + " to " + finalName);
            GenMapRedUtils.createMRWorkForMergingFiles(fileSink, finalName, context.dependencyTask, context.moveTask, hconf, context.currentTask, parseContext.getQueryState().getLineageState());
        }
        if ((fetchTask = parseContext.getFetchTask()) != null && context.currentTask.getNumChild() == 0 && fetchTask.isFetchFrom((FileSinkDesc)fileSink.getConf())) {
            context.currentTask.setFetchSource(true);
        }
    }

    public static void processAppMasterEvent(GenTezProcContext procCtx, AppMasterEventOperator event) {
        if (procCtx.abandonedEventOperatorSet.contains(event)) {
            return;
        }
        DynamicPruningEventDesc eventDesc = (DynamicPruningEventDesc)event.getConf();
        TableScanOperator ts = eventDesc.getTableScan();
        MapWork work = (MapWork)procCtx.rootToWorkMap.get(ts);
        if (work == null) {
            throw new AssertionError((Object)("No work found for tablescan " + ts));
        }
        BaseWork enclosingWork = GenTezUtils.getEnclosingWork(event, procCtx);
        if (enclosingWork == null) {
            throw new AssertionError((Object)("Cannot find work for operator" + event));
        }
        String sourceName = enclosingWork.getName();
        eventDesc.setVertexName(work.getName());
        eventDesc.setInputName(work.getAliases().get(0));
        if (!work.getEventSourceTableDescMap().containsKey(sourceName)) {
            work.getEventSourceTableDescMap().put(sourceName, new LinkedList());
        }
        List<TableDesc> tables = work.getEventSourceTableDescMap().get(sourceName);
        tables.add(((AppMasterEventDesc)event.getConf()).getTable());
        if (!work.getEventSourceColumnNameMap().containsKey(sourceName)) {
            work.getEventSourceColumnNameMap().put(sourceName, new LinkedList());
        }
        List<String> columns = work.getEventSourceColumnNameMap().get(sourceName);
        columns.add(eventDesc.getTargetColumnName());
        if (!work.getEventSourceColumnTypeMap().containsKey(sourceName)) {
            work.getEventSourceColumnTypeMap().put(sourceName, new LinkedList());
        }
        List<String> columnTypes = work.getEventSourceColumnTypeMap().get(sourceName);
        columnTypes.add(eventDesc.getTargetColumnType());
        if (!work.getEventSourcePartKeyExprMap().containsKey(sourceName)) {
            work.getEventSourcePartKeyExprMap().put(sourceName, new LinkedList());
        }
        List<ExprNodeDesc> keys = work.getEventSourcePartKeyExprMap().get(sourceName);
        keys.add(eventDesc.getPartKey());
        if (!work.getEventSourcePredicateExprMap().containsKey(sourceName)) {
            work.getEventSourcePredicateExprMap().put(sourceName, new LinkedList());
        }
        List<ExprNodeDesc> predicates = work.getEventSourcePredicateExprMap().get(sourceName);
        predicates.add(eventDesc.getPredicate());
    }

    public static BaseWork getEnclosingWork(Operator<?> op, GenTezProcContext procCtx) {
        ArrayList ops = new ArrayList();
        GenTezUtils.findRoots(op, ops);
        for (Operator operator : ops) {
            BaseWork work = procCtx.rootToWorkMap.get(operator);
            if (work == null) continue;
            return work;
        }
        return null;
    }

    private static void findRoots(Operator<?> op, List<Operator<?>> ops) {
        List<Operator<OperatorDesc>> parents = op.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            ops.add(op);
            return;
        }
        for (Operator<OperatorDesc> p : parents) {
            GenTezUtils.findRoots(p, ops);
        }
    }

    public static Operator<?> removeBranch(Operator<?> event) {
        Operator<?> child = event;
        Operator<Object> curr = event;
        while (curr.getChildOperators().size() <= 1) {
            child = curr;
            curr = curr.getParentOperators().get(0);
        }
        curr.removeChild(child);
        return child;
    }

    public static TezEdgeProperty.EdgeType determineEdgeType(BaseWork preceedingWork, BaseWork followingWork, ReduceSinkOperator reduceSinkOperator) {
        MapJoinOperator joinOp;
        ReduceWork reduceWork;
        if (((ReduceSinkDesc)reduceSinkOperator.getConf()).isForwarding() && !((ReduceSinkDesc)reduceSinkOperator.getConf()).isOrdering()) {
            return TezEdgeProperty.EdgeType.ONE_TO_ONE_EDGE;
        }
        if (followingWork instanceof ReduceWork && (reduceWork = (ReduceWork)followingWork).getReducer() instanceof MapJoinOperator && ((MapJoinDesc)(joinOp = (MapJoinOperator)reduceWork.getReducer()).getConf()).isDynamicPartitionHashJoin()) {
            return TezEdgeProperty.EdgeType.CUSTOM_SIMPLE_EDGE;
        }
        if (!((ReduceSinkDesc)reduceSinkOperator.getConf()).isOrdering()) {
            return TezEdgeProperty.EdgeType.CUSTOM_SIMPLE_EDGE;
        }
        return TezEdgeProperty.EdgeType.SIMPLE_EDGE;
    }

    public static void processDynamicSemiJoinPushDownOperator(GenTezProcContext procCtx, RuntimeValuesInfo runtimeValuesInfo, ReduceSinkOperator rs) throws SemanticException {
        SemiJoinBranchInfo sjInfo = procCtx.parseContext.getRsToSemiJoinBranchInfo().get(rs);
        List<BaseWork> rsWorkList = procCtx.childToWorkMap.get(rs);
        if (sjInfo == null || rsWorkList == null) {
            return;
        }
        if (rsWorkList.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (BaseWork curWork : rsWorkList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(curWork.getName());
            }
            throw new SemanticException(rs + " belongs to multiple BaseWorks: " + sb.toString());
        }
        TableScanOperator ts = sjInfo.getTsOp();
        LOG.debug("ResduceSink " + rs + " to TableScan " + ts);
        BaseWork parentWork = rsWorkList.get(0);
        BaseWork childWork = procCtx.rootToWorkMap.get(ts);
        LOG.debug("Connecting Baswork - " + parentWork.getName() + " to " + childWork.getName());
        TezEdgeProperty edgeProperty = new TezEdgeProperty(TezEdgeProperty.EdgeType.BROADCAST_EDGE);
        TezWork tezWork = (TezWork)procCtx.currentTask.getWork();
        tezWork.connect(parentWork, childWork, edgeProperty);
        ((ReduceSinkDesc)rs.getConf()).setOutputName(childWork.getName());
        RuntimeValuesInfo childRuntimeValuesInfo = new RuntimeValuesInfo();
        childRuntimeValuesInfo.setTableDesc(runtimeValuesInfo.getTableDesc());
        childRuntimeValuesInfo.setDynamicValueIDs(runtimeValuesInfo.getDynamicValueIDs());
        childRuntimeValuesInfo.setColExprs(runtimeValuesInfo.getColExprs());
        childWork.setInputSourceToRuntimeValuesInfo(parentWork.getName(), childRuntimeValuesInfo);
    }

    public static void removeSemiJoinOperator(ParseContext context, ReduceSinkOperator rs, TableScanOperator ts) throws SemanticException {
        LOG.debug("Removing ReduceSink " + rs + " and TableScan " + ts);
        ExprNodeConstantDesc constNode = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, Boolean.TRUE);
        DynamicValuePredicateContext filterDynamicValuePredicatesCollection = new DynamicValuePredicateContext();
        if (((TableScanDesc)ts.getConf()).getFilterExpr() != null) {
            GenTezUtils.collectDynamicValuePredicates(((TableScanDesc)ts.getConf()).getFilterExpr(), filterDynamicValuePredicatesCollection);
            for (ExprNodeDesc nodeToRemove : filterDynamicValuePredicatesCollection.childParentMapping.keySet()) {
                if (!GenTezUtils.removeSemiJoinPredicate(context, rs, nodeToRemove)) continue;
                ExprNodeDesc nodeParent = filterDynamicValuePredicatesCollection.childParentMapping.get(nodeToRemove);
                if (nodeParent == null) {
                    ((TableScanDesc)ts.getConf()).setFilterExpr(null);
                    continue;
                }
                int i = nodeParent.getChildren().indexOf(nodeToRemove);
                nodeParent.getChildren().remove(i);
                nodeParent.getChildren().add(i, constNode);
            }
        }
        for (Operator<OperatorDesc> op : ts.getChildOperators()) {
            if (!(op instanceof FilterOperator)) continue;
            FilterDesc filterDesc = (FilterDesc)((FilterOperator)op).getConf();
            filterDynamicValuePredicatesCollection = new DynamicValuePredicateContext();
            GenTezUtils.collectDynamicValuePredicates(filterDesc.getPredicate(), filterDynamicValuePredicatesCollection);
            for (ExprNodeDesc nodeToRemove : filterDynamicValuePredicatesCollection.childParentMapping.keySet()) {
                if (!GenTezUtils.removeSemiJoinPredicate(context, rs, nodeToRemove)) continue;
                ExprNodeDesc nodeParent = filterDynamicValuePredicatesCollection.childParentMapping.get(nodeToRemove);
                if (nodeParent == null) {
                    filterDesc.setPredicate(constNode);
                    continue;
                }
                int i = nodeParent.getChildren().indexOf(nodeToRemove);
                nodeParent.getChildren().remove(i);
                nodeParent.getChildren().add(i, constNode);
            }
        }
        context.getRsToSemiJoinBranchInfo().remove(rs);
    }

    private static boolean removeSemiJoinPredicate(ParseContext context, ReduceSinkOperator rs, ExprNodeDesc nodeToRemove) {
        boolean remove = false;
        block0: for (ExprNodeDesc expr : nodeToRemove.getChildren()) {
            if (!(expr instanceof ExprNodeDynamicValueDesc)) continue;
            String dynamicValueIdFromExpr = ((ExprNodeDynamicValueDesc)expr).getDynamicValue().getId();
            List<String> dynamicValueIdsFromMap = context.getRsToRuntimeValuesInfoMap().get(rs).getDynamicValueIDs();
            for (String dynamicValueIdFromMap : dynamicValueIdsFromMap) {
                if (!dynamicValueIdFromExpr.equals(dynamicValueIdFromMap)) continue;
                remove = true;
                continue block0;
            }
        }
        return remove;
    }

    public static void removeSemiJoinOperator(ParseContext context, AppMasterEventOperator eventOp, TableScanOperator ts) throws SemanticException {
        LOG.debug("Removing AppMasterEventOperator " + eventOp + " and TableScan " + ts);
        ExprNodeConstantDesc constNode = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, Boolean.TRUE);
        DynamicPruningEventDesc dped = (DynamicPruningEventDesc)eventOp.getConf();
        DynamicPartitionPrunerContext filterDynamicListPredicatesCollection = new DynamicPartitionPrunerContext();
        if (((TableScanDesc)ts.getConf()).getFilterExpr() != null) {
            GenTezUtils.collectDynamicPruningConditions(((TableScanDesc)ts.getConf()).getFilterExpr(), filterDynamicListPredicatesCollection);
            for (DynamicListContext dynamicListContext : filterDynamicListPredicatesCollection) {
                if (dynamicListContext.generator != dped.getGenerator()) continue;
                if (dynamicListContext.grandParent == null) {
                    ((TableScanDesc)ts.getConf()).setFilterExpr(null);
                    continue;
                }
                int i = dynamicListContext.grandParent.getChildren().indexOf(dynamicListContext.parent);
                dynamicListContext.grandParent.getChildren().remove(i);
                dynamicListContext.grandParent.getChildren().add(i, constNode);
            }
        }
        filterDynamicListPredicatesCollection.dynLists.clear();
        for (Operator operator : ts.getChildOperators()) {
            if (!(operator instanceof FilterOperator)) continue;
            FilterDesc filterDesc = (FilterDesc)((FilterOperator)operator).getConf();
            GenTezUtils.collectDynamicPruningConditions(filterDesc.getPredicate(), filterDynamicListPredicatesCollection);
            for (DynamicListContext ctx : filterDynamicListPredicatesCollection) {
                if (ctx.generator != dped.getGenerator()) continue;
                if (ctx.grandParent == null) {
                    filterDesc.setPredicate(constNode);
                    continue;
                }
                int i = ctx.grandParent.getChildren().indexOf(ctx.parent);
                ctx.grandParent.getChildren().remove(i);
                ctx.grandParent.getChildren().add(i, constNode);
            }
        }
    }

    private static void collectDynamicValuePredicates(ExprNodeDesc pred, NodeProcessorCtx ctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> exprRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeDynamicValueDesc.class.getName() + "%"), new DynamicValuePredicateProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, exprRules, ctx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(pred);
        egw.startWalking(startNodes, null);
    }

    public static Map<Node, Object> collectDynamicPruningConditions(ExprNodeDesc pred, NodeProcessorCtx ctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> exprRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeDynamicListDesc.class.getName() + "%"), new DynamicPartitionPrunerProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, exprRules, ctx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(pred);
        HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
        egw.startWalking(startNodes, outputMap);
        return outputMap;
    }

    private static Integer obtainBufferSize(Operator<?> op, ReduceSinkOperator rsOp, int defaultTinyBufferSize) {
        GroupByOperator groupByOperator;
        if (op instanceof GroupByOperator && ((GroupByDesc)(groupByOperator = (GroupByOperator)op).getConf()).getKeys().isEmpty() && ((GroupByDesc)groupByOperator.getConf()).getMode() == GroupByDesc.Mode.MERGEPARTIAL) {
            int result = defaultTinyBufferSize == -1 ? (int)Math.ceil((double)groupByOperator.getStatistics().getDataSize() / 1000000.0) : defaultTinyBufferSize;
            LOG.debug("Buffer size for output from operator {} can be set to {}Mb", (Object)rsOp, (Object)result);
            return result;
        }
        return null;
    }

    static class TruncatedOperatorTree
    implements AutoCloseable {
        List<Runnable> undoSteps = new ArrayList<Runnable>();

        public TruncatedOperatorTree(List<Operator<?>> roots) {
            Set known = Sets.newIdentityHashSet();
            this.runDFS(known, roots, new Class[0]);
            for (Operator o : known) {
                List<Operator<OperatorDesc>> orig;
                if (o instanceof UnionOperator) {
                    orig = o.getParentOperators();
                    this.undoSteps.add(() -> o.setParentOperators(orig));
                    List<Operator<? extends OperatorDesc>> newParents = o.getParentOperators().stream().filter(p -> known.contains(p)).collect(Collectors.toList());
                    o.setParentOperators(newParents);
                }
                if (!this.isTerminal(o)) continue;
                orig = o.getChildOperators();
                this.undoSteps.add(() -> o.setChildOperators(orig));
                o.setChildOperators(null);
            }
        }

        private void runDFS(Set<Operator<?>> known, List<Operator<?>> roots, Class<?> ... terminals) {
            LinkedList pending = new LinkedList();
            pending.addAll(roots);
            while (!pending.isEmpty()) {
                Operator o = (Operator)pending.poll();
                known.add(o);
                if (this.isTerminal(o)) continue;
                pending.addAll(o.getChildOperators());
            }
        }

        private boolean isTerminal(Operator<?> o) {
            return o instanceof FileSinkOperator || o instanceof ReduceSinkOperator;
        }

        @Override
        public void close() {
            for (Runnable runnable : this.undoSteps) {
                runnable.run();
            }
        }
    }

    private static class DynamicValuePredicateContext
    implements NodeProcessorCtx {
        HashMap<ExprNodeDesc, ExprNodeDesc> childParentMapping = new HashMap();

        private DynamicValuePredicateContext() {
        }
    }

    public static class DynamicPartitionPrunerContext
    implements NodeProcessorCtx,
    Iterable<DynamicListContext> {
        public List<DynamicListContext> dynLists = new ArrayList<DynamicListContext>();

        public void addDynamicList(ExprNodeDynamicListDesc desc, ExprNodeDesc parent, ExprNodeDesc grandParent, ReduceSinkOperator generator) {
            this.dynLists.add(new DynamicListContext(desc, parent, grandParent, generator));
        }

        @Override
        public Iterator<DynamicListContext> iterator() {
            return this.dynLists.iterator();
        }
    }

    public static class DynamicListContext {
        public ExprNodeDynamicListDesc desc;
        public ExprNodeDesc parent;
        public ExprNodeDesc grandParent;
        public ReduceSinkOperator generator;

        public DynamicListContext(ExprNodeDynamicListDesc desc, ExprNodeDesc parent, ExprNodeDesc grandParent, ReduceSinkOperator generator) {
            this.desc = desc;
            this.parent = parent;
            this.grandParent = grandParent;
            this.generator = generator;
        }

        public ExprNodeDesc getKeyCol() {
            ExprNodeDesc keyCol = this.desc.getTarget();
            if (keyCol != null) {
                return keyCol;
            }
            return ((ReduceSinkDesc)this.generator.getConf()).getKeyCols().get(this.desc.getKeyIndex());
        }
    }

    private static class DynamicValuePredicateProc
    implements SemanticNodeProcessor {
        private DynamicValuePredicateProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeGenericFuncDesc parentFunc;
            DynamicValuePredicateContext ctx = (DynamicValuePredicateContext)procCtx;
            ExprNodeDesc parent = (ExprNodeDesc)stack.get(stack.size() - 2);
            if (parent instanceof ExprNodeGenericFuncDesc && ((parentFunc = (ExprNodeGenericFuncDesc)parent).getGenericUDF() instanceof GenericUDFBetween || parentFunc.getGenericUDF() instanceof GenericUDFInBloomFilter)) {
                ExprNodeDesc grandParent = stack.size() >= 3 ? (ExprNodeDesc)stack.get(stack.size() - 3) : null;
                ctx.childParentMapping.put(parentFunc, grandParent);
            }
            return null;
        }
    }

    public static class DynamicPartitionPrunerProc
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeDynamicListDesc desc = (ExprNodeDynamicListDesc)nd;
            DynamicPartitionPrunerContext context = (DynamicPartitionPrunerContext)procCtx;
            ExprNodeDesc parent = (ExprNodeDesc)stack.get(stack.size() - 2);
            ExprNodeDesc grandParent = stack.size() >= 3 ? (ExprNodeDesc)stack.get(stack.size() - 3) : null;
            context.addDynamicList(desc, parent, grandParent, (ReduceSinkOperator)desc.getSource());
            return context;
        }
    }
}

