/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.RewriteAlgorithm;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteViewSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CommonTableExpressionSuggester;
import org.apache.hadoop.hive.ql.optimizer.calcite.CommonTableExpressionSuggesterFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveConfPlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveDefaultRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveMaterializedViewASTSubQueryRewriteShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.HivePlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptMaterializationValidator;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRexExecutorImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveSqlTypeUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTezModelRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.RuleEventLogger;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveAlgorithmsConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveVolcanoPlanner;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAntiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExcept;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIntersect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveMultiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRexExprList;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.JdbcHiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.CteRuleConfig;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateJoinTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregatePullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateReduceFunctionsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateSortLimitRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateSplitRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAntiSemiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveCardinalityPreservingJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveDruidRules;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExceptRewriteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExpandDistinctAggregatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFieldTrimmerRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterAggregateTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTSTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSetOpTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSortPredicates;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSortTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterTableFunctionTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveInBetweenExpandRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveInsertExchange4JoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveIntersectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveIntersectRewriteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinAddNotNullRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinCommuteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinConstraintsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinPushTransitivePredicatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinSwapConstraintsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinToMultiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveLoptOptimizeJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveOptimizeInlineArrayTableFunctionRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePartitionPruneRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePointLookupOptimizerRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePreFilteringRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectFilterPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectJoinTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectOverIntersectRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectSortExchangeTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectSortTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsWithStatsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelDecorrelator;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelFieldTrimmer;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRemoveEmptySingleRules;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRemoveGBYSemiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRemoveSqCountCheck;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRewriteToDataSketchesRules;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSearchRules;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSemiJoinProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSemiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortJoinReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortLimitRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortUnionReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSubQueryRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionSimpleSelectsToInlineTableRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveWindowingFixRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveWindowingLastValueRewrite;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.RemoveInfrequentCteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.TableScanToSpoolRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCAbstractSplitFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCAggregateProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCAggregationPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCExpandExpressionsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCExtractJoinFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCFilterPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCJoinPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCProjectPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCSortPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCUnionPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializationRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewBoxing;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierForReturnPath;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CBOFallbackStrategy;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.DruidSqlOperatorConverter;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ImmutableCommonToken;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.NamedJoinInfo;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.QBSubQueryParseInfo;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.parse.relnodegen.LateralViewPlan;
import org.apache.hadoop.hive.ql.parse.type.FunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.HiveFunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.JoinTypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.RexNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.mapper.EmptyStatsSource;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.reexec.ReCompileException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.joda.time.Interval;

public class CalcitePlanner
extends SemanticAnalyzer {
    private static final String EXCLUDED_RULES_PREFIX = "Excluded rules: ";
    private static final String EXPANDED_QUERY_TOKEN_REWRITE_PROGRAM = "EXPANDED_QUERY_PROGRAM";
    private static final String ERROR_MESSAGE_DUPLICATES_DETECTED = "Duplicates detected when adding columns to RR: see previous message";
    private final AtomicInteger noColsMissingStats = new AtomicInteger(0);
    private SemanticException semanticException;
    private boolean runCBO = true;
    private boolean disableSemJoinReordering = true;
    private final CBOFallbackStrategy fallbackStrategy;
    private EnumSet<ExtendedCBOProfile> profilesCBO;
    private static final CommonToken FROM_TOKEN = new ImmutableCommonToken(1032, "TOK_FROM");
    private static final CommonToken DEST_TOKEN = new ImmutableCommonToken(994, "TOK_DESTINATION");
    private static final CommonToken DIR_TOKEN = new ImmutableCommonToken(996, "TOK_DIR");
    private static final CommonToken TMPFILE_TOKEN = new ImmutableCommonToken(1285, "TOK_TMP_FILE");
    private static final CommonToken SELECT_TOKEN = new ImmutableCommonToken(1190, "TOK_SELECT");
    private static final CommonToken SELEXPR_TOKEN = new ImmutableCommonToken(1192, "TOK_SELEXPR");
    private static final CommonToken TABLEORCOL_TOKEN = new ImmutableCommonToken(1270, "TOK_TABLE_OR_COL");
    private static final CommonToken INSERT_TOKEN = new ImmutableCommonToken(1055, "TOK_INSERT");
    private static final CommonToken QUERY_TOKEN = new ImmutableCommonToken(1155, "TOK_QUERY");
    private static final CommonToken SUBQUERY_TOKEN = new ImmutableCommonToken(1236, "TOK_SUBQUERY");
    private static final Pattern PATTERN_VARCHAR = Pattern.compile("VARCHAR\\(2147483647\\)");
    private static final Pattern PATTERN_TIMESTAMP = Pattern.compile("TIMESTAMP\\(9\\)");
    public static final List<Class<? extends RelNode>> HIVE_REL_NODE_CLASSES = ImmutableList.of(RelNode.class, AbstractRelNode.class, RelSubset.class, HepRelVertex.class, ConverterImpl.class, AbstractConverter.class, HiveTableScan.class, HiveAggregate.class, HiveAntiJoin.class, HiveExcept.class, HiveFilter.class, HiveIntersect.class, (Object[])new Class[]{HiveJoin.class, HiveMultiJoin.class, HiveProject.class, HiveRelNode.class, HiveSemiJoin.class, HiveSortExchange.class, HiveSortLimit.class, HiveTableFunctionScan.class, HiveUnion.class, DruidQuery.class, HiveJdbcConverter.class, JdbcHiveTableScan.class, JdbcRules.JdbcAggregate.class, JdbcRules.JdbcFilter.class, JdbcRules.JdbcJoin.class, JdbcRules.JdbcProject.class, JdbcRules.JdbcSort.class, JdbcRules.JdbcUnion.class});

    public CalcitePlanner(QueryState queryState) throws SemanticException {
        super(queryState);
        if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = false;
            this.disableSemJoinReordering = false;
        }
        this.fallbackStrategy = CBOFallbackStrategy.valueOf(this.conf.getVar(HiveConf.ConfVars.HIVE_CBO_FALLBACK_STRATEGY));
    }

    public void resetCalciteConfiguration() {
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = true;
            this.disableSemJoinReordering = true;
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (this.runCBO) {
            super.analyzeInternal(ast, PreCboCtx::new);
        } else {
            super.analyzeInternal(ast);
        }
    }

    public RelNode genLogicalPlan(ASTNode ast) throws SemanticException {
        this.LOG.info("Starting generating logical plan");
        PreCboCtx cboCtx = new PreCboCtx();
        this.processPositionAlias(ast);
        if (!this.genResolvedParseTree(ast, cboCtx)) {
            return null;
        }
        ASTNode queryForCbo = ast;
        if (cboCtx.type == PreCboCtx.Type.CTAS || cboCtx.type == PreCboCtx.Type.VIEW) {
            queryForCbo = cboCtx.nodeOfInterest;
        }
        org.apache.calcite.util.Pair<Boolean, String> pairCanCBOHandleReason = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
        this.runCBO = (Boolean)pairCanCBOHandleReason.left;
        if (!this.runCBO) {
            this.ctx.setCboInfo("Plan not optimized by CBO because the statement " + (String)pairCanCBOHandleReason.right);
            return null;
        }
        this.profilesCBO = CalcitePlanner.obtainCBOProfiles(this.queryProperties);
        this.disableJoinMerge = true;
        RelNode resPlan = this.logicalPlan();
        this.LOG.info("Finished generating logical plan");
        return resPlan;
    }

    public static RelOptPlanner createPlanner(HiveConf conf) {
        return CalcitePlanner.createPlanner(conf, EmptyStatsSource.INSTANCE, false);
    }

    private static RelOptPlanner createPlanner(HiveConf conf, StatsSource statsSource, boolean isExplainPlan) {
        Double maxSplitSize = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MAX_SPLIT_SIZE);
        Double maxMemory = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CONVERT_JOIN_NOCONDITIONAL_TASK_THRESHOLD);
        HiveAlgorithmsConf algorithmsConf = new HiveAlgorithmsConf(maxSplitSize, maxMemory);
        HiveRulesRegistry registry = new HiveRulesRegistry();
        Properties calciteConfigProperties = new Properties();
        calciteConfigProperties.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), conf.getLocalTimeZone().getId());
        calciteConfigProperties.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.FALSE.toString());
        CalciteConnectionConfigImpl calciteConfig = new CalciteConnectionConfigImpl(calciteConfigProperties);
        boolean isCorrelatedColumns = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_STATS_CORRELATED_MULTI_KEY_JOINS);
        boolean heuristicMaterializationStrategy = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_SELECTION_STRATEGY).equals("heuristic");
        HivePlannerContext confContext = new HivePlannerContext(algorithmsConf, registry, (CalciteConnectionConfig)calciteConfig, new HiveConfPlannerContext(isCorrelatedColumns, heuristicMaterializationStrategy, isExplainPlan), statsSource);
        RelOptPlanner planner = HiveVolcanoPlanner.createPlanner(confContext);
        planner.addListener((RelOptListener)new RuleEventLogger());
        return planner;
    }

    @Override
    Operator genOPTree(ASTNode ast, SemanticAnalyzer.PlannerContext plannerCtx) throws SemanticException {
        Operator sinkOp;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        if (!this.runCBO) {
            sinkOp = super.genOPTree(ast, plannerCtx);
        } else {
            PreCboCtx cboCtx = (PreCboCtx)plannerCtx;
            ArrayList<ASTNode> oldHints = new ArrayList<ASTNode>();
            this.getHintsFromQB(this.getQB(), oldHints);
            ASTNode queryForCbo = ast;
            if (cboCtx.type == PreCboCtx.Type.CTAS || cboCtx.type == PreCboCtx.Type.VIEW) {
                queryForCbo = cboCtx.nodeOfInterest;
            }
            org.apache.calcite.util.Pair<Boolean, String> canCBOHandleReason = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
            this.runCBO = (Boolean)canCBOHandleReason.left;
            if (this.queryProperties.hasMultiDestQuery()) {
                this.handleMultiDestQuery(ast, cboCtx);
            }
            if (this.runCBO) {
                this.profilesCBO = CalcitePlanner.obtainCBOProfiles(this.queryProperties);
                this.disableJoinMerge = true;
                boolean materializedView = this.getQB().isMaterializedView();
                try {
                    perfLogger.perfLogBegin(this.getClass().getName(), "Generate Logical Plan");
                    RelNode newPlan = this.logicalPlan();
                    perfLogger.perfLogEnd(this.getClass().getName(), "Generate Logical Plan");
                    perfLogger.perfLogBegin(this.getClass().getName(), "Generate Operator Tree");
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                        if (cboCtx.type == PreCboCtx.Type.VIEW && !materializedView) {
                            throw new SemanticException("Create view is not supported in cbo return path.");
                        }
                        newPlan = PlanModifierForReturnPath.convertOpTree(newPlan, this.resultSchema, this.getQB().getTableDesc() != null);
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("Plan after return path modifier:\n" + RelOptUtil.toString((RelNode)newPlan));
                        }
                        sinkOp = this.getOptimizedHiveOPDag(newPlan);
                        if (oldHints.size() > 0) {
                            this.LOG.debug("Propagating hints to QB: " + oldHints);
                            this.getQB().getParseInfo().setHintList(oldHints);
                        }
                    } else {
                        ASTNode newAST = this.getOptimizedAST(newPlan);
                        newAST = this.fixUpAfterCbo(ast, newAST, cboCtx);
                        if (this.forViewCreation) {
                            this.executeUnParseTranslations();
                            this.originalResultSchema = this.resultSchema;
                        }
                        if (cboCtx.type == PreCboCtx.Type.VIEW) {
                            try {
                                this.viewSelect = this.handleCreateViewDDL(newAST);
                            }
                            catch (SemanticException e) {
                                throw new CalciteViewSemanticException(e.getMessage());
                            }
                        } else if (cboCtx.type == PreCboCtx.Type.CTAS) {
                            this.init(false);
                            this.setAST(newAST);
                            newAST = this.reAnalyzeCTASAfterCbo(newAST);
                        } else {
                            this.init(false);
                        }
                        if (oldHints.size() > 0) {
                            if (this.getQB().getParseInfo().getHints() != null) {
                                this.LOG.warn("Hints are not null in the optimized tree; after CBO " + this.getQB().getParseInfo().getHints().dump());
                            } else {
                                this.LOG.debug("Propagating hints to QB: " + oldHints);
                                this.getQB().getParseInfo().setHintList(oldHints);
                            }
                        }
                        SemanticAnalyzer.Phase1Ctx ctx_1 = this.initPhase1Ctx();
                        if (!this.doPhase1(newAST, this.getQB(), ctx_1, null)) {
                            throw new RuntimeException("Couldn't do phase1 on CBO optimized query plan");
                        }
                        this.getMetaData(this.getQB(), true);
                        this.disableJoinMerge = this.defaultJoinMerge;
                        sinkOp = this.genPlan(this.getQB());
                        if (this.LOG.isTraceEnabled()) {
                            this.LOG.trace(newAST.dump());
                        }
                    }
                    this.LOG.info("CBO Succeeded; optimized logical plan.");
                    this.ctx.setCboInfo(this.getOptimizedByCboInfo());
                    this.ctx.setCboSucceeded(true);
                    if (this.ctx.isExplainPlan()) {
                        ExplainConfiguration explainConfig = this.ctx.getExplainConfig();
                        if (explainConfig.isCbo()) {
                            if (!explainConfig.isCboJoinCost()) {
                                newPlan.getCluster().invalidateMetadataQuery();
                                RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.DEFAULT);
                            }
                            if (explainConfig.isFormatted()) {
                                this.ctx.setCalcitePlan(HiveRelOptUtil.toJsonString(newPlan));
                            } else if (explainConfig.isCboCost() || explainConfig.isCboJoinCost()) {
                                this.ctx.setCalcitePlan(RelOptUtil.toString((RelNode)newPlan, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES));
                            } else {
                                this.ctx.setCalcitePlan(RelOptUtil.toString((RelNode)newPlan));
                            }
                        } else if (explainConfig.isFormatted()) {
                            this.ctx.setCalcitePlan(HiveRelOptUtil.toJsonString(newPlan));
                            this.ctx.setOptimizedSql(this.getOptimizedSql(newPlan));
                        } else if (explainConfig.isExtended()) {
                            this.ctx.setOptimizedSql(this.getOptimizedSql(newPlan));
                        }
                    }
                    if (this.LOG.isTraceEnabled()) {
                        this.LOG.trace(this.getOptimizedSql(newPlan));
                    }
                    perfLogger.perfLogEnd(this.getClass().getName(), "Generate Operator Tree");
                }
                catch (Exception e) {
                    boolean requiresCBO;
                    CalciteSemanticException cse;
                    CalciteSemanticException.UnsupportedFeature unsupportedFeature;
                    boolean isMissingStats;
                    this.LOG.error("CBO failed, skipping CBO. ", (Throwable)e);
                    Object cboMsg = "Plan not optimized by CBO.";
                    boolean bl = isMissingStats = this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        this.LOG.error("CBO failed due to missing column stats (see previous errors), skipping CBO");
                        cboMsg = "Plan not optimized by CBO due to missing statistics. Please check log for more details.";
                    } else if (e instanceof CalciteSemanticException && (unsupportedFeature = (cse = (CalciteSemanticException)((Object)e)).getUnsupportedFeature()) != null) {
                        cboMsg = "Plan not optimized by CBO due to missing feature [" + unsupportedFeature + "].";
                    }
                    this.ctx.setCboInfo((String)cboMsg);
                    boolean bl2 = requiresCBO = this.queryProperties.hasQualify() || this.queryProperties.hasExcept() || this.queryProperties.hasIntersect();
                    if (requiresCBO || this.fallbackStrategy.isFatal(e)) {
                        if (e instanceof RuntimeException || e instanceof SemanticException) {
                            throw e;
                        }
                        throw new SemanticException((Throwable)e);
                    }
                    throw new ReCompileException(this.ctx.getCboInfo());
                }
                finally {
                    this.runCBO = false;
                    this.disableJoinMerge = this.defaultJoinMerge;
                    this.disableSemJoinReordering = false;
                }
            } else {
                Object msg = canCBOHandleReason.right != null ? "Plan not optimized by CBO because the statement " + (String)canCBOHandleReason.right : "Plan not optimized by CBO.";
                this.ctx.setCboInfo((String)msg);
                sinkOp = super.genOPTree(ast, plannerCtx);
            }
        }
        return sinkOp;
    }

    private String getOptimizedByCboInfo() {
        String ruleExclusionRegex = this.conf.get(HiveConf.ConfVars.HIVE_CBO_RULE_EXCLUSION_REGEX.varname, "");
        Object cboInfo = "Plan optimized by CBO.";
        if (!ruleExclusionRegex.isEmpty()) {
            cboInfo = (String)cboInfo + " Excluded rules: " + ruleExclusionRegex;
        }
        return cboInfo;
    }

    private ASTNode handleCreateViewDDL(ASTNode ast) throws SemanticException {
        this.saveViewDefinition();
        String originalText = this.createVwDesc.getViewOriginalText();
        String expandedText = this.createVwDesc.getViewExpandedText();
        List<FieldSchema> schema = this.createVwDesc.getCols();
        List<FieldSchema> partitionColumns = this.createVwDesc.getPartCols();
        this.init(false);
        this.setAST(ast);
        ASTNode newAST = this.reAnalyzeViewAfterCbo(ast);
        this.createVwDesc.setViewOriginalText(originalText);
        this.createVwDesc.setViewExpandedText(expandedText);
        this.createVwDesc.setCols(schema);
        this.createVwDesc.setPartCols(partitionColumns);
        return newAST;
    }

    private void handleMultiDestQuery(ASTNode ast, PreCboCtx cboCtx) throws SemanticException {
        if (!this.runCBO) {
            return;
        }
        if (CalcitePlanner.isJoinToken(cboCtx.nodeOfInterest)) {
            ASTNode subq = this.rewriteASTForMultiInsert(ast, cboCtx.nodeOfInterest);
            if (subq != null) {
                cboCtx.nodeOfInterest = (ASTNode)subq.getChild(0);
                QB newQB = new QB(null, "", false);
                SemanticAnalyzer.Phase1Ctx ctx_1 = this.initPhase1Ctx();
                this.doPhase1(cboCtx.nodeOfInterest, newQB, ctx_1, null);
                this.setQB(newQB);
                this.getMetaData(this.getQB());
            } else {
                this.runCBO = false;
            }
        } else if (cboCtx.nodeOfInterest.getToken().getType() == 1236) {
            ASTNode subq = cboCtx.nodeOfInterest;
            cboCtx.nodeOfInterest = (ASTNode)subq.getChild(0);
            String subQAlias = CalcitePlanner.unescapeIdentifier(subq.getChild(1).getText());
            QB newQB = this.getQB().getSubqForAlias(subQAlias).getQB();
            newQB.getParseInfo().setAlias("");
            newQB.getParseInfo().setIsSubQ(false);
            this.setQB(newQB);
        } else {
            this.runCBO = false;
        }
    }

    private ASTNode rewriteASTForMultiInsert(ASTNode query, ASTNode nodeOfInterest) {
        ArrayListMultimap aliasNodes = ArrayListMultimap.create();
        final AtomicBoolean notSupported = new AtomicBoolean(false);
        TreeVisitorAction action = new TreeVisitorAction(){
            final /* synthetic */ Multimap val$aliasNodes;
            {
                this.val$aliasNodes = multimap;
            }

            public Object pre(Object t) {
                if (!notSupported.get()) {
                    Object p;
                    if (ParseDriver.adaptor.getType(t) == 837) {
                        notSupported.set(true);
                    } else if (ParseDriver.adaptor.getType(t) == 16) {
                        Object c = ParseDriver.adaptor.getChild(t, 0);
                        if (c != null && ParseDriver.adaptor.getType(c) == 1270) {
                            this.val$aliasNodes.put((Object)((ASTNode)t).toStringTree(), t);
                        }
                    } else if (ParseDriver.adaptor.getType(t) == 1270 && ((p = ParseDriver.adaptor.getParent(t)) == null || ParseDriver.adaptor.getType(p) != 16)) {
                        this.val$aliasNodes.put((Object)((ASTNode)t).toStringTree(), t);
                    }
                }
                return t;
            }

            public Object post(Object t) {
                return t;
            }
        };
        TreeVisitor tv = new TreeVisitor(ParseDriver.adaptor);
        for (int i = 0; i < query.getChildCount(); ++i) {
            ASTNode child = (ASTNode)query.getChild(i);
            if (ParseDriver.adaptor.getType((Object)child) != 1055) continue;
            tv.visit((Object)child, action);
        }
        if (notSupported.get()) {
            return null;
        }
        ASTNode from = new ASTNode((Token)FROM_TOKEN);
        from.addChild((Tree)((ASTNode)ParseDriver.adaptor.dupTree((Object)nodeOfInterest)));
        ASTNode destination = new ASTNode((Token)DEST_TOKEN);
        ASTNode dir = new ASTNode((Token)DIR_TOKEN);
        ASTNode tmpFile = new ASTNode((Token)TMPFILE_TOKEN);
        dir.addChild((Tree)tmpFile);
        destination.addChild((Tree)dir);
        ASTNode select = new ASTNode((Token)SELECT_TOKEN);
        int num = 0;
        for (Collection selectIdentifier : aliasNodes.asMap().values()) {
            Iterator it = selectIdentifier.iterator();
            ASTNode node = (ASTNode)it.next();
            ASTNode selectExpr = new ASTNode((Token)SELEXPR_TOKEN);
            selectExpr.addChild((Tree)((ASTNode)ParseDriver.adaptor.dupTree((Object)node)));
            String colAlias = "col" + num;
            selectExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
            select.addChild((Tree)selectExpr);
            ASTNode colExpr = new ASTNode((Token)TABLEORCOL_TOKEN);
            colExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
            CalcitePlanner.replaceASTChild(node, colExpr);
            while (it.hasNext()) {
                node = (ASTNode)it.next();
                colExpr = new ASTNode((Token)TABLEORCOL_TOKEN);
                colExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
                CalcitePlanner.replaceASTChild(node, colExpr);
            }
            ++num;
        }
        ASTNode insert = new ASTNode((Token)INSERT_TOKEN);
        insert.addChild((Tree)destination);
        insert.addChild((Tree)select);
        ASTNode newQuery = new ASTNode((Token)QUERY_TOKEN);
        newQuery.addChild((Tree)from);
        newQuery.addChild((Tree)insert);
        ASTNode subq = new ASTNode((Token)SUBQUERY_TOKEN);
        subq.addChild((Tree)newQuery);
        subq.addChild((Tree)new ASTNode((Token)new CommonToken(24, "subq")));
        CalcitePlanner.replaceASTChild(nodeOfInterest, subq);
        return subq;
    }

    org.apache.calcite.util.Pair<Boolean, String> canCBOHandleAst(ASTNode ast, QB qb, PreCboCtx cboCtx) {
        int root = ast.getToken().getType();
        boolean needToLogMessage = STATIC_LOG.isInfoEnabled();
        boolean isSupportedRoot = root == 1155 || root == 1021 || qb.isCTAS() || qb.isMaterializedView();
        boolean isSupportedType = qb.getIsQuery() || qb.isCTAS() || qb.isMaterializedView() || cboCtx.type == PreCboCtx.Type.INSERT || cboCtx.type == PreCboCtx.Type.MULTI_INSERT;
        org.apache.calcite.util.Pair<Boolean, String> unsupportedFeatures = HiveCalciteUtil.unsupportedFeaturesPresentInASTorQB(ast, qb);
        boolean result = isSupportedRoot && isSupportedType && Boolean.FALSE.equals(unsupportedFeatures.getKey());
        Object msg = "";
        if (!result) {
            if (!isSupportedRoot) {
                msg = (String)msg + "doesn't have QUERY or EXPLAIN as root and not a CTAS; ";
            }
            if (!isSupportedType) {
                msg = (String)msg + "is not a query with at least one source table  or there is a subquery without a source table, or CTAS, or insert; ";
            }
            if (Boolean.TRUE.equals(unsupportedFeatures.getKey())) {
                msg = (String)msg + "has unsupported feature [" + (String)unsupportedFeatures.getValue() + "]; ";
            }
            msg = ((String)msg).substring(0, ((String)msg).length() - 2);
            if (needToLogMessage) {
                STATIC_LOG.info("Not invoking CBO because the statement " + (String)msg);
            }
            return org.apache.calcite.util.Pair.of((Object)false, (Object)msg);
        }
        msg = CalcitePlanner.canHandleQbForCbo(this.queryProperties, this.conf, true);
        if (msg == null) {
            return org.apache.calcite.util.Pair.of((Object)true, (Object)msg);
        }
        if (needToLogMessage) {
            STATIC_LOG.info("Not invoking CBO because the statement " + (String)msg);
        }
        return org.apache.calcite.util.Pair.of((Object)false, (Object)msg);
    }

    private static String canHandleQbForCbo(QueryProperties queryProperties, HiveConf conf, boolean topLevelQB) {
        ArrayList<String> reasons = new ArrayList<String>();
        if (queryProperties.hasSortBy() && queryProperties.hasLimit()) {
            reasons.add("has sort by with limit");
        }
        if (queryProperties.hasPTF()) {
            reasons.add("has PTF");
        }
        if (queryProperties.usesScript()) {
            reasons.add("uses scripts");
        }
        if (!queryProperties.isCBOSupportedLateralViews()) {
            reasons.add("has lateral views");
        }
        return reasons.isEmpty() ? null : String.join((CharSequence)"; ", reasons);
    }

    private static EnumSet<ExtendedCBOProfile> obtainCBOProfiles(QueryProperties queryProperties) {
        EnumSet<ExtendedCBOProfile> profilesCBO = EnumSet.noneOf(ExtendedCBOProfile.class);
        if (queryProperties.getJoinCount() > 1) {
            profilesCBO.add(ExtendedCBOProfile.JOIN_REORDERING);
        }
        if (queryProperties.hasWindowing()) {
            profilesCBO.add(ExtendedCBOProfile.WINDOWING_POSTPROCESSING);
        }
        return profilesCBO;
    }

    @Override
    boolean isCBOExecuted() {
        return this.runCBO;
    }

    @Override
    boolean isCBOSupportedLateralView(ASTNode lateralView) {
        return lateralView.getToken().getType() != 1076;
    }

    @Override
    boolean continueJoinMerge() {
        return !this.runCBO || !this.disableSemJoinReordering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Table materializeCTE(String cteName, SemanticAnalyzer.CTEClause cte) throws HiveException {
        ASTNode createTable = new ASTNode((Token)new ClassicToken(954));
        ASTNode tableName = new ASTNode((Token)new ClassicToken(1273));
        tableName.addChild((Tree)new ASTNode((Token)new ClassicToken(24, cteName)));
        ASTNode temporary = new ASTNode((Token)new ClassicToken(354, "$MATERIALIZATION"));
        createTable.addChild((Tree)tableName);
        createTable.addChild((Tree)temporary);
        createTable.addChild((Tree)cte.cteNode);
        CalcitePlanner analyzer = new CalcitePlanner(this.queryState);
        analyzer.initCtx(this.ctx);
        analyzer.init(false);
        analyzer.aliasToCTEs.putAll(this.aliasToCTEs);
        HiveOperation operation = this.queryState.getHiveOperation();
        try {
            analyzer.analyzeInternal(createTable);
        }
        finally {
            this.queryState.setCommandType(operation);
        }
        Table table = analyzer.tableDesc.toTable(this.conf);
        Path location = table.getDataLocation();
        try {
            location.getFileSystem((Configuration)this.conf).mkdirs(location);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        table.setMaterializedTable(true);
        this.LOG.info(cteName + " will be materialized into " + location);
        cte.source = analyzer;
        this.ctx.addMaterializedTable(cteName, table, this.getMaterializedTableStats(analyzer.getSinkOp()));
        return table;
    }

    @Override
    String fixCtasColumnName(String colName) {
        if (this.runCBO) {
            int lastDot = colName.lastIndexOf(46);
            if (lastDot < 0) {
                return colName;
            }
            String nqColumnName = colName.substring(lastDot + 1);
            STATIC_LOG.debug("Replacing " + colName + " (produced by CBO) by " + nqColumnName);
            return nqColumnName;
        }
        return super.fixCtasColumnName(colName);
    }

    protected ASTNode fixUpAfterCbo(ASTNode originalAst, ASTNode newAst, PreCboCtx cboCtx) throws SemanticException {
        switch (cboCtx.type) {
            case NONE: {
                return newAst;
            }
            case CTAS: 
            case VIEW: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
            case INSERT: {
                ASTNode newDest = new ASTSearcher().simpleBreadthFirstSearch(newAst, 1155, 1055, 994);
                if (newDest == null) {
                    this.LOG.error("Cannot find destination after CBO; new ast is " + newAst.dump());
                    throw new SemanticException("Cannot find destination after CBO");
                }
                CalcitePlanner.replaceASTChild(newDest, cboCtx.nodeOfInterest);
                return newAst;
            }
            case MULTI_INSERT: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
        }
        throw new AssertionError((Object)("Unexpected type " + cboCtx.type));
    }

    ASTNode reAnalyzeCTASAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateTable(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize CTAS after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize CTAS after CBO");
        }
        return newAst;
    }

    ASTNode reAnalyzeViewAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateView(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize materialized view after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize materialized view after CBO");
        }
        return newAst;
    }

    private static void replaceASTChild(ASTNode child, ASTNode newChild) {
        ASTNode parent = (ASTNode)child.parent;
        int childIndex = child.childIndex;
        parent.deleteChild(childIndex);
        parent.insertChild(childIndex, (Object)newChild);
    }

    RelNode logicalPlan() throws SemanticException {
        RelNode optimizedOptiqPlan = null;
        Frameworks.PlannerAction<RelNode> calcitePlannerAction = null;
        if (this.columnAccessInfo == null) {
            this.columnAccessInfo = new ColumnAccessInfo();
        }
        calcitePlannerAction = this.createPlannerAction(this.prunedPartitions, this.ctx.getStatsSource(), this.columnAccessInfo);
        try {
            optimizedOptiqPlan = (RelNode)Frameworks.withPlanner(calcitePlannerAction, (FrameworkConfig)Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        return optimizedOptiqPlan;
    }

    protected Frameworks.PlannerAction<RelNode> createPlannerAction(Map<String, PrunedPartitionList> partitionCache, StatsSource statsSource, ColumnAccessInfo columnAccessInfo) {
        return new CalcitePlannerAction(partitionCache, statsSource, columnAccessInfo, this.getQB());
    }

    public String getOptimizedSql(RelNode optimizedOptiqPlan) {
        boolean nullsLast = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST);
        NullCollation nullCollation = nullsLast ? NullCollation.LAST : NullCollation.LOW;
        HiveSqlDialect dialect = new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withDatabaseMajorVersion(4).withDatabaseMinorVersion(0).withIdentifierQuoteString("`").withDataTypeSystem((RelDataTypeSystem)new HiveTypeSystemImpl()).withNullCollation(nullCollation)){

            protected boolean allowsAs() {
                return true;
            }

            public boolean supportsCharSet() {
                return false;
            }
        };
        try {
            JdbcImplementor jdbcImplementor = new JdbcImplementor((SqlDialect)dialect, (JavaTypeFactory)optimizedOptiqPlan.getCluster().getTypeFactory());
            SqlImplementor.Result result = jdbcImplementor.visitRoot(optimizedOptiqPlan);
            String sql = result.asStatement().toSqlString((SqlDialect)dialect).getSql();
            sql = PATTERN_VARCHAR.matcher(sql).replaceAll("STRING");
            sql = PATTERN_TIMESTAMP.matcher(sql).replaceAll("TIMESTAMP");
            return sql;
        }
        catch (Error | Exception e) {
            this.LOG.warn("Rel2SQL Rewrite threw error", e);
            return null;
        }
    }

    ASTNode getOptimizedAST() throws SemanticException {
        return this.getOptimizedAST(this.logicalPlan());
    }

    ASTNode getOptimizedAST(RelNode optimizedOptiqPlan) throws SemanticException {
        ASTNode optiqOptimizedAST = ASTConverter.convert(optimizedOptiqPlan, this.resultSchema, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COLUMN_ALIGNMENT), this.ctx.getPlanMapper());
        return optiqOptimizedAST;
    }

    Operator getOptimizedHiveOPDag(RelNode optimizedOptiqPlan) throws SemanticException {
        Operator<?> hiveRoot = new HiveOpConverter(this, this.conf, this.unparseTranslator, this.topOps).convert(optimizedOptiqPlan);
        RowResolver hiveRootRR = this.genRowResolver(hiveRoot, this.getQB());
        this.opParseCtx.put(hiveRoot, new OpParseContext(hiveRootRR));
        String dest = this.getQB().getParseInfo().getClauseNames().iterator().next();
        if (this.isInsertInto(this.getQB().getParseInfo(), dest)) {
            Operator<?> selOp = this.handleInsertStatement(dest, hiveRoot, hiveRootRR, this.getQB());
            return this.genFileSinkPlan(dest, this.getQB(), selOp);
        }
        return this.genFileSinkPlan(dest, this.getQB(), hiveRoot);
    }

    Operator<?> handleInsertStatement(String dest, Operator<?> input, RowResolver inputRR, QB qb) throws SemanticException {
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        List<ColumnInfo> columns = inputRR.getColumnInfos();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            colList.add(new ExprNodeColumnDesc(col));
        }
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        RowResolver rowResolver = this.createRowResolver(columns);
        rowResolver = this.handleInsertStatementSpec(colList, dest, rowResolver, qb, selExprList);
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < colList.size(); ++i) {
            String outputCol = CalcitePlanner.getColumnInternalName(i);
            colExprMap.put(outputCol, (ExprNodeDesc)colList.get(i));
            columnNames.add(outputCol);
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames), new RowSchema(rowResolver.getColumnInfos()), input, new Operator[0]), rowResolver);
        output.setColumnExprMap(colExprMap);
        return output;
    }

    private RowResolver createRowResolver(List<ColumnInfo> columnInfos) {
        RowResolver rowResolver = new RowResolver();
        int pos = 0;
        for (ColumnInfo columnInfo : columnInfos) {
            ColumnInfo newColumnInfo = new ColumnInfo(columnInfo);
            newColumnInfo.setInternalName(HiveConf.getColumnInternalName((int)pos++));
            rowResolver.put(newColumnInfo.getTabAlias(), newColumnInfo.getAlias(), newColumnInfo);
        }
        return rowResolver;
    }

    private void rethrowCalciteException(Exception e) throws SemanticException {
        Throwable first;
        Throwable current = first = this.semanticException != null ? this.semanticException : e;
        Throwable cause = current.getCause();
        while (cause != null) {
            Throwable causeOfCause = cause.getCause();
            if (current == first && causeOfCause == null && this.isUselessCause(first)) {
                first = cause;
                break;
            }
            if (causeOfCause != null && this.isUselessCause(cause) && ExceptionHelper.resetCause(current, causeOfCause)) {
                cause = causeOfCause;
                continue;
            }
            current = cause;
            cause = current.getCause();
        }
        if (first instanceof RuntimeException) {
            throw (RuntimeException)first;
        }
        if (first instanceof SemanticException) {
            throw (SemanticException)first;
        }
        throw new RuntimeException(first);
    }

    private boolean isUselessCause(Throwable t) {
        return t instanceof RuntimeException || t instanceof InvocationTargetException;
    }

    private RowResolver genRowResolver(Operator op, QB qb) {
        RowResolver rr = new RowResolver();
        String subqAlias = qb.getAliases().size() == 1 && qb.getSubqAliases().size() == 1 ? qb.getAliases().get(0) : null;
        for (ColumnInfo ci : op.getSchema().getSignature()) {
            try {
                rr.putWithCheck(subqAlias != null ? subqAlias : ci.getTabAlias(), ci.getAlias() != null ? ci.getAlias() : ci.getInternalName(), ci.getInternalName(), new ColumnInfo(ci));
            }
            catch (SemanticException e) {
                throw new RuntimeException(e);
            }
        }
        return rr;
    }

    @Override
    protected Table getTableObjectByName(String tabName, boolean throwException) throws HiveException {
        String[] names = Utilities.getDbTableName(tabName);
        String tableName = names[1];
        String dbName = names[0];
        String tableMetaRef = null;
        if (names.length == 3) {
            tableMetaRef = names[2];
        }
        String fullyQualName = dbName + "." + tableName;
        if (tableMetaRef != null) {
            fullyQualName = fullyQualName + "." + tableMetaRef;
        }
        if (!this.tabNameToTabObject.containsKey(fullyQualName)) {
            Table table = this.db.getTable(dbName, tableName, tableMetaRef, throwException, false, false);
            if (table != null) {
                this.tabNameToTabObject.put(fullyQualName, table);
            }
            return table;
        }
        return this.tabNameToTabObject.get(fullyQualName);
    }

    RexNode genRexNode(ASTNode expr, RowResolver input, RowResolver outerRR, Map<ASTNode, QBSubQueryParseInfo> subqueryToRelNode, boolean useCaching, RexBuilder rexBuilder) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input, rexBuilder, useCaching, false);
        tcCtx.setOuterRR(outerRR);
        tcCtx.setSubqueryToRelNode(subqueryToRelNode);
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        return CalcitePlanner.genRexNode(expr, input, tcCtx, this.conf);
    }

    RexNode genRexNode(ASTNode expr, RowResolver input, RexBuilder rexBuilder) throws SemanticException {
        return this.genRexNode(expr, input, true, false, rexBuilder);
    }

    RexNode genRexNode(ASTNode expr, RowResolver input, boolean useCaching, boolean foldExpr, RexBuilder rexBuilder) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input, rexBuilder, useCaching, foldExpr);
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        return CalcitePlanner.genRexNode(expr, input, tcCtx, this.conf);
    }

    Map<ASTNode, RexNode> genAllRexNode(ASTNode expr, RowResolver input, RexBuilder rexBuilder) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input, rexBuilder);
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        return CalcitePlanner.genAllRexNode(expr, input, tcCtx, this.conf);
    }

    public static RexNode genRexNode(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx, HiveConf conf) throws SemanticException {
        RexNode cached = null;
        if (tcCtx.isUseCaching()) {
            cached = CalcitePlanner.getRexNodeCached(expr, input, tcCtx);
        }
        if (cached == null) {
            Map<ASTNode, RexNode> allExprs = CalcitePlanner.genAllRexNode(expr, input, tcCtx, conf);
            return allExprs.get(expr);
        }
        return cached;
    }

    private static RexNode getRexNodeCached(ASTNode node, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        Preconditions.checkNotNull((Object)tcCtx.getUnparseTranslator());
        ColumnInfo colInfo = input.getExpression(node);
        if (colInfo != null) {
            ASTNode source = input.getExpressionSource(node);
            if (source != null) {
                tcCtx.getUnparseTranslator().addCopyTranslation(node, source);
            }
            return RexNodeTypeCheck.toExprNode(colInfo, input, 0, tcCtx.getRexBuilder());
        }
        return null;
    }

    private static Map<ASTNode, RexNode> genAllRexNode(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx, HiveConf conf) throws SemanticException {
        Preconditions.checkNotNull((Object)tcCtx.getUnparseTranslator());
        Map<ASTNode, RexNode> nodeOutputs = RexNodeTypeCheck.genExprNode(expr, tcCtx);
        RexNode desc = nodeOutputs.get(expr);
        if (desc == null) {
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            ColumnInfo colInfo = input.get(null, tableOrCol);
            String errMsg = colInfo == null && input.getIsExprResolver() ? ASTErrorUtils.getMsg((String)ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(), (ASTNode)expr) : tcCtx.getError();
            throw new SemanticException(Optional.ofNullable(errMsg).orElse("Error in parsing "));
        }
        if (desc instanceof HiveRexExprList) {
            throw new SemanticException("TOK_ALLCOLREF is not supported in current context");
        }
        if (!tcCtx.getUnparseTranslator().isEnabled()) {
            return nodeOutputs;
        }
        ArrayList<ASTNode> fieldDescList = new ArrayList<ASTNode>();
        for (Map.Entry<ASTNode, RexNode> entry : nodeOutputs.entrySet()) {
            String[] tmp;
            if (!(entry.getValue() instanceof RexInputRef)) {
                if (!(entry.getValue() instanceof RexFieldAccess)) continue;
                fieldDescList.add(entry.getKey());
                continue;
            }
            ASTNode node = entry.getKey();
            RexInputRef columnDesc = (RexInputRef)entry.getValue();
            int index = columnDesc.getIndex();
            if (index < input.getColumnInfos().size()) {
                columnInfo = input.getColumnInfos().get(index);
                if (columnInfo.getTabAlias() == null || columnInfo.getTabAlias().length() == 0) continue;
                tmp = input.reverseLookup(columnInfo.getInternalName());
            } else {
                columnInfo = tcCtx.getOuterRR().getColumnInfos().get(index - input.getColumnInfos().size());
                if (columnInfo.getTabAlias() == null || columnInfo.getTabAlias().length() == 0) continue;
                tmp = tcCtx.getOuterRR().reverseLookup(columnInfo.getInternalName());
            }
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(tmp[0], (Configuration)conf));
            replacementText.append(".");
            replacementText.append(HiveUtils.unparseIdentifier(tmp[1], (Configuration)conf));
            tcCtx.getUnparseTranslator().addTranslation(node, replacementText.toString());
        }
        for (ASTNode node : fieldDescList) {
            Map<ASTNode, String> map = CalcitePlanner.translateFieldDesc(node, conf);
            for (Map.Entry<ASTNode, String> entry : map.entrySet()) {
                tcCtx.getUnparseTranslator().addTranslation(entry.getKey(), entry.getValue().toLowerCase());
            }
        }
        return nodeOutputs;
    }

    private String recommendName(RexNode exp, String colAlias, RowResolver rowResolver) {
        if (!colAlias.startsWith(this.autogenColAliasPrfxLbl)) {
            return null;
        }
        String column = CalcitePlanner.recommendInputName(exp, rowResolver);
        if (column != null && !column.startsWith(this.autogenColAliasPrfxLbl)) {
            return column;
        }
        return null;
    }

    private static String recommendInputName(RexNode desc, RowResolver rowResolver) {
        RexNode input;
        Integer pos = null;
        if (desc instanceof RexInputRef) {
            pos = ((RexInputRef)desc).getIndex();
        }
        if (desc.isA(SqlKind.CAST) && (input = (RexNode)((RexCall)desc).operands.get(0)) instanceof RexInputRef) {
            pos = ((RexInputRef)input).getIndex();
        }
        return pos != null ? rowResolver.getColumnInfos().get(pos).getInternalName() : null;
    }

    public static void warmup() {
        JaninoRelMetadataProvider.DEFAULT.register(HIVE_REL_NODE_CLASSES);
        HiveDefaultRelMetadataProvider.initializeMetadataProviderClass(HIVE_REL_NODE_CLASSES);
        HiveTezModelRelMetadataProvider.DEFAULT.register(HIVE_REL_NODE_CLASSES);
        HiveMaterializationRelMetadataProvider.DEFAULT.register(HIVE_REL_NODE_CLASSES);
        HiveRelFieldTrimmer.initializeFieldTrimmerClass(HIVE_REL_NODE_CLASSES);
    }

    protected static class PreCboCtx
    extends SemanticAnalyzer.PlannerContext {
        private ASTNode nodeOfInterest;
        private Type type = Type.NONE;

        protected PreCboCtx() {
        }

        private void set(Type type, ASTNode ast) {
            if (this.type != Type.NONE) {
                BaseSemanticAnalyzer.STATIC_LOG.warn("Setting " + type + " when already " + this.type + "; node " + ast.dump() + " vs old node " + this.nodeOfInterest.dump());
                this.type = Type.UNEXPECTED;
                return;
            }
            this.type = type;
            this.nodeOfInterest = ast;
        }

        @Override
        void setCTASToken(ASTNode child) {
            this.set(Type.CTAS, child);
        }

        @Override
        void setViewToken(ASTNode child) {
            this.set(Type.VIEW, child);
        }

        @Override
        void setInsertToken(ASTNode ast, boolean isTmpFileDest) {
            if (!isTmpFileDest) {
                this.set(Type.INSERT, ast);
            }
        }

        @Override
        void setMultiInsertToken(ASTNode child) {
            this.set(Type.MULTI_INSERT, child);
        }

        @Override
        void resetToken() {
            this.type = Type.NONE;
            this.nodeOfInterest = null;
        }

        static enum Type {
            NONE,
            INSERT,
            MULTI_INSERT,
            CTAS,
            VIEW,
            UNEXPECTED;

        }
    }

    private static enum ExtendedCBOProfile {
        JOIN_REORDERING,
        WINDOWING_POSTPROCESSING,
        REFERENTIAL_CONSTRAINTS;

    }

    public static class ASTSearcher {
        private final LinkedList<ASTNode> searchQueue = new LinkedList();

        public ASTNode simpleBreadthFirstSearch(ASTNode ast, Collection<Integer> tokens) {
            int[] tokenArray = new int[tokens.size()];
            int i = 0;
            for (Integer token : tokens) {
                tokenArray[i] = token;
                ++i;
            }
            return this.simpleBreadthFirstSearch(ast, tokenArray);
        }

        public ASTNode simpleBreadthFirstSearch(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            for (int i = 0; i < tokens.length; ++i) {
                boolean found = false;
                int token = tokens[i];
                while (!this.searchQueue.isEmpty() && !found) {
                    ASTNode next = this.searchQueue.poll();
                    boolean bl = found = next.getType() == token;
                    if (found) {
                        if (i == tokens.length - 1) {
                            return next;
                        }
                        this.searchQueue.clear();
                    }
                    for (int j = 0; j < next.getChildCount(); ++j) {
                        this.searchQueue.add((ASTNode)next.getChild(j));
                    }
                }
                if (found) continue;
                return null;
            }
            return null;
        }

        public ASTNode depthFirstSearch(ASTNode ast, int token) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                ASTNode next = this.searchQueue.poll();
                if (next.getType() == token) {
                    return next;
                }
                for (int j = 0; j < next.getChildCount(); ++j) {
                    this.searchQueue.add((ASTNode)next.getChild(j));
                }
            }
            return null;
        }

        public ASTNode simpleBreadthFirstSearchAny(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                int i;
                ASTNode next = this.searchQueue.poll();
                for (i = 0; i < tokens.length; ++i) {
                    if (next.getType() != tokens[i]) continue;
                    return next;
                }
                for (i = 0; i < next.getChildCount(); ++i) {
                    this.searchQueue.add((ASTNode)next.getChild(i));
                }
            }
            return null;
        }

        public void reset() {
            this.searchQueue.clear();
        }
    }

    public class CalcitePlannerAction
    implements Frameworks.PlannerAction<RelNode> {
        private RelOptCluster cluster;
        private RelOptSchema relOptSchema;
        private FunctionHelper functionHelper;
        private final Map<String, PrunedPartitionList> partitionCache;
        private final Map<String, ColumnStatsList> colStatsCache;
        private final ColumnAccessInfo columnAccessInfo;
        private Map<HiveProject, Table> viewProjectToTableSchema;
        private final QB rootQB;
        private int subqueryId;
        LinkedHashMap<RelNode, RowResolver> relToHiveRR = new LinkedHashMap();
        LinkedHashMap<RelNode, ImmutableMap<String, Integer>> relToHiveColNameCalcitePosMap = new LinkedHashMap();
        private final StatsSource statsSource;
        private RelNode dummyTableScan;
        Map<List<String>, JdbcConvention> jdbcConventionMap = new HashMap<List<String>, JdbcConvention>();
        Map<List<String>, JdbcSchema> schemaMap = new HashMap<List<String>, JdbcSchema>();
        Map<RelNode, ASTNode> subQueryMap = new HashMap<RelNode, ASTNode>();

        protected CalcitePlannerAction(Map<String, PrunedPartitionList> partitionCache, StatsSource statsSource, ColumnAccessInfo columnAccessInfo, QB rootQB) {
            this.partitionCache = partitionCache;
            this.statsSource = statsSource;
            this.rootQB = rootQB;
            this.colStatsCache = CalcitePlanner.this.ctx.getOpContext().getColStatsCache();
            this.columnAccessInfo = columnAccessInfo;
        }

        public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
            RelNode calcitePlan;
            RelOptCluster optCluster;
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.perfLogBegin(this.getClass().getName(), "Calcite: Plan generation");
            this.subqueryId = -1;
            RelOptPlanner planner = CalcitePlanner.createPlanner(CalcitePlanner.this.conf, this.statsSource, CalcitePlanner.this.ctx.isExplainPlan());
            RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new HiveTypeFactory());
            this.cluster = optCluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
            this.relOptSchema = relOptSchema;
            this.functionHelper = new HiveFunctionHelper(rexBuilder);
            perfLogger.perfLogBegin(this.getClass().getName(), "optimizer");
            try {
                calcitePlan = this.genLogicalPlan(CalcitePlanner.this.getQB(), true, null, null);
                CalcitePlanner.this.tabNameToTabObject.markParsingCompleted();
                CalcitePlanner.this.resultSchema = CalcitePlanner.this.convertRowSchemaToResultSetSchema(this.relToHiveRR.get(calcitePlan), CalcitePlanner.this.forViewCreation || CalcitePlanner.this.getQB().isMaterializedView() ? false : HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES));
            }
            catch (SemanticException e) {
                CalcitePlanner.this.semanticException = e;
                throw new RuntimeException(e);
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Initial CBO Plan:\n" + RelOptUtil.toString((RelNode)calcitePlan));
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "Calcite: Plan generation");
            perfLogger.perfLogBegin(this.getClass().getName(), "MV Rewrite and Field Trimmer");
            HiveRexExecutorImpl executorProvider = new HiveRexExecutorImpl();
            calcitePlan.getCluster().getPlanner().setExecutor((RexExecutor)executorProvider);
            HiveDefaultRelMetadataProvider mdProvider = new HiveDefaultRelMetadataProvider(CalcitePlanner.this.conf, HIVE_REL_NODE_CLASSES);
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)mdProvider.getMetadataProvider()));
            optCluster.setMetadataQuerySupplier(HiveRelMetadataQuery::new);
            optCluster.invalidateMetadataQuery();
            calcitePlan = this.applyMaterializedViewRewritingByText(CalcitePlanner.this.ast, calcitePlan, optCluster, mdProvider.getMetadataProvider());
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS) || !CalcitePlanner.this.skipAuthorization()) {
                HiveRelFieldTrimmer.get().trim(HiveRelFactories.HIVE_BUILDER.create(optCluster, null), calcitePlan, this.columnAccessInfo, this.viewProjectToTableSchema);
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "MV Rewrite and Field Trimmer");
            perfLogger.perfLogBegin(this.getClass().getName(), "Removing SubQuery");
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Plan before removing subquery:\n" + RelOptUtil.toString((RelNode)calcitePlan));
            }
            calcitePlan = this.removeSubqueries(calcitePlan, mdProvider.getMetadataProvider());
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Plan after removing subquery:\n" + RelOptUtil.toString((RelNode)calcitePlan));
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "Removing SubQuery");
            perfLogger.perfLogBegin(this.getClass().getName(), "Decorrelation");
            calcitePlan = HiveRelDecorrelator.decorrelateQuery(calcitePlan);
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Plan after decorrelation:\n" + RelOptUtil.toString((RelNode)calcitePlan));
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "Decorrelation");
            perfLogger.perfLogBegin(this.getClass().getName(), "Validate Query Materialization");
            HiveRelOptMaterializationValidator materializationValidator = new HiveRelOptMaterializationValidator();
            materializationValidator.validate(calcitePlan);
            CalcitePlanner.this.setInvalidResultCacheReason(materializationValidator.getResultCacheInvalidReason());
            CalcitePlanner.this.setMaterializationValidationResult(materializationValidator.getAutomaticRewritingValidationResult());
            perfLogger.perfLogEnd(this.getClass().getName(), "Validate Query Materialization");
            perfLogger.perfLogBegin(this.getClass().getName(), "Calcite: Prejoin ordering transformation");
            calcitePlan = this.applyPreJoinOrderingTransforms(calcitePlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Plan after pre-join transformations:\n" + RelOptUtil.toString((RelNode)calcitePlan));
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "Calcite: Prejoin ordering transformation");
            perfLogger.perfLogBegin(this.getClass().getName(), "MV Rewriting");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING) && !CalcitePlanner.this.getQB().isMaterializedView() && !CalcitePlanner.this.ctx.isLoadingMaterializedView() && !CalcitePlanner.this.getQB().isCTAS() && CalcitePlanner.this.getQB().hasTableDefined() && !CalcitePlanner.this.forViewCreation) {
                calcitePlan = this.applyMaterializedViewRewriting(planner, calcitePlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug("Plan after view-based rewriting:\n" + RelOptUtil.toString((RelNode)calcitePlan));
                }
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "MV Rewriting");
            perfLogger.perfLogBegin(this.getClass().getName(), "Calcite: Join Reordering");
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.JOIN_REORDERING)) {
                calcitePlan = this.applyJoinOrderingTransform(calcitePlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug("Plan after join transformations:\n" + RelOptUtil.toString((RelNode)calcitePlan));
                }
            } else {
                CalcitePlanner.this.disableSemJoinReordering = false;
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "Calcite: Join Reordering");
            perfLogger.perfLogBegin(this.getClass().getName(), "Calcite: Postjoin ordering transformation");
            calcitePlan = this.applyPostJoinOrderingTransform(calcitePlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
            perfLogger.perfLogEnd(this.getClass().getName(), "Calcite: Postjoin ordering transformation");
            if (!CalcitePlanner.this.forViewCreation) {
                calcitePlan = this.applyCteRewriting(planner, calcitePlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug("Plan after CTE rewriting:\n{}", (Object)RelOptUtil.toString((RelNode)calcitePlan));
                }
            }
            calcitePlan = this.applySearchExpandTransforms(calcitePlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
            perfLogger.perfLogBegin(this.getClass().getName(), "Hive Sort Predicates");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_SORT_PREDS_WITH_STATS)) {
                calcitePlan = calcitePlan.accept((RelShuttle)new HiveFilterSortPredicates(CalcitePlanner.this.noColsMissingStats));
            }
            perfLogger.perfLogEnd(this.getClass().getName(), "Hive Sort Predicates");
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Plan after post-join transformations:\n" + RelOptUtil.toString((RelNode)calcitePlan));
            }
            return calcitePlan;
        }

        private RelNode applySearchExpandTransforms(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executor) {
            HepProgramBuilder searchProgram = new HepProgramBuilder();
            searchProgram.addRuleCollection((Collection)ImmutableList.of((Object)HiveSearchRules.FILTER_SEARCH_EXPAND, (Object)HiveSearchRules.PROJECT_SEARCH_EXPAND, (Object)HiveSearchRules.JOIN_SEARCH_EXPAND));
            return this.executeProgram(basePlan, searchProgram.build(), mdProvider, executor);
        }

        protected RelNode applyPreJoinOrderingTransforms(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            int maxCNFNodeCount = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_CBO_CNF_NODES_LIMIT);
            int minNumORClauses = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_POINT_LOOKUP_OPTIMIZER_MIN);
            HepProgramBuilder program = new HepProgramBuilder();
            this.generatePartialProgram(program, true, HepMatchOrder.BOTTOM_UP, HiveProjectOverIntersectRemoveRule.INSTANCE, HiveIntersectMergeRule.INSTANCE, HiveUnionMergeRule.INSTANCE);
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveIntersectRewriteRule.INSTANCE);
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveExceptRewriteRule.INSTANCE);
            if (!this.isMaterializedViewMaintenance() && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_ENABLED)) {
                RelOptRule rule;
                String sketchType;
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_COUNTDISTINCT_ENABLED)) {
                    sketchType = CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_COUNT_DISTINCT_SKETCH);
                    rule = new HiveRewriteToDataSketchesRules.CountDistinctRewrite(sketchType);
                    this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, rule);
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_PERCENTILE_DISC_ENABLED)) {
                    sketchType = CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_PERCENTILE_DISC_SKETCH);
                    rule = new HiveRewriteToDataSketchesRules.PercentileDiscRewrite(sketchType);
                    this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, rule);
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_CUME_DIST_ENABLED)) {
                    sketchType = CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_CUME_DIST_SKETCH);
                    rule = new HiveRewriteToDataSketchesRules.CumeDistRewriteRule(sketchType);
                    this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, rule);
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_NTILE_ENABLED)) {
                    sketchType = CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_NTILE_SKETCH);
                    rule = new HiveRewriteToDataSketchesRules.NTileRewrite(sketchType);
                    this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, rule);
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_RANK_ENABLED)) {
                    sketchType = CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_OPTIMIZE_BI_REWRITE_RANK_SKETCH);
                    rule = new HiveRewriteToDataSketchesRules.RankRewriteRule(sketchType);
                    this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, rule);
                }
            }
            if (!CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("mr") && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_DISTINCT_REWRITE)) {
                this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, HiveExpandDistinctAggregatesRule.INSTANCE);
            }
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new RelOptRule[]{new HivePreFilteringRule(maxCNFNodeCount)});
            ArrayList rules = Lists.newArrayList();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPT_PPD_WINDOWING)) {
                rules.add(HiveFilterProjectTransposeRule.DETERMINISTIC_WINDOWING);
            } else {
                rules.add(HiveFilterProjectTransposeRule.DETERMINISTIC);
            }
            rules.add(HiveFilterTableFunctionTransposeRule.INSTANCE);
            rules.add(HiveOptimizeInlineArrayTableFunctionRule.INSTANCE);
            rules.add(HiveFilterSetOpTransposeRule.INSTANCE);
            rules.add(HiveFilterSortTransposeRule.SORT_LIMIT_INSTANCE);
            rules.add(HiveFilterSortTransposeRule.SORT_EXCHANGE_INSTANCE);
            rules.add(HiveFilterJoinRule.JOIN);
            rules.add(HiveFilterJoinRule.FILTER_ON_JOIN);
            rules.add(new HiveFilterAggregateTransposeRule(Filter.class, HiveRelFactories.HIVE_BUILDER, Aggregate.class));
            rules.add(FilterMergeRule.Config.DEFAULT.withOperandFor(HiveFilter.class).withRelBuilderFactory(HiveRelFactories.HIVE_BUILDER).toRule());
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_REDUCE_WITH_STATS)) {
                rules.add(HiveReduceExpressionsWithStatsRule.INSTANCE);
            }
            rules.add(HiveProjectFilterPullUpConstantsRule.INSTANCE);
            rules.add(HiveReduceExpressionsRule.PROJECT_INSTANCE);
            rules.add(HiveReduceExpressionsRule.FILTER_INSTANCE);
            rules.add(HiveReduceExpressionsRule.JOIN_INSTANCE);
            rules.add(HiveReduceExpressionsRule.SEMIJOIN_INSTANCE);
            rules.add(HiveAggregateReduceFunctionsRule.INSTANCE);
            rules.add(HiveAggregateReduceRule.INSTANCE);
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_POINT_LOOKUP_OPTIMIZER)) {
                rules.add(new HivePointLookupOptimizerRule.FilterCondition(minNumORClauses));
                rules.add(new HivePointLookupOptimizerRule.JoinCondition(minNumORClauses));
                rules.add(new HivePointLookupOptimizerRule.ProjectionExpressions(minNumORClauses));
            }
            rules.add(HiveProjectJoinTransposeRule.INSTANCE);
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_CONSTRAINTS_JOIN) && CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.REFERENTIAL_CONSTRAINTS)) {
                rules.add(HiveJoinConstraintsRule.INSTANCE);
            }
            rules.add(HiveJoinAddNotNullRule.INSTANCE_JOIN);
            rules.add(HiveJoinAddNotNullRule.INSTANCE_SEMIJOIN);
            rules.add(HiveJoinAddNotNullRule.INSTANCE_ANTIJOIN);
            rules.add(new HiveJoinPushTransitivePredicatesRule(HiveJoin.class));
            rules.add(new HiveJoinPushTransitivePredicatesRule(HiveSemiJoin.class));
            rules.add(new HiveJoinPushTransitivePredicatesRule(HiveAntiJoin.class));
            rules.add(HiveSortMergeRule.INSTANCE);
            rules.add(HiveSortPullUpConstantsRule.SORT_LIMIT_INSTANCE);
            rules.add(HiveSortPullUpConstantsRule.SORT_EXCHANGE_INSTANCE);
            rules.add(HiveUnionPullUpConstantsRule.INSTANCE);
            rules.add(HiveAggregatePullUpConstantsRule.INSTANCE);
            this.generatePartialProgram(program, true, HepMatchOrder.BOTTOM_UP, rules.toArray(new RelOptRule[0]));
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE)) {
                float reductionProportion = HiveConf.getFloatVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE_REDUCTION_PERCENTAGE);
                long reductionTuples = HiveConf.getLongVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE_REDUCTION_TUPLES);
                this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, new RelOptRule[]{HiveSortMergeRule.INSTANCE, HiveSortProjectTransposeRule.INSTANCE, HiveSortJoinReduceRule.INSTANCE, HiveSortUnionReduceRule.INSTANCE});
                this.generatePartialProgram(program, true, HepMatchOrder.BOTTOM_UP, new HiveSortRemoveRule(reductionProportion, reductionTuples), HiveProjectSortTransposeRule.INSTANCE);
            }
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveSortLimitRemoveRule.INSTANCE);
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new HivePartitionPruneRule(CalcitePlanner.this.conf));
            this.generatePartialProgram(program, false, HepMatchOrder.TOP_DOWN, new HiveFieldTrimmerRule(true));
            this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, new RelOptRule[]{HiveFilterProjectTSTransposeRule.INSTANCE, HiveFilterProjectTSTransposeRule.INSTANCE_DRUID, HiveProjectFilterPullUpConstantsRule.INSTANCE, HiveProjectMergeRule.INSTANCE, ProjectRemoveRule.Config.DEFAULT.toRule(), HiveSortMergeRule.INSTANCE});
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_REMOVE_SQ_COUNT_CHECK)) {
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveRemoveSqCountCheck.INSTANCE);
            }
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_ANTI_JOIN)) {
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveAntiSemiJoinRule.INSTANCE);
            }
            this.generatePartialProgram(program, true, HepMatchOrder.DEPTH_FIRST, HiveRemoveEmptySingleRules.PROJECT_INSTANCE, HiveRemoveEmptySingleRules.FILTER_INSTANCE, HiveRemoveEmptySingleRules.JOIN_LEFT_INSTANCE, HiveRemoveEmptySingleRules.SEMI_JOIN_LEFT_INSTANCE, HiveRemoveEmptySingleRules.JOIN_RIGHT_INSTANCE, HiveRemoveEmptySingleRules.SEMI_JOIN_RIGHT_INSTANCE, HiveRemoveEmptySingleRules.ANTI_JOIN_RIGHT_INSTANCE, HiveRemoveEmptySingleRules.SORT_INSTANCE, HiveRemoveEmptySingleRules.SORT_FETCH_ZERO_INSTANCE, HiveRemoveEmptySingleRules.AGGREGATE_INSTANCE, HiveRemoveEmptySingleRules.UNION_INSTANCE, HiveRemoveEmptySingleRules.CORRELATE_LEFT_INSTANCE, HiveRemoveEmptySingleRules.CORRELATE_RIGHT_INSTANCE);
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            return basePlan;
        }

        private boolean isMaterializedViewMaintenance() {
            return CalcitePlanner.this.mvRebuildMode != SemanticAnalyzer.MaterializationRebuildMode.NONE || CalcitePlanner.this.ctx.isLoadingMaterializedView() || CalcitePlanner.this.getQB().isMaterializedView();
        }

        protected RelNode applyMaterializedViewRewriting(RelOptPlanner planner, RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            RelOptCluster optCluster = basePlan.getCluster();
            boolean useMaterializedViewsRegistry = !CalcitePlanner.this.conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
            RelNode calcitePreMVRewritingPlan = basePlan;
            Set<TableName> tablesUsedQuery = this.getTablesUsed(basePlan);
            if (tablesUsedQuery.isEmpty()) {
                return basePlan;
            }
            List<HiveRelOptMaterialization> materializations = new ArrayList<HiveRelOptMaterialization>();
            try {
                if (useMaterializedViewsRegistry) {
                    materializations.addAll(CalcitePlanner.this.db.getPreprocessedMaterializedViewsFromRegistry(tablesUsedQuery, CalcitePlanner.this.queryState::getValidTxnList, CalcitePlanner.this.getTxnMgr()));
                } else {
                    materializations.addAll(CalcitePlanner.this.db.getPreprocessedMaterializedViews(tablesUsedQuery, CalcitePlanner.this.queryState::getValidTxnList, CalcitePlanner.this.getTxnMgr()));
                }
                materializations = materializations.stream().map(materialization -> materialization.copyToNewCluster(optCluster)).collect(Collectors.toList());
            }
            catch (HiveException e) {
                CalcitePlanner.this.LOG.warn("Exception loading materialized views", (Throwable)e);
            }
            if (materializations.isEmpty()) {
                return calcitePreMVRewritingPlan;
            }
            basePlan = this.rewriteUsingViews(planner, basePlan, mdProvider, executorProvider, materializations);
            List<Table> materializedViewsUsedOriginalPlan = this.getMaterializedViewsUsed(calcitePreMVRewritingPlan);
            List<Table> materializedViewsUsedAfterRewrite = this.getMaterializedViewsUsed(basePlan);
            if (materializedViewsUsedOriginalPlan.size() == materializedViewsUsedAfterRewrite.size()) {
                return calcitePreMVRewritingPlan;
            }
            try {
                if (!HiveMaterializedViewUtils.checkPrivilegeForMaterializedViews(materializedViewsUsedAfterRewrite)) {
                    return calcitePreMVRewritingPlan;
                }
            }
            catch (HiveException e) {
                CalcitePlanner.this.LOG.warn("Exception checking privileges for materialized views", (Throwable)e);
                return calcitePreMVRewritingPlan;
            }
            if (useMaterializedViewsRegistry) {
                try {
                    if (!CalcitePlanner.this.db.validateMaterializedViewsFromRegistry(materializedViewsUsedAfterRewrite, tablesUsedQuery, CalcitePlanner.this.queryState::getValidTxnList, CalcitePlanner.this.getTxnMgr())) {
                        return calcitePreMVRewritingPlan;
                    }
                }
                catch (HiveException e) {
                    CalcitePlanner.this.LOG.warn("Exception validating materialized views", (Throwable)e);
                    return calcitePreMVRewritingPlan;
                }
            }
            return this.applyPreJoinOrderingTransforms(basePlan, mdProvider, executorProvider);
        }

        private RelNode rewriteUsingViews(RelOptPlanner planner, RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider, Collection<? extends RelOptMaterialization> materializations) {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.perfLogBegin(this.getClass().getName(), "optimizer");
            RelOptCluster optCluster = basePlan.getCluster();
            HepProgramBuilder program = new HepProgramBuilder();
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveInBetweenExpandRule.FILTER_INSTANCE, HiveInBetweenExpandRule.JOIN_INSTANCE, HiveInBetweenExpandRule.PROJECT_INSTANCE);
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            basePlan = HiveMaterializedViewBoxing.boxPlan(basePlan);
            optCluster.invalidateMetadataQuery();
            RelMetadataQuery.THREAD_PROVIDERS.set(HiveMaterializationRelMetadataProvider.DEFAULT);
            for (RelOptMaterialization relOptMaterialization : materializations) {
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug("Adding materialization {} to the planner; the plan is:\n{}", (Object)relOptMaterialization.qualifiedTableName, (Object)RelOptUtil.toString((RelNode)relOptMaterialization.queryRel));
                }
                planner.addMaterialization(relOptMaterialization);
            }
            planner.addRule((RelOptRule)HiveAggregateSplitRule.INSTANCE);
            for (RelOptRule rule : HiveMaterializedViewRule.MATERIALIZED_VIEW_REWRITING_RULES) {
                planner.addRule(rule);
            }
            planner.addRule((RelOptRule)HiveMaterializedViewBoxing.INSTANCE_UNBOXING);
            planner.addRule((RelOptRule)HiveFilterProjectTSTransposeRule.INSTANCE);
            planner.addRule((RelOptRule)new HivePartitionPruneRule(CalcitePlanner.this.conf));
            String ruleExclusionRegex = CalcitePlanner.this.conf.get(HiveConf.ConfVars.HIVE_CBO_RULE_EXCLUSION_REGEX.varname, "");
            if (!ruleExclusionRegex.isEmpty()) {
                CalcitePlanner.this.LOG.info("The CBO rules matching the following regex are excluded from planning: {}", (Object)ruleExclusionRegex);
                planner.setRuleDescExclusionFilter(Pattern.compile(ruleExclusionRegex));
            }
            planner.setRoot(basePlan);
            basePlan = planner.findBestExp();
            planner.clear();
            optCluster.invalidateMetadataQuery();
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)mdProvider));
            perfLogger.perfLogEnd(this.getClass().getName(), "optimizer", "Calcite: View-based rewriting");
            return basePlan;
        }

        private RelNode applyCteRewriting(RelOptPlanner planner, RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            int referenceThreshold = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_CTE_MATERIALIZE_THRESHOLD);
            if (referenceThreshold <= 0) {
                return basePlan;
            }
            CommonTableExpressionSuggester suggester = CommonTableExpressionSuggesterFactory.create(CalcitePlanner.this.conf);
            List<RelNode> ctes = suggester.suggest(basePlan, (Configuration)CalcitePlanner.this.conf);
            if (ctes.isEmpty()) {
                return basePlan;
            }
            HiveRelMetadataQuery mq = (HiveRelMetadataQuery)basePlan.getCluster().getMetadataQuery();
            ArrayList<RelOptMaterialization> cteMVs = new ArrayList<RelOptMaterialization>();
            for (int i = 0; i < ctes.size(); ++i) {
                RelNode cte = ctes.get(i);
                if (!this.isMaterializableCte(mq, cte)) continue;
                cteMVs.add(HiveMaterializedViewUtils.createCTEMaterialization("cte_suggestion_" + i, cte, CalcitePlanner.this.conf));
            }
            RelNode ctePlan = this.rewriteUsingViews(planner, basePlan, mdProvider, executorProvider, cteMVs);
            Map<List<String>, Integer> tableOccurrences = RelOptUtil.findAllTables((RelNode)ctePlan).stream().map(RelOptTable::getQualifiedName).collect(Collectors.toMap(Function.identity(), v -> 1, Integer::sum));
            CteRuleConfig cteConfig = CteRuleConfig.config().withReferenceThreshold(referenceThreshold).withTableOccurrences(tableOccurrences);
            HepProgram spoolProgram = HepProgram.builder().addMatchOrder(HepMatchOrder.DEPTH_FIRST).addRuleInstance((RelOptRule)new TableScanToSpoolRule(cteConfig)).addRuleInstance((RelOptRule)new RemoveInfrequentCteRule(cteConfig)).build();
            RelNode spoolPlan = this.executeProgram(ctePlan, spoolProgram, mdProvider, executorProvider, cteMVs, true);
            if (ctePlan.getRelDigest().equals(spoolPlan.getRelDigest())) {
                return basePlan;
            }
            return spoolPlan;
        }

        private boolean isMaterializableCte(HiveRelMetadataQuery mq, RelNode cte) {
            boolean checkFullAggregate = CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CTE_MATERIALIZE_FULL_AGGREGATE_ONLY);
            ImmutableBitSet cteOutputColumns = ImmutableBitSet.range((int)cte.getRowType().getFieldCount());
            if (checkFullAggregate && !Boolean.TRUE.equals(mq.areColumnsAggregated(cte, cteOutputColumns))) {
                CalcitePlanner.this.LOG.debug("Skipping CTE {} cause its not a full aggregate.", (Object)cte);
                return false;
            }
            if (HiveSqlTypeUtil.containsSqlType(cte.getRowType(), SqlTypeName.NULL)) {
                CalcitePlanner.this.LOG.debug("Skipping CTE {} cause it contains untyped nulls", (Object)cte);
                return false;
            }
            return true;
        }

        private boolean isMaterializedViewRewritingByTextEnabled() {
            return CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING_SQL) && !HiveMaterializedViewsRegistry.get().isEmpty() && CalcitePlanner.this.mvRebuildMode == SemanticAnalyzer.MaterializationRebuildMode.NONE && !this.rootQB.isMaterializedView() && !CalcitePlanner.this.ctx.isLoadingMaterializedView() && !this.rootQB.isCTAS() && this.rootQB.getIsQuery() && this.rootQB.hasTableDefined() && !CalcitePlanner.this.forViewCreation;
        }

        private RelNode applyMaterializedViewRewritingByText(ASTNode queryToRewriteAST, RelNode originalPlan, RelOptCluster optCluster, RelMetadataProvider metadataProvider) {
            if (!this.isMaterializedViewRewritingByTextEnabled()) {
                return originalPlan;
            }
            String expandedQueryText = null;
            try {
                CalcitePlanner.this.unparseTranslator.applyTranslations(CalcitePlanner.this.ctx.getTokenRewriteStream(), CalcitePlanner.EXPANDED_QUERY_TOKEN_REWRITE_PROGRAM);
                expandedQueryText = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(CalcitePlanner.EXPANDED_QUERY_TOKEN_REWRITE_PROGRAM, queryToRewriteAST.getTokenStartIndex(), queryToRewriteAST.getTokenStopIndex());
                ASTNode expandedAST = ParseUtils.parse(expandedQueryText, new Context((Configuration)CalcitePlanner.this.conf));
                Set<TableName> tablesUsedByOriginalPlan = this.getTablesUsed(this.removeSubqueries(originalPlan, metadataProvider));
                if (tablesUsedByOriginalPlan.isEmpty()) {
                    return originalPlan;
                }
                RelNode mvScan = HiveMaterializedViewASTSubQueryRewriteShuttle.getMaterializedViewByAST(expandedAST, optCluster, RewriteAlgorithm.ANY, CalcitePlanner.this.db, tablesUsedByOriginalPlan, CalcitePlanner.this.queryState::getValidTxnList, CalcitePlanner.this.getTxnMgr());
                if (mvScan != null) {
                    return mvScan;
                }
                if (!CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING_SUBQUERY_SQL)) {
                    return originalPlan;
                }
                return new HiveMaterializedViewASTSubQueryRewriteShuttle(this.subQueryMap, queryToRewriteAST, expandedAST, HiveRelFactories.HIVE_BUILDER.create(optCluster, null), CalcitePlanner.this.db, tablesUsedByOriginalPlan, CalcitePlanner.this.queryState::getValidTxnList, CalcitePlanner.this.getTxnMgr()).rewrite(originalPlan);
            }
            catch (Exception e) {
                CalcitePlanner.this.LOG.warn("Automatic materialized view query rewrite failed. expanded query text: {} AST string {} ", new Object[]{expandedQueryText, queryToRewriteAST.toStringTree(), e});
                return originalPlan;
            }
        }

        private RelNode applyJoinOrderingTransform(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            RelNode calciteOptimizedPlan;
            HepProgramBuilder program = new HepProgramBuilder();
            ArrayList rules = Lists.newArrayList();
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.REFERENTIAL_CONSTRAINTS)) {
                rules.add(HiveJoinSwapConstraintsRule.INSTANCE);
            }
            rules.add(HiveSemiJoinProjectTransposeRule.INSTANCE);
            rules.add(HiveJoinProjectTransposeRule.LEFT_PROJECT_BTW_JOIN);
            rules.add(HiveJoinProjectTransposeRule.RIGHT_PROJECT_BTW_JOIN);
            rules.add(HiveProjectMergeRule.INSTANCE);
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.REFERENTIAL_CONSTRAINTS)) {
                rules.add(CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPT_PPD_WINDOWING) ? HiveFilterProjectTransposeRule.DETERMINISTIC_WINDOWING_ON_NON_FILTERING_JOIN : HiveFilterProjectTransposeRule.DETERMINISTIC_ON_NON_FILTERING_JOIN);
                rules.add(HiveFilterJoinRule.FILTER_ON_NON_FILTERING_JOIN);
            }
            this.generatePartialProgram(program, true, HepMatchOrder.BOTTOM_UP, rules.toArray(new RelOptRule[0]));
            this.generatePartialProgram(program, false, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{new JoinToMultiJoinRule(HiveJoin.class), HiveLoptOptimizeJoinRule.INSTANCE});
            try {
                calciteOptimizedPlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            }
            catch (Exception e) {
                if (CalcitePlanner.this.noColsMissingStats.get() > 0) {
                    CalcitePlanner.this.LOG.warn("Missing column stats (see previous messages), skipping join reordering in CBO");
                    CalcitePlanner.this.noColsMissingStats.set(0);
                    calciteOptimizedPlan = basePlan;
                    CalcitePlanner.this.disableSemJoinReordering = false;
                }
                throw e;
            }
            return calciteOptimizedPlan;
        }

        private RelNode applyPostJoinOrderingTransform(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            HepProgramBuilder program = new HepProgramBuilder();
            double factor = CalcitePlanner.this.conf.getFloatVar(HiveConf.ConfVars.HIVE_CARDINALITY_PRESERVING_JOIN_OPTIMIZATION_FACTOR);
            if (factor > 0.0) {
                this.generatePartialProgram(program, false, HepMatchOrder.TOP_DOWN, new HiveCardinalityPreservingJoinRule(factor));
            }
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new RelOptRule[]{ProjectRemoveRule.Config.DEFAULT.toRule(), HiveUnionMergeRule.INSTANCE, new HiveUnionSimpleSelectsToInlineTableRule(this.dummyTableScan), HiveAggregateProjectMergeRule.INSTANCE, HiveProjectMergeRule.INSTANCE_NO_FORCE, HiveJoinCommuteRule.INSTANCE, new HiveAggregateSortLimitRule(CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST))});
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.AGGR_JOIN_TRANSPOSE) || CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.AGGR_JOIN_TRANSPOSE_UNIQUE)) {
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new RelOptRule[]{new HiveAggregateJoinTransposeRule(CalcitePlanner.this.noColsMissingStats, CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.AGGR_JOIN_TRANSPOSE), CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.AGGR_JOIN_TRANSPOSE_UNIQUE))});
            }
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.SEMIJOIN_CONVERSION)) {
                this.generatePartialProgram(program, true, HepMatchOrder.DEPTH_FIRST, HiveSemiJoinRule.INSTANCE_PROJECT, HiveSemiJoinRule.INSTANCE_PROJECT_SWAPPED, HiveSemiJoinRule.INSTANCE_AGGREGATE, HiveSemiJoinRule.INSTANCE_AGGREGATE_SWAPPED);
            }
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveRemoveGBYSemiJoinRule.INSTANCE);
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.WINDOWING_POSTPROCESSING)) {
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveWindowingFixRule.INSTANCE);
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveWindowingLastValueRewrite.INSTANCE);
            }
            this.generatePartialProgram(program, true, HepMatchOrder.DEPTH_FIRST, HiveSearchRules.PROJECT_SEARCH_EXPAND, HiveSearchRules.FILTER_SEARCH_EXPAND, HiveSearchRules.JOIN_SEARCH_EXPAND);
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new RelOptRule[]{HiveDruidRules.FILTER_DATE_RANGE_RULE, HiveDruidRules.FILTER, HiveDruidRules.PROJECT_FILTER_TRANSPOSE, HiveDruidRules.AGGREGATE_FILTER_TRANSPOSE, HiveDruidRules.AGGREGATE_PROJECT, HiveDruidRules.PROJECT, HiveDruidRules.EXPAND_SINGLE_DISTINCT_AGGREGATES_DRUID_RULE, HiveDruidRules.AGGREGATE, HiveDruidRules.POST_AGGREGATION_PROJECT, HiveDruidRules.FILTER_AGGREGATE_TRANSPOSE, HiveDruidRules.FILTER_PROJECT_TRANSPOSE, HiveDruidRules.HAVING_FILTER_RULE, HiveDruidRules.SORT_PROJECT_TRANSPOSE, HiveDruidRules.SORT});
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ENABLE_JDBC_PUSHDOWN)) {
                ArrayList rules = Lists.newArrayList();
                rules.add(JDBCExpandExpressionsRule.FILTER_INSTANCE);
                rules.add(JDBCExpandExpressionsRule.JOIN_INSTANCE);
                rules.add(JDBCExpandExpressionsRule.PROJECT_INSTANCE);
                rules.add(JDBCExtractJoinFilterRule.INSTANCE);
                rules.add(JDBCAbstractSplitFilterRule.SPLIT_FILTER_ABOVE_JOIN);
                rules.add(JDBCAbstractSplitFilterRule.SPLIT_FILTER_ABOVE_CONVERTER);
                rules.add(JDBCFilterJoinRule.INSTANCE);
                rules.add(JDBCFilterPushDownRule.INSTANCE);
                rules.add(JDBCProjectPushDownRule.INSTANCE);
                rules.add(JDBCAggregateProjectMergeRule.INSTANCE);
                if (!CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ENABLE_JDBC_SAFE_PUSHDOWN)) {
                    rules.add(JDBCJoinPushDownRule.INSTANCE);
                    rules.add(JDBCUnionPushDownRule.INSTANCE);
                    rules.add(JDBCAggregationPushDownRule.INSTANCE);
                    rules.add(JDBCSortPushDownRule.INSTANCE);
                }
                this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, rules.toArray(new RelOptRule[rules.size()]));
            }
            if (HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                this.generatePartialProgram(program, true, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{HiveJoinProjectTransposeRule.BOTH_PROJECT_INCLUDE_OUTER, HiveJoinProjectTransposeRule.LEFT_PROJECT_INCLUDE_OUTER, HiveJoinProjectTransposeRule.RIGHT_PROJECT_INCLUDE_OUTER, HiveJoinToMultiJoinRule.INSTANCE, HiveProjectMergeRule.INSTANCE});
                this.generatePartialProgram(program, false, HepMatchOrder.TOP_DOWN, new HiveFieldTrimmerRule(false));
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new RelOptRule[]{ProjectRemoveRule.Config.DEFAULT.toRule(), new ProjectMergeRule(false, HiveRelFactories.HIVE_BUILDER)});
                this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, HiveFilterProjectTSTransposeRule.INSTANCE, HiveFilterProjectTSTransposeRule.INSTANCE_DRUID, HiveProjectFilterPullUpConstantsRule.INSTANCE);
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new HiveInsertExchange4JoinRule(Join.class, NullOrdering.defaultNullOrder((Configuration)CalcitePlanner.this.conf).getDirection()), new HiveInsertExchange4JoinRule(HiveMultiJoin.class, NullOrdering.defaultNullOrder((Configuration)CalcitePlanner.this.conf).getDirection()));
            } else {
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, new RelOptRule[]{HiveProjectSortExchangeTransposeRule.INSTANCE, HiveProjectMergeRule.INSTANCE});
            }
            if (CalcitePlanner.this.ctx.isLoadingMaterializedView()) {
                this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveInBetweenExpandRule.FILTER_INSTANCE, HiveInBetweenExpandRule.JOIN_INSTANCE, HiveInBetweenExpandRule.PROJECT_INSTANCE);
            }
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            return basePlan;
        }

        protected Set<TableName> getTablesUsed(RelNode plan) {
            final HashSet<TableName> tablesUsed = new HashSet<TableName>();
            new RelVisitor(){

                public void visit(RelNode node, int ordinal, RelNode parent) {
                    TableScan ts;
                    Table table;
                    if (node instanceof TableScan && (AcidUtils.isTransactionalTable(table = ((RelOptHiveTable)(ts = (TableScan)node).getTable()).getHiveTableMD()) || table.isNonNative() && table.getStorageHandler().areSnapshotsSupported())) {
                        tablesUsed.add(table.getFullTableName());
                    }
                    super.visit(node, ordinal, parent);
                }
            }.go(plan);
            return tablesUsed;
        }

        protected List<Table> getMaterializedViewsUsed(RelNode plan) {
            final ArrayList<Table> materializedViewsUsed = new ArrayList<Table>();
            new RelVisitor(){

                public void visit(RelNode node, int ordinal, RelNode parent) {
                    DruidQuery dq;
                    Table table;
                    if (node instanceof TableScan) {
                        TableScan ts = (TableScan)node;
                        Table table2 = ((RelOptHiveTable)ts.getTable()).getHiveTableMD();
                        if (table2.isMaterializedView()) {
                            materializedViewsUsed.add(table2);
                        }
                    } else if (node instanceof DruidQuery && (table = ((RelOptHiveTable)(dq = (DruidQuery)node).getTable()).getHiveTableMD()).isMaterializedView()) {
                        materializedViewsUsed.add(table);
                    }
                    super.visit(node, ordinal, parent);
                }
            }.go(plan);
            return materializedViewsUsed;
        }

        private RelNode removeSubqueries(RelNode basePlan, RelMetadataProvider mdProvider) {
            HepProgramBuilder builder = new HepProgramBuilder();
            builder.addMatchOrder(HepMatchOrder.DEPTH_FIRST);
            builder.addRuleCollection((Collection)ImmutableList.of((Object)HiveSubQueryRemoveRule.forFilter(CalcitePlanner.this.conf), (Object)HiveSubQueryRemoveRule.forProject(CalcitePlanner.this.conf)));
            return this.executeProgram(basePlan, builder.build(), mdProvider, null);
        }

        protected void generatePartialProgram(HepProgramBuilder programBuilder, boolean isCollection, HepMatchOrder order, RelOptRule ... rules) {
            programBuilder.addMatchOrder(order);
            if (isCollection) {
                programBuilder.addRuleCollection((Collection)ImmutableList.copyOf((Object[])rules));
            } else {
                for (RelOptRule r : rules) {
                    programBuilder.addRuleInstance(r);
                }
            }
        }

        protected RelNode executeProgram(RelNode basePlan, HepProgram program, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            return this.executeProgram(basePlan, program, mdProvider, executorProvider, null);
        }

        protected RelNode executeProgram(RelNode basePlan, HepProgram program, RelMetadataProvider mdProvider, RexExecutor executorProvider, List<? extends RelOptMaterialization> materializations) {
            return this.executeProgram(basePlan, program, mdProvider, executorProvider, materializations, false);
        }

        private RelNode executeProgram(RelNode basePlan, HepProgram program, RelMetadataProvider mdProvider, RexExecutor executorProvider, List<? extends RelOptMaterialization> materializations, boolean noDag) {
            String ruleExclusionRegex = CalcitePlanner.this.conf.get(HiveConf.ConfVars.HIVE_CBO_RULE_EXCLUSION_REGEX.varname, "");
            HepPlanner planner = new HepPlanner(program, basePlan.getCluster().getPlanner().getContext(), noDag, null, RelOptCostImpl.FACTORY);
            planner.addListener((RelOptListener)new RuleEventLogger());
            ArrayList list = Lists.newArrayList();
            list.add(mdProvider);
            planner.registerMetadataProviders((List)list);
            RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of((List)list);
            this.cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)planner));
            if (executorProvider != null) {
                this.cluster.getPlanner().setExecutor(executorProvider);
                planner.setExecutor(executorProvider);
            }
            if (materializations != null) {
                for (RelOptMaterialization relOptMaterialization : materializations) {
                    planner.addMaterialization(relOptMaterialization);
                }
            }
            if (!ruleExclusionRegex.isEmpty()) {
                CalcitePlanner.this.LOG.info("The CBO rules matching the following regex are excluded from planning: {}", (Object)ruleExclusionRegex);
                planner.setRuleDescExclusionFilter(Pattern.compile(ruleExclusionRegex));
            }
            planner.setRoot(basePlan);
            return planner.findBestExp();
        }

        private RelNode genSetOpLogicalPlan(QBExpr.Opcode opcode, String alias, String leftalias, RelNode leftRel, String rightalias, RelNode rightRel) throws SemanticException {
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            Map<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
            Map<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
            if (leftmap.size() != rightmap.size()) {
                throw new SemanticException("Schema of both sides of union should match.");
            }
            ASTNode tabref = CalcitePlanner.this.getQB().getAliases().isEmpty() ? null : CalcitePlanner.this.getQB().getParseInfo().getSrcForAlias(CalcitePlanner.this.getQB().getAliases().get(0));
            RowResolver setOpOutRR = new RowResolver();
            Iterator<Map.Entry<String, ColumnInfo>> lIter = leftmap.entrySet().iterator();
            Iterator<Map.Entry<String, ColumnInfo>> rIter = rightmap.entrySet().iterator();
            while (lIter.hasNext()) {
                Map.Entry<String, ColumnInfo> lEntry = lIter.next();
                Map.Entry<String, ColumnInfo> rEntry = rIter.next();
                ColumnInfo lInfo = lEntry.getValue();
                ColumnInfo rInfo = rEntry.getValue();
                String field = lEntry.getKey();
                TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
                if (commonTypeInfo == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of setop should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
                }
                ColumnInfo setOpColInfo = new ColumnInfo(lInfo);
                setOpColInfo.setType(commonTypeInfo);
                setOpOutRR.put(alias, field, setOpColInfo);
            }
            boolean leftNeedsTypeCast = false;
            boolean rightNeedsTypeCast = false;
            ArrayList<RexNode> leftProjs = new ArrayList<RexNode>();
            ArrayList<RexNode> rightProjs = new ArrayList<RexNode>();
            List leftRowDT = leftRel.getRowType().getFieldList();
            List rightRowDT = rightRel.getRowType().getFieldList();
            for (int i = 0; i < leftRowDT.size(); ++i) {
                RelDataType rightFieldDT;
                RelDataType leftFieldDT = ((RelDataTypeField)leftRowDT.get(i)).getType();
                if (!leftFieldDT.equals(rightFieldDT = ((RelDataTypeField)rightRowDT.get(i)).getType())) {
                    RelDataType unionFieldDT = TypeConverter.convert(setOpOutRR.getColumnInfos().get(i).getType(), this.cluster.getTypeFactory());
                    if (!unionFieldDT.equals(leftFieldDT)) {
                        leftNeedsTypeCast = true;
                    }
                    leftProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                    if (!unionFieldDT.equals(rightFieldDT)) {
                        rightNeedsTypeCast = true;
                    }
                    rightProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
                    continue;
                }
                leftProjs.add(this.cluster.getRexBuilder().ensureType(leftFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                rightProjs.add(this.cluster.getRexBuilder().ensureType(rightFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
            }
            RelNode setOpLeftInput = leftRel;
            RelNode setOpRightInput = rightRel;
            if (leftNeedsTypeCast) {
                setOpLeftInput = HiveProject.create(leftRel, leftProjs, leftRel.getRowType().getFieldNames());
            }
            if (rightNeedsTypeCast) {
                setOpRightInput = HiveProject.create(rightRel, rightProjs, rightRel.getRowType().getFieldNames());
            }
            ImmutableList.Builder bldr = new ImmutableList.Builder();
            bldr.add((Object)setOpLeftInput);
            bldr.add((Object)setOpRightInput);
            Object setOpRel = null;
            switch (opcode) {
                case UNION: {
                    setOpRel = new HiveUnion(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build());
                    break;
                }
                case INTERSECT: {
                    setOpRel = new HiveIntersect(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), false);
                    break;
                }
                case INTERSECTALL: {
                    setOpRel = new HiveIntersect(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), true);
                    break;
                }
                case EXCEPT: {
                    setOpRel = new HiveExcept(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), false);
                    break;
                }
                case EXCEPTALL: {
                    setOpRel = new HiveExcept(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), true);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SET_OPERATOR.getMsg(opcode.toString()));
                }
            }
            this.relToHiveRR.put((RelNode)setOpRel, setOpOutRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)setOpRel, this.buildHiveToCalciteColumnMap(setOpOutRR));
            return setOpRel;
        }

        private RelNode genJoinRelNode(RelNode leftRel, String leftTableAlias, RelNode rightRel, String rightTableAlias, JoinType hiveJoinType, ASTNode joinCond, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            JoinRelType calciteJoinType;
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            RexLiteral calciteJoinCond = null;
            ArrayList<String> namedColumns = null;
            if (joinCond != null) {
                JoinTypeCheckCtx jCtx = new JoinTypeCheckCtx(leftRR, rightRR, this.cluster.getRexBuilder(), hiveJoinType);
                jCtx.setOuterRR(outerRR);
                RowResolver input = jCtx.getInputRR();
                if (joinCond.getType() == 1247 && !hiveJoinType.equals((Object)JoinType.LEFTSEMI)) {
                    namedColumns = new ArrayList<String>();
                    ASTNode and = (ASTNode)ParseDriver.adaptor.create(36, "and");
                    ASTNode equal = null;
                    int count = 0;
                    for (Node child : joinCond.getChildren()) {
                        String columnName = ((ASTNode)child).getText();
                        if (CalcitePlanner.this.unparseTranslator != null && CalcitePlanner.this.unparseTranslator.isEnabled()) {
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)child);
                        }
                        namedColumns.add(columnName);
                        if (leftTableAlias == null) {
                            leftTableAlias = leftRR.getTableAliasContainingColumn(columnName);
                        }
                        if (leftTableAlias == null) {
                            throw new SemanticException("column '" + columnName + "' not present in any of these tables: " + leftRR.getTableNames());
                        }
                        ASTNode left = ASTBuilder.qualifiedName(leftTableAlias, columnName);
                        ASTNode right = ASTBuilder.qualifiedName(rightTableAlias, columnName);
                        equal = (ASTNode)ParseDriver.adaptor.create(18, "=");
                        ParseDriver.adaptor.addChild((Object)equal, (Object)left);
                        ParseDriver.adaptor.addChild((Object)equal, (Object)right);
                        ParseDriver.adaptor.addChild((Object)and, (Object)equal);
                        ++count;
                    }
                    joinCond = count > 1 ? and : equal;
                } else if (CalcitePlanner.this.unparseTranslator != null && CalcitePlanner.this.unparseTranslator.isEnabled()) {
                    jCtx.setUnparseTranslator(CalcitePlanner.this.unparseTranslator);
                    CalcitePlanner.genAllRexNode(joinCond, input, jCtx, CalcitePlanner.this.conf);
                }
                Map<ASTNode, RexNode> exprNodes = RexNodeTypeCheck.genExprNodeJoinCond(joinCond, jCtx, this.cluster.getRexBuilder());
                if (jCtx.getError() != null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(jCtx.getErrorSrcNode(), jCtx.getError()));
                }
                calciteJoinCond = exprNodes.get(joinCond);
            } else {
                calciteJoinCond = this.cluster.getRexBuilder().makeLiteral(true);
            }
            boolean leftSemiJoin = false;
            switch (hiveJoinType) {
                case LEFTOUTER: {
                    calciteJoinType = JoinRelType.LEFT;
                    break;
                }
                case RIGHTOUTER: {
                    calciteJoinType = JoinRelType.RIGHT;
                    break;
                }
                case FULLOUTER: {
                    calciteJoinType = JoinRelType.FULL;
                    break;
                }
                case LEFTSEMI: {
                    calciteJoinType = JoinRelType.SEMI;
                    leftSemiJoin = true;
                    break;
                }
                case ANTI: {
                    calciteJoinType = JoinRelType.ANTI;
                    leftSemiJoin = true;
                    break;
                }
                default: {
                    calciteJoinType = JoinRelType.INNER;
                }
            }
            Join topRel = null;
            RowResolver topRR = null;
            if (leftSemiJoin) {
                ArrayList<RelDataTypeField> sysFieldList = new ArrayList<RelDataTypeField>();
                ArrayList<RexNode> leftJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
                RexNode nonEquiConds = HiveRelOptUtil.splitHiveJoinCondition(sysFieldList, (List<RelNode>)ImmutableList.of((Object)leftRel, (Object)rightRel), (RexNode)calciteJoinCond, (List<List<RexNode>>)ImmutableList.of(leftJoinKeys, rightJoinKeys), null, null);
                RelNode[] inputRels = new RelNode[]{leftRel, rightRel};
                ArrayList<Integer> leftKeys = new ArrayList<Integer>();
                ArrayList<Integer> rightKeys = new ArrayList<Integer>();
                RexNode remainingEquiCond = HiveCalciteUtil.projectNonColumnEquiConditions(HiveRelFactories.HIVE_PROJECT_FACTORY, inputRels, leftJoinKeys, rightJoinKeys, 0, leftKeys, rightKeys);
                if (inputRels[0] != leftRel) {
                    nonEquiConds = RexUtil.shift((RexNode)nonEquiConds, (int)leftRel.getRowType().getFieldCount(), (int)(inputRels[0].getRowType().getFieldCount() - leftRel.getRowType().getFieldCount()));
                }
                calciteJoinCond = remainingEquiCond != null ? RexUtil.composeConjunction((RexBuilder)this.cluster.getRexBuilder(), (Iterable)ImmutableList.of((Object)remainingEquiCond, (Object)nonEquiConds), (boolean)false) : nonEquiConds;
                RelDataType combinedRowType = SqlValidatorUtil.createJoinType((RelDataTypeFactory)this.cluster.getTypeFactory(), (RelDataType)inputRels[0].getRowType(), (RelDataType)inputRels[1].getRowType(), null, (List)ImmutableList.of());
                topRel = hiveJoinType == JoinType.LEFTSEMI ? HiveSemiJoin.getSemiJoin(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), inputRels[0], inputRels[1], HiveCalciteUtil.fixNullability(this.cluster.getRexBuilder(), (RexNode)calciteJoinCond, (List<RelDataType>)RelOptUtil.getFieldTypeList((RelDataType)combinedRowType))) : HiveAntiJoin.getAntiJoin(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), inputRels[0], inputRels[1], HiveCalciteUtil.fixNullability(this.cluster.getRexBuilder(), (RexNode)calciteJoinCond, (List<RelDataType>)RelOptUtil.getFieldTypeList((RelDataType)combinedRowType)));
                if (inputRels[0] != leftRel) {
                    RowResolver newLeftRR = new RowResolver();
                    if (!RowResolver.add(newLeftRR, leftRR)) {
                        CalcitePlanner.this.LOG.warn(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED);
                    }
                    for (int i = leftRel.getRowType().getFieldCount(); i < inputRels[0].getRowType().getFieldCount(); ++i) {
                        ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(i), TypeConverter.convert(((RelDataTypeField)inputRels[0].getRowType().getFieldList().get(i)).getType()), null, false);
                        newLeftRR.put(oColInfo.getTabAlias(), oColInfo.getInternalName(), oColInfo);
                    }
                    RowResolver joinRR = new RowResolver();
                    if (!RowResolver.add(joinRR, newLeftRR)) {
                        CalcitePlanner.this.LOG.warn(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED);
                    }
                    this.relToHiveColNameCalcitePosMap.put((RelNode)topRel, this.buildHiveToCalciteColumnMap(joinRR));
                    this.relToHiveRR.put((RelNode)topRel, joinRR);
                    ArrayList<RexInputRef> topFields = new ArrayList<RexInputRef>();
                    ArrayList<String> topFieldNames = new ArrayList<String>();
                    for (int i = 0; i < leftRel.getRowType().getFieldCount(); ++i) {
                        RelDataTypeField field = (RelDataTypeField)leftRel.getRowType().getFieldList().get(i);
                        topFields.add(leftRel.getCluster().getRexBuilder().makeInputRef(field.getType(), i));
                        topFieldNames.add(field.getName());
                    }
                    topRel = HiveRelFactories.HIVE_PROJECT_FACTORY.createProject((RelNode)topRel, Collections.emptyList(), topFields, topFieldNames);
                }
                if (!RowResolver.add(topRR = new RowResolver(), leftRR)) {
                    CalcitePlanner.this.LOG.warn(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED);
                }
            } else {
                RelDataType combinedRowType = SqlValidatorUtil.createJoinType((RelDataTypeFactory)this.cluster.getTypeFactory(), (RelDataType)leftRel.getRowType(), (RelDataType)rightRel.getRowType(), null, (List)ImmutableList.of());
                topRR = RowResolver.getCombinedRR(leftRR, rightRR);
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(topRR);
                calciteJoinCond = new CorrelationConverter(new InputContext(combinedRowType, hiveColNameCalcitePosMap, topRR), outerNameToPosMap, outerRR, this.subqueryId).apply((RexNode)calciteJoinCond);
                topRel = HiveJoin.getJoin(this.cluster, leftRel, rightRel, HiveCalciteUtil.fixNullability(this.cluster.getRexBuilder(), (RexNode)calciteJoinCond, (List<RelDataType>)RelOptUtil.getFieldTypeList((RelDataType)combinedRowType)), calciteJoinType);
                if (namedColumns != null) {
                    ArrayList<String> tableAliases = new ArrayList<String>();
                    tableAliases.add(leftTableAlias);
                    tableAliases.add(rightTableAlias);
                    topRR.setNamedJoinInfo(new NamedJoinInfo(tableAliases, namedColumns, hiveJoinType));
                }
            }
            this.relToHiveColNameCalcitePosMap.put((RelNode)topRel, this.buildHiveToCalciteColumnMap(topRR));
            this.relToHiveRR.put((RelNode)topRel, topRR);
            return topRel;
        }

        private RelNode genJoinLogicalPlan(QB qb, ASTNode joinParseTree, Map<String, RelNode> aliasToRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            RelNode leftRel = null;
            RelNode rightRel = null;
            JoinType hiveJoinType = null;
            if (joinParseTree.getToken().getType() == 1299) {
                String msg = String.format("UNIQUE JOIN is currently not supported in CBO, turn off cbo to use UNIQUE JOIN.", new Object[0]);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Unique_join);
            }
            switch (joinParseTree.getToken().getType()) {
                case 1078: {
                    hiveJoinType = JoinType.LEFTOUTER;
                    break;
                }
                case 1183: {
                    hiveJoinType = JoinType.RIGHTOUTER;
                    break;
                }
                case 1034: {
                    hiveJoinType = JoinType.FULLOUTER;
                    break;
                }
                case 1079: {
                    hiveJoinType = JoinType.LEFTSEMI;
                    break;
                }
                case 1077: {
                    hiveJoinType = JoinType.ANTI;
                    break;
                }
                default: {
                    hiveJoinType = JoinType.INNER;
                }
            }
            ASTNode left = (ASTNode)joinParseTree.getChild(0);
            String leftTableAlias = null;
            if (left.getToken().getType() == 1274 || left.getToken().getType() == 1236 || left.getToken().getType() == 1153) {
                leftTableAlias = BaseSemanticAnalyzer.getTableAlias(left);
                leftRel = aliasToRel.get(leftTableAlias);
            } else if (SemanticAnalyzer.isJoinToken(left)) {
                leftRel = this.genJoinLogicalPlan(qb, left, aliasToRel, outerNameToPosMap, outerRR);
            } else if (left.getToken().getType() == 1075) {
                leftRel = this.genLateralViewPlans(qb, left, aliasToRel);
            } else assert (false);
            ASTNode right = (ASTNode)joinParseTree.getChild(1);
            String rightTableAlias = null;
            if (right.getToken().getType() == 1274 || right.getToken().getType() == 1236 || right.getToken().getType() == 1153) {
                rightTableAlias = BaseSemanticAnalyzer.getTableAlias(right);
                rightRel = aliasToRel.get(rightTableAlias);
            } else if (right.getToken().getType() == 1075) {
                rightRel = this.genLateralViewPlans(qb, right, aliasToRel);
            } else assert (false);
            ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
            return this.genJoinRelNode(leftRel, leftTableAlias, rightRel, rightTableAlias, hiveJoinType, joinCond, outerNameToPosMap, outerRR);
        }

        private RelNode genTableLogicalPlan(String tableAlias, QB qb) throws SemanticException {
            RowResolver rr = new RowResolver();
            HiveRelNode tableRel = null;
            try {
                RelOptHiveTable optTable;
                ColumnInfo colInfo;
                String colName;
                if (qb.getParseInfo().getTabSample(tableAlias) != null || CalcitePlanner.this.getNameToSplitSampleMap().containsKey(tableAlias) || CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP) && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE)) {
                    String msg = String.format("Table Sample specified for %s. Currently we don't support Table Sample clauses in CBO, turn off cbo for queries on tableSamples.", tableAlias);
                    CalcitePlanner.this.LOG.debug(msg);
                    throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Table_sample_clauses);
                }
                Table tabMetaData = qb.getMetaData().getSrcForAlias(tableAlias);
                Deserializer deserializer = tabMetaData.getDeserializer();
                StructObjectInspector rowObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                deserializer.handleJobLevelConfiguration(CalcitePlanner.this.conf);
                List fields = rowObjectInspector.getAllStructFieldRefs();
                ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
                NotNullConstraint nnc = tabMetaData.getNotNullConstraint();
                PrimaryKeyInfo pkc = tabMetaData.getPrimaryKeyInfo();
                for (StructField structField : fields) {
                    colName = structField.getFieldName();
                    colInfo = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)structField.getFieldObjectInspector()), this.isNullable(colName, nnc, pkc), tableAlias, false);
                    colInfo.setSkewedCol(CalcitePlanner.this.isSkewedCol(tableAlias, qb, colName));
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                }
                ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
                ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
                for (FieldSchema part_col : tabMetaData.getPartCols()) {
                    colName = part_col.getName();
                    colInfo = new ColumnInfo(colName, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)part_col.getType()), this.isNullable(colName, nnc, pkc), tableAlias, true);
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                    partitionColumns.add(colInfo);
                }
                TableType tableType = this.obtainTableType(tabMetaData);
                List<VirtualColumn> virtualCols = tabMetaData.getVirtualColumns();
                virtualCols.forEach(vc -> rr.put(tableAlias, vc.getName().toLowerCase(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden())));
                Map<String, String> tabPropsFromQuery = qb.getTabPropsForAlias(tableAlias);
                HiveTableScan.HiveTableScanTrait tableScanTrait = HiveTableScan.HiveTableScanTrait.from(tabPropsFromQuery);
                if (tableType == TableType.DRUID || tableType == TableType.JDBC && tabMetaData.getProperty("hive.sql.table") != null) {
                    List originalColumnNames = ((StandardStructObjectInspector)rowObjectInspector).getOriginalColumnNames();
                    ArrayList<ColumnInfo> cIList = new ArrayList<ColumnInfo>(originalColumnNames.size());
                    for (int i = 0; i < rr.getColumnInfos().size(); ++i) {
                        cIList.add(new ColumnInfo((String)originalColumnNames.get(i), rr.getColumnInfos().get(i).getType(), tableAlias, false));
                    }
                    RelDataType rowType = TypeConverter.getType(this.cluster, cIList);
                    ArrayList<String> fullyQualifiedTabName = new ArrayList<String>();
                    if (tabMetaData.getDbName() != null && !tabMetaData.getDbName().isEmpty()) {
                        fullyQualifiedTabName.add(tabMetaData.getDbName());
                    }
                    fullyQualifiedTabName.add(tabMetaData.getTableName());
                    if (tableType == TableType.DRUID) {
                        String address = HiveConf.getVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                        String dataSource = tabMetaData.getParameters().get("druid.datasource");
                        HashSet<String> metrics = new HashSet<String>();
                        RexBuilder rexBuilder = this.cluster.getRexBuilder();
                        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
                        ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
                        ArrayList<String> druidColNames = new ArrayList<String>();
                        for (RelDataTypeField field : rowType.getFieldList()) {
                            if ("__time".equals(field.getName())) {
                                druidColTypes.add(dtFactory.createTypeWithNullability(field.getType(), false));
                            } else {
                                druidColTypes.add(field.getType());
                            }
                            druidColNames.add(field.getName());
                            if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                            metrics.add(field.getName());
                        }
                        List<Interval> intervals = Arrays.asList(DruidTable.DEFAULT_INTERVAL);
                        rowType = dtFactory.createStructType(druidColTypes, druidColNames);
                        DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto((RelDataType)rowType), metrics, "__time", intervals, null, null);
                        optTable = new RelOptHiveTable(this.relOptSchema, this.relOptSchema.getTypeFactory(), fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, CalcitePlanner.this.tabNameToTabObject, this.partitionCache, this.colStatsCache, CalcitePlanner.this.noColsMissingStats);
                        HiveTableScan scan = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()), tableScanTrait);
                        tableRel = DruidQuery.create((RelOptCluster)this.cluster, (RelTraitSet)this.cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)optTable, (DruidTable)druidTable, (List)ImmutableList.of((Object)scan), DruidSqlOperatorConverter.getDefaultMap());
                    } else {
                        String pswd;
                        optTable = new RelOptHiveTable(this.relOptSchema, this.relOptSchema.getTypeFactory(), fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, CalcitePlanner.this.tabNameToTabObject, this.partitionCache, this.colStatsCache, CalcitePlanner.this.noColsMissingStats);
                        HiveTableScan hts = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()), tableScanTrait);
                        String dataBaseType = tabMetaData.getProperty("hive.sql.database.type");
                        String url = tabMetaData.getProperty("hive.sql.jdbc.url");
                        String driver = tabMetaData.getProperty("hive.sql.jdbc.driver");
                        String user = tabMetaData.getProperty("hive.sql.dbcp.username");
                        if (tabMetaData.getProperty("hive.sql.dbcp.password") != null) {
                            pswd = tabMetaData.getProperty("hive.sql.dbcp.password");
                        } else if (tabMetaData.getProperty("hive.sql.dbcp.password.keystore") != null) {
                            String keystore = tabMetaData.getProperty("hive.sql.dbcp.password.keystore");
                            String key = tabMetaData.getProperty("hive.sql.dbcp.password.key");
                            pswd = Utilities.getPasswdFromKeystore(keystore, key);
                        } else if (tabMetaData.getProperty("hive.sql.dbcp.password.uri") != null) {
                            pswd = Utilities.getPasswdFromUri(tabMetaData.getProperty("hive.sql.dbcp.password.uri"));
                        } else {
                            pswd = null;
                            CalcitePlanner.this.LOG.warn("No password found for accessing {} table via JDBC", fullyQualifiedTabName);
                        }
                        String catalogName = tabMetaData.getProperty("hive.sql.catalog");
                        String schemaName = tabMetaData.getProperty("hive.sql.schema");
                        String tableName = tabMetaData.getProperty("hive.sql.table");
                        DataSource ds = JdbcSchema.dataSource((String)url, (String)driver, (String)user, (String)pswd);
                        SqlDialect jdbcDialect = JdbcSchema.createDialect((SqlDialectFactory)SqlDialectFactoryImpl.INSTANCE, (DataSource)ds);
                        String dialectName = jdbcDialect.getClass().getName();
                        if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                            CalcitePlanner.this.LOG.debug("Dialect for table {}: {}", (Object)tableName, (Object)dialectName);
                        }
                        List jdbcConventionKey = ImmutableNullableList.of((Object)url, (Object)driver, (Object)user, (Object)pswd, (Object)dialectName, (Object)dataBaseType);
                        this.jdbcConventionMap.putIfAbsent(jdbcConventionKey, JdbcConvention.of((SqlDialect)jdbcDialect, null, (String)dataBaseType));
                        JdbcConvention jc = this.jdbcConventionMap.get(jdbcConventionKey);
                        List schemaKey = ImmutableNullableList.of((Object)url, (Object)driver, (Object)user, (Object)pswd, (Object)dialectName, (Object)dataBaseType, (Object)catalogName, (Object)schemaName, (Object[])new String[0]);
                        this.schemaMap.putIfAbsent(schemaKey, new JdbcSchema(ds, jc.dialect, jc, catalogName, schemaName));
                        JdbcSchema schema = this.schemaMap.get(schemaKey);
                        JdbcTable jt = (JdbcTable)schema.getTable(tableName);
                        if (jt == null) {
                            throw new SemanticException("Table " + tableName + " was not found in the database");
                        }
                        JdbcHiveTableScan jdbcTableRel = new JdbcHiveTableScan(this.cluster, optTable, jt, jc, hts);
                        tableRel = new HiveJdbcConverter(this.cluster, jdbcTableRel.getTraitSet().replace((RelTrait)HiveRelNode.CONVENTION), (RelNode)jdbcTableRel, jc, url, user);
                    }
                } else {
                    RelDataType rowType = TypeConverter.getType(this.cluster, rr, null);
                    ArrayList<String> fullyQualifiedTabName = new ArrayList<String>();
                    if (tabMetaData.getDbName() != null && !tabMetaData.getDbName().isEmpty()) {
                        fullyQualifiedTabName.add(tabMetaData.getDbName());
                    }
                    fullyQualifiedTabName.add(tabMetaData.getTableName());
                    optTable = new RelOptHiveTable(this.relOptSchema, this.relOptSchema.getTypeFactory(), fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, CalcitePlanner.this.tabNameToTabObject, this.partitionCache, this.colStatsCache, CalcitePlanner.this.noColsMissingStats);
                    tableRel = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()), tableScanTrait);
                }
                if (optTable.hasReferentialConstraints()) {
                    CalcitePlanner.this.profilesCBO.add(ExtendedCBOProfile.REFERENTIAL_CONSTRAINTS);
                }
                ImmutableMap<String, Integer> hiveToCalciteColMap = this.buildHiveToCalciteColumnMap(rr);
                this.relToHiveRR.put(tableRel, rr);
                this.relToHiveColNameCalcitePosMap.put(tableRel, hiveToCalciteColMap);
            }
            catch (Exception e) {
                if (e instanceof SemanticException) {
                    throw (SemanticException)((Object)e);
                }
                throw new RuntimeException(e);
            }
            return tableRel;
        }

        private boolean isNullable(String colName, NotNullConstraint notNullConstraints, PrimaryKeyInfo primaryKeyInfo) {
            if (notNullConstraints != null && notNullConstraints.getNotNullConstraints().containsValue(colName)) {
                return false;
            }
            return primaryKeyInfo == null || !primaryKeyInfo.getColNames().containsValue(colName);
        }

        private TableType obtainTableType(Table tabMetaData) {
            if (tabMetaData.getStorageHandler() != null) {
                String storageHandlerStr = tabMetaData.getStorageHandler().toString();
                if (storageHandlerStr.equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
                    return TableType.DRUID;
                }
                if (storageHandlerStr.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler")) {
                    return TableType.JDBC;
                }
            }
            return TableType.NATIVE;
        }

        private RelNode genFilterRelNode(ASTNode filterNode, RelNode srcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean useCaching) throws SemanticException {
            RexNode filterExpression = CalcitePlanner.this.genRexNode(filterNode, this.relToHiveRR.get(srcRel), outerRR, null, useCaching, this.cluster.getRexBuilder());
            return this.genFilterRelNode(filterExpression, srcRel, outerNameToPosMap, outerRR);
        }

        private RelNode genFilterRelNode(RexNode filterExpression, RelNode srcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) {
            if (filterExpression.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                RelDataType booleanType = srcRel.getCluster().getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
                filterExpression = srcRel.getCluster().getRexBuilder().makeCast(booleanType, filterExpression);
            }
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            filterExpression = new CorrelationConverter(new InputContext(srcRel.getRowType(), hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel)), outerNameToPosMap, outerRR, this.subqueryId).apply(filterExpression);
            RexNode factoredFilterExpression = RexUtil.pullFactors((RexBuilder)this.cluster.getRexBuilder(), (RexNode)filterExpression);
            HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, HiveCalciteUtil.fixNullability(this.cluster.getRexBuilder(), factoredFilterExpression, (List<RelDataType>)RelOptUtil.getFieldTypeList((RelDataType)srcRel.getRowType())));
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
            return filterRel;
        }

        private RelNode genLateralViewPlans(QB qb, ASTNode lateralView, Map<String, RelNode> aliasToRel) throws SemanticException {
            LateralViewPlan.validateLateralView(lateralView);
            ASTNode next = (ASTNode)lateralView.getChild(1);
            RelNode inputRel = next.getToken().getType() == 1075 ? this.genLateralViewPlans(qb, next, aliasToRel) : aliasToRel.get(BaseSemanticAnalyzer.getTableAlias(next));
            LateralViewPlan lateralViewPlan = new LateralViewPlan(lateralView, this.cluster, inputRel, this.relToHiveRR.get(inputRel), CalcitePlanner.this.unparseTranslator, CalcitePlanner.this.conf, this.functionHelper);
            qb.addAlias(lateralViewPlan.lateralTableAlias);
            this.relToHiveColNameCalcitePosMap.put(lateralViewPlan.lateralViewRel, this.buildHiveToCalciteColumnMap(lateralViewPlan.outputRR));
            this.relToHiveRR.put(lateralViewPlan.lateralViewRel, lateralViewPlan.outputRR);
            return lateralViewPlan.lateralViewRel;
        }

        private boolean genSubQueryRelNode(QB qb, ASTNode node, RelNode srcRel, boolean forHavingClause, Map<ASTNode, QBSubQueryParseInfo> subQueryToRelNode) throws CalciteSubquerySemanticException {
            boolean isSubQuery = false;
            boolean enableJoinReordering = false;
            try {
                ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
                stack.push(node);
                block5: while (!stack.isEmpty()) {
                    ASTNode next = (ASTNode)stack.pop();
                    switch (next.getType()) {
                        case 1237: {
                            QBSubQueryParseInfo parseInfo = QBSubQueryParseInfo.parse(next);
                            if (parseInfo.hasFullAggregate() && (parseInfo.getOperator().getType() == QBSubQuery.SubQueryType.EXISTS || parseInfo.getOperator().getType() == QBSubQuery.SubQueryType.NOT_EXISTS)) {
                                subQueryToRelNode.put(next, parseInfo);
                                isSubQuery = true;
                                continue block5;
                            }
                            SubQueryUtils.subqueryRestrictionCheck(qb, next, srcRel, forHavingClause, CalcitePlanner.this.ctx, this.relToHiveRR);
                            String sbQueryAlias = "sq_" + qb.incrNumSubQueryPredicates();
                            QB qbSQ = new QB(qb.getId(), sbQueryAlias, true);
                            qbSQ.setInsideView(qb.isInsideView());
                            SemanticAnalyzer.Phase1Ctx ctx1 = CalcitePlanner.this.initPhase1Ctx();
                            ASTNode subQueryRoot = (ASTNode)next.getChild(1);
                            CalcitePlanner.this.doPhase1(subQueryRoot, qbSQ, ctx1, null);
                            CalcitePlanner.this.getMetaData(qbSQ);
                            ++this.subqueryId;
                            RelNode subQueryRelNode = this.genLogicalPlan(qbSQ, false, this.relToHiveColNameCalcitePosMap.get(srcRel), this.relToHiveRR.get(srcRel));
                            if (subQueryRelNode instanceof HiveProject) {
                                this.subQueryMap.put(subQueryRelNode, subQueryRoot);
                            }
                            subQueryToRelNode.put(next, parseInfo.setSubQueryRelNode(subQueryRelNode));
                            isSubQuery = true;
                            enableJoinReordering = true;
                            continue block5;
                        }
                    }
                    int childCount = next.getChildCount();
                    for (int i = childCount - 1; i >= 0; --i) {
                        stack.push((ASTNode)next.getChild(i));
                    }
                }
            }
            catch (SemanticException e) {
                throw new CalciteSubquerySemanticException(e.getMessage());
            }
            if (enableJoinReordering) {
                CalcitePlanner.this.profilesCBO.add(ExtendedCBOProfile.JOIN_REORDERING);
            }
            return isSubQuery;
        }

        private RelNode genFilterRelNode(QB qb, ASTNode searchCond, RelNode srcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean forHavingClause) throws SemanticException {
            HashMap<ASTNode, QBSubQueryParseInfo> subQueryToRelNode = new HashMap<ASTNode, QBSubQueryParseInfo>();
            boolean isSubQuery = this.genSubQueryRelNode(qb, searchCond, srcRel, forHavingClause, subQueryToRelNode);
            if (isSubQuery) {
                RexNode filterExpression = CalcitePlanner.this.genRexNode(searchCond, this.relToHiveRR.get(srcRel), outerRR, subQueryToRelNode, forHavingClause, this.cluster.getRexBuilder());
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                filterExpression = new CorrelationConverter(new InputContext(srcRel.getRowType(), hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel)), outerNameToPosMap, outerRR, this.subqueryId).apply(filterExpression);
                HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, filterExpression);
                this.relToHiveColNameCalcitePosMap.put(filterRel, this.relToHiveColNameCalcitePosMap.get(srcRel));
                this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
                return filterRel;
            }
            return this.genFilterRelNode(searchCond, srcRel, outerNameToPosMap, outerRR, forHavingClause);
        }

        private RelNode genFilterLogicalPlan(QB qb, RelNode srcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean forHavingClause) throws SemanticException {
            RelNode filterRel = null;
            Iterator<ASTNode> whereClauseIterator = this.getQBParseInfo(qb).getDestToWhereExpr().values().iterator();
            if (whereClauseIterator.hasNext()) {
                filterRel = this.genFilterRelNode(qb, (ASTNode)whereClauseIterator.next().getChild(0), srcRel, outerNameToPosMap, outerRR, forHavingClause);
            }
            return filterRel;
        }

        private org.apache.calcite.util.Pair<RelNode, RowResolver> genConstraintFilterLogicalPlan(QB qb, org.apache.calcite.util.Pair<RelNode, RowResolver> selPair, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            if (qb.getIsQuery()) {
                return null;
            }
            String dest = qb.getParseInfo().getClauseNames().iterator().next();
            if (!CalcitePlanner.this.updating(dest)) {
                return null;
            }
            RowResolver inputRR = this.relToHiveRR.get(selPair.left);
            RexNode constraintUDF = RexNodeTypeCheck.genConstraintsExpr(CalcitePlanner.this.conf, this.cluster.getRexBuilder(), CalcitePlanner.this.getTargetTable(qb, dest), CalcitePlanner.this.updating(dest), inputRR);
            if (constraintUDF == null) {
                return null;
            }
            RelNode constraintRel = this.genFilterRelNode(constraintUDF, (RelNode)selPair.left, outerNameToPosMap, outerRR);
            List<RexNode> originalInputRefs = this.toRexNodeList((RelNode)selPair.left);
            List<RexNode> selectedRefs = originalInputRefs.subList(0, ((RowResolver)selPair.right).getColumnInfos().size());
            return new org.apache.calcite.util.Pair((Object)this.genSelectRelNode(selectedRefs, (RowResolver)selPair.right, constraintRel), (Object)((RowResolver)selPair.right));
        }

        private AggregateCall convertGBAgg(FunctionHelper.AggregateInfo agg, List<RexNode> gbChildProjLst, HashMap<String, Integer> rexNodeToPosMap, Integer childProjLstIndx) {
            RelDataType aggFnRetType = TypeConverter.convert(agg.getReturnType(), this.cluster.getTypeFactory());
            ArrayList<Integer> argList = new ArrayList<Integer>();
            ImmutableList.Builder aggArgRelDTBldr = ImmutableList.builder();
            for (RexNode rexNd : agg.getParameters()) {
                Integer inputIndx = rexNodeToPosMap.get(rexNd.toString());
                if (inputIndx == null) {
                    gbChildProjLst.add(rexNd);
                    rexNodeToPosMap.put(rexNd.toString(), childProjLstIndx);
                    inputIndx = childProjLstIndx;
                    Integer n = childProjLstIndx;
                    childProjLstIndx = childProjLstIndx + 1;
                }
                argList.add(inputIndx);
                aggArgRelDTBldr.add((Object)rexNd.getType());
            }
            SqlAggFunction aggregation = SqlFunctionConverter.getCalciteAggFn(agg.getAggregateName(), agg.isDistinct(), (ImmutableList<RelDataType>)aggArgRelDTBldr.build(), aggFnRetType);
            ArrayList<RelFieldCollation> collationList = new ArrayList<RelFieldCollation>(agg.getCollation().size());
            for (FunctionHelper.FieldCollation fieldCollation : agg.getCollation()) {
                Integer inputIndx = rexNodeToPosMap.get(fieldCollation.getSortExpression().toString());
                if (inputIndx == null) {
                    gbChildProjLst.add(fieldCollation.getSortExpression());
                    rexNodeToPosMap.put(fieldCollation.getSortExpression().toString(), childProjLstIndx);
                    inputIndx = childProjLstIndx;
                    Integer n = childProjLstIndx;
                    childProjLstIndx = childProjLstIndx + 1;
                }
                collationList.add(new RelFieldCollation(inputIndx.intValue(), DirectionUtils.codeToDirection(fieldCollation.getSortDirection()), fieldCollation.getNullOrdering().getDirection()));
            }
            return AggregateCall.create((SqlAggFunction)aggregation, (boolean)agg.isDistinct(), (boolean)false, (boolean)false, argList, (int)-1, (RelCollation)RelCollations.of(collationList), (RelDataType)aggFnRetType, null);
        }

        private RelNode genGBRelNode(List<RexNode> gbExprs, List<FunctionHelper.AggregateInfo> aggInfoLst, List<Long> groupSets, RelNode srcRel) throws SemanticException {
            boolean hasGroupSets = groupSets != null && !groupSets.isEmpty();
            ArrayList gbChildProjLst = Lists.newArrayList();
            HashMap<String, Integer> rexNodeToPosMap = new HashMap<String, Integer>();
            ArrayList groupSetPositions = Lists.newArrayList();
            Integer gbIndx = 0;
            for (RexNode gbExpr : gbExprs) {
                gbChildProjLst.add(gbExpr);
                groupSetPositions.add(gbIndx);
                rexNodeToPosMap.put(gbExpr.toString(), gbIndx);
                Integer n = gbIndx;
                gbIndx = gbIndx + 1;
            }
            ImmutableBitSet groupSet = ImmutableBitSet.of((Iterable)groupSetPositions);
            ArrayList<ImmutableBitSet> transformedGroupSets = null;
            if (hasGroupSets) {
                HashSet<ImmutableBitSet> setTransformedGroupSets = new HashSet<ImmutableBitSet>(groupSets.size());
                Iterator<Object> iterator = groupSets.iterator();
                while (iterator.hasNext()) {
                    long val = (Long)iterator.next();
                    setTransformedGroupSets.add(this.convert(val, groupSet.cardinality()));
                }
                transformedGroupSets = new ArrayList<ImmutableBitSet>(setTransformedGroupSets);
                Collections.sort(transformedGroupSets, ImmutableBitSet.COMPARATOR);
            }
            ArrayList aggregateCalls = Lists.newArrayList();
            for (FunctionHelper.AggregateInfo agg : aggInfoLst) {
                aggregateCalls.add(this.convertGBAgg(agg, gbChildProjLst, rexNodeToPosMap, gbChildProjLst.size()));
            }
            if (hasGroupSets) {
                AggregateCall aggCall = AggregateCall.create((SqlAggFunction)HiveGroupingID.INSTANCE, (boolean)false, (List)new ImmutableList.Builder().build(), (int)-1, (RelDataType)this.cluster.getTypeFactory().createSqlType(SqlTypeName.BIGINT), (String)HiveGroupingID.INSTANCE.getName());
                aggregateCalls.add(aggCall);
            }
            if (gbChildProjLst.isEmpty()) {
                gbChildProjLst.add(this.cluster.getRexBuilder().makeInputRef(srcRel, 0));
            }
            HiveProject gbInputRel = HiveProject.create(srcRel, HiveCalciteUtil.fixNullability(this.cluster.getRexBuilder(), gbChildProjLst, (List<RelDataType>)RelOptUtil.getFieldTypeList((RelDataType)srcRel.getRowType())), null);
            HiveAggregate aggregateRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), gbInputRel, groupSet, transformedGroupSets, aggregateCalls);
            return aggregateRel;
        }

        private ImmutableBitSet convert(long value, int length) {
            BitSet bits = new BitSet();
            for (int index = length - 1; index >= 0; --index) {
                if (value % 2L != 0L) {
                    bits.set(index);
                }
                value >>>= 1;
            }
            bits.flip(0, length);
            return (ImmutableBitSet)ImmutableBitSet.FROM_BIT_SET.apply((Object)bits);
        }

        private void addAlternateGByKeyMappings(ASTNode gByExpr, ColumnInfo colInfo, RowResolver gByInputRR, RowResolver gByRR) {
            if (gByExpr.getType() == 16 && gByExpr.getChild(0).getType() == 1270) {
                String tab_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText().toLowerCase());
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText().toLowerCase());
                gByRR.put(tab_alias, col_alias, colInfo);
            } else if (gByExpr.getType() == 1270) {
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText().toLowerCase());
                String tab_alias = null;
                try {
                    ColumnInfo pColInfo = gByInputRR.get(tab_alias, col_alias);
                    tab_alias = pColInfo == null ? null : pColInfo.getTabAlias();
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
                gByRR.put(tab_alias, col_alias, colInfo);
            }
        }

        private void addToGBExpr(RowResolver groupByOutputRowResolver, RowResolver groupByInputRowResolver, ASTNode grpbyExpr, RexNode grpbyExprNDesc, List<RexNode> gbExprNDescLst, List<String> outputColumnNames) {
            int i = gbExprNDescLst.size();
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            gbExprNDescLst.add(grpbyExprNDesc);
            ColumnInfo oColInfo = new ColumnInfo(field, TypeConverter.convert(grpbyExprNDesc.getType()), null, false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, groupByInputRowResolver, groupByOutputRowResolver);
        }

        private FunctionHelper.AggregateInfo getHiveAggInfo(ASTNode aggAst, int aggFnLstArgIndx, RowResolver inputRR) throws SemanticException {
            String aggName;
            boolean isAllColumns;
            ArrayList<RexNode> aggParameters = new ArrayList<RexNode>();
            for (int i = 1; i <= aggFnLstArgIndx; ++i) {
                RexNode parameterExpr = CalcitePlanner.this.genRexNode((ASTNode)aggAst.getChild(i), inputRR, this.cluster.getRexBuilder());
                aggParameters.add(parameterExpr);
            }
            boolean isDistinct = aggAst.getType() == 1036;
            FunctionHelper.AggregateInfo aInfo = this.functionHelper.getWindowAggregateFunctionInfo(isDistinct, isAllColumns = aggAst.getType() == 1037, aggName = BaseSemanticAnalyzer.unescapeIdentifier(aggAst.getChild(0).getText()), aggParameters);
            if (aInfo == null) {
                TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, this.cluster.getRexBuilder());
                tcCtx.setAllowStatefulFunctions(true);
                tcCtx.setAllowDistinctFunctions(false);
                tcCtx.setUnparseTranslator(CalcitePlanner.this.unparseTranslator);
                RexNode exp = CalcitePlanner.genRexNode((ASTNode)aggAst.getChild(0), inputRR, tcCtx, CalcitePlanner.this.conf);
                aInfo = new FunctionHelper.AggregateInfo(aggParameters, TypeConverter.convert(exp.getType()), aggName, isDistinct);
            }
            return aInfo;
        }

        private RelNode genGBLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            boolean cubeRollupGrpSetPresent;
            ASTNode node;
            RelNode groupByRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String destClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qb.getParseInfo().getSelForClause(destClauseName);
            SubQueryUtils.checkForTopLevelSubqueries(selExprList);
            if (selExprList.getToken().getType() == 1191 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (ASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 837) {
                srcRel = (RelNode)this.genSelectLogicalPlan(qb, srcRel, srcRel, null, null, true).getKey();
                RowResolver rr = this.relToHiveRR.get(srcRel);
                qbp.setSelExprForClause(destClauseName, CalcitePlanner.this.genSelectDIAST(rr));
            }
            if (selExprList.getToken().getType() == 1191 && !qb.getAllWindowingSpecs().isEmpty()) {
                return null;
            }
            List<ASTNode> groupByNodes = CalcitePlanner.this.getGroupByForClause(qbp, destClauseName);
            Map<String, ASTNode> aggregationTrees = qbp.getAggregationExprsForClause(destClauseName);
            boolean hasGrpByAstExprs = groupByNodes != null && !groupByNodes.isEmpty();
            boolean hasAggregationTrees = aggregationTrees != null && !aggregationTrees.isEmpty();
            boolean bl = cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) && qbp.getDistinctFuncExprsForClause(destClauseName).size() > 1) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
            }
            if (cubeRollupGrpSetPresent) {
                if (!HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPSIDE_AGGREGATE)) {
                    throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) && qbp.getDestGroupingSets().size() > CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY)) {
                    String errorMsg = "The number of rows per input row due to grouping sets is " + qbp.getDestGroupingSets().size();
                    throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
                }
            }
            if (hasGrpByAstExprs || hasAggregationTrees) {
                ArrayList<RexNode> groupByExpressions = new ArrayList<RexNode>();
                ArrayList<String> outputColumnNames = new ArrayList<String>();
                RowResolver groupByInputRowResolver = this.relToHiveRR.get(srcRel);
                RowResolver groupByOutputRowResolver = new RowResolver();
                groupByOutputRowResolver.setIsExprResolver(true);
                if (hasGrpByAstExprs) {
                    groupByInputRowResolver.setCheckForAmbiguity(true);
                    for (ASTNode groupByNode : groupByNodes) {
                        Map<ASTNode, RexNode> astToRexNodeMap = CalcitePlanner.this.genAllRexNode(groupByNode, groupByInputRowResolver, this.cluster.getRexBuilder());
                        RexNode groupByExpression = astToRexNodeMap.get(groupByNode);
                        if (groupByExpression == null) {
                            throw new CalciteSemanticException("Invalid Column Reference: " + groupByNode.dump(), CalciteSemanticException.UnsupportedFeature.Invalid_column_reference);
                        }
                        this.addToGBExpr(groupByOutputRowResolver, groupByInputRowResolver, groupByNode, groupByExpression, groupByExpressions, outputColumnNames);
                    }
                    groupByInputRowResolver.setCheckForAmbiguity(false);
                }
                int groupingColsSize = groupByExpressions.size();
                List groupingSets = null;
                if (cubeRollupGrpSetPresent) {
                    groupingSets = (List)CalcitePlanner.this.getGroupByGroupingSetsForClause(qbp, destClauseName).getRight();
                }
                ArrayList<FunctionHelper.AggregateInfo> aggregations = new ArrayList<FunctionHelper.AggregateInfo>();
                if (hasAggregationTrees) {
                    assert (aggregationTrees != null);
                    for (ASTNode value : aggregationTrees.values()) {
                        String aggName = BaseSemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
                        boolean isDistinct = value.getType() == 1036;
                        boolean isAllColumns = value.getType() == 1037;
                        ArrayList<RexNode> aggParameters = new ArrayList<RexNode>();
                        ArrayList<FunctionHelper.FieldCollation> fieldCollations = new ArrayList<FunctionHelper.FieldCollation>();
                        for (int i = 1; i < value.getChildCount(); ++i) {
                            if (value.getChild(i).getType() == 1321) {
                                Tree orderByNode = value.getChild(i).getChild(0);
                                if (aggParameters.size() != orderByNode.getChildCount()) {
                                    throw new SemanticException(ErrorMsg.WITHIN_GROUP_PARAMETER_MISMATCH, new String[]{Integer.toString(aggParameters.size()), Integer.toString(orderByNode.getChildCount())});
                                }
                                for (int j = 0; j < orderByNode.getChildCount(); ++j) {
                                    Tree tabSortColNameNode = orderByNode.getChild(j);
                                    Tree nullsNode = tabSortColNameNode.getChild(0);
                                    ASTNode sortKey = (ASTNode)tabSortColNameNode.getChild(0).getChild(0);
                                    RexNode sortExpr = CalcitePlanner.this.genRexNode(sortKey, groupByInputRowResolver, this.cluster.getRexBuilder());
                                    fieldCollations.add(new FunctionHelper.FieldCollation(sortExpr, DirectionUtils.tokenToCode(tabSortColNameNode.getType()), NullOrdering.fromToken(nullsNode.getType())));
                                }
                                continue;
                            }
                            RexNode parameterExpr = CalcitePlanner.this.genRexNode((ASTNode)value.getChild(i), groupByInputRowResolver, this.cluster.getRexBuilder());
                            aggParameters.add(parameterExpr);
                        }
                        FunctionHelper.AggregateInfo aInfo = this.functionHelper.getAggregateFunctionInfo(isDistinct, isAllColumns, aggName, aggParameters, fieldCollations);
                        aggregations.add(aInfo);
                        String field = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size() - 1);
                        outputColumnNames.add(field);
                        groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, aInfo.getReturnType(), "", false));
                    }
                }
                if (groupingSets != null && !groupingSets.isEmpty()) {
                    String field = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size());
                    outputColumnNames.add(field);
                    groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, VirtualColumn.GROUPINGID.getTypeInfo(), null, true));
                }
                groupByRel = this.genGBRelNode(groupByExpressions, aggregations, groupingSets, srcRel);
                this.relToHiveColNameCalcitePosMap.put(groupByRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver));
                this.relToHiveRR.put(groupByRel, groupByOutputRowResolver);
            }
            return groupByRel;
        }

        private RelNode genOBLogicalPlan(QB qb, org.apache.calcite.util.Pair<RelNode, RowResolver> selPair, boolean outermostOB) throws SemanticException {
            String error;
            String dest;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode obAST = qbp.getOrderByForClause(dest = qbp.getClauseNames().iterator().next());
            if (obAST == null) {
                return null;
            }
            Integer limit = qb.getParseInfo().getDestLimit(dest);
            if (limit == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)CalcitePlanner.this.conf)) != null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(obAST, error));
            }
            RexLiteral offsetRN = null;
            RexLiteral fetchRN = null;
            if (limit != null) {
                Integer offset = qb.getParseInfo().getDestLimitOffset(dest);
                offsetRN = offset == null || offset == 0 ? null : this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset.intValue()));
                fetchRN = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(limit.intValue()));
            }
            return new OrderByRelBuilder(this, selPair, outermostOB).addSortByKeys(obAST).sortLimit((RexNode)offsetRN, (RexNode)fetchRN);
        }

        private RelNode genSBLogicalPlan(QB qb, org.apache.calcite.util.Pair<RelNode, RowResolver> selPair, boolean outermostOB) throws SemanticException {
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String dest = qbp.getClauseNames().iterator().next();
            ASTNode sbAST = qbp.getSortByForClause(dest);
            ASTNode distributeByAST = qbp.getDistributeByForClause(dest);
            if (sbAST == null && distributeByAST == null) {
                return null;
            }
            return new OrderByRelBuilder(this, selPair, outermostOB).addSortByKeys(sbAST).addRelDistribution(distributeByAST).sortExchange();
        }

        private RelNode genClusterByLogicalPlan(QB qb, org.apache.calcite.util.Pair<RelNode, RowResolver> selPair, boolean outermostOB) throws SemanticException {
            String dest;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode clusterByAST = qbp.getClusterByForClause(dest = qbp.getClauseNames().iterator().next());
            if (clusterByAST == null) {
                return null;
            }
            return new OrderByRelBuilder(this, selPair, outermostOB).addClusterBy(clusterByAST).sortExchange();
        }

        private List<RexNode> toRexNodeList(RelNode srcRel) {
            return srcRel.getRowType().getFieldList().stream().map(input -> new RexInputRef(input.getIndex(), input.getType())).collect(Collectors.toList());
        }

        private RelNode genLimitLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            Integer fetch;
            HiveSortLimit sortRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            AbstractMap.SimpleEntry<Integer, Integer> entry = qbp.getDestToLimit().get(qbp.getClauseNames().iterator().next());
            Integer offset = entry == null ? null : entry.getKey();
            Integer n = fetch = entry == null ? null : entry.getValue();
            if (fetch != null) {
                RexLiteral offsetRN = offset == null || offset == 0 ? null : this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset.intValue()));
                RexLiteral fetchRN = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(fetch.intValue()));
                RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
                RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollations.EMPTY);
                sortRel = new HiveSortLimit(this.cluster, traitSet, srcRel, canonizedCollation, (RexNode)offsetRN, (RexNode)fetchRN);
                RowResolver inputRR = this.relToHiveRR.get(srcRel);
                RowResolver outputRR = inputRR.duplicate();
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR);
                this.relToHiveRR.put(sortRel, outputRR);
                this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            }
            return sortRel;
        }

        private List<RexNode> getPartitionKeys(PTFInvocationSpec.PartitionSpec ps, RowResolver inputRR) throws SemanticException {
            ArrayList<RexNode> pKeys = new ArrayList<RexNode>();
            if (ps != null) {
                ArrayList<PTFInvocationSpec.PartitionExpression> pExprs = ps.getExpressions();
                for (PTFInvocationSpec.PartitionExpression pExpr : pExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, this.cluster.getRexBuilder());
                    tcCtx.setAllowStatefulFunctions(true);
                    tcCtx.setUnparseTranslator(CalcitePlanner.this.unparseTranslator);
                    RexNode exp = CalcitePlanner.genRexNode(pExpr.getExpression(), inputRR, tcCtx, CalcitePlanner.this.conf);
                    pKeys.add(exp);
                }
            }
            return pKeys;
        }

        private List<RexFieldCollation> getOrderKeys(PTFInvocationSpec.OrderSpec os, RowResolver inputRR) throws SemanticException {
            ArrayList<RexFieldCollation> oKeys = new ArrayList<RexFieldCollation>();
            if (os != null) {
                ArrayList<PTFInvocationSpec.OrderExpression> oExprs = os.getExpressions();
                for (PTFInvocationSpec.OrderExpression oExpr : oExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, this.cluster.getRexBuilder());
                    tcCtx.setAllowStatefulFunctions(true);
                    tcCtx.setUnparseTranslator(CalcitePlanner.this.unparseTranslator);
                    RexNode ordExp = CalcitePlanner.genRexNode(oExpr.getExpression(), inputRR, tcCtx, CalcitePlanner.this.conf);
                    HashSet<SqlKind> flags = new HashSet<SqlKind>();
                    if (oExpr.getOrder() == PTFInvocationSpec.Order.DESC) {
                        flags.add(SqlKind.DESCENDING);
                    }
                    if (oExpr.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST) {
                        flags.add(SqlKind.NULLS_FIRST);
                    } else if (oExpr.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_LAST) {
                        flags.add(SqlKind.NULLS_LAST);
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + oExpr.getNullOrder());
                    }
                    oKeys.add(new RexFieldCollation(ordExp, flags));
                }
            }
            return oKeys;
        }

        private RexWindowBound getBound(WindowingSpec.BoundarySpec bs) {
            RexWindowBound rwb = null;
            if (bs != null) {
                SqlParserPos pos = new SqlParserPos(1, 1);
                SqlNumericLiteral amt = bs.getAmt() == 0 || bs.getAmt() == Integer.MAX_VALUE ? null : SqlLiteral.createExactNumeric((String)String.valueOf(bs.getAmt()), (SqlParserPos)new SqlParserPos(2, 2));
                RexNode amtLiteral = null;
                SqlCall sc = null;
                if (amt != null) {
                    amtLiteral = this.cluster.getRexBuilder().makeLiteral((Object)bs.getAmt(), this.cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), true);
                }
                switch (bs.getDirection()) {
                    case PRECEDING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)pos), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createPreceding((SqlNode)amt, (SqlParserPos)pos);
                        rwb = RexWindowBound.create((SqlNode)sc, (RexNode)this.cluster.getRexBuilder().makeCall(sc.getOperator(), new RexNode[]{amtLiteral}));
                        break;
                    }
                    case CURRENT: {
                        rwb = RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)new SqlParserPos(1, 1)), null);
                        break;
                    }
                    case FOLLOWING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedFollowing((SqlParserPos)new SqlParserPos(1, 1)), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createFollowing((SqlNode)amt, (SqlParserPos)pos);
                        rwb = RexWindowBound.create((SqlNode)sc, (RexNode)this.cluster.getRexBuilder().makeCall(sc.getOperator(), new RexNode[]{amtLiteral}));
                    }
                }
            }
            return rwb;
        }

        private int getWindowSpecIndx(ASTNode wndAST) {
            int wi = wndAST.getChildCount() - 1;
            if (wi <= 0 || wndAST.getChild(wi).getType() != 1319) {
                wi = -1;
            }
            return wi;
        }

        private org.apache.calcite.util.Pair<RexNode, TypeInfo> genWindowingProj(WindowingSpec.WindowExpressionSpec wExpSpec, RelNode srcRel) throws SemanticException {
            ImmutableList.Builder calciteAggFnArgsTypeBldr;
            List<RexNode> calciteAggFnArgs;
            RelDataType calciteAggFnRetType;
            FunctionHelper.AggregateInfo hiveAggInfo;
            RexNode w = null;
            TypeInfo wHiveRetType = null;
            if (wExpSpec instanceof WindowingSpec.WindowFunctionSpec) {
                WindowingSpec.WindowFunctionSpec wFnSpec = (WindowingSpec.WindowFunctionSpec)wExpSpec;
                ASTNode windowProjAst = wFnSpec.getExpression();
                int wndSpecASTIndx = this.getWindowSpecIndx(windowProjAst);
                hiveAggInfo = this.getHiveAggInfo(windowProjAst, wndSpecASTIndx - 1, this.relToHiveRR.get(srcRel));
                wHiveRetType = hiveAggInfo.getReturnType();
                calciteAggFnRetType = TypeConverter.convert(hiveAggInfo.getReturnType(), this.cluster.getTypeFactory());
                calciteAggFnArgs = hiveAggInfo.getParameters();
                calciteAggFnArgsTypeBldr = ImmutableList.builder();
                for (int i = 0; i < hiveAggInfo.getParameters().size(); ++i) {
                    calciteAggFnArgsTypeBldr.add((Object)hiveAggInfo.getParameters().get(i).getType());
                }
            } else {
                throw new RuntimeException("Unsupported window Spec");
            }
            ImmutableList calciteAggFnArgsType = calciteAggFnArgsTypeBldr.build();
            SqlAggFunction calciteAggFn = SqlFunctionConverter.getCalciteAggFn(hiveAggInfo.getAggregateName(), hiveAggInfo.isDistinct(), (ImmutableList<RelDataType>)calciteAggFnArgsType, calciteAggFnRetType);
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            WindowingSpec.WindowFunctionSpec wndFuncSpec = (WindowingSpec.WindowFunctionSpec)wExpSpec;
            WindowingSpec.WindowSpec wndSpec = wndFuncSpec.getWindowSpec();
            List<RexNode> partitionKeys = this.getPartitionKeys(wndSpec.getPartition(), inputRR);
            List<RexFieldCollation> orderKeys = this.getOrderKeys(wndSpec.getOrder(), inputRR);
            RexWindowBound lowerBound = this.getBound(wndSpec.getWindowFrame().getStart());
            RexWindowBound upperBound = this.getBound(wndSpec.getWindowFrame().getEnd());
            boolean isRows = wndSpec.getWindowFrame().getWindowType() == WindowingSpec.WindowType.ROWS;
            w = this.cluster.getRexBuilder().makeOver(calciteAggFnRetType, calciteAggFn, calciteAggFnArgs, partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, isRows, true, false, hiveAggInfo.isDistinct(), !wndFuncSpec.isRespectNulls());
            return new org.apache.calcite.util.Pair((Object)w, (Object)wHiveRetType);
        }

        private RelNode genSelectForWindowing(QB qb, RelNode srcRel, HashSet<ColumnInfo> newColumns) throws SemanticException {
            WindowingSpec wSpec;
            this.getQBParseInfo(qb);
            WindowingSpec windowingSpec = wSpec = !qb.getAllWindowingSpecs().isEmpty() ? qb.getAllWindowingSpecs().values().iterator().next() : null;
            if (wSpec == null) {
                return null;
            }
            wSpec.validateAndMakeEffective();
            ArrayList<WindowingSpec.WindowExpressionSpec> windowExpressions = wSpec.getWindowExpressions();
            if (windowExpressions == null || windowExpressions.isEmpty()) {
                return null;
            }
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            ArrayList<RexNode> projsForWindowSelOp = new ArrayList<RexNode>(HiveCalciteUtil.getProjsFromBelowAsInputRef(srcRel));
            RowResolver out_rwsch = new RowResolver();
            out_rwsch.setExprResolver(inputRR.getIsExprResolver());
            if (!RowResolver.add(out_rwsch, inputRR)) {
                CalcitePlanner.this.LOG.warn(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED);
            }
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            for (WindowingSpec.WindowExpressionSpec wExprSpec : windowExpressions) {
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    wExprSpec.setExpression(CalcitePlanner.this.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, selClauseName), wExprSpec.getExpression(), !cubeRollupGrpSetPresent));
                }
                if (out_rwsch.getExpression(wExprSpec.getExpression()) != null) continue;
                org.apache.calcite.util.Pair<RexNode, TypeInfo> wtp = this.genWindowingProj(wExprSpec, srcRel);
                projsForWindowSelOp.add((RexNode)wtp.getKey());
                ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(projsForWindowSelOp.size()), (TypeInfo)wtp.getValue(), null, false);
                out_rwsch.putExpression(wExprSpec.getExpression(), oColInfo);
                newColumns.add(oColInfo);
            }
            return this.genSelectRelNode(projsForWindowSelOp, out_rwsch, srcRel, windowExpressions);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel) throws CalciteSemanticException {
            return this.genSelectRelNode(calciteColLst, out_rwsch, srcRel, null);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel, List<WindowingSpec.WindowExpressionSpec> windowExpressions) throws CalciteSemanticException {
            HashSet<Object> colNamesSet = new HashSet<Object>();
            List<ColumnInfo> cInfoLst = out_rwsch.getRowSchema().getSignature();
            ArrayList<String> columnNames = new ArrayList<String>();
            HashMap<String, String> windowToAlias = null;
            if (windowExpressions != null) {
                windowToAlias = new HashMap<String, String>();
                for (WindowingSpec.WindowExpressionSpec wes : windowExpressions) {
                    windowToAlias.put(wes.getExpression().toStringTree().toLowerCase(), wes.getAlias());
                }
            }
            for (int i = 0; i < calciteColLst.size(); ++i) {
                ColumnInfo cInfo = cInfoLst.get(i);
                String[] qualifiedColNames = out_rwsch.reverseLookup(cInfo.getInternalName());
                Object tmpColAlias = qualifiedColNames[1];
                if (((String)tmpColAlias).contains(".") || ((String)tmpColAlias).contains(":")) {
                    tmpColAlias = cInfo.getInternalName();
                }
                if (((String)tmpColAlias).startsWith("_c")) {
                    tmpColAlias = "_o_" + (String)tmpColAlias;
                } else if (windowToAlias != null && windowToAlias.containsKey(tmpColAlias)) {
                    tmpColAlias = (String)windowToAlias.get(tmpColAlias);
                }
                int suffix = 1;
                while (colNamesSet.contains(tmpColAlias)) {
                    tmpColAlias = qualifiedColNames[1] + suffix;
                    ++suffix;
                }
                colNamesSet.add(tmpColAlias);
                columnNames.add((String)tmpColAlias);
            }
            HiveProject selRel = HiveProject.create(srcRel, HiveCalciteUtil.fixNullability(this.cluster.getRexBuilder(), calciteColLst, (List<RelDataType>)RelOptUtil.getFieldTypeList((RelDataType)srcRel.getRowType())), columnNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(out_rwsch));
            this.relToHiveRR.put(selRel, out_rwsch);
            return selRel;
        }

        private void setQueryHints(QB qb) throws SemanticException {
            String selClauseName;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            Tree selExpr0 = qbp.getSelForClause(selClauseName = qbp.getClauseNames().iterator().next()).getChild(0);
            if (selExpr0.getType() != 427) {
                return;
            }
            String hint = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(selExpr0.getTokenStartIndex(), selExpr0.getTokenStopIndex());
            CalcitePlanner.this.LOG.debug("Handling query hints: " + hint);
            ParseDriver pd = new ParseDriver();
            try {
                ASTNode hintNode = pd.parseHint(hint);
                qbp.setHints(hintNode);
            }
            catch (ParseException e) {
                throw new SemanticException("failed to parse query hint: " + e.getMessage(), (Throwable)e);
            }
        }

        private org.apache.calcite.util.Pair<RelNode, RowResolver> genSelectLogicalPlan(QB qb, RelNode srcRel, RelNode starSrcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean isAllColRefRewrite) throws SemanticException {
            String selClauseName;
            org.apache.calcite.util.Pair<RelNode, RowResolver> retNodeRR = this.internalGenSelectLogicalPlan(qb, srcRel, starSrcRel, outerNameToPosMap, outerRR, isAllColRefRewrite);
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode selExprList = qbp.getSelForClause(selClauseName = qbp.getClauseNames().iterator().next());
            if (CalcitePlanner.this.isSelectDistinct(selExprList) && CalcitePlanner.this.hasGroupBySibling(selExprList)) {
                retNodeRR = this.genGBSelectDistinctPlan(retNodeRR);
            }
            return retNodeRR;
        }

        private org.apache.calcite.util.Pair<RelNode, RowResolver> internalGenSelectLogicalPlan(QB qb, RelNode srcRel, RelNode starSrcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean isAllColRefRewrite) throws SemanticException {
            int startPosn;
            String funcName;
            FunctionInfo fi;
            boolean isInTransform;
            boolean hintPresent;
            RowResolver inputRR;
            HashSet<ColumnInfo> excludedColumns = new HashSet<ColumnInfo>();
            RelNode selForWindow = this.genSelectForWindowing(qb, srcRel, excludedColumns);
            srcRel = selForWindow == null ? srcRel : selForWindow;
            List<Object> columnList = new ArrayList<RexNode>();
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qbp.getSelForClause(selClauseName);
            SubQueryUtils.checkForTopLevelSubqueries(selExprList);
            boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            RowResolver outputRR = new RowResolver();
            Integer pos = 0;
            RowResolver starRR = inputRR = this.relToHiveRR.get(srcRel);
            inputRR.setCheckForAmbiguity(true);
            if (starSrcRel != null) {
                starRR = this.relToHiveRR.get(starSrcRel);
            }
            int posn = 0;
            boolean bl = hintPresent = selExprList.getChild(0).getType() == 427;
            if (hintPresent) {
                ++posn;
            }
            boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 1287;
            if (isInTransform) {
                String msg = String.format("SELECT TRANSFORM is currently not supported in CBO, turn off cbo to use TRANSFORM.", new Object[0]);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_transform);
            }
            String udtfTableAlias = null;
            GenericUDTF genericUDTF = null;
            String genericUDTFName = null;
            ArrayList<String> udtfColAliases = new ArrayList<String>();
            ASTNode expr = (ASTNode)selExprList.getChild(posn).getChild(0);
            int exprType = expr.getType();
            if ((exprType == 1035 || exprType == 1037) && (fi = FunctionRegistry.getFunctionInfo(funcName = TypeCheckProcFactory.getFunctionText(expr, true))) != null && fi.getGenericUDTF() != null) {
                CalcitePlanner.this.LOG.debug("Find UDTF " + funcName);
                genericUDTF = fi.getGenericUDTF();
                genericUDTFName = funcName;
                if (!fi.isNative()) {
                    CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (genericUDTF != null && exprType == 1037) {
                    this.genRexNodeRegex(".*", null, (ASTNode)expr.getChild(0), columnList, null, inputRR, starRR, pos, outputRR, qb.getAliases(), false);
                }
            }
            if (genericUDTF != null) {
                if (selExprList.getChildCount() > 1) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
                }
                ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
                block6: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                    ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                    switch (selExprChild.getType()) {
                        case 24: {
                            udtfColAliases.add(BaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getText().toLowerCase()));
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation(selExprChild);
                            continue block6;
                        }
                        case 1244: {
                            assert (selExprChild.getChildCount() == 1);
                            udtfTableAlias = BaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                            qb.addAlias(udtfTableAlias);
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)selExprChild.getChild(0));
                            continue block6;
                        }
                        default: {
                            throw new SemanticException("Find invalid token type " + selExprChild.getType() + " in UDTF.");
                        }
                    }
                }
                CalcitePlanner.this.LOG.debug("UDTF table alias is " + udtfTableAlias);
                CalcitePlanner.this.LOG.debug("UDTF col aliases are " + udtfColAliases);
            }
            ASTNode exprList = genericUDTF != null ? expr : selExprList;
            for (int i = startPosn = genericUDTF != null ? posn + 1 : posn; i < exprList.getChildCount(); ++i) {
                RexNode expression;
                String recommended;
                Object colAlias;
                String tabAlias;
                boolean hasAsClause;
                ASTNode child = (ASTNode)exprList.getChild(i);
                boolean bl3 = hasAsClause = !isInTransform && child.getChildCount() == 2;
                if (genericUDTF == null && child.getChildCount() > 2) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
                }
                if (genericUDTF != null) {
                    tabAlias = null;
                    colAlias = CalcitePlanner.this.getAutogenColAliasPrfxLbl() + i;
                    expr = child;
                } else {
                    expr = (ASTNode)child.getChild(0);
                    String[] colRef = SemanticAnalyzer.getColAlias(child, CalcitePlanner.this.getAutogenColAliasPrfxLbl(), inputRR, CalcitePlanner.this.autogenColAliasPrfxIncludeFuncName(), i);
                    tabAlias = colRef[0];
                    colAlias = colRef[1];
                    if (hasAsClause) {
                        CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)child.getChild(1));
                    }
                }
                HashMap<ASTNode, QBSubQueryParseInfo> subQueryToRelNode = new HashMap<ASTNode, QBSubQueryParseInfo>();
                boolean isSubQuery = this.genSubQueryRelNode(qb, expr, srcRel, false, subQueryToRelNode);
                if (isSubQuery) {
                    RexNode subQueryExpr = CalcitePlanner.this.genRexNode(expr, this.relToHiveRR.get(srcRel), outerRR, subQueryToRelNode, true, this.cluster.getRexBuilder());
                    columnList.add(subQueryExpr);
                    ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeConverter.convert(subQueryExpr.getType())), tabAlias, false);
                    if (!outputRR.putWithCheck(tabAlias, (String)colAlias, null, colInfo)) {
                        throw new CalciteSemanticException("Cannot add column to RR: " + tabAlias + "." + (String)colAlias + " => " + colInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                    }
                    pos = pos + 1;
                    continue;
                }
                if (expr.getType() == 837) {
                    pos = this.genRexNodeRegex(".*", expr.getChildCount() == 0 ? null : BaseSemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, columnList, excludedColumns, inputRR, starRR, pos, outputRR, qb.getAliases(), true);
                    continue;
                }
                if (expr.getType() == 1270 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), CalcitePlanner.this.conf)) {
                    pos = this.genRexNodeRegex(BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, columnList, excludedColumns, inputRR, starRR, pos, outputRR, qb.getAliases(), true);
                    continue;
                }
                if (expr.getType() == 16 && expr.getChild(0).getType() == 1270 && inputRR.hasTableAlias(BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), CalcitePlanner.this.conf)) {
                    pos = this.genRexNodeRegex(BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, columnList, excludedColumns, inputRR, starRR, pos, outputRR, qb.getAliases(), true);
                    continue;
                }
                if (Boolean.TRUE.equals(ParseUtils.containsTokenOfType(expr, 1036).getKey()) && Boolean.FALSE.equals(ParseUtils.containsTokenOfType(expr, 1319).getKey()) && !(srcRel instanceof HiveAggregate) && (srcRel.getInputs().size() != 1 || !(srcRel.getInput(0) instanceof HiveAggregate))) {
                    throw new CalciteSemanticException("Distinct without an aggregation.", CalciteSemanticException.UnsupportedFeature.Distinct_without_an_aggregation);
                }
                TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, this.cluster.getRexBuilder());
                tcCtx.setAllowStatefulFunctions(true);
                tcCtx.setUnparseTranslator(CalcitePlanner.this.unparseTranslator);
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    expr = CalcitePlanner.this.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, selClauseName), expr, !cubeRollupGrpSetPresent);
                }
                if ((recommended = CalcitePlanner.this.recommendName(expression = CalcitePlanner.genRexNode(expr, inputRR, tcCtx, CalcitePlanner.this.conf), (String)colAlias, inputRR)) != null && outputRR.get(null, recommended) == null) {
                    colAlias = recommended;
                }
                columnList.add(expression);
                TypeInfo typeInfo = expression.isA(SqlKind.LITERAL) ? TypeConverter.convertLiteralType((RexLiteral)expression) : TypeConverter.convert(expression.getType());
                ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo), tabAlias, false);
                outputRR.put(tabAlias, (String)colAlias, colInfo);
                pos = pos + 1;
            }
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveColNameToInputPosMap(columnList, inputRR);
            CorrelationConverter cc = new CorrelationConverter(new InputContext(srcRel.getRowType(), hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel)), outerNameToPosMap, outerRR, this.subqueryId);
            columnList = columnList.stream().map(arg_0 -> ((CorrelationConverter)cc).apply(arg_0)).collect(Collectors.toList());
            RelNode outputRel = null;
            if (genericUDTF != null) {
                return this.genUDTFPlan(genericUDTF, genericUDTFName, udtfTableAlias, udtfColAliases, qb, columnList, outputRR, srcRel);
            }
            String dest = qbp.getClauseNames().iterator().next();
            ASTNode obAST = qbp.getOrderByForClause(dest);
            ASTNode sbAST = qbp.getSortByForClause(dest);
            RowResolver originalRR = null;
            if (!(obAST == null && sbAST == null || selForWindow != null && selExprList.getToken().getType() == 1191 || isAllColRefRewrite)) {
                String error;
                Integer limit = qb.getParseInfo().getDestLimit(dest);
                if (limit == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)CalcitePlanner.this.conf)) != null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(obAST, error));
                }
                originalRR = outputRR.duplicate();
                this.appendInputColumns(srcRel, columnList, outputRR, inputRR);
                ASTNode obOrSbAST = obAST != null ? obAST : sbAST;
                for (int i = 0; i < obOrSbAST.getChildCount(); ++i) {
                    RexNode obRex;
                    ASTNode obExprAST = (ASTNode)obOrSbAST.getChild(i);
                    ASTNode nullObASTExpr = (ASTNode)obExprAST.getChild(0);
                    ASTNode ref = (ASTNode)nullObASTExpr.getChild(0);
                    try {
                        Map<ASTNode, RexNode> astToExprNDescMap = CalcitePlanner.this.genAllRexNode(ref, inputRR, this.cluster.getRexBuilder());
                        obRex = astToExprNDescMap.get(ref);
                    }
                    catch (SemanticException ex) {
                        continue;
                    }
                    if (obRex instanceof RexInputRef) continue;
                    columnList.add(obRex);
                    String field = SemanticAnalyzer.getColumnInternalName(outputRR.getColumnInfos().size());
                    ObjectInspector oi = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeConverter.convert(obRex.getType()));
                    outputRR.putExpression(ref, new ColumnInfo(field, oi, "", false));
                }
                outputRel = this.genSelectRelNode(columnList, outputRR, srcRel);
                return new org.apache.calcite.util.Pair((Object)outputRel, (Object)originalRR);
            }
            if (qbp.getQualifyExprForClause(dest) != null) {
                int originalColumnListSize = columnList.size();
                originalRR = outputRR.duplicate();
                this.appendInputColumns(srcRel, columnList, outputRR, inputRR);
                RelNode combinedProject = this.genSelectRelNode(columnList, outputRR, srcRel);
                RelNode qualifyRel = this.genQualifyLogicalPlan(qb, combinedProject);
                ArrayList<RexNode> topProjectColumnList = new ArrayList<RexNode>(originalColumnListSize);
                for (int i = 0; i < originalColumnListSize; ++i) {
                    topProjectColumnList.add((RexNode)qualifyRel.getCluster().getRexBuilder().makeInputRef(((RelDataTypeField)qualifyRel.getRowType().getFieldList().get(i)).getType(), i));
                }
                outputRel = this.genSelectRelNode(topProjectColumnList, originalRR, qualifyRel);
                outputRR = originalRR;
            } else {
                outputRel = this.genSelectRelNode(columnList, outputRR, srcRel);
            }
            if (selForWindow != null && selExprList.getToken().getType() == 1191) {
                ImmutableBitSet groupSet = ImmutableBitSet.range((int)outputRel.getRowType().getFieldList().size());
                outputRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), outputRel, groupSet, null, new ArrayList<AggregateCall>());
                RowResolver groupByOutputRowResolver = new RowResolver();
                List<ASTNode> gbyKeyExpressions = CalcitePlanner.this.getGroupByForClause(qbp, selClauseName);
                for (int i = 0; i < outputRR.getColumnInfos().size(); ++i) {
                    ColumnInfo colInfo = outputRR.getColumnInfos().get(i);
                    ColumnInfo newColInfo = new ColumnInfo(colInfo.getInternalName(), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                    groupByOutputRowResolver.put(colInfo.getTabAlias(), colInfo.getAlias(), newColInfo);
                    if (gbyKeyExpressions == null || gbyKeyExpressions.size() != outputRR.getColumnInfos().size()) continue;
                    groupByOutputRowResolver.putExpression(gbyKeyExpressions.get(i), colInfo);
                }
                this.relToHiveColNameCalcitePosMap.put(outputRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver));
                this.relToHiveRR.put(outputRel, groupByOutputRowResolver);
            }
            inputRR.setCheckForAmbiguity(false);
            return new org.apache.calcite.util.Pair((Object)outputRel, (Object)outputRR);
        }

        private void appendInputColumns(RelNode srcRel, List<RexNode> columnList, RowResolver outputRR, RowResolver inputRR) throws SemanticException {
            List originalInputRefs = Lists.transform((List)srcRel.getRowType().getFieldList(), input -> new RexInputRef(input.getIndex(), input.getType()));
            for (int i = 0; i < inputRR.getColumnInfos().size(); ++i) {
                ColumnInfo colInfo = new ColumnInfo(inputRR.getColumnInfos().get(i));
                String internalName = SemanticAnalyzer.getColumnInternalName(outputRR.getColumnInfos().size());
                colInfo.setInternalName(internalName);
                if (!outputRR.putWithCheck(colInfo.getTabAlias(), colInfo.getAlias(), internalName, colInfo)) {
                    CalcitePlanner.this.LOG.trace("Column already present in RR. skipping.");
                    continue;
                }
                columnList.add((RexNode)originalInputRefs.get(i));
            }
        }

        Integer genRexNodeRegex(String colRegex, String tabAlias, ASTNode sel, List<RexNode> exprList, Set<ColumnInfo> excludeCols, RowResolver input, RowResolver colSrcRR, Integer pos, RowResolver output, List<String> aliases, boolean ensureUniqueCols) throws SemanticException {
            ArrayList<Pair<ColumnInfo, RowResolver>> colList = new ArrayList<Pair<ColumnInfo, RowResolver>>();
            Integer i = CalcitePlanner.this.genColListRegex(colRegex, tabAlias, sel, colList, excludeCols, input, colSrcRR, pos, output, aliases, ensureUniqueCols);
            for (Pair pair : colList) {
                exprList.add(RexNodeTypeCheck.toExprNode((ColumnInfo)pair.getLeft(), (RowResolver)pair.getRight(), 0, this.cluster.getRexBuilder()));
            }
            return i;
        }

        private org.apache.calcite.util.Pair<RelNode, RowResolver> genUDTFPlan(GenericUDTF genericUDTF, String genericUDTFName, String outputTableAlias, ArrayList<String> colAliases, QB qb, List<RexNode> selectColLst, RowResolver selectRR, RelNode input) throws SemanticException {
            int numSuppliedAliases;
            QBParseInfo qbp = qb.getParseInfo();
            if (!qbp.getDestToGroupBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
            }
            if (!qbp.getDestToDistributeBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
            }
            if (!qbp.getDestToSortBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
            }
            if (!qbp.getDestToClusterBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
            }
            if (!qbp.getAliasToLateralViews().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
            }
            CalcitePlanner.this.LOG.debug("Table alias: " + outputTableAlias + " Col aliases: " + colAliases);
            StructTypeInfo type = (StructTypeInfo)TypeConverter.convert(this.functionHelper.getReturnType(this.functionHelper.getFunctionInfo(genericUDTFName), selectColLst));
            int numUdtfCols = type.getAllStructFieldNames().size();
            if (colAliases.isEmpty()) {
                for (String fieldName : type.getAllStructFieldNames()) {
                    colAliases.add(fieldName);
                }
            }
            if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
                throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases but got " + numSuppliedAliases));
            }
            ArrayList<ColumnInfo> udtfCols = new ArrayList<ColumnInfo>();
            Iterator<String> colAliasesIter = colAliases.iterator();
            for (int i = 0; i < type.getAllStructFieldTypeInfos().size(); ++i) {
                String fieldName = (String)type.getAllStructFieldNames().get(i);
                TypeInfo fieldTypeInfo = (TypeInfo)type.getAllStructFieldTypeInfos().get(i);
                String colAlias = colAliasesIter.next();
                assert (colAlias != null);
                ColumnInfo col = new ColumnInfo(fieldName, fieldTypeInfo, outputTableAlias, false);
                udtfCols.add(col);
            }
            RowResolver outputRR = new RowResolver();
            for (int i = 0; i < udtfCols.size(); ++i) {
                outputRR.put(outputTableAlias, colAliases.get(i), (ColumnInfo)udtfCols.get(i));
            }
            RelTraitSet traitSet = TraitsUtil.getDefaultTraitSet(this.cluster);
            RelDataType retType = TypeConverter.getType(this.cluster, outputRR, null);
            ImmutableList.Builder argTypeBldr = ImmutableList.builder();
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
            RowSchema rs = selectRR.getRowSchema();
            for (ColumnInfo ci : rs.getSignature()) {
                argTypeBldr.add((Object)TypeConverter.convert(ci.getType(), dtFactory));
            }
            SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(genericUDTFName, genericUDTF, (ImmutableList<RelDataType>)argTypeBldr.build(), retType);
            ArrayList<RelNode> list = new ArrayList<RelNode>();
            list.add(input);
            RexNode rexNode = this.cluster.getRexBuilder().makeCall(calciteOp, selectColLst);
            HiveTableFunctionScan udtf = HiveTableFunctionScan.create(this.cluster, traitSet, list, rexNode, null, retType, null);
            this.relToHiveColNameCalcitePosMap.put(udtf, this.buildHiveToCalciteColumnMap(outputRR));
            this.relToHiveRR.put(udtf, outputRR);
            return new org.apache.calcite.util.Pair((Object)udtf, (Object)outputRR);
        }

        private org.apache.calcite.util.Pair<RelNode, RowResolver> genGBSelectDistinctPlan(org.apache.calcite.util.Pair<RelNode, RowResolver> srcNodeRR) throws SemanticException {
            RelNode srcRel = (RelNode)srcNodeRR.left;
            RelDataType inputRT = srcRel.getRowType();
            List groupSetPositions = IntStream.range(0, inputRT.getFieldCount()).boxed().collect(Collectors.toList());
            HiveAggregate distAgg = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, ImmutableBitSet.of(groupSetPositions), null, new ArrayList<AggregateCall>());
            RowResolver outputRR = (RowResolver)srcNodeRR.right;
            if (outputRR == null) {
                outputRR = this.relToHiveRR.get(srcRel);
            }
            this.relToHiveRR.put(distAgg, outputRR);
            this.relToHiveColNameCalcitePosMap.put(distAgg, this.relToHiveColNameCalcitePosMap.get(srcRel));
            return new org.apache.calcite.util.Pair((Object)distAgg, (Object)outputRR);
        }

        private RelNode genLogicalPlan(QBExpr qbexpr) throws SemanticException {
            switch (qbexpr.getOpcode()) {
                case NULLOP: {
                    return this.genLogicalPlan(qbexpr.getQB(), false, null, null);
                }
                case UNION: 
                case INTERSECT: 
                case INTERSECTALL: 
                case EXCEPT: 
                case EXCEPTALL: {
                    RelNode qbexpr1Ops = this.genLogicalPlan(qbexpr.getQBExpr1());
                    RelNode qbexpr2Ops = this.genLogicalPlan(qbexpr.getQBExpr2());
                    return this.genSetOpLogicalPlan(qbexpr.getOpcode(), qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
                }
            }
            return null;
        }

        private RelNode genLogicalPlan(QB qb, boolean outerMostQB, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            RelNode srcRel = null;
            RelNode filterRel = null;
            RelNode gbRel = null;
            RelNode gbHavingRel = null;
            RelNode selectRel = null;
            RelNode obRel = null;
            RelNode sbRel = null;
            RelNode limitRel = null;
            HashMap<String, RelNode> aliasToRel = new HashMap<String, RelNode>();
            String reason = CalcitePlanner.canHandleQbForCbo(CalcitePlanner.this.queryProperties, CalcitePlanner.this.conf, false);
            if (reason != null) {
                String msg = "CBO can not handle Sub Query";
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug(msg + " because it: " + reason);
                }
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Subquery);
            }
            for (String subqAlias : qb.getSubqAliases()) {
                QBExpr qbexpr = qb.getSubqForAlias(subqAlias);
                RelNode relNode = this.genLogicalPlan(qbexpr);
                ASTNode subqueryRoot = qbexpr.getSubQueryRoot();
                if (subqueryRoot != null && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING_SUBQUERY_SQL) && relNode instanceof HiveProject) {
                    this.subQueryMap.put(relNode, subqueryRoot);
                }
                aliasToRel.put(subqAlias, relNode);
                if (!qb.getViewToTabSchema().containsKey(subqAlias)) continue;
                if (relNode instanceof HiveProject) {
                    if (this.viewProjectToTableSchema == null) {
                        this.viewProjectToTableSchema = new LinkedHashMap<HiveProject, Table>();
                    }
                    this.viewProjectToTableSchema.put((HiveProject)relNode, qb.getViewToTabSchema().get(subqAlias));
                    continue;
                }
                throw new SemanticException("View " + subqAlias + " is corresponding to " + relNode.toString() + ", rather than a HiveProject.");
            }
            for (String tableAlias : qb.getTabAliases()) {
                RelNode op = this.genTableLogicalPlan(tableAlias, qb);
                aliasToRel.put(tableAlias, op);
            }
            if (aliasToRel.isEmpty()) {
                RelNode op;
                qb.getMetaData().setSrcForAlias("_dummy_table", CalcitePlanner.this.getDummyTable());
                qb.addAlias("_dummy_table");
                qb.setTabAlias("_dummy_table", "_dummy_table");
                this.dummyTableScan = op = this.genTableLogicalPlan("_dummy_table", qb);
                aliasToRel.put("_dummy_table", op);
            }
            this.setQueryHints(qb);
            if (qb.getParseInfo().getJoinExpr() != null) {
                srcRel = this.genJoinLogicalPlan(qb, qb.getParseInfo().getJoinExpr(), aliasToRel, outerNameToPosMap, outerRR);
            } else {
                Map.Entry uniqueAliasToRel = aliasToRel.entrySet().iterator().next();
                srcRel = (RelNode)uniqueAliasToRel.getValue();
                List<ASTNode> lateralViews = this.getQBParseInfo(qb).getAliasToLateralViews().get(uniqueAliasToRel.getKey());
                if (lateralViews != null) {
                    srcRel = this.genLateralViewPlans(qb, (ASTNode)Iterables.getLast(lateralViews), aliasToRel);
                }
            }
            filterRel = this.genFilterLogicalPlan(qb, srcRel, outerNameToPosMap, outerRR, false);
            RelNode starSrcRel = srcRel = filterRel == null ? srcRel : filterRel;
            gbRel = this.genGBLogicalPlan(qb, srcRel);
            srcRel = gbRel == null ? srcRel : gbRel;
            gbHavingRel = this.genGBHavingLogicalPlan(qb, srcRel);
            srcRel = gbHavingRel == null ? srcRel : gbHavingRel;
            org.apache.calcite.util.Pair<RelNode, RowResolver> selPair = this.genSelectLogicalPlan(qb, srcRel, starSrcRel, outerNameToPosMap, outerRR, false);
            selectRel = (RelNode)selPair.getKey();
            srcRel = selectRel == null ? srcRel : selectRel;
            org.apache.calcite.util.Pair<RelNode, RowResolver> constraintPair = this.genConstraintFilterLogicalPlan(qb, selPair, outerNameToPosMap, outerRR);
            if (constraintPair != null) {
                selPair = constraintPair;
            }
            if ((obRel = this.genOBLogicalPlan(qb, selPair, outerMostQB)) != null) {
                srcRel = obRel;
            } else {
                sbRel = this.genSBLogicalPlan(qb, selPair, outerMostQB);
                srcRel = sbRel != null ? sbRel : ((sbRel = this.genClusterByLogicalPlan(qb, selPair, outerMostQB)) == null ? srcRel : sbRel);
                limitRel = this.genLimitLogicalPlan(qb, srcRel);
                RelNode relNode = srcRel = limitRel == null ? srcRel : limitRel;
            }
            if (qb.getParseInfo().getAlias() != null) {
                RowResolver rr = this.relToHiveRR.get(srcRel);
                RowResolver newRR = new RowResolver();
                String alias = qb.getParseInfo().getAlias();
                List<String> targetColNames = CalcitePlanner.this.processTableColumnNames(qb.getParseInfo().getColAliases(), alias);
                if (targetColNames.size() > rr.getColumnInfos().size()) {
                    throw new SemanticException(ErrorMsg.WITH_COL_LIST_NUM_OVERFLOW, new String[]{alias, Integer.toString(rr.getColumnInfos().size()), Integer.toString(targetColNames.size())});
                }
                for (int i = 0; i < rr.getColumnInfos().size(); ++i) {
                    ColumnInfo colInfo = rr.getColumnInfos().get(i);
                    String name = colInfo.getInternalName();
                    String[] tmp = rr.reverseLookup(name);
                    ColumnInfo newCi = new ColumnInfo(colInfo);
                    newCi.setTabAlias(alias);
                    if (i < targetColNames.size()) {
                        tmp[1] = targetColNames.get(i);
                        newCi.setAlias(tmp[1]);
                    } else if ("".equals(tmp[0]) || tmp[1] == null) {
                        tmp[1] = colInfo.getInternalName();
                    }
                    newRR.putWithCheck(alias, tmp[1], colInfo.getInternalName(), newCi);
                }
                this.relToHiveRR.put(srcRel, newRR);
                this.relToHiveColNameCalcitePosMap.put(srcRel, this.buildHiveToCalciteColumnMap(newRR));
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Created Plan for Query Block " + qb.getId());
            }
            CalcitePlanner.this.setQB(qb);
            return srcRel;
        }

        private RelNode genGBHavingLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            RelNode gbFilter = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String destClauseName = qbp.getClauseNames().iterator().next();
            ASTNode havingClause = qbp.getHavingForClause(qbp.getClauseNames().iterator().next());
            if (havingClause != null) {
                if (!(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Having clause without any group-by.", CalciteSemanticException.UnsupportedFeature.Having_clause_without_any_groupby);
                }
                ASTNode targetNode = (ASTNode)havingClause.getChild(0);
                QBParseInfo qbPI = qb.getParseInfo();
                Map<ASTNode, String> exprToAlias = qbPI.getAllExprToColumnAlias();
                RowResolver inputRR = this.relToHiveRR.get(srcRel);
                inputRR.putAll(exprToAlias);
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
                    targetNode = CalcitePlanner.this.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, destClauseName), targetNode, !cubeRollupGrpSetPresent);
                }
                gbFilter = this.genFilterRelNode(qb, targetNode, srcRel, null, null, true);
            }
            return gbFilter;
        }

        private RelNode genQualifyLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            String destClauseName;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode qualifyClause = qbp.getQualifyExprForClause(destClauseName = qbp.getClauseNames().iterator().next());
            if (qualifyClause == null) {
                throw new SemanticException("Missing expression: qualify.");
            }
            ASTNode targetNode = (ASTNode)qualifyClause.getChild(0);
            return this.genFilterRelNode(qb, targetNode, srcRel, null, null, true);
        }

        private ImmutableMap<String, Integer> buildHiveToCalciteColumnMap(RowResolver rr) {
            ImmutableMap.Builder b = new ImmutableMap.Builder();
            for (ColumnInfo ci : rr.getRowSchema().getSignature()) {
                b.put((Object)ci.getInternalName(), (Object)rr.getPosition(ci.getInternalName()));
            }
            return b.build();
        }

        private ImmutableMap<String, Integer> buildHiveColNameToInputPosMap(List<RexNode> columnList, RowResolver inputRR) {
            ImmutableBitSet refs = RelOptUtil.InputFinder.bits(columnList, null);
            ImmutableMap.Builder hiveColNameToInputPosMapBuilder = new ImmutableMap.Builder();
            Iterator iterator = refs.iterator();
            while (iterator.hasNext()) {
                int ref = (Integer)iterator.next();
                hiveColNameToInputPosMapBuilder.put((Object)inputRR.getColumnInfos().get(ref).getInternalName(), (Object)ref);
            }
            return hiveColNameToInputPosMapBuilder.build();
        }

        private QBParseInfo getQBParseInfo(QB qb) throws CalciteSemanticException {
            return qb.getParseInfo();
        }

        private class CorrelationConverter
        extends RexShuttle {
            private final InputContext inputContext;
            private final ImmutableMap<Integer, String> outerPositionToColumnName;
            private final RowResolver outerRowResolver;
            private final int correlatedId;

            private CorrelationConverter(InputContext inputContext, ImmutableMap<String, Integer> outerColumnNameToPosition, RowResolver outerRowResolver, int correlatedId) {
                this.inputContext = inputContext;
                this.outerPositionToColumnName = outerColumnNameToPosition == null ? null : ImmutableBiMap.copyOf(outerColumnNameToPosition).inverse();
                this.outerRowResolver = outerRowResolver;
                this.correlatedId = correlatedId;
            }

            public RexNode visitInputRef(RexInputRef col) {
                InputContext context = null;
                if (this.inputContext.inputRowResolver == null) {
                    context = this.inputContext;
                } else {
                    int index = col.getIndex();
                    String colName = (String)this.inputContext.positionToColumnName.get((Object)index);
                    if (colName != null) {
                        context = this.inputContext;
                    }
                }
                if (context == null) {
                    RelDataType rowType = TypeConverter.getType(CalcitePlannerAction.this.cluster, this.outerRowResolver, null);
                    int index = col.getIndex() - this.inputContext.inputRowType.getFieldList().size();
                    if (this.outerPositionToColumnName.get((Object)index) == null) {
                        throw new RuntimeException(ErrorMsg.INVALID_COLUMN_NAME.getMsg());
                    }
                    CorrelationId colCorr = new CorrelationId(this.correlatedId);
                    RexNode corExpr = CalcitePlannerAction.this.cluster.getRexBuilder().makeCorrel(rowType, colCorr);
                    return CalcitePlannerAction.this.cluster.getRexBuilder().makeFieldAccess(corExpr, index);
                }
                int pos = col.getIndex();
                return CalcitePlannerAction.this.cluster.getRexBuilder().makeInputRef(((RelDataTypeField)context.inputRowType.getFieldList().get(pos)).getType(), pos);
            }
        }
    }

    private static class ExceptionHelper {
        private static final Field CAUSE_FIELD = ExceptionHelper.getField(Throwable.class, "cause");
        private static final Field TARGET_FIELD = ExceptionHelper.getField(InvocationTargetException.class, "target");
        private static final Field MESSAGE_FIELD = ExceptionHelper.getField(Throwable.class, "detailMessage");

        private ExceptionHelper() {
        }

        private static Field getField(Class<?> clazz, String name) {
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Throwable t) {
                return null;
            }
        }

        public static boolean resetCause(Throwable target, Throwable newCause) {
            try {
                Field field;
                if (MESSAGE_FIELD == null) {
                    return false;
                }
                Field field2 = field = target instanceof InvocationTargetException ? TARGET_FIELD : CAUSE_FIELD;
                if (field == null) {
                    return false;
                }
                Throwable oldCause = target.getCause();
                String oldMsg = target.getMessage();
                field.set(target, newCause);
                if (oldMsg != null && oldMsg.equals(oldCause.toString())) {
                    MESSAGE_FIELD.set(target, newCause == null ? null : newCause.toString());
                }
            }
            catch (Throwable se) {
                return false;
            }
            return true;
        }
    }

    private class OrderByRelBuilder {
        private final CalcitePlannerAction calcitePlannerAction;
        private final List<RexNode> newVCLst = new ArrayList<RexNode>();
        private final List<RelFieldCollation> fieldCollations = Lists.newArrayList();
        private final List<org.apache.calcite.util.Pair<ASTNode, TypeInfo>> vcASTTypePairs = new ArrayList<org.apache.calcite.util.Pair<ASTNode, TypeInfo>>();
        private final RowResolver outputRR = new RowResolver();
        private final org.apache.calcite.util.Pair<RelNode, RowResolver> selPair;
        private final boolean outermostOB;
        private HiveRelDistribution hiveRelDistribution;
        private RelNode obInputRel;

        OrderByRelBuilder(CalcitePlannerAction calcitePlannerAction, org.apache.calcite.util.Pair<RelNode, RowResolver> selPair, boolean outermostOB) {
            this.calcitePlannerAction = calcitePlannerAction;
            this.selPair = selPair;
            this.outermostOB = outermostOB;
        }

        OrderByRelBuilder addSortByKeys(ASTNode obAST) throws SemanticException {
            if (obAST == null) {
                return this;
            }
            List obASTExprLst = obAST.getChildren();
            for (int i = 0; i < obASTExprLst.size(); ++i) {
                RelFieldCollation.NullDirection nullOrder;
                ASTNode orderByNode = (ASTNode)obASTExprLst.get(i);
                ASTNode nullObASTExpr = (ASTNode)orderByNode.getChild(0);
                ASTNode ref = (ASTNode)nullObASTExpr.getChild(0);
                int fieldIndex = this.genSortByKey(ref);
                if (fieldIndex < 0) continue;
                RelFieldCollation.Direction order = RelFieldCollation.Direction.DESCENDING;
                if (orderByNode.getType() == 1275) {
                    order = RelFieldCollation.Direction.ASCENDING;
                }
                if (nullObASTExpr.getType() == 1102) {
                    nullOrder = RelFieldCollation.NullDirection.FIRST;
                } else if (nullObASTExpr.getType() == 1103) {
                    nullOrder = RelFieldCollation.NullDirection.LAST;
                } else {
                    throw new SemanticException("Unexpected null ordering option: " + nullObASTExpr.getType());
                }
                this.fieldCollations.add(new RelFieldCollation(fieldIndex, order, nullOrder));
            }
            return this;
        }

        private int genSortByKey(ASTNode ref) throws SemanticException {
            boolean isObyByPos;
            RelNode srcRel = (RelNode)this.selPair.getKey();
            RowResolver selectOutputRR = (RowResolver)this.selPair.getValue();
            RowResolver inputRR = this.calcitePlannerAction.relToHiveRR.get(srcRel);
            int srcRelRecordSz = srcRel.getRowType().getFieldCount();
            boolean isBothByPos = HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_GROUPBY_ORDERBY_POSITION_ALIAS);
            boolean bl = isObyByPos = isBothByPos || HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORDERBY_POSITION_ALIAS);
            if (ref != null && ref.getToken().getType() == 424) {
                if (isObyByPos) {
                    return this.getFieldIndexFromColumnNumber(selectOutputRR, ref);
                }
                CalcitePlanner.this.LOG.warn("Using constant number {} in order by. If you try to use position alias when hive.orderby.position.alias is false, the position alias will be ignored.", (Object)ref.getText());
                return -1;
            }
            RexNode orderByExpression = this.getOrderByExpression(selectOutputRR, inputRR, ref);
            if (orderByExpression instanceof RexInputRef) {
                return ((RexInputRef)orderByExpression).getIndex();
            }
            int fieldIndex = srcRelRecordSz + this.newVCLst.size();
            this.newVCLst.add(orderByExpression);
            this.vcASTTypePairs.add((org.apache.calcite.util.Pair<ASTNode, TypeInfo>)new org.apache.calcite.util.Pair((Object)ref, (Object)TypeConverter.convert(orderByExpression.getType())));
            return fieldIndex;
        }

        private RexNode getOrderByExpression(RowResolver selectOutputRR, RowResolver inputRR, ASTNode ref) throws SemanticException {
            Map<ASTNode, RexNode> astToExprNDescMap;
            RexNode orderByExpression = null;
            if (selectOutputRR != null) {
                try {
                    astToExprNDescMap = CalcitePlanner.this.genAllRexNode(ref, selectOutputRR, this.calcitePlannerAction.cluster.getRexBuilder());
                    orderByExpression = astToExprNDescMap.get(ref);
                }
                catch (SemanticException ex) {
                    CalcitePlanner.this.LOG.debug("Can not find column in {} The error msg is {}", (Object)ref.getText(), (Object)ex.getMessage());
                }
            }
            if (orderByExpression == null) {
                astToExprNDescMap = CalcitePlanner.this.genAllRexNode(ref, inputRR, this.calcitePlannerAction.cluster.getRexBuilder());
                orderByExpression = astToExprNDescMap.get(ref);
            }
            if (orderByExpression == null) {
                throw new SemanticException("Invalid order by expression: " + ref.toString());
            }
            return orderByExpression;
        }

        private int getFieldIndexFromColumnNumber(RowResolver selectOutputRR, ASTNode ref) throws SemanticException {
            int pos = Integer.parseInt(ref.getText());
            if (pos <= 0 || pos > selectOutputRR.getColumnInfos().size()) {
                throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectOutputRR.getColumnInfos().size()));
            }
            int fieldIndex = pos - 1;
            return fieldIndex;
        }

        OrderByRelBuilder addRelDistribution(ASTNode distributeByAST) throws SemanticException {
            if (distributeByAST != null) {
                ImmutableList.Builder keys = ImmutableList.builder();
                for (int i = 0; i < distributeByAST.getChildCount(); ++i) {
                    ASTNode keyAST = (ASTNode)distributeByAST.getChild(i);
                    int fieldIndex = this.genSortByKey(keyAST);
                    if (fieldIndex < 0) continue;
                    keys.add((Object)fieldIndex);
                }
                ImmutableList keyList = keys.build();
                if (!keyList.isEmpty()) {
                    this.hiveRelDistribution = new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, (List<Integer>)keyList);
                    return this;
                }
            }
            this.hiveRelDistribution = new HiveRelDistribution(RelDistribution.Type.ANY, RelDistributions.ANY.getKeys());
            return this;
        }

        OrderByRelBuilder addClusterBy(ASTNode clusterBy) throws SemanticException {
            this.addRelDistribution(clusterBy);
            for (Integer fieldIndex : this.hiveRelDistribution.getKeys()) {
                this.fieldCollations.add(new RelFieldCollation(fieldIndex.intValue(), RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST));
            }
            return this;
        }

        private void genOBProject() throws SemanticException {
            RelNode srcRel = (RelNode)this.selPair.getKey();
            RowResolver inputRR = this.calcitePlannerAction.relToHiveRR.get(srcRel);
            this.obInputRel = srcRel;
            if (!this.newVCLst.isEmpty()) {
                List<RexNode> originalInputRefs = this.calcitePlannerAction.toRexNodeList(srcRel);
                RowResolver obSyntheticProjectRR = new RowResolver();
                if (!RowResolver.add(obSyntheticProjectRR, inputRR)) {
                    throw new CalciteSemanticException(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED, CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                int vcolPos = inputRR.getRowSchema().getSignature().size();
                for (org.apache.calcite.util.Pair<ASTNode, TypeInfo> astTypePair : this.vcASTTypePairs) {
                    obSyntheticProjectRR.putExpression((ASTNode)astTypePair.getKey(), new ColumnInfo(SemanticAnalyzer.getColumnInternalName(vcolPos), (TypeInfo)astTypePair.getValue(), null, false));
                    ++vcolPos;
                }
                this.obInputRel = this.calcitePlannerAction.genSelectRelNode((List<RexNode>)CompositeList.of(originalInputRefs, this.newVCLst), obSyntheticProjectRR, srcRel);
                if (this.outermostOB ? !RowResolver.add(this.outputRR, inputRR) : !RowResolver.add(this.outputRR, obSyntheticProjectRR)) {
                    throw new CalciteSemanticException(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED, CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
            } else if (!RowResolver.add(this.outputRR, inputRR)) {
                throw new CalciteSemanticException(CalcitePlanner.ERROR_MESSAGE_DUPLICATES_DETECTED, CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
            }
        }

        RelNode sortLimit(RexNode offsetRN, RexNode fetchRN) throws SemanticException {
            this.genOBProject();
            if (this.fieldCollations.isEmpty()) {
                return this.endGenOBLogicalPlan(this.obInputRel);
            }
            RelOptCluster cluster = this.calcitePlannerAction.cluster;
            RelTraitSet traitSet = cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
            RelCollation canonizedCollation = RelCollations.of(this.fieldCollations);
            HiveSortLimit sortRel = new HiveSortLimit(cluster, traitSet, this.obInputRel, canonizedCollation, offsetRN, fetchRN);
            return this.endGenOBLogicalPlan(sortRel);
        }

        RelNode sortExchange() throws SemanticException {
            this.genOBProject();
            if (this.fieldCollations.isEmpty() && this.hiveRelDistribution.getKeys().isEmpty()) {
                return this.endGenOBLogicalPlan(this.obInputRel);
            }
            RelCollation canonizedCollation = RelCollations.of(this.fieldCollations);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RelFieldCollation relFieldCollation : canonizedCollation.getFieldCollations()) {
                int index = relFieldCollation.getFieldIndex();
                builder.add((Object)this.calcitePlannerAction.cluster.getRexBuilder().makeInputRef(this.obInputRel, index));
            }
            ImmutableList keys = builder.build();
            HiveSortExchange sortRel = HiveSortExchange.create(this.obInputRel, this.hiveRelDistribution, canonizedCollation, (ImmutableList<RexNode>)keys);
            return this.endGenOBLogicalPlan(sortRel);
        }

        private RelNode endGenOBLogicalPlan(RelNode sortRel) throws CalciteSemanticException {
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.calcitePlannerAction.buildHiveToCalciteColumnMap(this.outputRR);
            this.calcitePlannerAction.relToHiveRR.put(sortRel, this.outputRR);
            this.calcitePlannerAction.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            RowResolver selectOutputRR = (RowResolver)this.selPair.getValue();
            if (selectOutputRR != null) {
                List<RexNode> originalInputRefs = this.calcitePlannerAction.toRexNodeList((RelNode)this.selPair.getKey());
                List<RexNode> selectedRefs = originalInputRefs.subList(0, selectOutputRR.getColumnInfos().size());
                return this.calcitePlannerAction.genSelectRelNode(selectedRefs, selectOutputRR, sortRel);
            }
            return sortRel;
        }
    }

    private static enum TableType {
        DRUID,
        NATIVE,
        JDBC;

    }

    protected static class InputContext {
        protected final RelDataType inputRowType;
        protected final ImmutableBiMap<Integer, String> positionToColumnName;
        protected final RowResolver inputRowResolver;

        protected InputContext(RelDataType inputRowType, ImmutableMap<String, Integer> columnNameToPosition, RowResolver inputRowResolver) {
            this.inputRowType = inputRowType;
            this.positionToColumnName = ImmutableBiMap.copyOf(columnNameToPosition).inverse();
            this.inputRowResolver = inputRowResolver.duplicate();
        }
    }
}

