/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.HivePlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRowCount;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelMdRuntimeRowCount
extends HiveRelMdRowCount {
    protected static final Logger LOG = LoggerFactory.getLogger((String)HiveRelMdRuntimeRowCount.class.getName());
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ROW_COUNT.method, (MetadataHandler)new HiveRelMdRuntimeRowCount());

    protected HiveRelMdRuntimeRowCount() {
    }

    @Override
    public Double getRowCount(Filter rel, RelMetadataQuery mq) {
        Optional<Long> runtimeRowCount = this.getRuntimeRowCount((RelNode)rel);
        if (runtimeRowCount.isPresent()) {
            return runtimeRowCount.get().doubleValue();
        }
        return super.getRowCount(rel, mq);
    }

    public Optional<Long> getRuntimeRowCount(RelNode rel) {
        Optional<OperatorStats> os;
        StatsSource ss;
        RelOptCluster cluster = rel.getCluster();
        Context context = cluster.getPlanner().getContext();
        if (context instanceof HivePlannerContext && (ss = ((HivePlannerContext)context).unwrap(StatsSource.class)).canProvideStatsFor(rel.getClass()) && (os = ss.lookup(RelTreeSignature.of(rel))).isPresent()) {
            long outputRecords = os.get().getOutputRecords();
            return Optional.of(outputRecords);
        }
        return Optional.empty();
    }
}

