/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveBetween;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.optimizer.graph.DiGraph;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HivePointLookupOptimizerRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HivePointLookupOptimizerRule.class);
    protected final int minNumORClauses;

    protected HivePointLookupOptimizerRule(RelOptRuleOperand operand, int minNumORClauses, String description) {
        super(operand, description);
        this.minNumORClauses = minNumORClauses;
    }

    public RexNode analyzeRexNode(RexBuilder rexBuilder, RexNode condition) {
        RexTransformIntoInClause transformIntoInClause = new RexTransformIntoInClause(rexBuilder, this.minNumORClauses);
        RexNode newCondition = transformIntoInClause.apply(condition);
        RexMergeInClause mergeInClause = new RexMergeInClause(rexBuilder);
        newCondition = mergeInClause.apply(newCondition);
        RexTransformIntoBetween t = new RexTransformIntoBetween(rexBuilder);
        newCondition = t.apply(newCondition);
        return newCondition;
    }

    protected static class RexTransformIntoInClause
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final int minNumORClauses;

        RexTransformIntoInClause(RexBuilder rexBuilder, int minNumORClauses) {
            this.rexBuilder = rexBuilder;
            this.minNumORClauses = minNumORClauses;
        }

        public RexNode visitCall(RexCall inputCall) {
            RexCall call;
            RexNode node = super.visitCall(inputCall);
            if (node instanceof RexCall && (call = (RexCall)node).getKind() == SqlKind.OR) {
                try {
                    RexNode newNode = this.transformIntoInClauseCondition(this.rexBuilder, (RexNode)call, this.minNumORClauses);
                    if (newNode != null) {
                        return newNode;
                    }
                }
                catch (SemanticException e) {
                    LOG.error("Exception in HivePointLookupOptimizerRule", (Throwable)e);
                    return call;
                }
            }
            return node;
        }

        private RexNode transformIntoInClauseCondition(RexBuilder rexBuilder, RexNode condition, int minNumORClauses) throws SemanticException {
            assert (condition.getKind() == SqlKind.OR);
            ImmutableList operands = RexUtil.flattenOr((Iterable)((RexCall)condition).getOperands());
            if (operands.size() < minNumORClauses) {
                return null;
            }
            ArrayList<Object> allNodes = new ArrayList<Object>();
            ArrayList processedNodes = new ArrayList();
            for (int i = 0; i < operands.size(); ++i) {
                ConstraintGroup m = new ConstraintGroup((RexNode)operands.get(i));
                allNodes.add(m);
            }
            ImmutableListMultimap assignmentGroups = Multimaps.index(allNodes, cg -> cg.key);
            for (Map.Entry entry : assignmentGroups.asMap().entrySet()) {
                if (((Set)entry.getKey()).isEmpty() || ((Collection)entry.getValue()).size() < 2 || ((Collection)entry.getValue()).size() < minNumORClauses) continue;
                allNodes.add(new ConstraintGroup(this.buildInFor((Set)entry.getKey(), (Collection)entry.getValue())));
                processedNodes.addAll((Collection)entry.getValue());
            }
            if (processedNodes.isEmpty()) {
                return null;
            }
            allNodes.removeAll(processedNodes);
            ArrayList<RexNode> ops = new ArrayList<RexNode>();
            for (ConstraintGroup constraintGroup : allNodes) {
                ops.add(constraintGroup.originalRexNode);
            }
            if (ops.size() == 1) {
                return (RexNode)ops.get(0);
            }
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, ops);
        }

        private RexNode buildInFor(Set<RexNodeRef> set, Collection<ConstraintGroup> value) throws SemanticException {
            ArrayList<RexNodeRef> columns = new ArrayList<RexNodeRef>(set);
            columns.sort(RexNodeRef.COMPARATOR);
            ArrayList<RexNode> operands = new ArrayList<RexNode>();
            List columnNodes = columns.stream().map(RexNodeRef::getRexNode).collect(Collectors.toList());
            operands.add(this.useStructIfNeeded(columnNodes));
            for (ConstraintGroup node : value) {
                List<RexNode> values = node.getValuesInOrder(columns);
                operands.add(this.useStructIfNeeded(values));
            }
            return this.rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, operands);
        }

        private RexNode useStructIfNeeded(List<? extends RexNode> columns) {
            if (columns.size() == 1) {
                return columns.get(0);
            }
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, columns);
        }

        static class ConstraintGroup {
            private final Map<RexNodeRef, Constraint> constraints = new HashMap<RexNodeRef, Constraint>();
            private final RexNode originalRexNode;
            private final Set<RexNodeRef> key;

            public ConstraintGroup(RexNode rexNode) {
                this.originalRexNode = rexNode;
                List conjunctions = RelOptUtil.conjunctions((RexNode)rexNode);
                for (RexNode n : conjunctions) {
                    Constraint c = Constraint.of(n);
                    if (c == null) {
                        this.key = Collections.emptySet();
                        return;
                    }
                    this.constraints.put(c.getKey(), c);
                }
                if (this.constraints.size() != conjunctions.size()) {
                    LOG.debug("unexpected situation; giving up on this branch");
                    this.key = Collections.emptySet();
                    return;
                }
                this.key = this.constraints.keySet();
            }

            public List<RexNode> getValuesInOrder(List<RexNodeRef> columns) throws SemanticException {
                ArrayList<RexNode> ret = new ArrayList<RexNode>();
                for (RexNodeRef rexInputRef : columns) {
                    Constraint constraint = this.constraints.get(rexInputRef);
                    if (constraint == null) {
                        throw new SemanticException("Unable to find constraint which was earlier added.");
                    }
                    ret.add(constraint.constNode);
                }
                return ret;
            }
        }
    }

    protected static class RexMergeInClause
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        RexMergeInClause(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            switch (call.getKind()) {
                case AND: {
                    return RexMergeInClause.handleAND(this.rexBuilder, call);
                }
                case OR: {
                    return RexMergeInClause.handleOR(this.rexBuilder, call);
                }
            }
            return super.visitCall(call);
        }

        private static RexNode handleAND(RexBuilder rexBuilder, RexCall call) {
            LinkedHashSet<RexNode> visitedRefs = new LinkedHashSet<RexNode>();
            LinkedHashMultimap inLHSExprToRHSExprs = LinkedHashMultimap.create();
            LinkedHashMultimap inLHSExprToRHSNullableExprs = LinkedHashMultimap.create();
            ArrayList operands = new ArrayList(RexUtil.flattenAnd((Iterable)call.getOperands()));
            for (int i = 0; i < operands.size(); ++i) {
                Constraint c;
                RexNode operand = (RexNode)operands.get(i);
                if (operand instanceof RexCall && HiveIn.INSTANCE.equals((Object)((RexCall)operand).op)) {
                    RexCall inCall = (RexCall)operand;
                    if (!HiveCalciteUtil.isDeterministic((RexNode)inCall.getOperands().get(0))) continue;
                    RexNode ref = (RexNode)inCall.getOperands().get(0);
                    visitedRefs.add(ref);
                    if (ref.getType().isNullable()) {
                        inLHSExprToRHSNullableExprs.put((Object)ref, (Object)ref);
                    }
                    if (inLHSExprToRHSExprs.containsKey((Object)ref)) {
                        HashSet expressions = Sets.newHashSet();
                        for (int j = 1; j < inCall.getOperands().size(); ++j) {
                            RexNode constNode = (RexNode)inCall.getOperands().get(j);
                            expressions.add(new SimilarRexNodeElement(constNode));
                            if (!constNode.getType().isNullable()) continue;
                            inLHSExprToRHSNullableExprs.put((Object)ref, (Object)constNode);
                        }
                        Collection knownConstants = inLHSExprToRHSExprs.get((Object)ref);
                        if (!RexMergeInClause.shareSameType(knownConstants, expressions)) {
                            return call;
                        }
                        knownConstants.retainAll(expressions);
                    } else {
                        for (int j = 1; j < inCall.getOperands().size(); ++j) {
                            RexNode constNode = (RexNode)inCall.getOperands().get(j);
                            inLHSExprToRHSExprs.put((Object)ref, (Object)new SimilarRexNodeElement(constNode));
                            if (!constNode.getType().isNullable()) continue;
                            inLHSExprToRHSNullableExprs.put((Object)ref, (Object)constNode);
                        }
                    }
                    operands.remove(i);
                    --i;
                    continue;
                }
                if (operand.getKind() != SqlKind.EQUALS || (c = Constraint.of(operand)) == null || !HiveCalciteUtil.isDeterministic(c.exprNode)) continue;
                visitedRefs.add(c.exprNode);
                if (c.exprNode.getType().isNullable()) {
                    inLHSExprToRHSNullableExprs.put((Object)c.exprNode, (Object)c.exprNode);
                }
                if (c.constNode.getType().isNullable()) {
                    inLHSExprToRHSNullableExprs.put((Object)c.exprNode, (Object)c.constNode);
                }
                if (inLHSExprToRHSExprs.containsKey((Object)c.exprNode)) {
                    Set<SimilarRexNodeElement> nextConstant;
                    Collection knownConstants = inLHSExprToRHSExprs.get((Object)c.exprNode);
                    if (!RexMergeInClause.shareSameType(knownConstants, nextConstant = Collections.singleton(new SimilarRexNodeElement(c.constNode)))) {
                        return call;
                    }
                    knownConstants.retainAll(nextConstant);
                } else {
                    inLHSExprToRHSExprs.put((Object)c.exprNode, (Object)new SimilarRexNodeElement(c.constNode));
                }
                operands.remove(i);
                --i;
            }
            List<RexNode> newOperands = RexMergeInClause.createInClauses(rexBuilder, visitedRefs, (Multimap<RexNode, SimilarRexNodeElement>)inLHSExprToRHSExprs, (Multimap<RexNode, RexNode>)inLHSExprToRHSNullableExprs);
            newOperands.addAll(operands);
            return RexUtil.composeConjunction((RexBuilder)rexBuilder, newOperands, (boolean)false);
        }

        private static boolean shareSameType(Collection<SimilarRexNodeElement> nodes1, Collection<SimilarRexNodeElement> nodes2) {
            return Stream.of(nodes1, nodes2).flatMap(Collection::stream).map(n -> n.getRexNode().getType().getSqlTypeName()).distinct().count() == 1L;
        }

        private static RexNode handleOR(RexBuilder rexBuilder, RexCall call) {
            ArrayList operands = new ArrayList(RexUtil.flattenOr((Iterable)call.getOperands()));
            LinkedHashMultimap inLHSExprToRHSExprs = LinkedHashMultimap.create();
            for (int i = 0; i < operands.size(); ++i) {
                RexCall inCall;
                RexNode operand = (RexNode)operands.get(i);
                if (!(operand instanceof RexCall) || !HiveIn.INSTANCE.equals((Object)((RexCall)operand).op) || !HiveCalciteUtil.isDeterministic((RexNode)(inCall = (RexCall)operand).getOperands().get(0))) continue;
                RexNode ref = (RexNode)inCall.getOperands().get(0);
                for (int j = 1; j < inCall.getOperands().size(); ++j) {
                    inLHSExprToRHSExprs.put((Object)ref, (Object)new SimilarRexNodeElement((RexNode)inCall.getOperands().get(j)));
                }
                operands.remove(i);
                --i;
            }
            List<RexNode> newOperands = RexMergeInClause.createInClauses(rexBuilder, inLHSExprToRHSExprs.keySet(), (Multimap<RexNode, SimilarRexNodeElement>)inLHSExprToRHSExprs, null);
            newOperands.addAll(operands);
            RexNode result = RexUtil.composeDisjunction((RexBuilder)rexBuilder, newOperands, (boolean)false);
            if (!result.getType().equals(call.getType())) {
                return rexBuilder.makeCast(call.getType(), result, true);
            }
            return result;
        }

        private static RexNode createResultFromEmptySet(RexBuilder rexBuilder, RexNode ref, Multimap<RexNode, RexNode> inLHSExprToRHSNullableExprs) {
            if (inLHSExprToRHSNullableExprs.containsKey((Object)ref)) {
                List nullableExprs = inLHSExprToRHSNullableExprs.get((Object)ref).stream().map(n -> rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, (List)ImmutableList.of((Object)n))).collect(Collectors.toList());
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)ImmutableList.of((Object)RexUtil.composeDisjunction((RexBuilder)rexBuilder, nullableExprs, (boolean)false), (Object)rexBuilder.makeNullLiteral(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN))), (boolean)false);
            }
            return rexBuilder.makeLiteral(false);
        }

        private static List<RexNode> createInClauses(RexBuilder rexBuilder, Set<RexNode> visitedRefs, Multimap<RexNode, SimilarRexNodeElement> inLHSExprToRHSExprs, Multimap<RexNode, RexNode> inLHSExprToRHSNullableExprs) {
            ArrayList<RexNode> newExpressions = new ArrayList<RexNode>();
            for (RexNode ref : visitedRefs) {
                ArrayList<RexNode> newOperands;
                Collection exprs = inLHSExprToRHSExprs.get((Object)ref);
                if (exprs.isEmpty()) {
                    newExpressions.add(RexMergeInClause.createResultFromEmptySet(rexBuilder, ref, inLHSExprToRHSNullableExprs));
                    continue;
                }
                if (exprs.size() == 1) {
                    newOperands = new ArrayList<RexNode>(2);
                    newOperands.add(ref);
                    newOperands.add(((SimilarRexNodeElement)exprs.iterator().next()).getRexNode());
                    newExpressions.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, newOperands));
                    continue;
                }
                newOperands = new ArrayList(exprs.size() + 1);
                newOperands.add(ref);
                newOperands.addAll(exprs.stream().map(SimilarRexNodeElement::getRexNode).collect(Collectors.toList()));
                newExpressions.add(rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, newOperands));
            }
            return newExpressions;
        }

        protected static class SimilarRexNodeElement {
            private final RexNode rexNode;

            protected SimilarRexNodeElement(RexNode rexNode) {
                this.rexNode = rexNode;
            }

            public RexNode getRexNode() {
                return this.rexNode;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SimilarRexNodeElement that = (SimilarRexNodeElement)o;
                return SimilarRexNodeElement.equalsWithSimilarType(this.rexNode, that.rexNode);
            }

            private static boolean equalsWithSimilarType(RexNode rexNode1, RexNode rexNode2) {
                if (!(rexNode1 instanceof RexLiteral) || !(rexNode2 instanceof RexLiteral)) {
                    return rexNode1.equals((Object)rexNode2);
                }
                RexLiteral rexLiteral1 = (RexLiteral)rexNode1;
                RexLiteral rexLiteral2 = (RexLiteral)rexNode2;
                if (rexLiteral1.getValue() == null && rexLiteral2.getValue() == null) {
                    return true;
                }
                return rexLiteral1.getValue() != null && rexLiteral1.getValue().compareTo(rexLiteral2.getValue()) == 0 && rexLiteral1.getType().getSqlTypeName().equals((Object)rexLiteral2.getType().getSqlTypeName());
            }

            public int hashCode() {
                if (this.rexNode instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)this.rexNode;
                    return Objects.hash(rexLiteral.getValue(), rexLiteral.getType().getSqlTypeName());
                }
                return Objects.hash(this.rexNode);
            }
        }
    }

    protected static class RexTransformIntoBetween
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        RexTransformIntoBetween(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall inputCall) {
            RexNode node = super.visitCall(inputCall);
            if (node instanceof RexCall) {
                RexCall call = (RexCall)node;
                switch (call.getKind()) {
                    case AND: {
                        return this.processComparisons(call, SqlKind.LESS_THAN_OR_EQUAL, false);
                    }
                    case OR: {
                        return this.processComparisons(call, SqlKind.GREATER_THAN, true);
                    }
                }
            }
            return node;
        }

        private RexNode processComparisons(RexCall call, SqlKind forwardEdge, boolean invert) {
            DiGraph<RexNodeRef, RexCall> g = this.buildComparisonGraph(call.getOperands(), forwardEdge);
            IdentityHashMap<RexNode, BetweenCandidate> replacedNodes = new IdentityHashMap<RexNode, BetweenCandidate>();
            for (RexNodeRef n : g.nodes()) {
                Set<RexNodeRef> pred = g.predecessors(n);
                Set<RexNodeRef> succ = g.successors(n);
                if (pred.size() <= 0 || succ.size() <= 0) continue;
                RexNodeRef p = pred.iterator().next();
                RexNodeRef s = succ.iterator().next();
                RexNode between = this.rexBuilder.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{this.rexBuilder.makeLiteral(invert), n.node, p.node, s.node});
                BetweenCandidate bc = new BetweenCandidate(between, (RexNode)g.removeEdge(p, n), (RexNode)g.removeEdge(n, s));
                for (RexNode node : bc.oldNodes) {
                    replacedNodes.put(node, bc);
                }
            }
            if (replacedNodes.isEmpty()) {
                return call;
            }
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode o : call.getOperands()) {
                BetweenCandidate candidate = (BetweenCandidate)replacedNodes.get(o);
                if (candidate == null) {
                    newOperands.add(o);
                    continue;
                }
                if (candidate.used) continue;
                newOperands.add(candidate.newNode);
                candidate.used = true;
            }
            if (newOperands.size() == 1) {
                return (RexNode)newOperands.get(0);
            }
            return this.rexBuilder.makeCall(call.getOperator(), newOperands);
        }

        private DiGraph<RexNodeRef, RexCall> buildComparisonGraph(List<RexNode> operands, SqlKind cmpForward) {
            DiGraph<RexNodeRef, RexCall> g = new DiGraph<RexNodeRef, RexCall>();
            for (RexNode node : operands) {
                RexNode opB;
                RexNode opA;
                if (!(node instanceof RexCall)) continue;
                RexCall rexCall = (RexCall)node;
                SqlKind kind = rexCall.getKind();
                if (kind == cmpForward) {
                    opA = (RexNode)rexCall.getOperands().get(0);
                    opB = (RexNode)rexCall.getOperands().get(1);
                    g.putEdgeValue(new RexNodeRef(opA), new RexNodeRef(opB), rexCall);
                    continue;
                }
                if (kind != cmpForward.reverse()) continue;
                opA = (RexNode)rexCall.getOperands().get(1);
                opB = (RexNode)rexCall.getOperands().get(0);
                g.putEdgeValue(new RexNodeRef(opA), new RexNodeRef(opB), rexCall);
            }
            return g;
        }

        static class BetweenCandidate {
            private final RexNode newNode;
            private final RexNode[] oldNodes;
            private boolean used;

            public BetweenCandidate(RexNode newNode, RexNode ... oldNodes) {
                this.newNode = newNode;
                this.oldNodes = oldNodes;
            }
        }
    }

    static class Constraint {
        private final RexNode exprNode;
        private final RexNode constNode;

        public Constraint(RexNode exprNode, RexNode constNode) {
            this.exprNode = exprNode;
            this.constNode = constNode;
        }

        public static Constraint of(RexNode n) {
            if (!(n instanceof RexCall)) {
                return null;
            }
            RexCall call = (RexCall)n;
            if (call.getOperator().getKind() != SqlKind.EQUALS) {
                return null;
            }
            RexNode opA = (RexNode)call.operands.get(0);
            RexNode opB = (RexNode)call.operands.get(1);
            if (RexUtil.isNull((RexNode)opA) || RexUtil.isNull((RexNode)opB)) {
                return null;
            }
            if (Constraint.isConstExpr(opA) && Constraint.isColumnExpr(opB)) {
                return new Constraint(opB, opA);
            }
            if (Constraint.isColumnExpr(opA) && Constraint.isConstExpr(opB)) {
                return new Constraint(opA, opB);
            }
            return null;
        }

        private static boolean isColumnExpr(RexNode node) {
            return !node.getType().isStruct() && !HiveCalciteUtil.getInputRefs(node).isEmpty() && HiveCalciteUtil.isDeterministic(node);
        }

        private static boolean isConstExpr(RexNode node) {
            return !node.getType().isStruct() && HiveCalciteUtil.getInputRefs(node).isEmpty() && HiveCalciteUtil.isDeterministic(node);
        }

        public RexNodeRef getKey() {
            return new RexNodeRef(this.exprNode);
        }
    }

    static class RexNodeRef {
        public static Comparator<RexNodeRef> COMPARATOR = Comparator.comparing(o -> o.node.toString());
        private final RexNode node;

        public RexNodeRef(RexNode node) {
            this.node = node;
        }

        public RexNode getRexNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RexNodeRef) {
                RexNodeRef otherRef = (RexNodeRef)o;
                return this.node.toString().equals(otherRef.node.toString());
            }
            return false;
        }

        public String toString() {
            return "ref for:" + this.node.toString();
        }
    }

    public static class ProjectionExpressions
    extends HivePointLookupOptimizerRule {
        public ProjectionExpressions(int minNumORClauses) {
            super(ProjectionExpressions.operand(Project.class, (RelOptRuleOperandChildren)ProjectionExpressions.any()), minNumORClauses, "HivePointLookupOptimizerRule(ProjectionExpressions)");
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            boolean changed = false;
            RexBuilder rexBuilder = project.getCluster().getRexBuilder();
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
            for (RexNode oldNode : project.getProjects()) {
                RexNode newNode = this.analyzeRexNode(rexBuilder, oldNode);
                if (!newNode.toString().equals(oldNode.toString())) {
                    changed = true;
                    newProjects.add(newNode);
                    continue;
                }
                newProjects.add(oldNode);
            }
            if (!changed) {
                return;
            }
            Project newProject = project.copy(project.getTraitSet(), project.getInput(), newProjects, project.getRowType());
            call.transformTo((RelNode)newProject);
        }
    }

    public static class JoinCondition
    extends HivePointLookupOptimizerRule {
        public JoinCondition(int minNumORClauses) {
            super(JoinCondition.operand(Join.class, (RelOptRuleOperandChildren)JoinCondition.any()), minNumORClauses, "HivePointLookupOptimizerRule(JoinCondition)");
        }

        public void onMatch(RelOptRuleCall call) {
            RexNode condition;
            Join join = (Join)call.rel(0);
            RexBuilder rexBuilder = join.getCluster().getRexBuilder();
            RexNode newCondition = this.analyzeRexNode(rexBuilder, condition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)join.getCondition()));
            if (newCondition.toString().equals(condition.toString())) {
                return;
            }
            Join newNode = join.copy(join.getTraitSet(), newCondition, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
            call.transformTo((RelNode)newNode);
        }
    }

    public static class FilterCondition
    extends HivePointLookupOptimizerRule {
        public FilterCondition(int minNumORClauses) {
            super(FilterCondition.operand(Filter.class, (RelOptRuleOperandChildren)FilterCondition.any()), minNumORClauses, "HivePointLookupOptimizerRule(FilterCondition)");
        }

        public void onMatch(RelOptRuleCall call) {
            RexNode condition;
            Filter filter = (Filter)call.rel(0);
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            RexNode newCondition = this.analyzeRexNode(rexBuilder, condition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition()));
            if (newCondition.toString().equals(condition.toString())) {
                return;
            }
            Filter newNode = filter.copy(filter.getTraitSet(), filter.getInput(), newCondition);
            call.transformTo((RelNode)newNode);
        }
    }
}

