/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public final class FilterFlattenCorrelatedConditionRule
extends RelOptRule {
    public FilterFlattenCorrelatedConditionRule(Class<? extends Filter> clazz, RelBuilderFactory factory, String description) {
        super(FilterFlattenCorrelatedConditionRule.operand(clazz, (RelOptRuleOperandChildren)FilterFlattenCorrelatedConditionRule.any()), factory, description);
    }

    public boolean matches(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        return RexUtil.containsCorrelation((RexNode)filter.getCondition());
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        final RelBuilder b = call.builder();
        b.push(filter.getInput());
        final int proj = b.fields().size();
        final ArrayList projOperands = new ArrayList();
        RexNode newCondition = (RexNode)filter.getCondition().accept((RexVisitor)new RexShuttle(){

            public RexNode visitCall(RexCall call) {
                switch (call.getKind()) {
                    case EQUALS: 
                    case NOT_EQUALS: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        RexNode op0 = (RexNode)call.operands.get(0);
                        RexNode op1 = (RexNode)call.operands.get(1);
                        int replaceIndex = RexUtil.containsCorrelation((RexNode)op1) && FilterFlattenCorrelatedConditionRule.isUncorrelatedCall(op0) ? 0 : (RexUtil.containsCorrelation((RexNode)op0) && FilterFlattenCorrelatedConditionRule.isUncorrelatedCall(op1) ? 1 : -1);
                        if (replaceIndex == -1) break;
                        ArrayList<RexInputRef> copyOperands = new ArrayList<RexInputRef>((Collection<RexInputRef>)call.operands);
                        RexNode oldOp = (RexNode)call.operands.get(replaceIndex);
                        RexInputRef newOp = b.getRexBuilder().makeInputRef(oldOp.getType(), proj + projOperands.size());
                        projOperands.add(oldOp);
                        copyOperands.set(replaceIndex, newOp);
                        return call.clone(call.type, copyOperands);
                    }
                    case AND: 
                    case OR: {
                        return super.visitCall(call);
                    }
                }
                return call;
            }
        });
        if (newCondition.equals((Object)filter.getCondition())) {
            return;
        }
        b.projectPlus(projOperands);
        b.filter(new RexNode[]{newCondition});
        b.project((Iterable)b.fields(ImmutableBitSet.range((int)proj).asList()));
        call.transformTo(b.build());
    }

    private static boolean isUncorrelatedCall(RexNode node) {
        return node instanceof RexCall && !RexUtil.containsCorrelation((RexNode)node);
    }
}

