/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HiveIOExceptionHandlerUtil;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.HashableInputSplit;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BatchToRowInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveRecordReader;
import org.apache.hadoop.hive.ql.io.LlapCacheOnlyInputFormatInterface;
import org.apache.hadoop.hive.ql.io.LlapWrappableInputFormatInterface;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.hive.ql.io.NullScanFileSystem;
import org.apache.hadoop.hive.ql.io.PartitionAwareSplit;
import org.apache.hadoop.hive.ql.io.RecordReaderWrapper;
import org.apache.hadoop.hive.ql.io.SkippingTextInputFormat;
import org.apache.hadoop.hive.ql.io.ZeroRowsInputFormat;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.Ref;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveInputFormat<K extends WritableComparable, V extends Writable>
implements InputFormat<K, V>,
JobConfigurable {
    private static final String CLASS_NAME = HiveInputFormat.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final Map<Class, InputFormat<WritableComparable, Writable>> inputFormats = new ConcurrentHashMap<Class, InputFormat<WritableComparable, Writable>>();
    private JobConf job;
    protected Map<Path, PartitionDesc> pathToPartitionInfo;
    protected MapWork mrwork;

    public void configure(JobConf job) {
        this.job = job;
    }

    public static InputFormat<WritableComparable, Writable> wrapForLlap(InputFormat<WritableComparable, Writable> inputFormat, Configuration conf, PartitionDesc part) throws HiveException {
        InputFormat wrappedIf;
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (boolean)LlapProxy.isDaemon())) {
            return inputFormat;
        }
        String ifName = inputFormat.getClass().getCanonicalName();
        boolean isSupported = inputFormat instanceof LlapWrappableInputFormatInterface;
        boolean isCacheOnly = inputFormat instanceof LlapCacheOnlyInputFormatInterface;
        boolean isVectorized = Utilities.getIsVectorized(conf);
        if (!isVectorized) {
            isVectorized = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_NONVECTOR_WRAPPER_ENABLED) && Utilities.getPlanPath(conf) != null;
        }
        boolean isSerdeBased = false;
        if (isVectorized && !isSupported && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_ENABLED)) {
            isSupported = isSerdeBased = HiveInputFormat.checkInputFormatForLlapEncode(conf, ifName);
        }
        if (!(isSupported && isVectorized || isCacheOnly)) {
            LOG.info("Not using llap for " + ifName + ": supported = " + isSupported + ", vectorized = " + isVectorized + ", cache only = " + isCacheOnly);
            return inputFormat;
        }
        LOG.debug("Processing {}", (Object)ifName);
        LlapIo llapIo = LlapProxy.getIo();
        if (llapIo == null) {
            LOG.info("Not using LLAP IO because it is not initialized");
            return inputFormat;
        }
        Deserializer serde = null;
        if (isSerdeBased) {
            if (part == null) {
                if (isCacheOnly) {
                    LOG.info("Using cache only because there's no partition spec for SerDe-based IF");
                    HiveInputFormat.injectLlapCaches(inputFormat, (LlapIo<VectorizedRowBatch>)llapIo, conf);
                } else {
                    LOG.info("Not using LLAP IO because there's no partition spec for SerDe-based IF");
                }
                return inputFormat;
            }
            try {
                serde = part.getDeserializer(conf);
            }
            catch (Exception e) {
                throw new HiveException("Error creating SerDe for LLAP IO", (Throwable)e);
            }
        }
        if (isSupported && isVectorized && (wrappedIf = llapIo.getInputFormat(inputFormat, serde)) != null) {
            return HiveInputFormat.castInputFormat(wrappedIf);
        }
        if (isCacheOnly) {
            HiveInputFormat.injectLlapCaches(inputFormat, (LlapIo<VectorizedRowBatch>)llapIo, conf);
        }
        return inputFormat;
    }

    public static boolean checkInputFormatForLlapEncode(Configuration conf, String ifName) {
        String formatList = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_FORMATS);
        LOG.debug("Checking {} against {}", (Object)ifName, (Object)formatList);
        String[] formats = StringUtils.getStrings((String)formatList);
        if (formats != null) {
            for (String format : formats) {
                if (!ifName.equals(format)) continue;
                LOG.info("Using SerDe-based LLAP reader for " + ifName);
                return true;
            }
        }
        return false;
    }

    public static void injectLlapCaches(InputFormat<WritableComparable, Writable> inputFormat, LlapIo<VectorizedRowBatch> llapIo, Configuration conf) {
        LOG.info("Injecting LLAP caches into " + inputFormat.getClass().getCanonicalName());
        conf.setInt("parquet.read.allocation.size", 0x40000000);
        llapIo.initCacheOnlyInputFormat(inputFormat);
    }

    public static boolean canWrapForLlap(Class<? extends InputFormat> clazz, boolean checkVector) {
        return LlapWrappableInputFormatInterface.class.isAssignableFrom(clazz) && (!checkVector || BatchToRowInputFormat.class.isAssignableFrom(clazz));
    }

    public static boolean canInjectCaches(Class<? extends InputFormat> clazz, boolean isVectorized) {
        if (LlapCacheOnlyInputFormatInterface.VectorizedOnly.class.isAssignableFrom(clazz)) {
            return isVectorized;
        }
        return LlapCacheOnlyInputFormatInterface.class.isAssignableFrom(clazz);
    }

    private static <T, U, V, W> InputFormat<T, U> castInputFormat(InputFormat<V, W> from) {
        return from;
    }

    public static InputFormat<WritableComparable, Writable> getInputFormatFromCache(Class inputFormatClass, JobConf job) throws IOException {
        InputFormat instance = inputFormats.get(inputFormatClass);
        if (instance == null) {
            try {
                instance = (InputFormat)ReflectionUtil.newInstance((Class)inputFormatClass, (Configuration)job);
                String inputFormatName = inputFormatClass.getName().toLowerCase();
                if (!inputFormatName.contains("hbase")) {
                    inputFormats.put(inputFormatClass, (InputFormat<WritableComparable, Writable>)instance);
                }
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!", e);
            }
        }
        return instance;
    }

    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        HiveInputSplit hsplit = (HiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName, e);
        }
        if (this.mrwork == null || this.pathToPartitionInfo == null) {
            this.init(job);
        }
        boolean nonNative = false;
        PartitionDesc part = HiveFileFormatUtils.getFromPathRecursively(this.pathToPartitionInfo, hsplit.getPath(), null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found spec for " + hsplit.getPath() + " " + part + " from " + this.pathToPartitionInfo);
        }
        try {
            if (part != null && part.getTableDesc() != null) {
                Utilities.copyTableJobPropertiesToConf(part.getTableDesc(), job);
                nonNative = part.getTableDesc().isNonNative();
            }
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        Path splitPath = hsplit.getPath();
        this.pushProjectionsAndFiltersAndAsOf(job, splitPath);
        InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
        if (HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (boolean)LlapProxy.isDaemon())) {
            try {
                inputFormat = HiveInputFormat.wrapForLlap(inputFormat, (Configuration)job, part);
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }
        RecordReader innerReader = null;
        try {
            innerReader = RecordReaderWrapper.create(inputFormat, hsplit, part.getTableDesc(), job, reporter);
        }
        catch (Exception e) {
            Throwable rootCause = JavaUtils.findRootCause((Throwable)e);
            if (this.checkLimitReached(job) && (rootCause instanceof InterruptedException || rootCause instanceof ClosedByInterruptException)) {
                LOG.info("Ignoring exception while getting record reader as limit is reached", rootCause);
                innerReader = new NullRowsInputFormat.NullRowsRecordReader((Configuration)job, split);
            }
            innerReader = HiveIOExceptionHandlerUtil.handleRecordReaderCreationException((Exception)e, (JobConf)job);
        }
        HiveRecordReader rr = new HiveRecordReader(innerReader, job);
        rr.initIOContext(hsplit, job, inputFormatClass, innerReader);
        return rr;
    }

    private boolean checkLimitReached(JobConf job) {
        return LimitOperator.checkLimitReachedForVertex(job, job.get("tez.mapreduce.vertex.name"));
    }

    protected void init(JobConf job) {
        if (this.mrwork == null || this.pathToPartitionInfo == null) {
            if (HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                this.mrwork = (MapWork)Utilities.getMergeWork((Configuration)job);
                if (this.mrwork == null) {
                    this.mrwork = Utilities.getMapWork((Configuration)job);
                }
            } else {
                this.mrwork = Utilities.getMapWork((Configuration)job);
            }
            this.pathToPartitionInfo = this.mrwork.getPathToPartitionInfo();
        }
    }

    private void addSplitsForGroup(List<Path> dirs, TableScanOperator tableScan, JobConf conf, InputFormat inputFormat, Class<? extends InputFormat> inputFormatClass, int splits, TableDesc table, List<InputSplit> result) throws IOException {
        String tableName = table.getTableName();
        ValidWriteIdList validWriteIdList = AcidUtils.getTableValidWriteIdList((Configuration)conf, tableName == null ? null : HiveStringUtils.normalizeIdentifier((String)tableName));
        ValidWriteIdList validMmWriteIdList = this.getMmValidWriteIds(conf, table, validWriteIdList);
        try {
            Utilities.copyJobSecretToTableProperties(table);
            Utilities.copyTablePropertiesToConf(table, conf);
            if (tableScan != null) {
                AcidUtils.setAcidOperationalProperties((Configuration)conf, ((TableScanDesc)tableScan.getConf()).isTranscationalTable(), ((TableScanDesc)tableScan.getConf()).getAcidOperationalProperties());
                if (((TableScanDesc)tableScan.getConf()).isTranscationalTable() && validWriteIdList == null) {
                    throw new IOException("Acid table: " + table.getTableName() + " is missing from the ValidWriteIdList config: " + conf.get("hive.txn.tables.valid.writeids"));
                }
                if (validWriteIdList != null) {
                    AcidUtils.setValidWriteIdList((Configuration)conf, validWriteIdList);
                }
            }
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        if (tableScan != null) {
            HiveInputFormat.pushFiltersAndAsOf(conf, tableScan, this.mrwork);
        }
        List<Path> dirsWithFileOriginals = Collections.synchronizedList(new ArrayList());
        List<Path> finalDirs = Collections.synchronizedList(new ArrayList());
        HiveInputFormat.processPathsForMmRead(dirs, (Configuration)conf, validMmWriteIdList, finalDirs, dirsWithFileOriginals);
        if (finalDirs.isEmpty() && dirsWithFileOriginals.isEmpty()) {
            if (!conf.getBoolean("ENSURE_OPERATORS_EXECUTED", false)) {
                LOG.warn("No valid inputs found in " + dirs);
            } else if (validMmWriteIdList != null) {
                result.add(new HiveInputSplit((InputSplit)new NullRowsInputFormat.DummyInputSplit(dirs.get(0).toString()), ZeroRowsInputFormat.class.getName()));
            }
            return;
        }
        conf.setInputFormat(inputFormat.getClass());
        if (table != null) {
            int headerCount = Utilities.getHeaderCount(table);
            int footerCount = Utilities.getFooterCount(table, conf);
            if (headerCount != 0 || footerCount != 0) {
                if (TextInputFormat.class.isAssignableFrom(inputFormatClass) && this.isUncompressedInput(finalDirs, (Configuration)conf)) {
                    SkippingTextInputFormat skippingTextInputFormat = new SkippingTextInputFormat();
                    skippingTextInputFormat.configure(conf, headerCount, footerCount);
                    inputFormat = skippingTextInputFormat;
                } else {
                    HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MIN_SPLIT_SIZE, (long)Long.MAX_VALUE);
                }
            }
        }
        if (!finalDirs.isEmpty()) {
            InputSplit[] iss;
            FileInputFormat.setInputPaths((JobConf)conf, (Path[])finalDirs.toArray(new Path[finalDirs.size()]));
            for (InputSplit is : iss = inputFormat.getSplits(conf, splits)) {
                result.add(new HiveInputSplit(is, inputFormatClass.getName()));
            }
        }
        if (!dirsWithFileOriginals.isEmpty()) {
            InputSplit[] iss;
            JobConf nonRecConf = HiveInputFormat.createConfForMmOriginalsSplit(conf, dirsWithFileOriginals);
            for (InputSplit is : iss = inputFormat.getSplits(nonRecConf, splits)) {
                result.add(new HiveInputSplit(is, inputFormatClass.getName()));
            }
        }
        if (result.isEmpty() && conf.getBoolean("ENSURE_OPERATORS_EXECUTED", false)) {
            result.add(new HiveInputSplit((InputSplit)new NullRowsInputFormat.DummyInputSplit(finalDirs.get(0).toString()), ZeroRowsInputFormat.class.getName()));
        }
    }

    public static JobConf createConfForMmOriginalsSplit(JobConf conf, List<Path> dirsWithFileOriginals) {
        JobConf nonRecConf = new JobConf((Configuration)conf);
        FileInputFormat.setInputPaths((JobConf)nonRecConf, (Path[])dirsWithFileOriginals.toArray(new Path[dirsWithFileOriginals.size()]));
        nonRecConf.setBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
        nonRecConf.setBoolean("mapred.input.dir.recursive", false);
        nonRecConf.setBoolean("mapreduce.input.fileinputformat.input.dir.nonrecursive.ignore.subdirs", true);
        return nonRecConf;
    }

    protected ValidWriteIdList getMmValidWriteIds(JobConf conf, TableDesc table, ValidWriteIdList validWriteIdList) throws IOException {
        if (!AcidUtils.isInsertOnlyTable(table.getProperties())) {
            return null;
        }
        if (validWriteIdList == null && (validWriteIdList = AcidUtils.getTableValidWriteIdList((Configuration)conf, table.getTableName())) == null) {
            throw new IOException("Insert-Only table: " + table.getTableName() + " is missing from the ValidWriteIdList config: " + conf.get("hive.txn.tables.valid.writeids"));
        }
        return validWriteIdList;
    }

    public boolean isUncompressedInput(List<Path> finalPaths, Configuration conf) throws IOException {
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        for (Path curr : finalPaths) {
            FileSystem fs = curr.getFileSystem(conf);
            if (fs.isDirectory(curr)) {
                ArrayList results = new ArrayList();
                FileUtils.listStatusRecursively((FileSystem)fs, (FileStatus)fs.getFileStatus(curr), results);
                for (FileStatus fileStatus : results) {
                    if (compressionCodecs.getCodec(fileStatus.getPath()) == null) continue;
                    return false;
                }
                continue;
            }
            if (compressionCodecs.getCodec(curr) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPathsForMmRead(List<Path> dirs, Configuration conf, ValidWriteIdList validWriteIdList, List<Path> finalPaths, List<Path> pathsWithFileOriginals) throws IOException {
        if (validWriteIdList == null) {
            finalPaths.addAll(dirs);
            return;
        }
        boolean allowOriginals = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MM_ALLOW_ORIGINALS);
        int numThreads = Integer.min(HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPUTE_SPLITS_NUM_THREADS), dirs.size());
        ArrayList<Future<Void>> pathFutures = new ArrayList<Future<Void>>();
        ExecutorService pool = null;
        if (numThreads > 1) {
            pool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MM-Split-Paths-%d").build());
        }
        try {
            for (Path path : dirs) {
                if (pool != null) {
                    Future<Void> future = pool.submit(() -> {
                        HiveInputFormat.processForWriteIdsForMmRead(dir, conf, validWriteIdList, allowOriginals, finalPaths, pathsWithFileOriginals);
                        return null;
                    });
                    pathFutures.add(future);
                    continue;
                }
                HiveInputFormat.processForWriteIdsForMmRead(path, conf, validWriteIdList, allowOriginals, finalPaths, pathsWithFileOriginals);
            }
            try {
                for (Future future : pathFutures) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                for (Future future : pathFutures) {
                    future.cancel(true);
                }
                throw new IOException(e);
            }
        }
        finally {
            if (pool != null) {
                pool.shutdown();
            }
        }
    }

    private static void processForWriteIdsForMmRead(Path dir, Configuration conf, ValidWriteIdList validWriteIdList, boolean allowOriginals, List<Path> finalPaths, List<Path> pathsWithFileOriginals) throws IOException {
        FileSystem fs = dir.getFileSystem(conf);
        Utilities.FILE_OP_LOGGER.trace("Checking {} for inputs", (Object)dir);
        if (fs instanceof NullScanFileSystem) {
            finalPaths.add(dir);
            return;
        }
        boolean hasOriginalFiles = false;
        boolean hasAcidDirs = false;
        ArrayList<Path> originalDirectories = new ArrayList<Path>();
        for (FileStatus file : fs.listStatus(dir, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
            Path currDir = file.getPath();
            Utilities.FILE_OP_LOGGER.trace("Checking {} for being an input", (Object)currDir);
            if (!file.isDirectory()) {
                hasOriginalFiles = true;
                continue;
            }
            if (AcidUtils.extractWriteId(currDir) == null) {
                if (allowOriginals) {
                    originalDirectories.add(currDir);
                    continue;
                }
                Utilities.FILE_OP_LOGGER.debug("Ignoring unknown (original?) directory {}", (Object)currDir);
                continue;
            }
            hasAcidDirs = true;
        }
        if (hasAcidDirs) {
            AcidDirectory dirInfo = AcidUtils.getAcidState(fs, dir, conf, validWriteIdList, (Ref<Boolean>)Ref.from((Object)false), true);
            Path base = dirInfo.getBaseDirectory();
            if (base != null) {
                Utilities.FILE_OP_LOGGER.debug("Adding input {}", (Object)base);
                finalPaths.add(base);
                originalDirectories.clear();
                hasOriginalFiles = false;
            }
            for (AcidUtils.ParsedDelta delta : dirInfo.getCurrentDirectories()) {
                Utilities.FILE_OP_LOGGER.debug("Adding input {}", (Object)delta.getPath());
                finalPaths.add(delta.getPath());
            }
        }
        if (!originalDirectories.isEmpty()) {
            Utilities.FILE_OP_LOGGER.debug("Adding original directories {}", originalDirectories);
            finalPaths.addAll(originalDirectories);
        }
        if (hasOriginalFiles) {
            if (allowOriginals) {
                Utilities.FILE_OP_LOGGER.debug("Directory has original files {}", (Object)dir);
                pathsWithFileOriginals.add(dir);
            } else {
                Utilities.FILE_OP_LOGGER.debug("Ignoring unknown (original?) files in {}", (Object)dir);
            }
        }
    }

    Path[] getInputPaths(JobConf job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            if (HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                try {
                    List<Path> paths = Utilities.getInputPathsTez(job, this.mrwork);
                    dirs = paths.toArray(new Path[paths.size()]);
                }
                catch (Exception e) {
                    throw new IOException("Could not create input files", e);
                }
            } else {
                throw new IOException("No input paths specified in job");
            }
        }
        StringInternUtils.internUriStringsInPathArray((Path[])dirs);
        return dirs;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "getSplits");
        this.init(job);
        Object[] dirs = this.getInputPaths(job);
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        ArrayList<Path> currentDirs = new ArrayList<Path>();
        Class<? extends InputFormat> currentInputFormatClass = null;
        TableDesc currentTable = null;
        TableScanOperator currentTableScan = null;
        boolean pushDownProjection = false;
        StringBuilder readColumnsBuffer = new StringBuilder(newjob.get("hive.io.file.readcolumn.ids", ""));
        StringBuilder readColumnNamesBuffer = new StringBuilder(newjob.get("hive.io.file.readcolumn.names", ""));
        boolean fetchVirtualColumns = newjob.getBoolean("hive.io.file.fetch.virtual.columns", false);
        for (Path path : dirs) {
            PartitionDesc part = HiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, path);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            TableDesc table = part.getTableDesc();
            TableScanOperator tableScan = null;
            List<String> aliases = this.mrwork.getPathToAliases().get(path);
            if (aliases != null && aliases.size() == 1) {
                Operator<? extends OperatorDesc> op = this.mrwork.getAliasToWork().get(aliases.get(0));
                if (op != null && op instanceof TableScanOperator) {
                    tableScan = (TableScanOperator)op;
                    readColumnsBuffer.setLength(0);
                    readColumnNamesBuffer.setLength(0);
                    ColumnProjectionUtils.appendReadColumns((StringBuilder)readColumnsBuffer, (StringBuilder)readColumnNamesBuffer, tableScan.getNeededColumnIDs(), tableScan.getNeededColumns());
                    fetchVirtualColumns = ((TableScanDesc)tableScan.getConf()).hasVirtualCols();
                    pushDownProjection = true;
                    HiveInputFormat.pushFiltersAndAsOf(newjob, tableScan, this.mrwork);
                    this.addGroupingDetails(newjob, tableScan);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("aliases: {} pathToAliases: {} dir: {}", new Object[]{aliases, this.mrwork.getPathToAliases(), path});
            }
            if (!currentDirs.isEmpty() && inputFormatClass.equals(currentInputFormatClass) && table.equals(currentTable) && tableScan == currentTableScan) {
                currentDirs.add(path);
                continue;
            }
            if (!currentDirs.isEmpty()) {
                LOG.info("Generating splits as currentDirs is not empty. currentDirs: {}", currentDirs);
                if (pushDownProjection) {
                    this.pushProjection(newjob, readColumnsBuffer, readColumnNamesBuffer, fetchVirtualColumns);
                }
                this.addSplitsForGroup(currentDirs, currentTableScan, newjob, HiveInputFormat.getInputFormatFromCache(currentInputFormatClass, job), currentInputFormatClass, currentDirs.size() * (numSplits / dirs.length), currentTable, result);
            }
            currentDirs.clear();
            currentDirs.add(path);
            currentTableScan = tableScan;
            currentTable = table;
            currentInputFormatClass = inputFormatClass;
        }
        if (pushDownProjection) {
            this.pushProjection(newjob, readColumnsBuffer, readColumnNamesBuffer, fetchVirtualColumns);
        }
        if (dirs.length != 0) {
            LOG.info("Generating splits for dirs: {}", dirs);
            this.addSplitsForGroup(currentDirs, currentTableScan, newjob, HiveInputFormat.getInputFormatFromCache(currentInputFormatClass, job), currentInputFormatClass, currentDirs.size() * (numSplits / dirs.length), currentTable, result);
        }
        Utilities.clearWorkMapForConf((Configuration)job);
        LOG.info("number of splits " + result.size());
        perfLogger.perfLogEnd(CLASS_NAME, "getSplits");
        return result.toArray(new HiveInputSplit[result.size()]);
    }

    private void pushProjection(JobConf newjob, StringBuilder readColumnsBuffer, StringBuilder readColumnNamesBuffer, boolean fetchVirtualColumns) {
        String readColIds = readColumnsBuffer.toString();
        String readColNames = readColumnNamesBuffer.toString();
        newjob.setBoolean("hive.io.file.read.all.columns", false);
        newjob.set("hive.io.file.readcolumn.ids", readColIds);
        newjob.set("hive.io.file.readcolumn.names", readColNames);
        newjob.setBoolean("hive.io.file.fetch.virtual.columns", fetchVirtualColumns);
        LOG.info("{} = {}", (Object)"hive.io.file.readcolumn.ids", (Object)readColIds);
        LOG.info("{} = {}", (Object)"hive.io.file.readcolumn.names", (Object)readColNames);
        LOG.info("{} = {}", (Object)"hive.io.file.fetch.virtual.columns", (Object)fetchVirtualColumns);
    }

    protected static PartitionDesc getPartitionDescFromPath(Map<Path, PartitionDesc> pathToPartitionInfo, Path dir) throws IOException {
        PartitionDesc partDesc = pathToPartitionInfo.get(dir);
        if (partDesc == null) {
            partDesc = pathToPartitionInfo.get(Path.getPathWithoutSchemeAndAuthority((Path)dir));
        }
        if (partDesc == null) {
            throw new IOException("cannot find dir = " + dir.toString() + " in " + pathToPartitionInfo);
        }
        return partDesc;
    }

    public static void pushFiltersAndAsOf(JobConf jobConf, TableScanOperator tableScan, MapWork mrwork) {
        Serializable filterObject;
        boolean hasExpr;
        HiveInputFormat.pushAsOf((Configuration)jobConf, tableScan);
        jobConf.unset("hive.io.filter.text");
        jobConf.unset("hive.io.filter.expr.serialized");
        Utilities.unsetSchemaEvolution((Configuration)jobConf);
        TableScanDesc scanDesc = (TableScanDesc)tableScan.getConf();
        if (scanDesc == null) {
            return;
        }
        Utilities.addTableSchemaToConf((Configuration)jobConf, tableScan);
        Utilities.setPartitionColumnNames((Configuration)jobConf, tableScan);
        Utilities.setColumnNameList(jobConf, tableScan);
        Utilities.setColumnTypeList(jobConf, tableScan);
        ExprNodeGenericFuncDesc filterExpr = scanDesc.getFilterExpr();
        String pruningFilter = jobConf.get("hive.io.pruning.filter");
        if (pruningFilter != null) {
            ExprNodeGenericFuncDesc pruningExpr = SerializationUtilities.deserializeExpression(pruningFilter);
            filterExpr = filterExpr != null ? ExprNodeDescUtils.and(filterExpr, pruningExpr) : pruningExpr;
            scanDesc.setFilterExpr(filterExpr);
            scanDesc.setSerializedFilterExpr(SerializationUtilities.serializeExpression(filterExpr));
            jobConf.unset("hive.io.pruning.filter");
        }
        if (filterExpr == null) {
            return;
        }
        if (mrwork != null && mrwork.getAliases() != null && mrwork.getAliases().size() > 1 && jobConf.get(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname).equals("mr") && (scanDesc.getTableMetadata() == null || !(scanDesc.getTableMetadata().getStorageHandler() instanceof HiveStoragePredicateHandler))) {
            return;
        }
        String serializedFilterObj = scanDesc.getSerializedFilterObject();
        String serializedFilterExpr = scanDesc.getSerializedFilterExpr();
        boolean hasObj = serializedFilterObj != null;
        boolean bl = hasExpr = serializedFilterExpr != null;
        if (!hasObj && (filterObject = scanDesc.getFilterObject()) != null) {
            serializedFilterObj = SerializationUtilities.serializeObject(filterObject);
        }
        if (serializedFilterObj != null) {
            jobConf.set("hive.io.filter.object", serializedFilterObj);
        }
        if (!hasExpr) {
            serializedFilterExpr = SerializationUtilities.serializeExpression(filterExpr);
        }
        String filterText = filterExpr.getExprString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pushdown initiated with filterText = " + filterText + ", filterExpr = " + filterExpr + ", serializedFilterExpr = " + serializedFilterExpr + " (" + (hasExpr ? "desc" : "new") + ")" + (String)(serializedFilterObj == null ? "" : ", serializedFilterObj = " + serializedFilterObj + " (" + (hasObj ? "desc" : "new") + ")"));
        }
        jobConf.set("hive.io.filter.text", filterText);
        jobConf.set("hive.io.filter.expr.serialized", serializedFilterExpr);
    }

    protected static void pushAsOf(Configuration jobConf, TableScanOperator ts) {
        TableScanDesc scanDesc = (TableScanDesc)ts.getConf();
        if (scanDesc.getAsOfTimestamp() != null) {
            ZoneId timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
            TimestampTZ time = TimestampTZUtil.parse((String)scanDesc.getAsOfTimestamp(), (ZoneId)timeZone);
            jobConf.set("hive.io.as.of.timestamp", Long.toString(time.toEpochMilli()));
        }
        if (scanDesc.getAsOfVersion() != null) {
            jobConf.set("hive.io.as.of.version", scanDesc.getAsOfVersion());
        }
        if (scanDesc.getVersionIntervalFrom() != null) {
            jobConf.set("hive.io.version.from", scanDesc.getVersionIntervalFrom());
        }
        if (scanDesc.getSnapshotRef() != null) {
            jobConf.set("hive.io.snapshot.ref", scanDesc.getSnapshotRef());
        }
    }

    protected void pushProjectionsAndFiltersAndAsOf(JobConf jobConf, Path splitPath) {
        Path splitPathWithNoSchema = Path.getPathWithoutSchemeAndAuthority((Path)splitPath);
        if (this.mrwork == null) {
            this.init(this.job);
        }
        if (this.mrwork.getPathToAliases() == null) {
            return;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        Iterator<Map.Entry<Path, List<String>>> iterator = this.mrwork.getPathToAliases().entrySet().iterator();
        HashSet splitParentPaths = null;
        int pathsSize = this.mrwork.getPathToAliases().entrySet().size();
        while (iterator.hasNext()) {
            boolean match;
            Map.Entry<Path, List<String>> entry = iterator.next();
            Path key = entry.getKey();
            if (pathsSize > 1) {
                if (splitParentPaths == null) {
                    splitParentPaths = new HashSet();
                    FileUtils.populateParentPaths(splitParentPaths, (Path)splitPath);
                    FileUtils.populateParentPaths(splitParentPaths, (Path)splitPathWithNoSchema);
                }
                match = splitParentPaths.contains(key);
            } else {
                boolean bl = match = FileUtils.isPathWithinSubtree((Path)splitPath, (Path)key) || FileUtils.isPathWithinSubtree((Path)splitPathWithNoSchema, (Path)key);
            }
            if (!match) continue;
            List<String> list = entry.getValue();
            for (String val : list) {
                aliases.add(val);
            }
        }
        for (String alias : aliases) {
            Operator<? extends OperatorDesc> op = this.mrwork.getAliasToWork().get(alias);
            if (!(op instanceof TableScanOperator)) continue;
            TableScanOperator ts = (TableScanOperator)op;
            ColumnProjectionUtils.appendReadColumns((Configuration)jobConf, ts.getNeededColumnIDs(), ts.getNeededColumns(), ts.getNeededNestedColumnPaths(), (boolean)((TableScanDesc)ts.getConf()).hasVirtualCols());
            HiveInputFormat.pushFiltersAndAsOf(jobConf, ts, this.mrwork);
            AcidUtils.setAcidOperationalProperties((Configuration)this.job, ((TableScanDesc)ts.getConf()).isTranscationalTable(), ((TableScanDesc)ts.getConf()).getAcidOperationalProperties());
            AcidUtils.setValidWriteIdList((Configuration)this.job, (TableScanDesc)ts.getConf());
        }
    }

    private void addGroupingDetails(JobConf conf, TableScanOperator tableScan) {
        List<String> groupingPartitionColumns = ((TableScanDesc)tableScan.getConf()).getGroupingPartitionColumns();
        if (groupingPartitionColumns != null) {
            conf.setStrings("hive.io.grouping.partition.columns", groupingPartitionColumns.toArray(new String[0]));
            conf.setInt("hive.io.grouping.num.buckets", ((TableScanDesc)tableScan.getConf()).getGroupingNumBuckets().intValue());
        }
    }

    public static class HiveInputSplit
    extends FileSplit
    implements InputSplit,
    Configurable,
    HashableInputSplit {
        InputSplit inputSplit;
        String inputFormatClassName;
        Configuration conf;

        public HiveInputSplit() {
            super((Path)null, 0L, 0L, (String[])null);
        }

        public HiveInputSplit(InputSplit inputSplit, String inputFormatClassName) {
            super((Path)null, 0L, 0L, (String[])null);
            this.inputSplit = inputSplit;
            this.inputFormatClassName = inputFormatClassName;
        }

        public InputSplit getInputSplit() {
            return this.inputSplit;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public OptionalInt getBucketId() {
            if (this.inputSplit instanceof PartitionAwareSplit) {
                return ((PartitionAwareSplit)this.inputSplit).getBucketId();
            }
            int bucketId = Utilities.parseSplitBucket(this.inputSplit);
            return bucketId == -1 ? OptionalInt.empty() : OptionalInt.of(bucketId);
        }

        public Path getPath() {
            if (this.inputSplit instanceof FileSplit) {
                return ((FileSplit)this.inputSplit).getPath();
            }
            throw new RuntimeException(this.inputSplit + " is not a FileSplit");
        }

        public long getStart() {
            if (this.inputSplit instanceof FileSplit) {
                return ((FileSplit)this.inputSplit).getStart();
            }
            return 0L;
        }

        public String toString() {
            return this.inputFormatClassName + ":" + this.inputSplit.toString();
        }

        public long getLength() {
            long r = 0L;
            try {
                r = this.inputSplit.getLength();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return r;
        }

        public String[] getLocations() throws IOException {
            return this.inputSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            String inputSplitClassName = in.readUTF();
            try {
                this.inputSplit = (InputSplit)ReflectionUtil.newInstance((Class)this.conf.getClassByName(inputSplitClassName), (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputSplit class = " + inputSplitClassName + ":" + e.getMessage(), e);
            }
            this.inputSplit.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.inputSplit.getClass().getName());
            this.inputSplit.write(out);
            out.writeUTF(this.inputFormatClassName);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public byte[] getBytesForHash() {
            if (this.inputSplit instanceof HashableInputSplit) {
                return ((HashableInputSplit)this.inputSplit).getBytesForHash();
            }
            byte[] pathBytes = this.getPath().toString().getBytes();
            byte[] allBytes = new byte[pathBytes.length + 8];
            System.arraycopy(pathBytes, 0, allBytes, 0, pathBytes.length);
            SerDeUtils.writeLong((byte[])allBytes, (int)pathBytes.length, (long)(this.getStart() >> 3));
            return allBytes;
        }

        public byte[] getBytesForEquality() {
            if (this.inputSplit instanceof HashableInputSplit) {
                return ((HashableInputSplit)this.inputSplit).getBytesForHash();
            }
            byte[] pathBytes = this.getPath().toString().getBytes();
            byte[] allBytes = new byte[pathBytes.length + 8];
            System.arraycopy(pathBytes, 0, allBytes, 0, pathBytes.length);
            SerDeUtils.writeLong((byte[])allBytes, (int)pathBytes.length, (long)this.getStart());
            return allBytes;
        }
    }

    public static final class HiveInputSplitComparator
    implements Comparator<HiveInputSplit> {
        @Override
        public int compare(HiveInputSplit o1, HiveInputSplit o2) {
            int pathCompare = this.comparePath(o1.getPath(), o2.getPath());
            if (pathCompare != 0) {
                return pathCompare;
            }
            return Long.compare(o1.getStart(), o2.getStart());
        }

        private int comparePath(Path p1, Path p2) {
            return p1.compareTo(p2);
        }
    }
}

