/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(BucketIdentifier.class);
    private final long writeId;
    private final int bucketId;

    public static BucketIdentifier from(Configuration conf, Path path) {
        if (!AcidUtils.isInsertOnlyFetchBucketId(conf)) {
            return null;
        }
        return BucketIdentifier.parsePath(path);
    }

    public static BucketIdentifier parsePath(Path path) {
        try {
            boolean isDelta;
            Path parent = path.getParent();
            if (parent == null) {
                return null;
            }
            boolean isBase = parent.getName().startsWith("base_");
            boolean bl = isDelta = parent.getName().startsWith("delta_") || parent.getName().startsWith("delete_delta_");
            if (isBase || isDelta) {
                if (isBase) {
                    AcidUtils.ParsedBaseLight parsedBaseLight = AcidUtils.ParsedBaseLight.parseBase(parent);
                    if (parsedBaseLight.getVisibilityTxnId() > 0L) {
                        return null;
                    }
                    return new BucketIdentifier(parsedBaseLight.getWriteId(), AcidUtils.parseBucketId(path));
                }
                AcidUtils.ParsedDeltaLight pd = AcidUtils.ParsedDeltaLight.parse(parent);
                if (pd.getMinWriteId() != pd.getMaxWriteId()) {
                    return null;
                }
                return new BucketIdentifier(pd.getMinWriteId(), AcidUtils.parseBucketId(path));
            }
        }
        catch (NumberFormatException ex) {
            LOG.warn("Error while parsing path " + path, (Throwable)ex);
        }
        return null;
    }

    public BucketIdentifier(long writeId, int bucket) {
        this.writeId = writeId;
        this.bucketId = bucket;
    }

    public long getWriteId() {
        return this.writeId;
    }

    public int getBucketProperty() {
        return this.bucketId;
    }

    public String toString() {
        return "BucketIdentifier{writeId=" + this.writeId + ", bucketId=" + this.bucketId + "}";
    }
}

