/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class Decimal64ColDivideDecimal64Column
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private static final long[] powerOfTenTable = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public Decimal64ColDivideDecimal64Column(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, colNum2, outputColumnNum);
    }

    public Decimal64ColDivideDecimal64Column() {
    }

    private long roundingDivision(long divident, long divisor) {
        long absDivident = Math.abs(divident);
        long absDivisor = Math.abs(divisor);
        boolean differentSigns = divident > 0L ^ divisor > 0L;
        long remainder = absDivident % absDivisor;
        long result = absDivident / absDivisor;
        if (remainder * 2L >= absDivisor) {
            ++result;
        }
        if (differentSigns) {
            return -1L * result;
        }
        return result;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        block25: {
            long outputDecimal64AbsMax;
            long scaleFactor;
            boolean[] outputIsNull;
            long[] vector2;
            long[] vector1;
            int[] sel;
            Decimal64ColumnVector outputColVector;
            Decimal64ColumnVector inputColVector2;
            Decimal64ColumnVector inputColVector1;
            int n;
            block24: {
                long result;
                n = batch.size;
                if (n == 0) {
                    return;
                }
                if (this.childExpressions != null) {
                    super.evaluateChildren(batch);
                }
                inputColVector1 = (Decimal64ColumnVector)batch.cols[this.inputColumnNum[0]];
                inputColVector2 = (Decimal64ColumnVector)batch.cols[this.inputColumnNum[1]];
                outputColVector = (Decimal64ColumnVector)batch.cols[this.outputColumnNum];
                sel = batch.selected;
                vector1 = inputColVector1.vector;
                vector2 = inputColVector2.vector;
                long[] outputVector = outputColVector.vector;
                outputIsNull = outputColVector.isNull;
                int outputScale = ((DecimalTypeInfo)this.outputTypeInfo).scale();
                scaleFactor = powerOfTenTable[outputScale];
                outputDecimal64AbsMax = HiveDecimalWritable.getDecimal64AbsMax((int)outputColVector.precision);
                NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
                if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block24;
                if (vector2[0] == 0L) {
                    outputColVector.noNulls = false;
                    outputColVector.isRepeating = true;
                    Arrays.fill(outputIsNull, true);
                    NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
                    return;
                }
                outputVector[0] = result = this.roundingDivision(vector1[0] * scaleFactor, vector2[0]);
                if (Math.abs(result) <= outputDecimal64AbsMax) break block25;
                outputColVector.noNulls = false;
                outputIsNull[0] = true;
                break block25;
            }
            if (inputColVector1.isRepeating) {
                long repeatedValue1 = vector1[0];
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        if (vector2[i] == 0L) {
                            outputColVector.noNulls = false;
                            outputIsNull[i] = true;
                            outputVector[i] = 1L;
                            continue;
                        }
                        outputVector[i] = result = this.roundingDivision(repeatedValue1 * scaleFactor, vector2[i]);
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        long result;
                        if (vector2[i] == 0L) {
                            outputColVector.noNulls = false;
                            outputIsNull[i] = true;
                            outputVector[i] = 1L;
                            continue;
                        }
                        outputVector[i] = result = this.roundingDivision(repeatedValue1 * scaleFactor, vector2[i]);
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                long repeatedValue2 = vector2[0];
                if (repeatedValue2 == 0L) {
                    outputColVector.noNulls = false;
                    outputColVector.isRepeating = true;
                    Arrays.fill(outputIsNull, true);
                    NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
                    return;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputVector[i] = result = this.roundingDivision(vector1[i] * scaleFactor, repeatedValue2);
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        long result;
                        outputVector[i] = result = this.roundingDivision(vector1[i] * scaleFactor, repeatedValue2);
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    long result;
                    int i = sel[j];
                    if (vector2[i] == 0L) {
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = result = this.roundingDivision(vector1[i] * scaleFactor, vector2[i]);
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputColVector.noNulls = false;
                    outputIsNull[i] = true;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    long result;
                    if (vector2[i] == 0L) {
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = result = this.roundingDivision(vector1[i] * scaleFactor, vector2[i]);
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputColVector.noNulls = false;
                    outputIsNull[i] = true;
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }

    @Override
    public boolean shouldConvertDecimal64ToDecimal() {
        return false;
    }
}

