/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.snapshotref;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.snapshotref.AlterTableSnapshotRefDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class AlterTableDropSnapshotRefAnalyzer
extends AbstractAlterTableAnalyzer {
    protected AlterTableType alterTableType;

    public AlterTableDropSnapshotRefAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        boolean ifExists = command.getFirstChildWithType(1050) != null;
        Table table = this.getTable(tableName);
        DDLUtils.validateTableIsIceberg(table);
        this.inputs.add(new ReadEntity(table));
        this.validateAlterTableType(table, this.alterTableType, false);
        String refName = ifExists ? command.getChild(1).getText() : command.getChild(0).getText();
        AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropSnapshotRefSpec = new AlterTableSnapshotRefSpec.DropSnapshotRefSpec(refName, ifExists);
        AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.DropSnapshotRefSpec> alterTableSnapshotRefSpec = new AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.DropSnapshotRefSpec>(this.alterTableType, dropSnapshotRefSpec);
        AlterTableSnapshotRefDesc alterTableDesc = new AlterTableSnapshotRefDesc(this.alterTableType, tableName, alterTableSnapshotRefSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTableDesc)));
    }
}

