/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ShowPartitionsOperation
extends DDLOperation<ShowPartitionsDesc> {
    public ShowPartitionsOperation(DDLOperationContext context, ShowPartitionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table tbl = this.context.getDb().getTable(((ShowPartitionsDesc)this.desc).getTabName());
        if (!tbl.isPartitioned()) {
            this.context.getTask().setException(new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{((ShowPartitionsDesc)this.desc).getTabName()}));
            return ErrorMsg.TABLE_NOT_PARTITIONED.getErrorCode();
        }
        List<String> parts = ((ShowPartitionsDesc)this.desc).getCond() != null || ((ShowPartitionsDesc)this.desc).getOrder() != null ? this.getPartitionNames(tbl) : (((ShowPartitionsDesc)this.desc).getPartSpec() != null ? this.context.getDb().getPartitionNames(tbl, ((ShowPartitionsDesc)this.desc).getPartSpec(), ((ShowPartitionsDesc)this.desc).getLimit()) : this.context.getDb().getPartitionNames(tbl, ((ShowPartitionsDesc)this.desc).getLimit()));
        try (DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowPartitionsDesc)this.desc).getResFile()), this.context);){
            ShowPartitionsFormatter formatter = ShowPartitionsFormatter.getFormatter(this.context.getConf());
            formatter.showTablePartitions(outStream, parts);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"show partitions for table " + ((ShowPartitionsDesc)this.desc).getTabName()});
        }
        return 0;
    }

    private List<String> getPartitionNames(Table tbl) throws HiveException {
        ExprNodeDesc predicate = ((ShowPartitionsDesc)this.desc).getCond();
        if (((ShowPartitionsDesc)this.desc).getPartSpec() != null) {
            List<FieldSchema> fieldSchemas = tbl.getPartitionKeys();
            HashMap<String, String> colTypes = new HashMap<String, String>();
            for (FieldSchema fieldSchema : fieldSchemas) {
                colTypes.put(fieldSchema.getName().toLowerCase(), fieldSchema.getType());
            }
            for (Map.Entry entry : ((ShowPartitionsDesc)this.desc).getPartSpec().entrySet()) {
                String type = (String)colTypes.get(((String)entry.getKey()).toLowerCase());
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                Object val = entry.getValue();
                if (!pti.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                    Object converted = ObjectInspectorConverters.getConverter((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo), (ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)pti)).convert(val);
                    if (converted == null) {
                        throw new HiveException("Cannot convert to " + type + " from string, value: " + val);
                    }
                    val = converted;
                }
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                children.add(new ExprNodeColumnDesc((TypeInfo)pti, ((String)entry.getKey()).toLowerCase(), null, true));
                children.add(new ExprNodeConstantDesc((TypeInfo)pti, val));
                ExprNodeGenericFuncDesc exprNodeDesc = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), children);
                predicate = predicate == null ? exprNodeDesc : ExprNodeDescUtils.mergePredicates(exprNodeDesc, predicate);
            }
        }
        List<String> partNames = this.context.getDb().getPartitionNames(tbl, (ExprNodeGenericFuncDesc)predicate, ((ShowPartitionsDesc)this.desc).getOrder(), ((ShowPartitionsDesc)this.desc).getLimit());
        return partNames;
    }
}

