/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={1210})
public class ShowPartitionAnalyzer
extends BaseSemanticAnalyzer {
    public ShowPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String tableName = ShowPartitionAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), (CommonTree)ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = partSpecs.size() > 0 ? partSpecs.get(0) : null;
        Table table = this.getTable(HiveTableName.of(tableName));
        this.inputs.add(new ReadEntity(table));
        this.setColumnAccessInfo(new ColumnAccessInfo());
        table.getPartColNames().forEach(col -> this.getColumnAccessInfo().add(table.getCompleteName(), (String)col));
        ExprNodeDesc filter = this.getShowPartitionsFilter(table, ast);
        String orderBy = this.getShowPartitionsOrder(table, ast);
        short limit = this.getShowPartitionsLimit(ast);
        ShowPartitionsDesc desc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec, filter, orderBy, limit);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("partition#string"));
    }

    @VisibleForTesting
    ExprNodeDesc getShowPartitionsFilter(Table table, ASTNode command) throws SemanticException {
        ExprNodeDesc showFilter = null;
        for (int childIndex = 0; childIndex < command.getChildCount(); ++childIndex) {
            ASTNode astChild = (ASTNode)command.getChild(childIndex);
            if (astChild.getType() != 1316) continue;
            RowResolver rwsch = new RowResolver();
            HashMap<String, String> colTypes = new HashMap<String, String>();
            for (FieldSchema fs : table.getPartCols()) {
                rwsch.put(table.getTableName(), fs.getName(), new ColumnInfo(fs.getName(), (TypeInfo)TypeInfoFactory.stringTypeInfo, null, true));
                colTypes.put(fs.getName().toLowerCase(), fs.getType());
            }
            TypeCheckCtx tcCtx = new TypeCheckCtx(rwsch);
            ASTNode conds = (ASTNode)astChild.getChild(0);
            Map<ASTNode, ExprNodeDesc> nodeOutputs = ExprNodeTypeCheck.genExprNode(conds, tcCtx);
            ExprNodeDesc target = nodeOutputs.get(conds);
            if (!(target instanceof ExprNodeGenericFuncDesc) || !target.getTypeInfo().equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                String errorMsg = tcCtx.getError() != null ? ". " + tcCtx.getError() : "";
                throw new SemanticException("Not a filter expr: " + (target == null ? "null" : target.getExprString()) + errorMsg);
            }
            showFilter = this.replaceDefaultPartNameAndCastType(target, colTypes, HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_PARTITION_NAME));
        }
        return showFilter;
    }

    private ExprNodeDesc replaceDefaultPartNameAndCastType(ExprNodeDesc nodeDesc, Map<String, String> colTypes, String defaultPartName) throws SemanticException {
        if (!(nodeDesc instanceof ExprNodeGenericFuncDesc)) {
            return nodeDesc;
        }
        ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)nodeDesc;
        if (FunctionRegistry.isOpAnd(funcDesc) || FunctionRegistry.isOpOr(funcDesc)) {
            ArrayList<ExprNodeDesc> newChildren = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc child : funcDesc.getChildren()) {
                newChildren.add(this.replaceDefaultPartNameAndCastType(child, colTypes, defaultPartName));
            }
            funcDesc.setChildren(newChildren);
            return funcDesc;
        }
        List<ExprNodeDesc> children = funcDesc.getChildren();
        int colIdx = -1;
        int constIdx = -1;
        for (int i = 0; i < children.size(); ++i) {
            ExprNodeDesc child = children.get(i);
            if (child instanceof ExprNodeColumnDesc) {
                String col = ((ExprNodeColumnDesc)child).getColumn().toLowerCase();
                String type = colTypes.get(col);
                if (!type.equals(child.getTypeString())) {
                    child.setTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)type));
                }
                colIdx = i;
                continue;
            }
            if (!(child instanceof ExprNodeConstantDesc)) continue;
            constIdx = i;
        }
        if (funcDesc.getGenericUDF() instanceof GenericUDFBaseCompare && children.size() == 2 && colIdx > -1 && constIdx > -1) {
            ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)children.get(constIdx);
            ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)children.get(colIdx);
            Object val = constantDesc.getValue();
            boolean isDefaultPartitionName = defaultPartName.equals(val);
            String type = colTypes.get(columnDesc.getColumn().toLowerCase());
            PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
            if (!isDefaultPartitionName) {
                if (!constantDesc.getTypeString().equals(type)) {
                    Object converted = ObjectInspectorConverters.getConverter((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)constantDesc.getTypeInfo()), (ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)pti)).convert(val);
                    if (converted == null) {
                        throw new SemanticException("Cannot convert to " + type + " from " + constantDesc.getTypeString() + ", value: " + val);
                    }
                    ExprNodeConstantDesc newConstantDesc = new ExprNodeConstantDesc((TypeInfo)pti, converted);
                    children.set(constIdx, newConstantDesc);
                }
            } else {
                String fnName;
                GenericUDF originalOp = funcDesc.getGenericUDF();
                if (FunctionRegistry.isEq(originalOp)) {
                    fnName = "isnull";
                } else if (FunctionRegistry.isNeq(originalOp)) {
                    fnName = "isnotnull";
                } else {
                    throw new SemanticException("Only '=' and '!=' are allowed for the default partition, function: " + originalOp.getUdfName());
                }
                funcDesc = PartitionUtils.makeUnaryPredicate(fnName, columnDesc);
            }
        }
        return funcDesc;
    }

    private String getShowPartitionsOrder(Table table, ASTNode command) throws SemanticException {
        String orderBy = null;
        for (int childIndex = 0; childIndex < command.getChildCount(); ++childIndex) {
            ASTNode astChild = (ASTNode)command.getChild(childIndex);
            if (astChild.getType() != 1126) continue;
            HashMap<String, Integer> poses = new HashMap<String, Integer>();
            RowResolver rwsch = new RowResolver();
            for (int i = 0; i < table.getPartCols().size(); ++i) {
                FieldSchema fs = table.getPartCols().get(i);
                rwsch.put(table.getTableName(), fs.getName(), new ColumnInfo(fs.getName(), (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType()), null, true));
                poses.put(fs.getName().toLowerCase(), i);
            }
            TypeCheckCtx tcCtx = new TypeCheckCtx(rwsch);
            StringBuilder colIndices = new StringBuilder();
            StringBuilder order = new StringBuilder();
            int ccount = astChild.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)astChild.getChild(i);
                if (cl.getType() == 1275) {
                    order.append("+");
                    cl = (ASTNode)cl.getChild(0).getChild(0);
                } else if (cl.getType() == 1276) {
                    order.append("-");
                    cl = (ASTNode)cl.getChild(0).getChild(0);
                } else {
                    order.append("+");
                }
                Map<ASTNode, ExprNodeDesc> nodeOutputs = ExprNodeTypeCheck.genExprNode(cl, tcCtx);
                ExprNodeDesc desc = nodeOutputs.get(cl);
                if (!(desc instanceof ExprNodeColumnDesc)) {
                    throw new SemanticException("Only partition keys are allowed for sorting partition names, input: " + cl.toStringTree());
                }
                String col = ((ExprNodeColumnDesc)desc).getColumn().toLowerCase();
                colIndices.append(poses.get(col)).append(",");
            }
            colIndices.setLength(colIndices.length() - 1);
            orderBy = colIndices + ":" + order;
        }
        return orderBy;
    }

    private short getShowPartitionsLimit(ASTNode command) {
        short limit = -1;
        for (int childIndex = 0; childIndex < command.getChildCount(); ++childIndex) {
            ASTNode astChild = (ASTNode)command.getChild(childIndex);
            if (astChild.getType() != 1084) continue;
            limit = Short.valueOf(astChild.getChild(0).getText());
        }
        return limit;
    }
}

