/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.desc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.function.desc.DescFunctionDesc;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hive.common.util.AnnotationUtils;

public class DescFunctionOperation
extends DDLOperation<DescFunctionDesc> {
    public DescFunctionOperation(DDLOperationContext context, DescFunctionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = ShowUtils.getOutputStream(((DescFunctionDesc)this.desc).getResFile(), this.context);){
            String funcName = ((DescFunctionDesc)this.desc).getName();
            FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(funcName);
            Class<?> funcClass = functionInfo == null ? null : functionInfo.getFunctionClass();
            Description description = funcClass == null ? null : (Description)AnnotationUtils.getAnnotation(funcClass, Description.class);
            this.printBaseInfo(outStream, funcName, funcClass, description);
            outStream.write(10);
            this.printExtendedInfoIfRequested(outStream, functionInfo, funcClass);
        }
        catch (IOException e) {
            LOG.warn("describe function: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return 0;
    }

    private void printBaseInfo(DataOutputStream outStream, String funcName, Class<?> funcClass, Description description) throws IOException, SemanticException {
        if (funcClass == null) {
            outStream.writeBytes("Function '" + funcName + "' does not exist.");
        } else if (description == null) {
            outStream.writeBytes("There is no documentation for function '" + funcName + "'");
        } else {
            outStream.writeBytes(description.value().replace("_FUNC_", funcName));
            if (((DescFunctionDesc)this.desc).isExtended()) {
                Set<String> synonyms = FunctionRegistry.getFunctionSynonyms(funcName);
                if (synonyms.size() > 0) {
                    outStream.writeBytes("\nSynonyms: " + StringUtils.join(synonyms, (String)", "));
                }
                if (description.extended().length() > 0) {
                    outStream.writeBytes("\n" + description.extended().replace("_FUNC_", funcName));
                }
            }
        }
    }

    private void printExtendedInfoIfRequested(DataOutputStream outStream, FunctionInfo functionInfo, Class<?> funcClass) throws IOException {
        if (!((DescFunctionDesc)this.desc).isExtended()) {
            return;
        }
        if (funcClass != null) {
            outStream.writeBytes("Function class:" + funcClass.getName() + "\n");
        }
        if (functionInfo != null) {
            outStream.writeBytes("Function type:" + functionInfo.getFunctionType() + "\n");
            FunctionInfo.FunctionResource[] resources = functionInfo.getResources();
            if (resources != null) {
                for (FunctionInfo.FunctionResource resource : resources) {
                    outStream.writeBytes("Resource:" + resource.getResourceURI() + "\n");
                }
            }
        }
    }
}

