/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.drop;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.drop.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1001})
public class DropDatabaseAnalyzer
extends BaseSemanticAnalyzer {
    public DropDatabaseAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = DropDatabaseAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        boolean ifExists = root.getFirstChildWithType(1050) != null;
        boolean cascade = root.getFirstChildWithType(933) != null;
        boolean isSoftDelete = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
        Database database = this.getDatabase(databaseName, !ifExists);
        if (database == null) {
            return;
        }
        boolean isDbLevelLock = true;
        if (cascade) {
            Hive newDb = null;
            boolean allowClose = this.db.allowClose();
            try {
                this.db.setAllowClose(false);
                HiveConf hiveConf = new HiveConf(this.conf);
                hiveConf.set("hive.metastore.client.filter.enabled", "false");
                newDb = Hive.get(hiveConf);
                List<Table> tables = newDb.getAllTableObjects(databaseName);
                isDbLevelLock = !isSoftDelete || tables.stream().allMatch(table -> AcidUtils.isTableSoftDeleteEnabled(table, this.conf));
                for (Table table2 : tables) {
                    WriteEntity.WriteType lockType = WriteEntity.WriteType.DDL_NO_LOCK;
                    if (!isDbLevelLock) {
                        lockType = AcidUtils.isTableSoftDeleteEnabled(table2, this.conf) ? WriteEntity.WriteType.DDL_EXCL_WRITE : WriteEntity.WriteType.DDL_EXCLUSIVE;
                    }
                    this.outputs.add(new WriteEntity(table2, lockType));
                }
                List<Function> functions = this.db.getFunctionsInDb(databaseName, ".*");
                for (Function func : functions) {
                    this.outputs.add(new WriteEntity(func, WriteEntity.WriteType.DDL_NO_LOCK));
                }
            }
            catch (HiveException e) {
                throw new SemanticException((Throwable)e);
            }
            finally {
                if (newDb != null) {
                    try {
                        newDb = Hive.get(this.conf);
                    }
                    catch (HiveException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.db.setAllowClose(allowClose);
                Hive.set(this.db);
            }
        }
        this.inputs.add(new ReadEntity(database));
        if (isDbLevelLock) {
            WriteEntity.WriteType lockType = isSoftDelete ? WriteEntity.WriteType.DDL_EXCL_WRITE : WriteEntity.WriteType.DDL_EXCLUSIVE;
            this.outputs.add(new WriteEntity(database, lockType));
        }
        DropDatabaseDesc desc = new DropDatabaseDesc(databaseName, ifExists, cascade, new ReplicationSpec());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    @Override
    public boolean isRequiresOpenTransaction() {
        return true;
    }
}

