/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DDLUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.exec.DDLTask");

    private DDLUtils() {
        throw new UnsupportedOperationException("DDLUtils should not be instantiated");
    }

    public static boolean addIfAbsentByName(WriteEntity newWriteEntity, Set<WriteEntity> outputs) {
        for (WriteEntity writeEntity : outputs) {
            if (!writeEntity.getName().equalsIgnoreCase(newWriteEntity.getName())) continue;
            LOG.debug("Ignoring request to add {} because {} is present", (Object)newWriteEntity.toStringDetail(), (Object)writeEntity.toStringDetail());
            return false;
        }
        outputs.add(newWriteEntity);
        return true;
    }

    public static boolean addIfAbsentByName(WriteEntity newWriteEntity, DDLOperationContext context) {
        return DDLUtils.addIfAbsentByName(newWriteEntity, context.getWork().getOutputs());
    }

    public static void validateSerDe(String serdeName, DDLOperationContext context) throws HiveException {
        DDLUtils.validateSerDe(serdeName, context.getConf());
    }

    public static void validateSerDe(String serdeName, HiveConf conf) throws HiveException {
        try {
            Deserializer d = (Deserializer)ReflectionUtil.newInstance(conf.getClassByName(serdeName).asSubclass(Deserializer.class), (Configuration)conf);
            if (d != null) {
                LOG.debug("Found class for {}", (Object)serdeName);
            }
        }
        catch (Exception e) {
            throw new HiveException("Cannot validate serde: " + serdeName, (Throwable)e);
        }
    }

    public static boolean allowOperationInReplicationScope(Hive db, String tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec) throws HiveException {
        Map dbParams;
        if (null == replicationSpec || !replicationSpec.isInReplicationScope()) {
            return true;
        }
        Table existingTable = db.getTable(tableName, false);
        if (existingTable != null && replicationSpec.allowEventReplacementInto(dbParams = db.getDatabase(existingTable.getDbName()).getParameters())) {
            if (partSpec != null) {
                Partition existingPtn = db.getPartition(existingTable, partSpec, false);
                return existingPtn != null && replicationSpec.allowEventReplacementInto(dbParams);
            }
            return true;
        }
        return false;
    }

    public static void addServiceOutput(HiveConf conf, Set<WriteEntity> outputs) throws SemanticException {
        String hs2Hostname = DDLUtils.getHS2Host(conf);
        if (hs2Hostname != null) {
            outputs.add(new WriteEntity(hs2Hostname, Entity.Type.SERVICE_NAME));
        }
    }

    private static String getHS2Host(HiveConf conf) throws SemanticException {
        if (SessionState.get().isHiveServerQuery()) {
            return SessionState.get().getHiveServer2Host();
        }
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_AUTHORIZATION_SQLSTD_HS2_MODE)) {
            return "dummyHostnameForTest";
        }
        throw new SemanticException("Kill query is only supported in HiveServer2 (not hive cli)");
    }

    public static String getFQName(ASTNode node) {
        if (node.getChildCount() == 0) {
            return node.getText();
        }
        if (node.getChildCount() == 2) {
            return DDLUtils.getFQName((ASTNode)node.getChild(0)) + "." + DDLUtils.getFQName((ASTNode)node.getChild(1));
        }
        if (node.getChildCount() == 3) {
            return DDLUtils.getFQName((ASTNode)node.getChild(0)) + "." + DDLUtils.getFQName((ASTNode)node.getChild(1)) + "." + DDLUtils.getFQName((ASTNode)node.getChild(2));
        }
        return null;
    }

    public static void addDbAndTableToOutputs(Database database, TableName tableName, TableType type, boolean isTemporary, Map<String, String> properties, Set<WriteEntity> outputs) {
        outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_SHARED));
        Table table = new Table(tableName.getDb(), tableName.getTable());
        table.setParameters(properties);
        table.setTableType(type);
        table.setTemporary(isTemporary);
        outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
    }

    public static void setColumnsAndStorePartitionTransformSpecOfTable(List<FieldSchema> columns, List<FieldSchema> partitionColumns, HiveConf conf, Table tbl) {
        Optional<List<FieldSchema>> cols = Optional.ofNullable(columns);
        Optional<List<FieldSchema>> partCols = Optional.ofNullable(partitionColumns);
        if (tbl.hasNonNativePartitionSupport()) {
            tbl.getSd().setCols(new ArrayList());
            cols.ifPresent(c -> tbl.getSd().getCols().addAll(c));
            if (partCols.isPresent() && !partCols.get().isEmpty()) {
                tbl.getSd().getCols().addAll((Collection)partCols.get());
                List<TransformSpec> spec = PartitionTransform.getPartitionTransformSpec(partCols.get());
                SessionStateUtil.addResourceOrThrow((Configuration)conf, "partition_transform_spec", spec);
            }
        } else {
            cols.ifPresent(tbl::setFields);
            partCols.ifPresent(tbl::setPartCols);
        }
    }

    public static void validateTableIsIceberg(Table table) throws SemanticException {
        String tableType = table.getParameters().get("table_type");
        if (!"ICEBERG".equalsIgnoreCase(tableType)) {
            throw new SemanticException(String.format("Not an iceberg table: %s (type=%s)", table.getFullTableName(), tableType));
        }
    }

    public static boolean isIcebergTable(Table table) {
        return table.isNonNative() && table.getStorageHandler().getType() == StorageFormat.StorageHandlerTypes.ICEBERG;
    }

    public static boolean isIcebergStatsSource(HiveConf conf) {
        return conf.get(HiveConf.ConfVars.HIVE_ICEBERG_STATS_SOURCE.varname, "ICEBERG").equalsIgnoreCase("ICEBERG");
    }

    public static boolean hasTransformsInPartitionSpec(Table table) {
        return DDLUtils.isIcebergTable(table) && table.getStorageHandler().getPartitionTransformSpec(table).stream().anyMatch(spec -> spec.getTransformType() != TransformSpec.TransformType.IDENTITY);
    }
}

