/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.testutils;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestHiveTestEnvSetup {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestHiveTestEnvSetup.createDriver();
        TestHiveTestEnvSetup.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table tu(u int)", "insert into tu values (1),(2),(3)"}) {
            driver.run(cmd);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestHiveTestEnvSetup.createDriver();
        TestHiveTestEnvSetup.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"s", "tu", "tv", "tw"}) {
            driver.run("drop table if exists " + t);
        }
    }

    @Test
    public void testMappingSameQuery() throws Exception {
        IDriver driver = TestHiveTestEnvSetup.createDriver();
        String query = "select sum(u*u),sum(u) from tu where u>1";
        driver.run(query);
        ArrayList res = new ArrayList();
        driver.getFetchTask().fetch(res);
        System.out.println(res);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((Object)"13\t5", res.get(0));
    }

    private static IDriver createDriver() {
        HiveConf conf = TestHiveTestEnvSetup.env_setup.getTestCtx().hiveConf;
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }
}

