/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.util.UpgradeTool;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUpgradeTool
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestUpgradeTool.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestUpgradeTool.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void testPostUpgrade() throws Exception {
        int[][] data = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        int[][] dataPart = new int[][]{{1, 2, 10}, {3, 4, 11}, {5, 6, 12}};
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, "dynamic");
        this.runStatementOnDriver("drop table if exists TAcid");
        this.runStatementOnDriver("drop table if exists TAcidPart");
        this.runStatementOnDriver("drop table if exists TFlat");
        this.runStatementOnDriver("drop table if exists TFlatText");
        this.runStatementOnDriver("create table TAcid (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into TAcid" + TestUpgradeTool.makeValuesClause(data));
        this.runStatementOnDriver("insert into TAcid" + TestUpgradeTool.makeValuesClause(data));
        this.runStatementOnDriver("insert into TAcid" + TestUpgradeTool.makeValuesClause(data));
        this.runStatementOnDriver("create table TAcidPart (a int, b int) partitioned by (p int) clustered by (b) into 2 buckets  stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into TAcidPart partition(p)" + TestUpgradeTool.makeValuesClause(dataPart));
        this.runStatementOnDriver("insert into TAcidPart partition(p)" + TestUpgradeTool.makeValuesClause(dataPart));
        this.runStatementOnDriver("create table TFlat (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into TFlat values(1,2)");
        this.runStatementOnDriver("insert into TFlat values(2,3)");
        this.runStatementOnDriver("insert into TFlat values(3,4)");
        this.runStatementOnDriver("insert into TFlat values(4,5)");
        this.runStatementOnDriver("insert into TFlat values(5,6)");
        this.runStatementOnDriver("insert into TFlat values(6,7)");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        fs.rename(new Path(this.getWarehouseDir() + "/tflat/000000_0_copy_1"), new Path(this.getWarehouseDir() + "/tflat/subdir/part-0001"));
        fs.rename(new Path(this.getWarehouseDir() + "/tflat/000000_0_copy_3"), new Path(this.getWarehouseDir() + "/tflat/1/000000_0"));
        fs.rename(new Path(this.getWarehouseDir() + "/tflat/000000_0_copy_4"), new Path(this.getWarehouseDir() + "/tflat/2/000000_0"));
        fs.rename(new Path(this.getWarehouseDir() + "/tflat/000000_0_copy_5"), new Path(this.getWarehouseDir() + "/tflat/.hive-staging_hive_2018-07-04_11-12-18_760_5286422535984490754-1395/000000_0"));
        String testQuery0 = "select a, b from TFlat order by a";
        String[][] expected0 = new String[][]{{"1\t2", ""}, {"2\t3", ""}, {"3\t4", ""}, {"4\t5", ""}, {"5\t6", ""}};
        this.checkResultAndVectorization(expected0, testQuery0, "TFlat pre-check", LOG);
        this.runStatementOnDriver("create table TFlatText (a int, b int) stored as textfile tblproperties('transactional'='false')");
        Hive db = Hive.get((HiveConf)this.hiveConf);
        Table tacid = db.getTable("default", "tacid");
        Assert.assertEquals((String)"Expected TAcid to not be full acid", (Object)false, (Object)AcidUtils.isFullAcidTable((Table)tacid));
        Table tacidpart = db.getTable("default", "tacidpart");
        Assert.assertEquals((String)"Expected TAcidPart to not be full acid", (Object)false, (Object)AcidUtils.isFullAcidTable((Table)tacidpart));
        Table t = db.getTable("default", "tflat");
        Assert.assertEquals((String)"Expected TAcid to not be full acid", (Object)false, (Object)AcidUtils.isFullAcidTable((Table)t));
        t = db.getTable("default", "tflattext");
        Assert.assertEquals((String)"Expected TAcidPart to not be full acid", (Object)false, (Object)AcidUtils.isInsertOnlyTable((Table)tacidpart));
        String[] args2 = new String[]{"-location", this.getTestDataDir(), "-execute"};
        UpgradeTool.hiveConf = this.hiveConf;
        UpgradeTool.main((String[])args2);
        tacid = db.getTable("default", "tacid");
        Assert.assertEquals((String)"Expected TAcid to become full acid", (Object)true, (Object)AcidUtils.isFullAcidTable((Table)tacid));
        tacidpart = db.getTable("default", "tacidpart");
        Assert.assertEquals((String)"Expected TAcidPart to become full acid", (Object)true, (Object)AcidUtils.isFullAcidTable((Table)tacidpart));
        t = db.getTable("default", "tflat");
        Assert.assertEquals((String)"Expected TAcid to become acid", (Object)true, (Object)AcidUtils.isFullAcidTable((Table)t));
        t = db.getTable("default", "tflattext");
        Assert.assertEquals((String)"Expected TAcidPart to become MM", (Object)true, (Object)AcidUtils.isInsertOnlyTable((Table)t));
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from TAcid order by a, b, ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "tacid/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "tacid/delta_0000001_0000001/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "tacid/delta_0000002_0000002/000000_0"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t3\t4", "tacid/000001_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t3\t4", "tacid/delta_0000001_0000001/000001_0"}, {"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":0}\t3\t4", "tacid/delta_0000002_0000002/000001_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}\t5\t6", "tacid/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t5\t6", "tacid/delta_0000001_0000001/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":1}\t5\t6", "tacid/delta_0000002_0000002/000000_0"}};
        this.checkResultAndVectorization(expected, testQuery, "TAcid post-check", LOG);
        testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from TAcidPart order by a, b, p, ROW__ID";
        String[][] expected2 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "warehouse/tacidpart/p=10/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "tacidpart/p=10/delta_0000001_0000001/000000_0"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t3\t4", "tacidpart/p=11/000001_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t3\t4", "tacidpart/p=11/delta_0000001_0000001/000001_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "tacidpart/p=12/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "tacidpart/p=12/delta_0000001_0000001/000000_0"}};
        this.checkResultAndVectorization(expected2, testQuery, "TAcidPart post-check", LOG);
        testQuery = "select a, b from TFlat order by a";
        String[][] expectedData = new String[][]{{"1\t2"}, {"2\t3"}, {"3\t4"}, {"4\t5"}, {"5\t6"}};
        this.checkResultAndVectorization(expectedData, testQuery, "TFlat post-check data", LOG);
        testQuery = "select ROW__ID, INPUT__FILE__NAME from TFlat order by INPUT__FILE__NAME";
        String[][] expectedMetaData = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}", "tflat/delta_0000001_0000001/00000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}", "tflat/delta_0000002_0000002/00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}", "tflat/delta_0000003_0000003/00000_0"}, {"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":0}", "tflat/delta_0000004_0000004/00000_0"}, {"{\"writeid\":5,\"bucketid\":536870912,\"rowid\":0}", "tflat/delta_0000005_0000005/00000_0"}};
        this.checkResultAndVectorization(expectedMetaData, testQuery, "TFlat post-check files", LOG);
    }

    @Test
    public void testGuessNumBuckets() {
        Assert.assertEquals((long)1L, (long)UpgradeTool.guessNumBuckets((long)123L));
        Assert.assertEquals((long)1L, (long)UpgradeTool.guessNumBuckets((long)30393930L));
        Assert.assertEquals((long)1L, (long)UpgradeTool.guessNumBuckets((long)((long)Math.pow(10.0, 9.0))));
        Assert.assertEquals((long)32L, (long)UpgradeTool.guessNumBuckets((long)((long)Math.pow(10.0, 13.0))));
        Assert.assertEquals((long)128L, (long)UpgradeTool.guessNumBuckets((long)((long)Math.pow(10.0, 15.0))));
    }
}

