/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.util.HiveStrictManagedMigration;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveStrictManagedMigration
extends TxnCommandsBaseForTests {
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestHiveStrictManagedMigration.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private static final String EXTERNAL_TABLE_LOCATION = new File(TEST_DATA_DIR, "tmp").getPath();

    @Test
    public void testUpgrade() throws Exception {
        int[][] data = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        this.runStatementOnDriver("DROP TABLE IF EXISTS test.TAcid");
        this.runStatementOnDriver("DROP DATABASE IF EXISTS test");
        this.runStatementOnDriver("CREATE DATABASE test");
        this.runStatementOnDriver("CREATE TABLE test.TAcid (a int, b int) CLUSTERED BY (b) INTO 2 BUCKETS STORED AS orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO test.TAcid" + TestHiveStrictManagedMigration.makeValuesClause(data));
        this.runStatementOnDriver("CREATE EXTERNAL TABLE texternal (a int, b int)");
        this.runStatementOnDriver("CREATE EXTERNAL TABLE test.sysdbtest(tbl_id bigint)");
        Table table = Hive.get((HiveConf)this.hiveConf).getTable("test", "sysdbtest");
        table.getSd().unsetLocation();
        Hive.get((HiveConf)this.hiveConf).alterTable(table, false, new EnvironmentContext((Map)ImmutableMap.of((Object)"DO_NOT_UPDATE_STATS", (Object)"true")), false);
        String oldWarehouse = this.getWarehouseDir();
        String[] args = new String[]{"--hiveconf", "hive.strict.managed.tables=true", "-m", "automatic", "--modifyManagedTables", "--oldWarehouseRoot", oldWarehouse};
        HiveConf newConf = new HiveConf(this.hiveConf);
        File newWarehouseDir = new File(this.getTestDataDir(), "newWarehouse");
        newConf.set(HiveConf.ConfVars.METASTORE_WAREHOUSE.varname, newWarehouseDir.getAbsolutePath());
        newConf.set("strict.managed.tables.migration.owner", System.getProperty("user.name"));
        TestHiveStrictManagedMigration.runMigrationTool(newConf, args);
        Assert.assertTrue((boolean)newWarehouseDir.exists());
        Assert.assertTrue((boolean)new File(newWarehouseDir, TxnCommandsBaseForTests.Table.ACIDTBL.toString().toLowerCase()).exists());
        Assert.assertTrue((boolean)new File(newWarehouseDir, TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase()).exists());
        Assert.assertTrue((boolean)new File(newWarehouseDir, TxnCommandsBaseForTests.Table.NONACIDNONBUCKET.toString().toLowerCase()).exists());
        Assert.assertTrue((boolean)new File(newWarehouseDir, TxnCommandsBaseForTests.Table.NONACIDORCTBL.toString().toLowerCase()).exists());
        Assert.assertTrue((boolean)new File(newWarehouseDir, TxnCommandsBaseForTests.Table.NONACIDORCTBL2.toString().toLowerCase()).exists());
        Assert.assertTrue((boolean)new File(new File(newWarehouseDir, "test.db"), "tacid").exists());
        Assert.assertTrue((boolean)new File(oldWarehouse, "texternal").exists());
        this.runStatementOnDriver("drop database test cascade");
        Database defaultDb = Hive.get().getDatabase("default");
        defaultDb.setLocationUri(oldWarehouse);
        Hive.get().alterDatabase("default", defaultDb);
        System.setProperty("hive.strict.managed.tables", "false");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExternalMoveFailsForIncorrectOptions() throws Throwable {
        try {
            String[] args = new String[]{"-m", "automatic", "--shouldMoveExternal"};
            TestHiveStrictManagedMigration.runMigrationTool(new HiveConf(this.hiveConf), args);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionForDbRegexPlusControlFile() throws Throwable {
        try {
            String[] args = new String[]{"-m", "automatic", "--dbRegex", "db0", "--controlFileUrl", "file:/tmp/file"};
            TestHiveStrictManagedMigration.runMigrationTool(new HiveConf(this.hiveConf), args);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test
    public void testUsingControlFileUrl() throws Throwable {
        this.setupExternalTableTest();
        String oldWarehouse = this.getWarehouseDir();
        String[] args = new String[]{"-m", "external", "--oldWarehouseRoot", oldWarehouse, "--controlFileUrl", "src/test/resources/hsmm/hsmm_cfg_01.yaml"};
        HiveConf newConf = new HiveConf(this.hiveConf);
        TestHiveStrictManagedMigration.runMigrationTool(newConf, args);
        this.verifySubsetOfTablesBecameExternal(Sets.newHashSet((Object[])new String[]{"manwhwh", "manwhnone"}));
    }

    @Test
    public void testUsingControlDirUrl() throws Throwable {
        this.setupExternalTableTest();
        String oldWarehouse = this.getWarehouseDir();
        String[] args = new String[]{"-m", "external", "--oldWarehouseRoot", oldWarehouse, "--controlFileUrl", "src/test/resources/hsmm"};
        HiveConf newConf = new HiveConf(this.hiveConf);
        TestHiveStrictManagedMigration.runMigrationTool(newConf, args);
        this.verifySubsetOfTablesBecameExternal(Sets.newHashSet((Object[])new String[]{"manwhwh", "manwhnone", "custdb.custmanwhwh"}));
    }

    private void verifySubsetOfTablesBecameExternal(Set<String> expectedExternals) throws Throwable {
        HashSet allTables = Sets.newHashSet((Object[])new String[]{"manwhnone", "manoutnone", "manwhwh", "manwhout", "manwhmixed", "manoutout", "custdb.custmanwhwh"});
        for (String expectedExternalTableName : expectedExternals) {
            Assert.assertEquals((Object)TableType.EXTERNAL_TABLE, (Object)Hive.get().getTable(expectedExternalTableName).getTableType());
        }
        for (String expectedLeftAsManagedTableName : Sets.difference((Set)allTables, expectedExternals)) {
            Assert.assertEquals((Object)TableType.MANAGED_TABLE, (Object)Hive.get().getTable(expectedLeftAsManagedTableName).getTableType());
        }
    }

    @Test(expected=AssertionError.class)
    public void testExtDbDirOnFsIsCreatedAsHiveIfDbOwnerNull() throws Exception {
        this.runStatementOnDriver("drop database if exists ownerlessdb");
        this.runStatementOnDriver("create database ownerlessdb");
        Database db = Hive.get().getDatabase("ownerlessdb");
        db.setOwnerName(null);
        Hive.get().alterDatabase("ownerlessdb", db);
        String[] args = new String[]{"-m", "external"};
        HiveConf newConf = new HiveConf(this.hiveConf);
        File newExtWarehouseDir = new File(this.getTestDataDir(), "newExternal");
        newConf.set(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL.varname, newExtWarehouseDir.getAbsolutePath());
        TestHiveStrictManagedMigration.runMigrationTool(newConf, args);
    }

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    private static void runMigrationTool(HiveConf hiveConf, String[] args) throws Exception {
        HiveStrictManagedMigration.hiveConf = hiveConf;
        HiveStrictManagedMigration.scheme = "file";
        HiveStrictManagedMigration.main((String[])args);
        if (HiveStrictManagedMigration.RC != 0) {
            Assert.fail((String)"HiveStrictManagedMigration failed with error(s)");
        }
    }

    private void setupExternalTableTest() throws Exception {
        this.runStatementOnDriver("drop table if exists manwhnone");
        this.runStatementOnDriver("drop table if exists manoutnone");
        this.runStatementOnDriver("drop table if exists manwhwh");
        this.runStatementOnDriver("drop table if exists manwhout");
        this.runStatementOnDriver("drop table if exists manwhmixed");
        this.runStatementOnDriver("drop table if exists manoutout");
        this.runStatementOnDriver("drop table if exists extwhnone");
        this.runStatementOnDriver("drop table if exists extoutnone");
        this.runStatementOnDriver("drop table if exists extwhwh");
        this.runStatementOnDriver("drop table if exists extwhout");
        this.runStatementOnDriver("drop table if exists extwhmixed");
        this.runStatementOnDriver("drop table if exists extoutout");
        this.runStatementOnDriver("drop table if exists custdb.custmanwhwh");
        this.runStatementOnDriver("drop table if exists custdb.custextwhwh");
        this.runStatementOnDriver("create table manwhnone (a string)");
        this.runStatementOnDriver("create table manoutnone (a string) location '" + EXTERNAL_TABLE_LOCATION + "/manoutnone'");
        this.runStatementOnDriver("create table manwhwh (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table manwhwh add partition (p='p1')");
        this.runStatementOnDriver("alter table manwhwh add partition (p='p2')");
        this.runStatementOnDriver("create table manwhout (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table manwhout add partition (p='p1') location '" + EXTERNAL_TABLE_LOCATION + "/manwhoutp1'");
        this.runStatementOnDriver("alter table manwhout add partition (p='p2') location '" + EXTERNAL_TABLE_LOCATION + "/manwhoutp2'");
        this.runStatementOnDriver("create table manwhmixed (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table manwhmixed add partition (p='p1') location '" + EXTERNAL_TABLE_LOCATION + "/manwhmixedp1'");
        this.runStatementOnDriver("alter table manwhmixed add partition (p='p2')");
        this.runStatementOnDriver("create table manoutout (a string) partitioned by (p string) location '" + EXTERNAL_TABLE_LOCATION + "/manoutout'");
        this.runStatementOnDriver("alter table manoutout add partition (p='p1')");
        this.runStatementOnDriver("alter table manoutout add partition (p='p2')");
        this.runStatementOnDriver("create external table extwhnone (a string)");
        this.runStatementOnDriver("create external table extoutnone (a string) location '" + EXTERNAL_TABLE_LOCATION + "/extoutnone'");
        this.runStatementOnDriver("create external table extwhwh (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table extwhwh add partition (p='p1')");
        this.runStatementOnDriver("alter table extwhwh add partition (p='p2')");
        this.runStatementOnDriver("create external table extwhout (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table extwhout add partition (p='p1') location '" + EXTERNAL_TABLE_LOCATION + "/extwhoutp1'");
        this.runStatementOnDriver("alter table extwhout add partition (p='p2') location '" + EXTERNAL_TABLE_LOCATION + "/extwhoutp2'");
        this.runStatementOnDriver("create external table extwhmixed (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table extwhmixed add partition (p='p1') location '" + EXTERNAL_TABLE_LOCATION + "/extwhmixedp1'");
        this.runStatementOnDriver("alter table extwhmixed add partition (p='p2')");
        this.runStatementOnDriver("create external table extoutout (a string) partitioned by (p string) location '" + EXTERNAL_TABLE_LOCATION + "/extoutout'");
        this.runStatementOnDriver("alter table extoutout add partition (p='p1')");
        this.runStatementOnDriver("alter table extoutout add partition (p='p2')");
        this.runStatementOnDriver("drop database if exists custdb");
        this.runStatementOnDriver("create database custdb");
        this.runStatementOnDriver("create table custdb.custmanwhwh (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table custdb.custmanwhwh add partition (p='p1')");
        this.runStatementOnDriver("alter table custdb.custmanwhwh add partition (p='p2')");
        this.runStatementOnDriver("create external table custdb.custextwhwh (a string) partitioned by (p string)");
        this.runStatementOnDriver("alter table custdb.custextwhwh add partition (p='p1')");
        this.runStatementOnDriver("alter table custdb.custextwhwh add partition (p='p2')");
    }

    private static void assertExternalTableLocations(File exteralWarehouseDir, File externalNonWhDir) throws IOException {
        Set actualDirs = Files.find(Paths.get(exteralWarehouseDir.toURI()), Integer.MAX_VALUE, (p, a) -> true, new FileVisitOption[0]).map(p -> p.toString().replaceAll(exteralWarehouseDir.getAbsolutePath(), "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        HashSet<String> expectedDirs = new HashSet<String>();
        expectedDirs.add("/extwhwh");
        expectedDirs.add("/extwhwh/p=p2");
        expectedDirs.add("/extwhwh/p=p1");
        expectedDirs.add("/extwhmixed");
        expectedDirs.add("/extwhmixed/p=p2");
        expectedDirs.add("/manwhwh");
        expectedDirs.add("/manwhwh/p=p2");
        expectedDirs.add("/manwhwh/p=p1");
        expectedDirs.add("/custdb.db");
        expectedDirs.add("/custdb.db/custmanwhwh");
        expectedDirs.add("/custdb.db/custmanwhwh/p=p2");
        expectedDirs.add("/custdb.db/custmanwhwh/p=p1");
        expectedDirs.add("/custdb.db/custextwhwh");
        expectedDirs.add("/custdb.db/custextwhwh/p=p2");
        expectedDirs.add("/custdb.db/custextwhwh/p=p1");
        expectedDirs.add("/manwhout");
        expectedDirs.add("/manwhnone");
        expectedDirs.add("/manwhmixed");
        expectedDirs.add("/manwhmixed/p=p2");
        expectedDirs.add("/extwhnone");
        expectedDirs.add("/extwhout");
        Assert.assertEquals((String)("Unexpected external warehouse directory structure in " + exteralWarehouseDir), expectedDirs, actualDirs);
        actualDirs = Files.find(Paths.get(externalNonWhDir.toURI()), Integer.MAX_VALUE, (p, a) -> true, new FileVisitOption[0]).map(p -> p.toString().replaceAll(externalNonWhDir.getAbsolutePath(), "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        expectedDirs.clear();
        expectedDirs.add("/manoutout");
        expectedDirs.add("/extoutout/p=p2");
        expectedDirs.add("/extoutout/p=p1");
        expectedDirs.add("/extwhoutp2");
        expectedDirs.add("/extwhoutp1");
        expectedDirs.add("/manwhmixedp1");
        expectedDirs.add("/manwhoutp1");
        expectedDirs.add("/manoutout/p=p1");
        expectedDirs.add("/manoutout/p=p2");
        expectedDirs.add("/manwhoutp2");
        expectedDirs.add("/extoutnone");
        expectedDirs.add("/manoutnone");
        expectedDirs.add("/extoutout");
        expectedDirs.add("/extwhmixedp1");
        Assert.assertEquals((String)("Unexpected external (non-warehouse) directory structure in " + externalNonWhDir), expectedDirs, actualDirs);
    }

    private static void assertSDLocationCorrect() throws HiveException {
        Table table = Hive.get().getTable("manwhwh");
        List partitions = Hive.get().getPartitions(table);
        Assert.assertTrue((boolean)((Partition)partitions.get(0)).getLocation().contains("/newExternal/manwhwh/p=p1"));
        Assert.assertTrue((boolean)((Partition)partitions.get(1)).getLocation().contains("/newExternal/manwhwh/p=p2"));
        table = Hive.get().getTable("manwhout");
        partitions = Hive.get().getPartitions(table);
        Assert.assertTrue((boolean)((Partition)partitions.get(0)).getLocation().contains("/tmp/manwhoutp1"));
        Assert.assertTrue((boolean)((Partition)partitions.get(1)).getLocation().contains("/tmp/manwhoutp2"));
        table = Hive.get().getTable("manwhmixed");
        partitions = Hive.get().getPartitions(table);
        Assert.assertTrue((boolean)((Partition)partitions.get(0)).getLocation().contains("/tmp/manwhmixedp1"));
        Assert.assertTrue((boolean)((Partition)partitions.get(1)).getLocation().contains("/newExternal/manwhmixed/p=p2"));
    }
}

