/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.BooleanValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.CharValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.DateValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.HiveDecimalValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.LongValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.StringValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampLocalTZValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.VarcharValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestValueBoundaryScanner {
    @Test
    public void testLongEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        LongValueBoundaryScanner scanner = new LongValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        LongWritable w1 = new LongWritable(1L);
        LongWritable w2 = new LongWritable(2L);
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testHiveDecimalEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector);
        HiveDecimalValueBoundaryScanner scanner = new HiveDecimalValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        HiveDecimalWritable w1 = new HiveDecimalWritable(1L);
        HiveDecimalWritable w2 = new HiveDecimalWritable(2L);
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testDateEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
        DateValueBoundaryScanner scanner = new DateValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        Date date = new Date();
        date.setTimeInMillis(86400000L);
        DateWritableV2 w1 = new DateWritableV2(date);
        DateWritableV2 w2 = new DateWritableV2(date);
        DateWritableV2 w3 = new DateWritableV2();
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w3, (Object)new DateWritableV2(new Date())));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w3, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testTimestampEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
        TimestampValueBoundaryScanner scanner = new TimestampValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        Timestamp ts = new Timestamp();
        ts.setTimeInMillis(1000L);
        TimestampWritableV2 w1 = new TimestampWritableV2(ts);
        TimestampWritableV2 w2 = new TimestampWritableV2(ts);
        TimestampWritableV2 w3 = new TimestampWritableV2();
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w3, (Object)new TimestampWritableV2(new Timestamp())));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w3, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testTimestampLocalTZEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampTZObjectInspector);
        TimestampLocalTZValueBoundaryScanner scanner = new TimestampLocalTZValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        TimestampTZ ts = new TimestampTZ();
        ts.set(10L, 0, ZoneId.systemDefault());
        TimestampLocalTZWritable w1 = new TimestampLocalTZWritable(ts);
        TimestampLocalTZWritable w2 = new TimestampLocalTZWritable(ts);
        TimestampLocalTZWritable w3 = new TimestampLocalTZWritable();
        w3.setTimeZone(ZoneId.of("UTC"));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w2, (Object)w1));
        TimestampTZ epoch = new TimestampTZ();
        epoch.set(0L, 0, ZoneId.of("UTC"));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w3, (Object)new TimestampLocalTZWritable(epoch)));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, (Object)w3));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testStringEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        StringValueBoundaryScanner scanner = new StringValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        Text w1 = new Text("a");
        Text w2 = new Text("b");
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testVarcharEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector);
        VarcharValueBoundaryScanner scanner = new VarcharValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        HiveVarcharWritable w1 = new HiveVarcharWritable(new HiveVarchar("abc", 3));
        HiveVarcharWritable w2 = new HiveVarcharWritable(new HiveVarchar("bcd", 3));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testCharEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableHiveCharObjectInspector);
        CharValueBoundaryScanner scanner = new CharValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        HiveCharWritable w1 = new HiveCharWritable(new HiveChar("a", 1));
        HiveCharWritable w2 = new HiveCharWritable(new HiveChar("b", 1));
        Assert.assertTrue((boolean)scanner.isEqual((Object)w1, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w2, (Object)w1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)w2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)w1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testBooleanEquals() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
        BooleanValueBoundaryScanner scanner = new BooleanValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        BooleanWritable b1 = new BooleanWritable(true);
        BooleanWritable b2 = new BooleanWritable(false);
        Assert.assertTrue((boolean)scanner.isEqual((Object)b1, (Object)b1));
        Assert.assertFalse((boolean)scanner.isEqual((Object)b1, (Object)b2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)b2, (Object)b1));
        Assert.assertFalse((boolean)scanner.isEqual(null, (Object)b2));
        Assert.assertFalse((boolean)scanner.isEqual((Object)b1, null));
        Assert.assertTrue((boolean)scanner.isEqual(null, null));
    }

    @Test
    public void testTimestampIsDistanceGreater() {
        PTFExpressionDef argDef = new PTFExpressionDef();
        argDef.setOI((ObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
        TimestampValueBoundaryScanner scanner = new TimestampValueBoundaryScanner(null, null, new OrderExpressionDef(argDef), false);
        Timestamp ts = new Timestamp();
        ts.setTimeInMillis(1000000L);
        TimestampWritableV2 w1 = new TimestampWritableV2(ts);
        TimestampWritableV2 w2 = new TimestampWritableV2(ts);
        TimestampWritableV2 w3 = new TimestampWritableV2();
        Assert.assertFalse((boolean)scanner.isDistanceGreater((Object)w1, (Object)w2, 0));
        Assert.assertFalse((boolean)scanner.isDistanceGreater((Object)w2, (Object)w1, 0));
        Assert.assertTrue((boolean)scanner.isDistanceGreater((Object)w1, null, 100));
        Assert.assertTrue((boolean)scanner.isDistanceGreater((Object)w2, null, 100));
        Assert.assertFalse((boolean)scanner.isDistanceGreater(null, null, 100));
        Assert.assertTrue((boolean)scanner.isDistanceGreater((Object)w1, (Object)w3, 999));
        Assert.assertFalse((boolean)scanner.isDistanceGreater((Object)w1, (Object)w3, 1000));
        Assert.assertFalse((boolean)scanner.isDistanceGreater((Object)w1, (Object)w3, 1001));
    }
}

