/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.PTFRollingPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.junit.Assert;
import org.junit.Test;

public class TestRange {
    @Test
    public void testRangeHashCode() {
        Range range1 = new Range(0, 10, null);
        Range range2 = new Range(0, 10, null);
        Assert.assertTrue((range1.hashCode() == range2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testRangeDifferentHashCode() {
        Range range1 = new Range(0, 10, null);
        Range range2 = new Range(0, 20, null);
        Assert.assertFalse((range1.hashCode() == range2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testRangeEqualsNoRange() {
        Range range1 = new Range(0, 10, null);
        Range range2 = new Range(0, 10, null);
        Assert.assertTrue((boolean)range1.equals((Object)range2));
    }

    @Test
    public void testRangeEqualsOnlyIfSamePartition() throws HiveException {
        PTFRollingPartition partition1 = PTFPartition.createRolling((Configuration)new Configuration(), null, null, null, (int)0, (int)0);
        PTFRollingPartition partition2 = PTFPartition.createRolling((Configuration)new Configuration(), null, null, null, (int)0, (int)0);
        Range range1 = new Range(0, 10, (PTFPartition)partition1);
        Range range2 = new Range(0, 10, (PTFPartition)partition2);
        Range range3 = new Range(0, 10, (PTFPartition)partition2);
        Assert.assertFalse((boolean)range1.equals((Object)range2));
        Assert.assertTrue((boolean)range2.equals((Object)range3));
    }

    @Test
    public void testRangeDoesntEqual() {
        Range range1 = new Range(0, 10, null);
        Range range2 = new Range(0, 20, null);
        Assert.assertFalse((boolean)range1.equals((Object)range2));
    }

    @Test
    public void testRangeDoesntEqualNull() {
        Range range1 = new Range(0, 10, null);
        Assert.assertFalse((boolean)range1.equals(null));
    }
}

