/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFValueCache;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.junit.Assert;
import org.junit.Test;

public class TestPTFValueCache {
    @Test
    public void testBasicUsage() {
        PTFValueCache cache = new PTFValueCache(3).init(1);
        cache.put(0, new Range(0, 10, null), (Object)"0-10");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put(0, new Range(0, 10, null), (Object)"0-10");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put(0, new Range(5, 10, null), (Object)"5-10");
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((Object)"0-10", (Object)cache.get(0, new Range(0, 10, null)));
        Assert.assertEquals((Object)"5-10", (Object)cache.get(0, new Range(5, 10, null)));
    }

    @Test
    public void testBiggerRangeIsMoreImportant() {
        PTFValueCache cache = new PTFValueCache(3).init(1);
        cache.put(0, new Range(0, 10, null), (Object)"0-10");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put(0, new Range(0, 100, null), (Object)"0-100");
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.put(0, new Range(0, 1000, null), (Object)"0-1000");
        Assert.assertEquals((long)3L, (long)cache.size());
        cache.put(0, new Range(0, 10000, null), (Object)"0-10000");
        Assert.assertEquals((long)3L, (long)cache.size());
        Assert.assertNull((Object)cache.get(0, new Range(0, 10, null)));
        Assert.assertEquals((Object)"0-100", (Object)cache.get(0, new Range(0, 100, null)));
        Assert.assertEquals((Object)"0-1000", (Object)cache.get(0, new Range(0, 1000, null)));
        Assert.assertEquals((Object)"0-10000", (Object)cache.get(0, new Range(0, 10000, null)));
    }

    @Test
    public void testLargerStartIsMoreImportant() {
        PTFValueCache cache = new PTFValueCache(2).init(1);
        cache.put(0, new Range(0, 10, null), (Object)"0-10");
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.put(0, new Range(10, 20, null), (Object)"10-20");
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.put(0, new Range(20, 30, null), (Object)"20-30");
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertNull((Object)cache.get(0, new Range(0, 10, null)));
        Assert.assertEquals((Object)"10-20", (Object)cache.get(0, new Range(10, 20, null)));
        Assert.assertEquals((Object)"20-30", (Object)cache.get(0, new Range(20, 30, null)));
    }
}

