/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTypeOf;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFTypeOf {
    private final GenericUDF.DeferredObject[] evaluateArguments = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text("Test"))};

    private Text executeUDF(ObjectInspector initArg) throws HiveException {
        GenericUDFTypeOf udf = new GenericUDFTypeOf();
        ObjectInspector[] arguments = new ObjectInspector[]{initArg};
        udf.initialize(arguments);
        return (Text)udf.evaluate(this.evaluateArguments);
    }

    @Test
    public void testPrimitiveTypes() throws HiveException {
        ImmutableMap oiToExpectedOutput = new ImmutableMap.Builder().put((Object)PrimitiveObjectInspectorFactory.writableBinaryObjectInspector, (Object)"binary").put((Object)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, (Object)"boolean").put((Object)PrimitiveObjectInspectorFactory.writableByteObjectInspector, (Object)"tinyint").put((Object)PrimitiveObjectInspectorFactory.writableDateObjectInspector, (Object)"date").put((Object)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, (Object)"double").put((Object)PrimitiveObjectInspectorFactory.writableFloatObjectInspector, (Object)"float").put((Object)PrimitiveObjectInspectorFactory.writableHiveCharObjectInspector, (Object)"char(255)").put((Object)PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector, (Object)"decimal(38,18)").put((Object)PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector, (Object)"interval_day_time").put((Object)PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector, (Object)"interval_year_month").put((Object)PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, (Object)"varchar(65535)").put((Object)PrimitiveObjectInspectorFactory.writableIntObjectInspector, (Object)"int").put((Object)PrimitiveObjectInspectorFactory.writableLongObjectInspector, (Object)"bigint").put((Object)PrimitiveObjectInspectorFactory.writableShortObjectInspector, (Object)"smallint").put((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)"string").put((Object)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, (Object)"timestamp").put((Object)PrimitiveObjectInspectorFactory.writableTimestampTZObjectInspector, (Object)"timestamp with local time zone").put((Object)PrimitiveObjectInspectorFactory.writableVoidObjectInspector, (Object)"void").build();
        for (Map.Entry testCase : oiToExpectedOutput.entrySet()) {
            Text retValue = this.executeUDF((ObjectInspector)testCase.getKey());
            Assert.assertEquals(testCase.getValue(), (Object)retValue.toString());
        }
    }

    @Test
    public void testListType() throws HiveException {
        StandardListObjectInspector oi = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        Text retValue = this.executeUDF((ObjectInspector)oi);
        Assert.assertEquals((Object)"array<string>", (Object)retValue.toString());
    }

    @Test
    public void testStructType() throws HiveException {
        List<String> structFieldNames = Arrays.asList("str", "long", "strArray");
        List<ObjectInspector> structOIs = Arrays.asList(PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector));
        StandardStructObjectInspector oi = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, structOIs);
        Text retValue = this.executeUDF((ObjectInspector)oi);
        Assert.assertEquals((Object)"struct<str:string,long:bigint,strarray:array<string>>", (Object)retValue.toString());
    }

    @Test
    public void testMapType() throws HiveException {
        WritableDateObjectInspector keyOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        StandardListObjectInspector valueOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        StandardMapObjectInspector oi = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyOI, (ObjectInspector)valueOI);
        Text retValue = this.executeUDF((ObjectInspector)oi);
        Assert.assertEquals((Object)"map<date,array<string>>", (Object)retValue.toString());
    }

    @Test(expected=UDFArgumentLengthException.class)
    public void testNotEnoughArguments() throws HiveException {
        GenericUDFTypeOf udf = new GenericUDFTypeOf();
        ObjectInspector[] arguments = new ObjectInspector[]{};
        udf.initialize(arguments);
    }

    @Test(expected=UDFArgumentLengthException.class)
    public void testTooManyArguments() throws HiveException {
        GenericUDFTypeOf udf = new GenericUDFTypeOf();
        ObjectInspector[] arguments = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector};
        udf.initialize(arguments);
    }
}

