/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnixTimeStamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGenericUDFToUnixTimestampEvaluateStringString {
    private final GenericUDFToUnixTimeStamp udf = new GenericUDFToUnixTimeStamp();
    private final GenericUDFUnixTimeStamp udfUnixTimeStamp = new GenericUDFUnixTimeStamp();
    private final ObjectInspector[] argInspectors = new ObjectInspector[2];
    private final String value;
    private final String pattern;
    private final String zone;
    private final String formatter;
    private final String resolverStyle;
    private final LongWritable expectedResult;

    public TestGenericUDFToUnixTimestampEvaluateStringString(String value, String pattern, String zone, String formatter, String resolverStyle, String expectedResult) {
        this.value = value;
        this.pattern = pattern;
        this.zone = zone;
        this.formatter = formatter;
        this.resolverStyle = resolverStyle;
        this.expectedResult = expectedResult.equals("null") ? null : new LongWritable(Long.parseLong(expectedResult));
        Arrays.fill(this.argInspectors, PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    @Parameterized.Parameters(name="('{0}','{1}'), zone={2}, parserLegacy={3}, resolverStyle={4}")
    public static Collection<String[]> readInputs() throws IOException, CsvException {
        CSVParser parser = new CSVParserBuilder().withSeparator(';').withIgnoreQuotations(true).build();
        try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(TestGenericUDFToUnixTimestampEvaluateStringString.class.getResourceAsStream("TestGenericUDFToUnixTimestampEvaluateStringString.csv"))).withCSVParser((ICSVParser)parser).build();){
            List list = reader.readAll();
            return list;
        }
    }

    @Test
    public void testEvaluateToUnixTimeStamp() throws HiveException, InterruptedException {
        this.testEvaluateWithUDF((GenericUDF)this.udf);
    }

    @Test
    public void testEvaluateUnixTimeStamp() throws HiveException, InterruptedException {
        this.testEvaluateWithUDF((GenericUDF)this.udfUnixTimeStamp);
    }

    private void testEvaluateWithUDF(GenericUDF udfToTest) throws HiveException, InterruptedException {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setVar(HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, this.formatter);
        conf.setVar(HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE, this.zone);
        conf.setVar(HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE, this.resolverStyle);
        SessionState state = SessionState.start((HiveConf)conf);
        udfToTest.initialize(this.argInspectors);
        LongWritable result = (LongWritable)udfToTest.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text(this.value)), new GenericUDF.DeferredJavaObject((Object)new Text(this.pattern))});
        Assert.assertEquals((String)this.udfDisplayWithInputs(udfToTest), (Object)this.expectedResult, (Object)result);
        SessionState.endStart((SessionState)state);
    }

    private String udfDisplayWithInputs(GenericUDF udf) {
        return udf.getDisplayString(new String[]{this.value, this.pattern}) + " sessionZone=" + this.zone + ", formatter=" + this.formatter + ", resolver Style=" + this.resolverStyle;
    }
}

