/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFToUnixTimestamp {
    public static void runAndVerify(GenericUDFToUnixTimeStamp udf, Object arg, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    public static void runAndVerify(GenericUDFToUnixTimeStamp udf, Object arg1, Object arg2, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg1), new GenericUDF.DeferredJavaObject(arg2)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    @Test
    public void testTimestamp() throws HiveException {
        GenericUDFToUnixTimeStamp udf = new GenericUDFToUnixTimeStamp();
        WritableTimestampObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        Timestamp ts = Timestamp.valueOf((String)"1970-01-01 00:00:00");
        TimestampTZ tstz = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, new TimestampWritableV2(ts), new LongWritable(tstz.getEpochSecond()));
        ts = Timestamp.valueOf((String)"2001-02-03 01:02:03");
        tstz = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, new TimestampWritableV2(ts), new LongWritable(tstz.getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, null, null);
    }

    @Test
    public void testDate() throws HiveException {
        GenericUDFToUnixTimeStamp udf = new GenericUDFToUnixTimeStamp();
        WritableDateObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        Date date = Date.valueOf((String)"1970-01-01");
        TimestampTZ tstz = TimestampTZUtil.convert((Date)date, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, new DateWritableV2(date), new LongWritable(tstz.getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, null, null);
    }

    @Test
    public void testStringArg1() throws HiveException {
        GenericUDFToUnixTimeStamp udf1 = new GenericUDFToUnixTimeStamp();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf1.initialize(arguments);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("2001-01-01 01:02:03"), new LongWritable(TimestampTZUtil.parse((String)"2001-01-01 01:02:03", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("1400-11-08 01:53:11"), new LongWritable(TimestampTZUtil.parse((String)"1400-11-08 01:53:11", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("1800-11-08 01:53:11"), new LongWritable(TimestampTZUtil.parse((String)"1800-11-08 01:53:11", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, null, null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("0000-00-00 00:00:00"), null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("1400-20-00 00:00:00"), null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("1400-02-34 00:00:00"), null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text("1800-11-08 01:53:11 UTC"), null);
    }

    @Test
    public void testStringArg2() throws HiveException {
        GenericUDFToUnixTimeStamp udf2 = new GenericUDFToUnixTimeStamp();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf2.initialize(args2);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("2001.07.04 AD at 12:08:56 PDT"), new Text("yyyy.MM.dd G 'at' HH:mm:ss z"), new LongWritable(TimestampTZUtil.parse((String)"2001-07-04 12:08:56", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("Wed, Jul 4, '01"), new Text("EEE, MMM d, ''yy"), new LongWritable(TimestampTZUtil.parse((String)"2001-07-04", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("2009 Mar 20 11:30:01 AM"), new Text("yyyy MMM dd h:mm:ss a"), new LongWritable(TimestampTZUtil.parse((String)"2009-03-20 11:30:01", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("2009 Mar 20 11:30:01 pm"), new Text("yyyy MMM dd h:mm:ss a"), new LongWritable(TimestampTZUtil.parse((String)"2009-03-20 23:30:01", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("1800-02-03"), new Text("yyyy-MM-dd"), new LongWritable(TimestampTZUtil.parse((String)"1800-02-03", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("1400-02-01 00:00:00 ICT"), new Text("yyyy-MM-dd HH:mm:ss z"), new LongWritable(TimestampTZUtil.parse((String)"1400-01-31 09:24:58", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("1400-02-01 00:00:00 UTC"), new Text("yyyy-MM-dd HH:mm:ss z"), new LongWritable(TimestampTZUtil.parse((String)"1400-01-31 16:07:02", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("1400-02-01 00:00:00 GMT"), new Text("yyyy-MM-dd HH:mm:ss z"), new LongWritable(TimestampTZUtil.parse((String)"1400-01-31 16:07:02", (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, null, null, null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, null, new Text("yyyy-MM-dd"), null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("2001-01-01"), null, null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text("1400-20-00 00:00:00 ICT"), new Text("yyyy-MM-dd HH:mm:ss z"), null);
    }
}

