/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSha2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFSha2 {
    @Test
    public void testSha0Str() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        IntWritable lenWr = new IntWritable(0);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", lenWr, "b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78", udf);
        this.runAndVerifyStr("", lenWr, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", udf);
        this.runAndVerifyStr(null, lenWr, null, udf);
    }

    @Test
    public void testSha0Bin() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        IntWritable lenWr = new IntWritable(0);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, lenWr, "b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78", udf);
        this.runAndVerifyBin(new byte[0], lenWr, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", udf);
        this.runAndVerifyBin(null, lenWr, null, udf);
    }

    @Test
    public void testSha200Str() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        IntWritable lenWr = new IntWritable(200);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", lenWr, null, udf);
    }

    @Test
    public void testSha200Bin() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        IntWritable lenWr = new IntWritable(200);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, lenWr, null, udf);
    }

    @Test
    public void testSha256Str() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        IntWritable lenWr = new IntWritable(256);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", lenWr, "b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78", udf);
        this.runAndVerifyStr("", lenWr, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", udf);
        this.runAndVerifyStr(null, lenWr, null, udf);
    }

    @Test
    public void testSha256Bin() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        IntWritable lenWr = new IntWritable(256);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, lenWr, "b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78", udf);
        this.runAndVerifyBin(new byte[0], lenWr, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", udf);
        this.runAndVerifyBin(null, lenWr, null, udf);
    }

    @Test
    public void testSha384Str() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        IntWritable lenWr = new IntWritable(384);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", lenWr, "1e02dc92a41db610c9bcdc9b5935d1fb9be5639116f6c67e97bc1a3ac649753baba7ba021c813e1fe20c0480213ad371", udf);
        this.runAndVerifyStr("", lenWr, "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b", udf);
        this.runAndVerifyStr(null, lenWr, null, udf);
    }

    @Test
    public void testSha384Bin() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        IntWritable lenWr = new IntWritable(384);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, lenWr, "1e02dc92a41db610c9bcdc9b5935d1fb9be5639116f6c67e97bc1a3ac649753baba7ba021c813e1fe20c0480213ad371", udf);
        this.runAndVerifyBin(new byte[0], lenWr, "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b", udf);
        this.runAndVerifyBin(null, lenWr, null, udf);
    }

    @Test
    public void testSha512Str() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        IntWritable lenWr = new IntWritable(512);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", lenWr, "397118fdac8d83ad98813c50759c85b8c47565d8268bf10da483153b747a74743a58a90e85aa9f705ce6984ffc128db567489817e4092d050d8a1cc596ddc119", udf);
        this.runAndVerifyStr("", lenWr, "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e", udf);
        this.runAndVerifyStr(null, lenWr, null, udf);
    }

    @Test
    public void testSha512Bin() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        IntWritable lenWr = new IntWritable(512);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, lenWr, "397118fdac8d83ad98813c50759c85b8c47565d8268bf10da483153b747a74743a58a90e85aa9f705ce6984ffc128db567489817e4092d050d8a1cc596ddc119", udf);
        this.runAndVerifyBin(new byte[0], lenWr, "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e", udf);
        this.runAndVerifyBin(null, lenWr, null, udf);
    }

    @Test
    public void testShaNullStr() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        IntWritable lenWr = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("ABC", lenWr, null, udf);
    }

    @Test
    public void testShaNullBin() throws HiveException {
        GenericUDFSha2 udf = new GenericUDFSha2();
        WritableBinaryObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        IntWritable lenWr = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, lenWr);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, lenWr, null, udf);
    }

    private void runAndVerifyStr(String str, IntWritable lenWr, String expResult, GenericUDFSha2 udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)lenWr);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        Assert.assertEquals((String)"sha2() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }

    private void runAndVerifyBin(byte[] b, IntWritable lenWr, String expResult, GenericUDFSha2 udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(b != null ? new BytesWritable(b) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)lenWr);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        Assert.assertEquals((String)"sha2() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }
}

