/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.testutil.BaseScalarUdfTest;
import org.apache.hadoop.hive.ql.testutil.DataBuilder;
import org.apache.hadoop.hive.ql.testutil.OperatorTestUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFRound
extends BaseScalarUdfTest {
    private static final String[] cols = new String[]{"s", "i", "d", "f", "b", "sh", "l", "dec"};

    @Override
    public InspectableObject[] getBaseTable() {
        DataBuilder db = new DataBuilder();
        db.setColumnNames(cols);
        db.setColumnTypes(new ObjectInspector[]{PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector, PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, PrimitiveObjectInspectorFactory.javaFloatObjectInspector, PrimitiveObjectInspectorFactory.javaByteObjectInspector, PrimitiveObjectInspectorFactory.javaShortObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)15, (int)5))});
        db.addRow("one", 170, Double.valueOf("1.1"), Float.valueOf("32.1234"), Byte.valueOf("25"), Short.valueOf("1234"), 123456L, HiveDecimal.create((String)"983.7235"));
        db.addRow("-234", null, null, Float.valueOf("0.347232"), Byte.valueOf("109"), Short.valueOf("551"), 923L, HiveDecimal.create((String)"983723.005"));
        db.addRow("454.45", 22345, Double.valueOf("-23.00009"), Float.valueOf("-3.4"), Byte.valueOf("76"), Short.valueOf("2321"), 9232L, HiveDecimal.create((String)"-932032.7"));
        return db.createRows();
    }

    @Override
    public InspectableObject[] getExpectedResult() {
        DataBuilder db = new DataBuilder();
        db.setColumnNames("_col1", "_col2", "_col3", "_col4", "_col5", "_col6", "_col7", "_col8");
        db.setColumnTypes(new ObjectInspector[]{PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector});
        db.addRow(null, new IntWritable(170), new DoubleWritable(1.1), new FloatWritable(32.0f), new ByteWritable(0), new ShortWritable(1234), new LongWritable(123500L), new HiveDecimalWritable(HiveDecimal.create((String)"983.724")));
        db.addRow(new DoubleWritable(-200.0), null, null, new FloatWritable(0.0f), new ByteWritable(100), new ShortWritable(551), new LongWritable(900L), new HiveDecimalWritable(HiveDecimal.create((String)"983723.005")));
        db.addRow(new DoubleWritable(500.0), new IntWritable(22345), new DoubleWritable(-23.0), new FloatWritable(-3.0f), new ByteWritable(100), new ShortWritable(2321), new LongWritable(9200L), new HiveDecimalWritable(HiveDecimal.create((String)"-932032.7")));
        return db.createRows();
    }

    @Override
    public List<ExprNodeDesc> getExpressionList() throws Exception {
        ArrayList<ExprNodeColumnDesc> exprs = new ArrayList<ExprNodeColumnDesc>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            exprs.add(OperatorTestUtils.getStringColumn(cols[i]));
        }
        ExprNodeDesc[] scales = new ExprNodeDesc[]{new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)-2), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.byteTypeInfo, (Object)0), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.shortTypeInfo, (Object)3), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)0), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)-2L), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)0), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)-2), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)3)};
        ArrayList<ExprNodeDesc> earr = new ArrayList<ExprNodeDesc>();
        for (int j = 0; j < cols.length; ++j) {
            ExprNodeDesc r = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("round", (Object[])new ExprNodeDesc[]{(ExprNodeDesc)exprs.get(j), scales[j]});
            earr.add(r);
        }
        return earr;
    }

    @Test
    public void testDecimalRoundingMetaData() throws UDFArgumentException {
        GenericUDFRound udf = new GenericUDFRound();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)7, (int)3)), PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(2))};
        PrimitiveObjectInspector outputOI = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        DecimalTypeInfo outputTypeInfo = (DecimalTypeInfo)outputOI.getTypeInfo();
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)7, (int)2), (Object)outputTypeInfo);
    }

    @Test
    public void testDecimalRoundingMetaData1() throws UDFArgumentException {
        GenericUDFRound udf = new GenericUDFRound();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)7, (int)3)), PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(-2))};
        PrimitiveObjectInspector outputOI = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        DecimalTypeInfo outputTypeInfo = (DecimalTypeInfo)outputOI.getTypeInfo();
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)0), (Object)outputTypeInfo);
    }

    @Test
    public void testDecimalRoundingMetaData2() throws UDFArgumentException {
        GenericUDFRound udf = new GenericUDFRound();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)7, (int)3)), PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(5))};
        PrimitiveObjectInspector outputOI = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        DecimalTypeInfo outputTypeInfo = (DecimalTypeInfo)outputOI.getTypeInfo();
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)5), (Object)outputTypeInfo);
    }
}

